/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.logger.CheckerLogPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimplePattern {
    private final List<String> parts;
    private final List<Character> escapeCharacters;
    private final String representation;

    public SimplePattern(String pattern) {
        this.representation = pattern;
        this.parts = new ArrayList<String>();
        this.escapeCharacters = new ArrayList<Character>();
        String[] decodedParts = pattern.split("%");
        if (this.parts != null) {
            if (pattern.startsWith("%")) {
                this.parts.add("");
            } else {
                this.parts.add(decodedParts[0]);
            }
            for (int i = 1; i < decodedParts.length; ++i) {
                this.parts.add(decodedParts[i].substring(1));
                this.escapeCharacters.add(Character.valueOf(decodedParts[i].charAt(0)));
            }
        }
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<Character> getEscapeCharacters() {
        return this.escapeCharacters;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public static String getValue(SimplePattern pattern, Map<Character, String> values) {
        StringBuffer result = new StringBuffer();
        result.append(pattern.getParts().get(0));
        for (int i = 1; i < pattern.getParts().size(); ++i) {
            char escape = pattern.getEscapeCharacters().get(i - 1).charValue();
            String value = values.get(Character.valueOf(escape));
            result.append(value == null ? "%" + escape : value);
            if (CheckerLogPattern.getListEscapeSequences().contains(pattern.getEscapeCharacters().get(i - 1))) continue;
            result.append(pattern.getParts().get(i));
        }
        return result.toString();
    }
}

