/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.logger;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.logger.StructureCheckerLogger;
import chemaxon.checkers.logger.StructureLog;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.StructureFixer;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;

public class SummarizerLogger
implements StructureCheckerLogger {
    private int structureIndex = 0;
    private String lastFileName = null;
    private LinkedHashMap<String, Integer> entryInfo;
    private int structureCount = 0;
    private int errorCount = 0;
    private int errorStructureCount = 0;
    private int errorFileCount = 0;
    private int fixedErrorCount = 0;
    private int fixedStructureCount = 0;
    private int fixedFileCount = 0;
    private StructureLog processedErrors = new StructureLog();
    private boolean fileContainsError = false;
    private boolean fileIsFixed = true;
    private String currentFileName = null;
    private int fileCount = 0;
    private long currentStructureIndex = 0L;

    @Override
    public void onFirstCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        String fileName = this.getFileNameFor(this.structureIndex + 1);
        if (fileName != null && fileName != this.lastFileName) {
            this.finalizeFile();
            this.lastFileName = fileName;
        }
        this.processedErrors = new StructureLog();
        for (StructureCheckerResult result : resultList) {
            this.processedErrors.addLogEntry(result, molecule);
        }
    }

    @Override
    public void onFix(Molecule originalMolecule, Molecule fixedMolecule, StructureCheckerResult checkerResult, StructureFixer appliedFixer, boolean fixResult) {
        this.processedErrors.addLogEntry(checkerResult, appliedFixer, originalMolecule, fixedMolecule, fixResult);
    }

    @Override
    public void onLastCheck(Molecule molecule, List<StructureCheckerResult> resultList) {
        this.processedErrors.finalize(resultList);
        this.finalizeEntry(this.structureIndex);
        ++this.structureIndex;
    }

    public void closeLog() {
        this.finalizeFile();
    }

    private void finalizeFile() {
        if (this.fileContainsError) {
            ++this.errorFileCount;
            if (this.fileIsFixed) {
                ++this.fixedFileCount;
            }
        }
        this.fileContainsError = false;
        this.fileIsFixed = true;
    }

    private void finalizeEntry(long structureId) {
        if (structureId >= 0L) {
            ++this.structureCount;
        }
        int errors = 0;
        int fixes = 0;
        for (StructureChecker checker : this.processedErrors.getLogEntries().keySet()) {
            StructureLog.LogEntry entry = this.processedErrors.getLogEntries().get(checker);
            if (entry == null) continue;
            ++errors;
            if (!entry.isFixed()) continue;
            ++fixes;
        }
        this.errorCount += errors;
        this.fixedErrorCount += fixes;
        if (errors > 0) {
            ++this.errorStructureCount;
            this.fileContainsError = true;
            if (errors <= fixes) {
                ++this.fixedStructureCount;
            } else {
                this.fileIsFixed = false;
            }
        }
        this.processedErrors = new StructureLog();
    }

    public void setEntryInfo(LinkedHashMap<String, Integer> info) {
        this.entryInfo = info;
    }

    public void setEntryInfo(List<String> filePaths) {
        this.entryInfo = new LinkedHashMap();
        for (String path : filePaths) {
            try {
                File file = new File(path);
                boolean stdin = !file.exists();
                MolImporter importer = new MolImporter(this.createInputStream(path));
                int count = 0;
                while (importer.skipRecord()) {
                    ++count;
                }
                this.entryInfo.put(stdin ? "Standard Input" : file.getName(), count);
            }
            catch (MolFormatException e) {
            }
            catch (IOException e) {}
        }
    }

    private InputStream createInputStream(String inputString) {
        InputStream inputStream = null;
        File inputFile = new File(inputString);
        if (inputFile.exists()) {
            try {
                inputStream = new FileInputStream(inputFile);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            inputStream = new ByteArrayInputStream(inputString.getBytes());
        }
        return inputStream;
    }

    protected String getFileNameFor(long structureId) {
        String result = null;
        if (this.entryInfo != null && !this.entryInfo.isEmpty()) {
            long count = 0L;
            for (String fileName : this.entryInfo.keySet()) {
                int length = this.entryInfo.get(fileName);
                if (length >= 0) {
                    if ((count += (long)length) <= structureId) continue;
                    return fileName;
                }
                return fileName;
            }
        } else if (this.currentFileName != null) {
            return this.currentFileName;
        }
        return result;
    }

    protected Long getFileIndexFor(long structureId) {
        Long result = null;
        if (this.entryInfo != null && !this.entryInfo.isEmpty()) {
            long count = 0L;
            for (String fileName : this.entryInfo.keySet()) {
                int length = this.entryInfo.get(fileName);
                if (length < 0 || count + (long)length > structureId) {
                    return structureId - count;
                }
                count += (long)length;
            }
        } else if (this.currentFileName != null) {
            return this.currentStructureIndex;
        }
        return result;
    }

    public int getFileCount() {
        return this.entryInfo == null ? this.fileCount : this.entryInfo.size();
    }

    public long getStructureCount() {
        return this.structureCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getErrorStructureCount() {
        return this.errorStructureCount;
    }

    public int getErrorFileCount() {
        return this.errorFileCount;
    }

    public int getFixedErrorCount() {
        return this.fixedErrorCount;
    }

    public int getFixedStructureCount() {
        return this.fixedStructureCount;
    }

    public int getNotFixedErrorCount() {
        return this.errorCount - this.fixedErrorCount;
    }

    public int getNotFixedStructureCount() {
        return this.errorStructureCount - this.fixedStructureCount;
    }

    public int getFixedFileCount() {
        return this.fixedFileCount;
    }

    public int getNotFixedFileCount() {
        return this.errorFileCount - this.fixedFileCount;
    }

    public void setFileName(String fileName) {
        this.currentStructureIndex = 0L;
        this.currentFileName = fileName;
        if (this.lastFileName == null) {
            this.lastFileName = fileName;
        }
        ++this.fileCount;
    }
}

