/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.registry;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.registry.configuration.reader.ConfigurationReader;
import chemaxon.fixers.StructureFixer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CheckerFixerRegistry {
    private Map<StructureCheckerErrorType, List<StructureFixer>> registry = null;
    private Map<String, List<StructureFixer>> externalRegistry = null;
    private final ConfigurationReader reader;

    public CheckerFixerRegistry(ConfigurationReader reader) {
        this.reader = reader;
    }

    public List<StructureFixer> getFixer(StructureCheckerErrorType errorType) {
        if (this.registry == null) {
            this.registry = this.reader.getRegistryMap();
        }
        return this.registry.get((Object)errorType);
    }

    public List<StructureFixer> getExternalFixer(String errorCode) {
        List<StructureFixer> fixerList;
        if (this.externalRegistry == null) {
            this.externalRegistry = this.reader.getExternalFixerMap();
        }
        if ((fixerList = this.externalRegistry.get(errorCode)) == null) {
            fixerList = new ArrayList<StructureFixer>();
            this.externalRegistry.put(errorCode, fixerList);
        }
        return fixerList;
    }
}

