/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.registry.configuration.reader;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.registry.configuration.reader.ConfigurationReader;
import chemaxon.fixers.Fixes;
import chemaxon.fixers.FixesExternal;
import chemaxon.fixers.StructureFixer;
import chemaxon.fixers.StructureFixerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultConfigurationReader
implements ConfigurationReader {
    Map<StructureCheckerErrorType, List<StructureFixer>> registryMap;
    Map<String, List<StructureFixer>> externalRegistryMap;
    List<StructureFixer> fixers;

    public DefaultConfigurationReader() {
        StructureFixerFactory fixerFactory = new StructureFixerFactory();
        this.fixers = fixerFactory.getFixers();
    }

    @Override
    public Map<StructureCheckerErrorType, List<StructureFixer>> getRegistryMap() {
        if (this.registryMap == null) {
            this.registryMap = new HashMap<StructureCheckerErrorType, List<StructureFixer>>();
            this.initRegistryMap();
            for (StructureFixer fixer : this.fixers) {
                StructureCheckerErrorType[] errorTypes;
                Fixes fixes = fixer.getClass().getAnnotation(Fixes.class);
                if (fixes == null) continue;
                for (StructureCheckerErrorType errorType : errorTypes = fixes.value()) {
                    this.registryMap.get((Object)errorType).add(fixer);
                }
            }
        }
        return this.registryMap;
    }

    private void initRegistryMap() {
        if (this.registryMap != null) {
            for (StructureCheckerErrorType erroType : StructureCheckerErrorType.values()) {
                this.registryMap.put(erroType, new ArrayList());
            }
        }
    }

    @Override
    public Map<String, List<StructureFixer>> getExternalFixerMap() {
        if (this.externalRegistryMap == null) {
            this.externalRegistryMap = new HashMap<String, List<StructureFixer>>();
            for (StructureFixer fixer : this.fixers) {
                String[] errorCodes;
                FixesExternal fixes = fixer.getClass().getAnnotation(FixesExternal.class);
                if (fixes == null) continue;
                for (String errorCode : errorCodes = fixes.value()) {
                    if (!this.externalRegistryMap.containsKey(errorCode)) {
                        ArrayList<StructureFixer> fixerList = new ArrayList<StructureFixer>();
                        fixerList.add(fixer);
                        this.externalRegistryMap.put(errorCode, fixerList);
                        continue;
                    }
                    this.externalRegistryMap.get(errorCode).add(fixer);
                }
            }
        }
        return this.externalRegistryMap;
    }
}

