/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.result;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class DefaultStructureCheckerResult
implements StructureCheckerResult {
    private final StructureChecker source;
    private List<MolAtom> atoms;
    private List<MolBond> bonds;
    private final StructureCheckerErrorType errorType;
    private Molecule molecule;
    private final String description;
    private final String name;
    private final String localMenuName;
    private final String helpText;
    private final Icon icon;

    public DefaultStructureCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, StructureCheckerErrorType errorType, Molecule molecule, String description, String name, String localMenuName, String helpText, Icon icon) {
        if (molecule == null) {
            throw new IllegalArgumentException("Molecule can not be null");
        }
        this.source = source;
        this.atoms = atoms == null ? new ArrayList() : atoms;
        this.bonds = bonds == null ? new ArrayList() : bonds;
        this.errorType = errorType == null ? StructureCheckerErrorType.NO_ERROR : errorType;
        this.molecule = molecule;
        this.description = description;
        this.name = name;
        this.localMenuName = localMenuName;
        this.helpText = helpText;
        this.icon = icon;
    }

    public DefaultStructureCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, Molecule molecule) {
        if (molecule == null) {
            throw new IllegalArgumentException("Molecule can not be null");
        }
        this.source = source;
        this.atoms = atoms == null ? new ArrayList() : atoms;
        this.bonds = bonds == null ? new ArrayList() : bonds;
        this.errorType = source.getErrorType() == null ? StructureCheckerErrorType.NO_ERROR : source.getErrorType();
        this.molecule = molecule;
        this.name = source.getDescriptor().getName();
        this.description = source.getDescriptor().getDescription();
        this.helpText = source.getDescriptor().getHelpText();
        this.icon = source.getDescriptor().getIcon();
        this.localMenuName = source.getDescriptor().getLocalMenuName();
    }

    @Override
    public StructureChecker getSource() {
        return this.source;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getLocalMenuName() {
        return this.localMenuName;
    }

    @Override
    public List<MolAtom> getAtoms() {
        return this.atoms;
    }

    @Override
    public List<MolBond> getBonds() {
        return this.bonds;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Molecule getMolecule() {
        return this.molecule;
    }

    @Override
    public StructureCheckerErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.atoms == null ? 0 : ((Object)this.atoms).hashCode());
        result = 31 * result + (this.bonds == null ? 0 : ((Object)this.bonds).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.errorType == null ? 0 : this.errorType.hashCode());
        result = 31 * result + (this.helpText == null ? 0 : this.helpText.hashCode());
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.localMenuName == null ? 0 : this.localMenuName.hashCode());
        result = 31 * result + (this.molecule == null ? 0 : this.molecule.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultStructureCheckerResult other = (DefaultStructureCheckerResult)obj;
        if (this.atoms == null ? other.atoms != null : !((Object)this.atoms).equals(other.atoms)) {
            return false;
        }
        if (this.bonds == null ? other.bonds != null : !((Object)this.bonds).equals(other.bonds)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.errorType == null ? other.errorType != null : !this.errorType.equals((Object)other.errorType)) {
            return false;
        }
        if (this.helpText == null ? other.helpText != null : !this.helpText.equals(other.helpText)) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.localMenuName == null ? other.localMenuName != null : !this.localMenuName.equals(other.localMenuName)) {
            return false;
        }
        if (this.molecule == null ? other.molecule != null : !this.molecule.equals(other.molecule)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        return "DefaultStructureCheckerResult [atoms=" + this.atoms + ", bonds=" + this.bonds + ", description=" + this.description + ", errorType=" + (Object)((Object)this.errorType) + ", helpText=" + this.helpText + ", icon=" + this.icon + ", localMenuName=" + this.localMenuName + ", molecule=" + this.molecule + ", name=" + this.name + ", source=" + this.source + "]";
    }

    @Override
    public void setAtoms(List<MolAtom> atoms) {
        this.atoms = atoms;
    }

    @Override
    public void setBonds(List<MolBond> bonds) {
        this.bonds = bonds;
    }

    @Override
    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    @Override
    public void convert(Molecule molecule, Map<String, Map<? extends Object, ? extends Object>> convertData) {
        this.setMolecule(molecule);
        Map<? extends Object, ? extends Object> atomAtomMap = convertData.get("atomAtomMap");
        Map<? extends Object, ? extends Object> bondBondMap = convertData.get("bondBondMap");
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        ArrayList<MolBond> bondList = new ArrayList<MolBond>();
        for (MolAtom molAtom : this.getAtoms()) {
            atomList.add((MolAtom)atomAtomMap.get(molAtom));
        }
        for (MolBond molBond : this.getBonds()) {
            bondList.add((MolBond)bondBondMap.get(molBond));
        }
        this.setAtoms(atomList);
        this.setBonds(bondList);
    }
}

