/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.result;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.DefaultStructureCheckerResult;
import chemaxon.checkers.util.RgroupInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class RgroupCheckerResult
extends DefaultStructureCheckerResult {
    private final List<RgroupInfo> groups;

    public RgroupCheckerResult(StructureChecker source, List<MolAtom> atoms, List<MolBond> bonds, List<RgroupInfo> groups, StructureCheckerErrorType type, Molecule molecule, String description, String name, String localMenuName, String helpText, Icon icon) {
        super(source, atoms, bonds, type, molecule, description, name, localMenuName, helpText, icon);
        this.groups = groups;
    }

    public List<RgroupInfo> getRgroups() {
        return this.groups;
    }

    @Override
    public void convert(Molecule molecule, Map<String, Map<? extends Object, ? extends Object>> convertData) {
        super.convert(molecule, convertData);
        Map<? extends Object, ? extends Object> atomAtomMap = convertData.get("atomAtomMap");
        Map<? extends Object, ? extends Object> rgroupRgroupMap = convertData.get("rgroupRgroupMap");
        for (RgroupInfo group : this.groups) {
            ArrayList<Object> atoms = new ArrayList<Object>(group.getAtoms().size());
            ArrayList<Object> members = new ArrayList<Object>(group.getMembers().size());
            for (MolAtom molAtom : group.getAtoms()) {
                atoms.add(atomAtomMap.get(molAtom));
            }
            for (Molecule member : group.getMembers()) {
                members.add(rgroupRgroupMap.get(member));
            }
            group.getAtoms().clear();
            group.getMembers().clear();
            group.getAtoms().addAll(atoms);
            group.getMembers().addAll(members);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groups == null ? 0 : ((Object)this.groups).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RgroupCheckerResult other = (RgroupCheckerResult)obj;
        return !(this.groups == null ? other.groups != null : !((Object)this.groups).equals(other.groups));
    }
}

