/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.registry.CheckerFixerRegistry;
import chemaxon.checkers.registry.configuration.reader.DefaultConfigurationReader;
import chemaxon.checkers.result.ExternalStructureCheckerResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.fixers.StructureFixer;
import chemaxon.license.LicenseThread;
import chemaxon.struc.Molecule;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BasicCheckerRunner
implements CheckerRunner {
    protected Molecule molecule;
    private List<StructureCheckerResult> resultList;
    private List<StructureChecker> checkerList;
    private final CheckerFixerRegistry registry = new CheckerFixerRegistry(new DefaultConfigurationReader());
    private boolean canceled = true;
    private boolean isDoodle = true;
    private int index = 0;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected Thread backgroundThread = null;
    private Map<StructureCheckerErrorType, StructureFixer> errorTypeDefaultFixerMap;
    private final Runnable checkStrategy = new Runnable(){

        @Override
        public void run() {
            BasicCheckerRunner.this.setCanceled(false);
            BasicCheckerRunner.this.setDoodle(false);
            BasicCheckerRunner.this.setIndex(0);
            BasicCheckerRunner.this.setResultList(new ArrayList<StructureCheckerResult>());
            while (BasicCheckerRunner.this.isChecking()) {
                StructureChecker checker = BasicCheckerRunner.this.getCheckerList().get(BasicCheckerRunner.this.getIndex());
                StructureCheckerResult result = checker.check(BasicCheckerRunner.this.getMolecule());
                if (result != null) {
                    BasicCheckerRunner.this.convertResult(result);
                    BasicCheckerRunner.this.getResultList().add(result);
                    if (result.getErrorType().equals((Object)StructureCheckerErrorType.DOODLE)) {
                        BasicCheckerRunner.this.setDoodle(true);
                    }
                }
                BasicCheckerRunner.this.setIndex(BasicCheckerRunner.this.getIndex() + 1);
            }
            BasicCheckerRunner.this.getChangeSupport().firePropertyChange("checking", true, false);
        }
    };

    public BasicCheckerRunner(ConfigurationReader configurationReader) {
        this.setConfigurationReader(configurationReader);
    }

    public BasicCheckerRunner(List<StructureChecker> checkerList) {
        this.setCheckerList(checkerList);
        this.errorTypeDefaultFixerMap = Collections.emptyMap();
    }

    @Override
    public void setConfigurationReader(ConfigurationReader configurationReader) {
        this.setCheckerList(configurationReader.getCheckerList());
        this.errorTypeDefaultFixerMap = configurationReader.getErrorTypeDefaultFixerMap();
    }

    @Override
    public boolean fix() {
        for (StructureChecker checker : this.getCheckerList()) {
            StructureCheckerResult result = checker.check(this.getMolecule());
            if (result == null) continue;
            this.convertResult(result);
            if (this.fix(result)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean fix(StructureCheckerResult result) {
        if (this.errorTypeDefaultFixerMap.containsKey((Object)result.getErrorType())) {
            return this.errorTypeDefaultFixerMap.get((Object)result.getErrorType()).fix(result);
        }
        if (this.getFixers(result).size() > 0) {
            return this.getFixers(result).get(0).fix(result);
        }
        return false;
    }

    @Override
    public List<StructureFixer> getFixers(StructureCheckerResult result) {
        if (result.getErrorType() == StructureCheckerErrorType.EXTERNAL && result instanceof ExternalStructureCheckerResult) {
            return this.registry.getExternalFixer(((ExternalStructureCheckerResult)result).getErrorCode());
        }
        return this.registry.getFixer(result.getErrorType());
    }

    @Override
    public void setMolecule(Molecule molecule) {
        this.molecule = molecule;
    }

    @Override
    public void check() {
        if (this.backgroundThread != null) {
            try {
                this.backgroundThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.backgroundThread = new LicenseThread(this.getStrategy());
        this.backgroundThread.start();
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
    }

    @Override
    public int getCurrent() {
        return this.getIndex();
    }

    @Override
    public String getCurrentCheckerName() {
        return this.getCheckerList().get(this.getIndex()).getName();
    }

    @Override
    public int getProgessLength() {
        return this.getCheckerList().size();
    }

    @Override
    public List<StructureCheckerResult> getResultList() {
        return this.resultList;
    }

    @Override
    public boolean isChecking() {
        return !this.isDoodle() && !this.isCanceled() && this.getIndex() < this.getCheckerList().size();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener changeListener) {
        this.getChangeSupport().addPropertyChangeListener(changeListener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public List<StructureCheckerResult> checkAndWait() {
        this.getStrategy().run();
        return this.getResultList();
    }

    protected void convertResult(StructureCheckerResult result) {
    }

    protected Runnable getStrategy() {
        return this.checkStrategy;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    protected boolean isCanceled() {
        return this.canceled;
    }

    protected void setDoodle(boolean isDoodle) {
        this.isDoodle = isDoodle;
    }

    protected boolean isDoodle() {
        return this.isDoodle;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected int getIndex() {
        return this.index;
    }

    protected void setResultList(List<StructureCheckerResult> resultList) {
        this.resultList = resultList;
    }

    protected void setCheckerList(List<StructureChecker> checkerList) {
        this.checkerList = checkerList;
    }

    protected List<StructureChecker> getCheckerList() {
        return this.checkerList;
    }

    protected Molecule getMolecule() {
        return this.molecule;
    }

    protected void setChangeSupport(PropertyChangeSupport changeSupport) {
        this.changeSupport = changeSupport;
    }

    protected PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }
}

