/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.BasicCheckerRunner;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.fixers.StructureFixer;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerResultWrapper;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class SketchCheckerRunner
extends BasicCheckerRunner {
    private Molecule clonedMolecule;
    private final Map<String, Map<? extends Object, ? extends Object>> convertData = new HashMap<String, Map<? extends Object, ? extends Object>>();
    private final Map<MolAtom, MolAtom> molAtomSketchMolAtomMap = new IdentityHashMap<MolAtom, MolAtom>();
    private final Map<MolBond, MolBond> molBondSketchMolBondMap = new IdentityHashMap<MolBond, MolBond>();
    private final Map<Sgroup, Sgroup> sgroupSkethSgroupMap = new IdentityHashMap<Sgroup, Sgroup>();
    private final Map<MolAtom, MolAtom> rgroupAtomSketchRgroupAtomMap = new IdentityHashMap<MolAtom, MolAtom>();
    private final Map<Molecule, Molecule> rgroupMemberSketchRgroupMemberMap = new IdentityHashMap<Molecule, Molecule>();

    public SketchCheckerRunner(ConfigurationReader configurationReader) {
        super(configurationReader);
        this.convertData.put("atomAtomMap", this.molAtomSketchMolAtomMap);
        this.convertData.put("bondBondMap", this.molBondSketchMolBondMap);
        this.convertData.put("sgroupSgroupMap", this.sgroupSkethSgroupMap);
        this.convertData.put("rgroupRgroupMap", this.rgroupMemberSketchRgroupMemberMap);
    }

    @Override
    public void setMolecule(Molecule molecule) {
        super.setMolecule(molecule);
        this.cloneAndMapSketchMolecule(molecule);
    }

    @Override
    protected Molecule getMolecule() {
        return this.clonedMolecule;
    }

    private void cloneAndMapSketchMolecule(Molecule molecule) {
        int i;
        this.clonedMolecule = molecule.cloneMolecule();
        this.molAtomSketchMolAtomMap.clear();
        this.molBondSketchMolBondMap.clear();
        this.sgroupSkethSgroupMap.clear();
        this.rgroupAtomSketchRgroupAtomMap.clear();
        for (i = 0; i < this.clonedMolecule.getAtomCount(); ++i) {
            this.molAtomSketchMolAtomMap.put(this.clonedMolecule.getAtom(i), this.molecule.getAtom(i));
        }
        for (i = 0; i < this.clonedMolecule.getBondCount(); ++i) {
            this.molBondSketchMolBondMap.put(this.clonedMolecule.getBond(i), this.molecule.getBond(i));
        }
        for (i = 0; i < this.clonedMolecule.getSgroupCount(); ++i) {
            this.sgroupSkethSgroupMap.put(this.clonedMolecule.getSgroup(i), this.molecule.getSgroup(i));
        }
        if (this.clonedMolecule instanceof RgMolecule && molecule instanceof RgMolecule) {
            RgMolecule clonedRgmol = (RgMolecule)this.clonedMolecule;
            RgMolecule origRgmol = (RgMolecule)molecule;
            for (int i2 = 0; i2 < clonedRgmol.getRgroupCount(); ++i2) {
                for (int j = 0; j < clonedRgmol.getRgroupMemberCount(i2); ++j) {
                    int k;
                    Molecule clonedRgroup = clonedRgmol.getRgroupMember(i2, j);
                    Molecule origRgrop = origRgmol.getRgroupMember(i2, j);
                    this.rgroupMemberSketchRgroupMemberMap.put(clonedRgroup, origRgrop);
                    for (k = 0; k < clonedRgroup.getAtomCount(); ++k) {
                        this.molAtomSketchMolAtomMap.put(clonedRgroup.getAtom(k), origRgrop.getAtom(k));
                    }
                    for (k = 0; k < clonedRgroup.getBondCount(); ++k) {
                        this.molBondSketchMolBondMap.put(clonedRgroup.getBond(k), origRgrop.getBond(k));
                    }
                }
            }
        }
    }

    @Override
    protected void convertResult(StructureCheckerResult result) {
        result.convert(this.molecule, this.convertData);
    }

    @Override
    public List<StructureFixer> getFixers(StructureCheckerResult result) {
        return super.getFixers(result instanceof CheckerResultWrapper ? ((CheckerResultWrapper)result).getResult() : result);
    }
}

