/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner.configuration.reader;

import chemaxon.checkers.FixMode;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerFactory;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.fixers.StructureFixer;
import chemaxon.fixers.StructureFixerFactory;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionStringBasedConfigurationReader
implements ConfigurationReader {
    private static final String FIXER_CLASS_PREFIX = "chemaxon.fixers.";
    private static Map<String, String> actionStringCheckerNameMap = new HashMap<String, String>();
    private static Map<String, String> actionStringFixerNameMap = new HashMap<String, String>();
    private final String configString;
    private final Map<StructureCheckerErrorType, StructureFixer> errorTypeDefaultFixerMap = new HashMap<StructureCheckerErrorType, StructureFixer>();

    public ActionStringBasedConfigurationReader(String configString) {
        this(configString, new StructureCheckerFactory(), new StructureFixerFactory());
    }

    public ActionStringBasedConfigurationReader(String configString, StructureCheckerFactory checkerFactory, StructureFixerFactory fixerFactory) {
        this.configString = configString;
        for (StructureChecker checker : checkerFactory.getAvailableCheckers()) {
            for (String token : checker.getDescriptor().getActionStringTokens()) {
                if (token == null || token.length() <= 0) continue;
                actionStringCheckerNameMap.put(token, this.getClassName(checker.getClass()));
            }
        }
        for (StructureFixer fixer : fixerFactory.getFixers()) {
            for (String token : fixer.getDescriptor().getActionStringTokens()) {
                if (token == null || token.length() <= 0) continue;
                actionStringFixerNameMap.put(token, this.getClassName(fixer.getClass()));
            }
        }
        this.errorTypeDefaultFixerMap.put(StructureCheckerErrorType.ABBREVIATED_GROUP, fixerFactory.getFixer("ContractGroupFixer"));
        this.errorTypeDefaultFixerMap.put(StructureCheckerErrorType.ALIAS, fixerFactory.getFixer("ConvertAliasToGroupFixer"));
    }

    private String getClassName(Class<?> target) {
        String FQClassName = target.getName();
        int firstChar = FQClassName.lastIndexOf(46) + 1;
        if (firstChar > 0) {
            FQClassName = FQClassName.substring(firstChar);
        }
        return FQClassName;
    }

    @Override
    public List<StructureChecker> getCheckerList() {
        String[] actions;
        ArrayList<StructureChecker> checkerList = new ArrayList<StructureChecker>();
        if (this.configString == null || this.configString.length() == 0) {
            return checkerList;
        }
        StructureCheckerFactory checkerFactory = new StructureCheckerFactory();
        for (String action : actions = this.configString.split("\\.\\.")) {
            HashMap<String, String> params;
            String checkerName;
            String checkerActionString;
            String fixerName = null;
            int indexOfArrow = action.indexOf("->");
            if (indexOfArrow == -1) {
                checkerActionString = action;
            } else {
                checkerActionString = action.substring(0, indexOfArrow);
                fixerName = action.substring(indexOfArrow + 2);
            }
            int firstColon = checkerActionString.indexOf(58);
            StructureChecker checker = null;
            if (firstColon == -1) {
                if (!actionStringCheckerNameMap.containsKey(checkerActionString.toLowerCase())) continue;
                checker = checkerFactory.getChecker(actionStringCheckerNameMap.get(checkerActionString.toLowerCase()), new HashMap<String, String>());
                if (fixerName != null && !fixerName.isEmpty()) {
                    checker.getDescriptor().setFixMode(FixMode.FIX);
                    checker.getDescriptor().setFixerClassName(FIXER_CLASS_PREFIX + actionStringFixerNameMap.get(fixerName.toLowerCase()));
                }
                checkerList.add(checker);
                continue;
            }
            if (firstColon > 0 && checkerActionString.startsWith("substructure")) {
                int indexOfFirstEqual;
                checkerName = checkerActionString.substring(0, firstColon);
                String paramName = "reactionsmarts";
                params = new HashMap<String, String>();
                if (!"substructure".equals(checkerName)) continue;
                String smarts = checkerActionString.substring(firstColon + 1);
                boolean isValidSmarts = false;
                if (smarts.length() > 0) {
                    try {
                        Molecule mol = MolImporter.importMol(smarts, "smarts");
                        if (mol.isReaction()) {
                            fixerName = "transform";
                        }
                        isValidSmarts = true;
                    }
                    catch (MolFormatException e) {
                        isValidSmarts = false;
                    }
                }
                if (!isValidSmarts && "reactionsmarts".equals(paramName = checkerActionString.substring(firstColon + 1, indexOfFirstEqual = checkerActionString.indexOf(61)).toLowerCase()) && indexOfFirstEqual > 0) {
                    smarts = checkerActionString.substring(indexOfFirstEqual + 1);
                    try {
                        Molecule mol = MolImporter.importMol(smarts, "smarts");
                        if (mol.isReaction()) {
                            fixerName = "transform";
                        }
                    }
                    catch (MolFormatException e) {
                        throw new IllegalArgumentException("Could not read structure string: " + smarts, e);
                    }
                }
                params.put(paramName, smarts);
                checker = checkerFactory.getChecker(actionStringCheckerNameMap.get(checkerName.toLowerCase()), params);
                checkerList.add(checker);
                continue;
            }
            checkerName = checkerActionString.substring(0, firstColon);
            if (!actionStringCheckerNameMap.containsKey(checkerName.toLowerCase())) continue;
            String[] paramString = checkerActionString.substring(firstColon + 1).split(":");
            params = new HashMap();
            for (String string : paramString) {
                int indexOfEqual = string.indexOf("=");
                params.put(string.substring(0, indexOfEqual), string.substring(indexOfEqual + 1));
            }
            checker = checkerFactory.getChecker(actionStringCheckerNameMap.get(checkerName.toLowerCase()), params);
            if (fixerName != null && !fixerName.isEmpty()) {
                checker.getDescriptor().setFixMode(FixMode.FIX);
                checker.getDescriptor().setFixerClassName(FIXER_CLASS_PREFIX + actionStringFixerNameMap.get(fixerName.toLowerCase()));
            }
            checkerList.add(checker);
        }
        return checkerList;
    }

    @Override
    public Map<StructureCheckerErrorType, StructureFixer> getErrorTypeDefaultFixerMap() {
        return this.errorTypeDefaultFixerMap;
    }
}

