/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner.configuration.reader;

import chemaxon.checkers.FixMode;
import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerDescriptor;
import chemaxon.checkers.StructureCheckerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBasedConfigurationReaderSAXHandler
extends DefaultHandler {
    private final List<StructureChecker> checkerList;
    private final StructureCheckerFactory factory;

    public XMLBasedConfigurationReaderSAXHandler(List<StructureChecker> checkerList) {
        this(checkerList, new StructureCheckerFactory());
    }

    public XMLBasedConfigurationReaderSAXHandler(List<StructureChecker> checkerList, StructureCheckerFactory factory) {
        this.checkerList = checkerList;
        this.factory = factory;
    }

    @Override
    public void startDocument() throws SAXException {
        this.checkerList.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!"checkers".equalsIgnoreCase(qName)) {
            Map<String, String> params = this.getParams(attributes);
            HashMap<String, String> descriptorAttributes = new HashMap<String, String>();
            for (Field field : StructureCheckerDescriptor.class.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Persistent.class)) continue;
                Persistent persistent = field.getAnnotation(Persistent.class);
                String attributeName = "".equals(persistent.alias()) ? field.getName() : persistent.alias();
                String attributeValue = params.remove(attributeName);
                if (attributeValue == null && ("fixMode".equals(attributeName) || "fixerClassName".equals(attributeName))) {
                    attributeValue = params.remove(attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1));
                }
                if (attributeValue == null) continue;
                descriptorAttributes.put(attributeName, attributeValue);
            }
            StructureChecker checker = this.factory.getChecker(qName, params);
            if (checker != null) {
                for (Field field : StructureCheckerDescriptor.class.getDeclaredFields()) {
                    String attributeName;
                    if (!field.isAnnotationPresent(Persistent.class)) continue;
                    Persistent persistent = field.getAnnotation(Persistent.class);
                    String string = attributeName = "".equals(persistent.alias()) ? field.getName() : persistent.alias();
                    if (!descriptorAttributes.containsKey(attributeName)) continue;
                    String methodName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                    for (Method method : StructureCheckerDescriptor.class.getDeclaredMethods()) {
                        if (!methodName.equals(method.getName()) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
                        Class<?> argumentClass = method.getParameterTypes()[0];
                        try {
                            if (String.class.equals(argumentClass)) {
                                method.invoke((Object)checker.getDescriptor(), descriptorAttributes.get(attributeName));
                                continue;
                            }
                            if (FixMode.class.equals(argumentClass)) {
                                method.invoke((Object)checker.getDescriptor(), new Object[]{FixMode.valueOf(((String)descriptorAttributes.get(attributeName)).toUpperCase())});
                                continue;
                            }
                            throw new IllegalArgumentException("The class '" + argumentClass + "' can not be used as a persistent data type in StructureCheckerDescriptor.");
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                    }
                }
                this.checkerList.add(checker);
            }
        }
    }

    private Map<String, String> getParams(Attributes attributes) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            params.put(attributes.getQName(i), attributes.getValue(i));
        }
        return params;
    }
}

