/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.runner.configuration.writer;

import chemaxon.checkers.Persistent;
import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.runner.configuration.writer.ConfigurationWriter;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBasedConfigurationWriter
implements ConfigurationWriter {
    private static void addPersistentValueToElement(Object instance, Element element) {
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Persistent.class)) continue;
            Persistent persistent = field.getAnnotation(Persistent.class);
            try {
                String functionSuffix = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                Method method = null;
                try {
                    method = field.getDeclaringClass().getMethod("get" + functionSuffix, null);
                }
                catch (NoSuchMethodException ex) {
                    method = field.getDeclaringClass().getMethod("is" + functionSuffix, null);
                }
                Object result = method.invoke(instance, (Object[])null);
                if (result == null) continue;
                element.setAttribute("".equals(persistent.alias()) ? field.getName() : persistent.alias(), result.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The persistent field '" + field.getName() + "' of '" + field.getDeclaringClass().getName() + "' can not be saved.", e);
            }
        }
    }

    @Override
    public void writeConfiguration(List<StructureChecker> checkerList, OutputStream output) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("checkers");
            document.appendChild(root);
            for (StructureChecker checker : checkerList) {
                Element checkerElement = document.createElement(checker.getClass().getSimpleName());
                XMLBasedConfigurationWriter.addPersistentValueToElement(checker, checkerElement);
                XMLBasedConfigurationWriter.addPersistentValueToElement(checker.getDescriptor(), checkerElement);
                root.appendChild(checkerElement);
            }
            Transformer megatron = TransformerFactory.newInstance().newTransformer();
            megatron.setOutputProperty("encoding", "UTF-8");
            megatron.setOutputProperty("indent", "yes");
            megatron.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            megatron.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            megatron.transform(new DOMSource(document), new StreamResult(output));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

