/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.checkers.util;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class RgroupInfo {
    private final int id;
    private final List<MolAtom> atoms = new ArrayList<MolAtom>();
    private final List<Molecule> members = new ArrayList<Molecule>();
    private final List<Integer> nests = new ArrayList<Integer>();
    private boolean valid = true;

    public RgroupInfo(int id) {
        this.id = id;
    }

    public static List<RgroupInfo> collectRgroups(Molecule mol) {
        RgroupInfo group;
        ArrayList<RgroupInfo> result = new ArrayList<RgroupInfo>();
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            int rid = atom.getRgroup();
            if (atom.getAtno() != 134) continue;
            if (ids.get(rid) == null) {
                group = new RgroupInfo(rid);
                result.add(group);
                ids.put(rid, result.size() - 1);
            } else {
                group = (RgroupInfo)result.get((Integer)ids.get(rid));
            }
            group.getAtoms().add(atom);
            group.getNests().add(-1);
        }
        if (mol instanceof RgMolecule) {
            RgMolecule rmol = (RgMolecule)mol;
            for (int i = 0; i < rmol.getRgroupCount(); ++i) {
                int gid = rmol.getRgroupId(i);
                if (ids.get(gid) == null) {
                    result.add(new RgroupInfo(gid));
                    ids.put(gid, result.size() - 1);
                }
                RgroupInfo rgroup = (RgroupInfo)result.get((Integer)ids.get(gid));
                for (int j = 0; j < rmol.getRgroupMemberCount(i); ++j) {
                    Molecule rmember = rmol.getRgroupMember(i, j);
                    rgroup.getMembers().add(rmember);
                    for (int k = 0; k < rmember.getAtomCount(); ++k) {
                        MolAtom atom = rmember.getAtom(k);
                        int rid = atom.getRgroup();
                        if (atom.getAtno() != 134) continue;
                        if (ids.get(rid) == null) {
                            group = new RgroupInfo(rid);
                            result.add(group);
                            ids.put(rid, result.size() - 1);
                        } else {
                            group = (RgroupInfo)result.get((Integer)ids.get(rid));
                        }
                        group.getAtoms().add(atom);
                        group.getNests().add((Integer)ids.get(gid));
                    }
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    public static List<Integer> collectAttachments(MolAtom atom) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            result.add(atom.getBond(i).getType());
        }
        return result;
    }

    public static List<Integer> collectAttachments(Molecule member) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<MolAtom> atoms = RgroupInfo.collectAttachmentAtoms(member);
        for (MolAtom atom : atoms) {
            if (atom.getBondCount() <= 0) continue;
            result.add(atom.getBond(0).getType());
        }
        return result;
    }

    public static List<MolAtom> collectAttachmentAtoms(Molecule member) {
        ArrayList<MolAtom> result = new ArrayList<MolAtom>();
        for (int i = 0; i < member.getAtomCount(); ++i) {
            if (member.getAtom(i).getAtno() != 138) continue;
            result.add(member.getAtom(i));
        }
        Collections.sort(result, new Comparator<MolAtom>(){

            @Override
            public int compare(MolAtom atom1, MolAtom atom2) {
                return atom1.getRgroupAttachmentPointOrder() - atom2.getRgroupAttachmentPointOrder();
            }
        });
        return result;
    }

    public static int compare(List<Integer> list1, List<Integer> list2) {
        if (list1.size() != list2.size()) {
            return list1.size() - list2.size();
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return list1.get(i) - list2.get(i);
        }
        return 0;
    }

    public List<MolAtom> getAtoms() {
        return this.atoms;
    }

    public int getId() {
        return this.id;
    }

    public List<Molecule> getMembers() {
        return this.members;
    }

    public List<Integer> getNests() {
        return this.nests;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public LigandInfo[] getBondInfos() {
        LigandInfo[] result = new LigandInfo[3];
        for (int i = 0; i < 3; ++i) {
            result[i] = new LigandInfo();
        }
        if (this.getAtoms() != null && !this.getAtoms().isEmpty()) {
            MolAtom target = this.getAtoms().get(0);
            for (int i = 0; i < target.getBondCount(); ++i) {
                if (target.getBond(i).getType() <= 0 || target.getBond(i).getType() > 3) continue;
                result[target.getBond(i).getType() - 1].add(i + 1);
            }
        }
        return result;
    }

    public static class LigandInfo {
        private List<Integer> ligandOrders = new ArrayList<Integer>();

        public void add(int order) {
            this.ligandOrders.add(order);
        }

        public void remove(int index) {
            this.ligandOrders.remove(index);
        }

        public int get(int index) {
            return this.ligandOrders.get(index);
        }

        public int size() {
            return this.ligandOrders.size();
        }

        public void removeValue(int value) {
            for (int i = 0; i < this.ligandOrders.size(); ++i) {
                if (this.ligandOrders.get(i) != value) continue;
                this.ligandOrders.remove(i);
                return;
            }
        }
    }
}

