/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.ClusteringException;
import chemaxon.clustering.Common;
import chemaxon.clustering.InvalidLicenseKeyException;
import chemaxon.clustering.SpaceDBLoader;
import chemaxon.clustering.SpaceInputStream;
import chemaxon.clustering.SpaceLoader;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class Compare
extends Common {
    private boolean onlyDiss = false;
    private boolean listSimilar = false;
    private boolean diffId = false;
    private float threshold;
    private ChemicalSpace mySpace;
    private ChemicalSpace extSpace;
    private InputStream input1;
    private InputStream input2;
    private SpaceDBLoader db_input1;
    private SpaceDBLoader db_input2;
    private boolean orderSimilarObjects = false;
    private int maxSimilar = 0;
    private static final String helptext = "Compr " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Diversity/dissimarity comparison of two libraries." + lineSep + "Usage:" + lineSep + "  compr [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -P  --proptable <table>       property table" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <path1> <path2>   input files to compare (text file input)" + lineSep + "  -q  --query <sql1> <sql2>     SQL query strings for reading input " + lineSep + "                                (database input)" + lineSep + "Combined input (table vs. file comparison):" + lineSep + "  -i <path> -q <sql>" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output file path (text file output)" + lineSep + "  -a  --statement <sql>         SQL statement for inserting results" + lineSep + "                                (database output)" + lineSep + "  -z  --stat                    print statistics on overall dissimilarity" + lineSep + "  -Z  --only-stat               statistics only on overall dissimilarity" + lineSep + "  -y  --only-dissimilar         print only dissimilar objects" + lineSep + "  -L  --list-similar            list similar objects from the first set" + lineSep + "" + lineSep + "" + "Data properties" + lineSep + "" + "  -m  --dimensions <dim>        number of floating-point descriptors" + lineSep + "  -f  --fingerprint-size <bits> binary fingerprint size in bits." + lineSep + "                                fpsize should be a multiple of 32" + lineSep + "  -w  --weights <w1> <w2> ...   the weights of the floating-point descriptors" + lineSep + "  -g  --generate-id             generate id for each compound." + lineSep + "" + lineSep + "Conditions of calculation" + lineSep + "  -t  --threshold <threshold>   maximum dissimilarity of two compounds " + lineSep + "                                compounds (default: 1)" + lineSep + "  -D  --different-ids           don't compare compounds with the same id" + lineSep + "  -c  --max-count <count>       maximum number of similar objects listed" + lineSep + "  -r  --order                   sort similar objects by distance (closest first)" + lineSep;
    private float maxDist;
    private int maxIdx;

    public void setInput1(ConnectionHandler conh, String querySQL) throws SQLException {
        this.input1 = null;
        this.db_input1 = new SpaceDBLoader(conh, querySQL);
    }

    public void setInput2(ConnectionHandler conh, String querySQL) throws SQLException {
        this.input2 = null;
        this.db_input2 = new SpaceDBLoader(conh, querySQL);
    }

    public void setInput1(File file) throws FileNotFoundException {
        this.input1 = new FileInputStream(file);
        this.db_input1 = null;
    }

    public void setInput2(File file) throws FileNotFoundException {
        this.input2 = new FileInputStream(file);
        this.db_input2 = null;
    }

    public void setInput1(String fileName) throws FileNotFoundException {
        this.input1 = new FileInputStream(fileName);
        this.db_input1 = null;
    }

    public void setInput2(String fileName) throws FileNotFoundException {
        this.input2 = new FileInputStream(fileName);
        this.db_input2 = null;
    }

    public void setInput1(InputStream is) {
        this.input1 = is;
        this.db_input1 = null;
    }

    public void setInput2(InputStream is) {
        this.input2 = is;
        this.db_input2 = null;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setOnlyDissimilarListed(boolean b) {
        this.onlyDiss = b;
    }

    public boolean isOnlyDissimilarListed() {
        return this.onlyDiss;
    }

    public void setSimilarListed(boolean b) {
        this.listSimilar = b;
    }

    public boolean isSimilarListed() {
        return this.listSimilar;
    }

    public void setDifferentIdsOnly(boolean b) {
        this.diffId = b;
    }

    public boolean isDifferentIdsOnly() {
        return this.diffId;
    }

    public void setMaxSimilar(int maxSimilar) {
        this.maxSimilar = maxSimilar;
    }

    public int getMaxSimilar() {
        return this.maxSimilar;
    }

    public void setOrderSimilarObjects(boolean orderSimilarObjects) {
        this.orderSimilarObjects = orderSimilarObjects;
    }

    public boolean isOrderSimilarObjects() {
        return this.orderSimilarObjects;
    }

    private void setRes(StatResult res, Vector neighbours, ACompoundInTheSpace q, ACompoundInTheSpace c) {
        float dist = this.mySpace.distance(q, c);
        if (this.statsNeeded || dist <= this.threshold) {
            if (dist < res.minDist) {
                res.minDist = dist;
                res.mostSimilar = c.getId();
            }
            if (dist <= this.threshold) {
                ++res.similarCount;
                c.distance = dist;
                if (this.maxSimilar > 0 && this.orderSimilarObjects) {
                    if (dist < this.maxDist) {
                        neighbours.add(c);
                        if (neighbours.size() >= this.maxSimilar + 1) {
                            neighbours.removeElementAt(this.maxIdx);
                            this.maxDist = Float.MIN_VALUE;
                            for (int x = 0; x < neighbours.size(); ++x) {
                                float d = ((ACompoundInTheSpace)neighbours.get((int)x)).distance;
                                if (!(d > this.maxDist)) continue;
                                this.maxDist = d;
                                this.maxIdx = x;
                            }
                        }
                    }
                } else {
                    neighbours.add(c);
                }
            }
            if (this.statsNeeded) {
                res.avgDist += dist;
                if (dist > res.maxDist) {
                    res.maxDist = dist;
                }
            }
        }
    }

    private synchronized void calcNeighbours(ACompoundInTheSpace query, float threshold, StatResult res, StatResult allRes, Vector neighbours) {
        neighbours.clear();
        res.init();
        this.maxDist = Float.MAX_VALUE;
        for (int i = 0; i < this.mySpace.size(); ++i) {
            ACompoundInTheSpace c = (ACompoundInTheSpace)this.mySpace.elementAt(i);
            if (this.diffId && c.getId() == query.getId()) continue;
            if (this.mySpace.getDim() == 0) {
                int qb = query.fingerprint().brightness();
                int cb = c.fingerprint().brightness();
                int min = cb < qb ? cb : qb;
                float lb = 1.0f - (float)min / (float)(cb + qb - min);
                if (!(lb <= threshold) && !this.statsNeeded) continue;
                this.setRes(res, neighbours, query, c);
                continue;
            }
            this.setRes(res, neighbours, query, c);
        }
        if (this.orderSimilarObjects) {
            distanceComparator c = new distanceComparator();
            Collections.sort(neighbours, c);
        }
        if (this.maxSimilar > 0 && this.maxSimilar < neighbours.size()) {
            neighbours.setSize(this.maxSimilar);
        }
        if (res.minDist < allRes.minDist) {
            allRes.minDist = res.minDist;
        }
        if (this.statsNeeded) {
            allRes.avgDist += res.avgDist;
            if (res.maxDist > allRes.maxDist) {
                allRes.maxDist = res.maxDist;
            }
        }
        res.avgDist /= (float)this.mySpace.size();
    }

    public void run() throws ClusteringException, IOException, SQLException, InvalidLicenseKeyException {
        this.startTime = System.currentTimeMillis();
        this.checkWeights();
        if (this.fpSize % 32 != 0) {
            throw new ClusteringException("Binary fingerprint size must be dividable by 32");
        }
        SpaceLoader loader1 = this.input1 != null ? new SpaceInputStream(this.input1) : this.db_input1;
        SpaceLoader loader2 = this.input2 != null ? new SpaceInputStream(this.input2) : this.db_input2;
        this.mySpace = loader1.loadSpace(this.fpSize, this.dimensions, this.weights, !this.generateID);
        this.extSpace = loader2.loadSpace(this.fpSize, this.dimensions, this.weights, !this.generateID);
        if (this.onlyStat) {
            this.statsNeeded = true;
        }
        if (!this.onlyStat) {
            if (this.statsNeeded) {
                this.output.writeHeader("id\tminD\tnneib\tsimcnt\tavgD\tmaxD" + (this.listSimilar ? "\tlist_of_similar_objects ..." : ""));
            } else if (this.onlyDiss) {
                this.output.writeHeader("id");
            } else {
                this.output.writeHeader("id\tminD\tnneib\tsimcnt" + (this.listSimilar ? "\tlist_of_similar_objects ..." : ""));
            }
        }
        StatResult res = new StatResult();
        StatResult allRes = new StatResult();
        Vector neighbours = new Vector(100, 100);
        for (ACompoundInTheSpace query : this.extSpace) {
            this.calcNeighbours(query, this.threshold, res, allRes, neighbours);
            if (!(this.onlyDiss || this.onlyStat || !this.statsNeeded && res.isInInitState())) {
                this.output.setInt(query.getId());
                this.output.setFloat(res.minDist);
                this.output.setInt(res.mostSimilar);
                this.output.setInt(res.similarCount);
                if (this.statsNeeded) {
                    this.output.setFloat(res.avgDist);
                    this.output.setFloat(res.maxDist);
                }
                if (this.listSimilar) {
                    for (int i = 0; i < neighbours.size(); ++i) {
                        this.output.setInt(((ACompoundInTheSpace)neighbours.get(i)).getId());
                    }
                }
                this.output.writeln();
                continue;
            }
            if (this.onlyStat || !this.onlyDiss || !res.isInInitState()) continue;
            this.output.setInt(query.getId());
            this.output.writeln();
        }
        if (this.statsNeeded) {
            allRes.avgDist /= (float)this.mySpace.size();
            allRes.avgDist /= (float)this.extSpace.size();
            this.statStream.println();
            this.statStream.println("STATISTICS");
            this.statStream.println();
            this.statStream.println("Number of objects in set 1 = " + this.mySpace.size());
            this.statStream.println("Number of objects in set 2 = " + this.extSpace.size());
            this.statStream.println("Minimum dissimilarity between sets = " + allRes.minDist);
            this.statStream.println("Average dissimilarity between sets = " + allRes.avgDist);
            this.statStream.println("Maximum dissimilarity between sets = " + allRes.maxDist);
            this.statStream.println();
        }
    }

    public static void main(String[] args) {
        ConnectionHandler conh = null;
        long startTime = System.currentTimeMillis();
        CLQ.Parameter verbose = null;
        Properties p = new Properties();
        Compare cp = new Compare();
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            // empty catch block
        }
        CLQ clq = new CLQ(args, p);
        try {
            String s;
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
            long startMemory = 0L;
            if (verbose != null) {
                System.err.println("Compare started at " + new Date());
                Runtime.getRuntime().gc();
                startMemory = Runtime.getRuntime().freeMemory();
                System.err.println("Free memory at start: " + startMemory + " bytes ");
            }
            CLQ.Parameter inputfiles = clq.lookup("-i", "--input", "", 2, false, false);
            CLQ.Parameter inputqueries = clq.lookup("-q", "--query", "", 2, false, false);
            if (inputfiles != null && inputqueries != null) {
                conh = Compare.openConn(clq);
                cp.setInput1(conh, inputqueries.getString(0));
                cp.setInput2(inputfiles.getString(0));
            } else {
                inputfiles = clq.lookup("-i", "--input", "", 3, false, false);
                inputqueries = clq.lookup("-q", "--query", "", 3, false, false);
                if (inputfiles == null && inputqueries == null) {
                    throw new ArgumentException("Input not defined");
                }
                if (inputfiles != null && inputqueries != null) {
                    throw new ArgumentException("Ambiguous input");
                }
                if (inputfiles != null) {
                    cp.setInput1(inputfiles.getString(0));
                    cp.setInput2(inputfiles.getString(1));
                } else if (inputqueries != null) {
                    conh = Compare.openConn(clq);
                    cp.setInput1(conh, inputqueries.getString(0));
                    cp.setInput2(conh, inputqueries.getString(1));
                }
            }
            CLQ.Parameter genid = clq.lookup("-g", "--generate-id", "", 1, false, false);
            CLQ.Parameter dimensions = clq.lookup("-m", "--dimensions", "", 2, false, false);
            CLQ.Parameter fpsize = clq.lookup("-f", "--fingerprint-size", "fingerprint.size", 2, true, true);
            if (fpsize.getInt() % 32 != 0) {
                throw new ArgumentException("Binary fingerprint size must be dividable by 32");
            }
            int wnum = dimensions != null ? dimensions.getInt() : 0;
            CLQ.Parameter pweights = clq.lookup("-w", "--weights", "", wnum + 1, false, false);
            float[] weights = new float[wnum];
            for (int i = 0; i < wnum; ++i) {
                weights[i] = pweights != null ? (float)pweights.getDouble(i) : 1.0f;
            }
            CLQ.Parameter stat = clq.lookup("-z", "--statistics", "", 1, false, false);
            CLQ.Parameter onlyStat = clq.lookup("-Z", "--only-statistics", "", 1, false, false);
            CLQ.Parameter onlyDiss = clq.lookup("-y", "--only-dissimilar", "", 1, false, false);
            if (onlyDiss != null && (stat != null || onlyStat != null)) {
                throw new ArgumentException("Ambiguous parameters");
            }
            CLQ.Parameter listSimilar = clq.lookup("-L", "--list-similar", "", 1, false, false);
            CLQ.Parameter diffId = clq.lookup("-D", "--different-ids", "", 1, false, false);
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            CLQ.Parameter outputquery = clq.lookup("-a", "--statement", "", 2, false, false);
            if (outputfile == null && outputquery == null) {
                cp.setOutput(System.out);
            } else {
                if (outputfile != null && outputquery != null) {
                    throw new ArgumentException("Ambiguous output");
                }
                if (outputfile != null) {
                    cp.setOutput(outputfile.getString());
                } else if (outputquery != null) {
                    if (conh == null) {
                        conh = Compare.openConn(clq);
                    }
                    cp.setOutput(conh.getConnection(), outputquery.getString());
                }
            }
            CLQ.Parameter threshold = clq.lookup("-t", "--threshold", "compare.threshold", 2, false, false);
            CLQ.Parameter maxsim = clq.lookup("-c", "--max-count", "", 2, false, false);
            CLQ.Parameter ordersim = clq.lookup("-r", "--order", "", 1, false, false);
            CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
            if (store != null) {
                settingsHandler.save(p);
            }
            if ((s = clq.notUsed()) != null) {
                throw new ArgumentException("Unknown or unnecessary parameter: " + s);
            }
            cp.setFpSize(fpsize != null ? fpsize.getInt() : 0);
            cp.setDimensions(dimensions != null ? dimensions.getInt() : 0);
            cp.setWeights(weights);
            cp.setIdGeneration(genid != null);
            cp.setThreshold(threshold == null ? 1.0f : (float)threshold.getDouble());
            cp.setStatNeeded(stat != null);
            cp.setOnlyStat(onlyStat != null);
            cp.setOnlyDissimilarListed(onlyDiss != null);
            cp.setSimilarListed(listSimilar != null);
            cp.setMaxSimilar(maxsim == null ? 0 : maxsim.getInt());
            cp.setOrderSimilarObjects(ordersim != null);
            cp.setDifferentIdsOnly(diffId != null);
            cp.run();
            if (verbose != null) {
                System.err.println("Compare finished at " + new Date());
                System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime) / 1000L + " sec.");
            }
            System.exit(0);
        }
        catch (InvalidLicenseKeyException exi) {
            System.err.println(exi.getMessage());
            System.exit(1);
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }

    private class StatResult {
        float avgDist;
        float minDist;
        float maxDist;
        int mostSimilar;
        int similarCount;

        public StatResult() {
            this.init();
        }

        public void init() {
            this.avgDist = 0.0f;
            this.minDist = Float.MAX_VALUE;
            this.maxDist = Float.MIN_VALUE;
            this.mostSimilar = -1;
            this.similarCount = 0;
        }

        public boolean isInInitState() {
            return this.minDist == Float.MAX_VALUE;
        }
    }

    private class distanceComparator
    implements Comparator {
        private distanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            float dist1 = ((ACompoundInTheSpace)o1).distance;
            float dist2 = ((ACompoundInTheSpace)o2).distance;
            return dist1 == dist2 ? 0 : (dist1 < dist2 ? -1 : 1);
        }
    }
}

