/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.calculations.ElementalAnalyser;
import chemaxon.clustering.LibraryMCS;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.MMoleculeNode;
import chemaxon.clustering.MMultiMoleculeNode;
import chemaxon.clustering.gui.JKProgressMonitor;
import chemaxon.clustering.gui.JKlustor;
import chemaxon.clustering.gui.JKlustorOptionsDialog;
import chemaxon.clustering.gui.ReportDialog;
import chemaxon.clustering.gui.SwingWorker;
import chemaxon.clustering.gui.component.ProgressMonitorPanel;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.Molecule;
import chemaxon.util.FindCodeBase;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JKlustorImport {
    Log log = LogFactory.getLog(JKlustorImport.class);
    private JKlustor jKlustor = null;
    private LibraryMCS libmcs;
    private MGraph workGraph;
    private JKlustorOptionsDialog optionsDialog;
    private ReportDialog reportDialog;
    private ProgressMonitorPanel progressPanel;
    private JKProgressMonitor progressMonitor;
    private Timer timer;
    private TimerListener timerListener;
    private SwingWorker worker;
    private boolean loadDone = true;
    private boolean searchDone = true;
    private String importedStructures;
    private String[] selectedKeys = null;
    private int[] selectedTypes = null;
    static int mode = 9;
    private static Hashtable properties = new Hashtable();
    public static final double INTPROPTOLERANCE = 1.0E-8;
    private static String[] DefaultMols = new String[]{"OC(=O)[C@@H]1CCCN1C(=O)NC2=CC=CC=C2", "[H][C@]1(CCCN1C(=O)CCS)C(O)=O", "C[C@H](CS)C(=O)N1CCC[C@H]1C(O)=O", "CC(S)C(=O)NCC(O)=O", "CCOC(=O)C(CC1=CC=CC=C1)NC(=O)NC(CC2=CC=CC=C2)C(=O)OCC", "OC(=O)[C@@H]1CCCN1C(=O)[C@@H]2CCC[C@H]2SC(=O)C3=CC=CC=C3", "[H][C@@]12CCCC[C@]1([H])N([C@@H](C2)C(O)=O)C(=O)CC[C@@H](NC(=O)C(CCCCN)NC(=O)C3=CN=CC=C3)C(O)=O", "C[C@H](N[C@@H](CCC1=CC=CC=C1)C(O)=O)C(=O)N2CCC[C@H]2C(O)=O", "NCCCC[C@H](NC(CCC1CCCCC1)C(O)=O)C(=O)N(CC(O)=O)C2CCCC2", "C[C@@H]1CSC(=O)[C@@H]2CCCN2C1=O", "CC(Cl)=NOC(N)=O", "C[C@@H]1CSC(=O)[C@@H]2CC3=C(CN2C1=O)C=CC=C3", "C[C@H](CS)C(O)=O", "CC1SC(=O)CNC1=O", "CC1SC(=O)C2CCCN2C1=O", "CC1CSC(=O)CN(C2CCCC2)C1=O", "C[C@@H]1SC(=O)[C@@]2(C)CC3=CC=CC=C3CN2C1=O", "OC(=O)[C@@H]1CCCN1C(=O)C2CCCCC2S", "OC(=O)[C@@H]1CSCCCCCCCC[C@@H](CS)C(=O)N1"};

    public JKlustorImport(JKlustor jKlustor) {
        this.jKlustor = jKlustor;
        this.timerListener = new TimerListener();
        this.timer = new Timer(1000, this.timerListener);
        this.timer.setInitialDelay(0);
    }

    public JKlustorImport(LibraryMCS libMCS, MGraph graph) {
        this.libmcs = libMCS;
        this.workGraph = graph;
    }

    public static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    public static InputStream getInputStream(String s, boolean monitorProgress) throws IOException {
        InputStream is;
        if (JKlustorImport.isURL(s)) {
            URLConnection conn = new URL(s).openConnection();
            is = conn.getInputStream();
            is = new MonitorableInputStream(is, conn.getContentLength());
        } else {
            File f = new File(s);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                File f2 = new File(FindCodeBase.getCodeBaseDir() + File.separator + s);
                if (f2.exists()) {
                    is = new FileInputStream(f2);
                } else {
                    is = BasicEnvironment.getResourceAsStream(JKlustorImport.class, "/" + s);
                    if (is == null) {
                        is = new ByteArrayInputStream(s.getBytes());
                    }
                }
            }
        }
        is = new BufferedInputStream(monitorProgress ? new ProgressMonitorInputStream(null, "Reading " + s, is) : is);
        if (s.endsWith(".gz")) {
            return new GZIPInputStream(is);
        }
        if (s.endsWith(".zip")) {
            System.out.println("zipped");
            return new ZipInputStream(is);
        }
        return is;
    }

    public void setOptionsDialog(JKlustorOptionsDialog optionsDialog) {
        this.optionsDialog = optionsDialog;
        this.optionsDialog.initMCS(3, 9, true, true, true, false, false);
        this.optionsDialog.initClustering(true, 1, 10);
    }

    public void setProgressPanel(ProgressMonitorPanel progressPanel) {
        this.progressPanel = progressPanel;
        String[] progressInfo = new String[]{"Level count", "Total cluster count", "Top level cluster count", "Opened node count"};
        this.progressPanel.addInformationPanel(progressInfo);
    }

    public void setMode(int m) {
        mode = m;
    }

    public void importStructures(String fileName) throws IOException {
        if (fileName.endsWith(".gsf")) {
            this.loadGraph(JKlustorImport.getInputStream(fileName, true));
            return;
        }
        this.importStructures(JKlustorImport.getInputStream(fileName, true));
        this.importedStructures = fileName;
    }

    public void importStructures(String fileName, int[] selectedProperties) throws IOException {
        if (fileName.endsWith(".gsf")) {
            this.loadGraph(JKlustorImport.getInputStream(fileName, true));
            return;
        }
        this.importStructures(JKlustorImport.getInputStream(fileName, true), selectedProperties);
        this.importedStructures = fileName;
    }

    public void importStructures(InputStream is) throws IOException {
        this.importStructures(is, null);
    }

    public void importStructures(InputStream is, int[] selectedProperties) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"importStructures()");
            this.log.trace((Object)("selectedProperties: " + U.sel(selectedProperties)));
        }
        this.importedStructures = "Unknown";
        this.workGraph = new MGraph();
        this.libmcs = new LibraryMCS(this.workGraph);
        this.jKlustor.setLibMCS(this.libmcs);
        this.startLoad(is, selectedProperties);
    }

    public void addStructures(String fileName) throws IOException {
        this.addStructures(JKlustorImport.getInputStream(fileName, true));
        this.importedStructures = fileName;
    }

    public void addStructures(InputStream is) throws IOException {
        this.addStructures(is, null);
    }

    public void addStructures(InputStream is, int[] selectedProperties) throws IOException {
        this.importedStructures = "Unknown";
        this.startLoad(is, selectedProperties);
    }

    private void createReportDialog() {
        this.reportDialog = new ReportDialog(this.jKlustor.getClusterViewer());
        this.reportDialog.setTerminationCause(this.libmcs.getStopCauseExplanation());
        this.reportDialog.setImportedStructures(this.importedStructures);
        this.reportDialog.setImportedStructureCount("" + this.libmcs.getInputStructureCount());
        this.reportDialog.setRunningTime(JKlustorImport.formatProgressText(this.libmcs.getRunningTime() / 1000L));
        this.reportDialog.setLevelCount("" + this.libmcs.getLevelCount());
        this.reportDialog.setTopLevelClusterCount("" + this.libmcs.getTopLevelClusterCount());
        this.reportDialog.setTotalClusterCount("" + this.libmcs.getTotalClusterCount());
        this.reportDialog.pack();
        this.reportDialog.setLocationRelativeTo(this.jKlustor.getClusterViewer());
    }

    public void showReport() {
        if (this.reportDialog != null) {
            this.reportDialog.setVisible(true);
        }
    }

    private void setOptions(LibraryMCS mcs) {
        mcs.setMCSMode(this.optionsDialog.getMode());
        mcs.setMinimumMCSSize(this.optionsDialog.getMinimalMCSSize());
        mcs.setAtomTypeMatch(this.optionsDialog.getAtomTypeMatch());
        mcs.setBondTypeMatch(this.optionsDialog.getBondTypeMatch());
        mcs.setChargeMatch(this.optionsDialog.getChargeMatch());
        mcs.setKeepRings(this.optionsDialog.isKeepRings());
        mcs.setRequiredClusterCount(this.optionsDialog.getRequiredClusterCount());
        mcs.setAllowedLevelCount(this.optionsDialog.getMaximumLevelCount());
    }

    private void startLoad(final InputStream is, final int[] selectedProperties) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"startLoad", new Throwable().fillInStackTrace());
        }
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new LoadTask(is);
            }

            @Override
            public void finished() {
                if (JKlustorImport.this.log.isTraceEnabled()) {
                    JKlustorImport.this.log.trace((Object)"startLoad worker finished");
                }
                if (!JKlustorImport.this.loadDone) {
                    JKlustorImport.this.loadDone = true;
                    return;
                }
                int i = 0;
                try {
                    if (selectedProperties == null && !JKlustorImport.this.selectProperties(JKlustorImport.this.jKlustor.getClusterViewer())) {
                        return;
                    }
                    if (selectedProperties != null) {
                        JKlustorImport.this.selectProperties(selectedProperties);
                    }
                    JKlustorImport.this.jKlustor.getClusterViewer().setCursor(Cursor.getPredefinedCursor(3));
                    JKlustorImport.this.calculateLibMCS();
                    JKlustorImport.this.jKlustor.getClusterViewer().setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (RuntimeException rex) {
                    System.err.println("Internal exception: " + rex.getMessage());
                    System.err.println("Input molecule " + (i + 1) + " is ignored.");
                    rex.printStackTrace();
                }
                catch (Exception e) {
                    JKlustorImport.this.jKlustor.getClusterViewer().setCursor(Cursor.getPredefinedCursor(0));
                    e.printStackTrace();
                }
            }
        };
        this.worker.start();
    }

    private void startSearch() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"startSearch()", new Throwable().fillInStackTrace());
        }
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                JKlustorImport.this.searchDone = false;
                return new SearchTask();
            }

            @Override
            public void finished() {
                if (JKlustorImport.this.log.isTraceEnabled()) {
                    JKlustorImport.this.log.trace((Object)"startSearch worker finished()");
                }
                if (!JKlustorImport.this.searchDone) {
                    JKlustorImport.this.searchDone = true;
                    return;
                }
                JKlustorImport.this.createReportDialog();
                JKlustorImport.this.showReport();
                if (JKlustorImport.this.selectedKeys != null && JKlustorImport.this.selectedKeys.length > 0) {
                    JKlustorImport.this.workGraph.setProperties(JKlustorImport.this.selectedKeys, JKlustorImport.this.selectedTypes);
                }
                JKlustorImport.this.jKlustor.setGraph(JKlustorImport.this.workGraph);
            }
        };
        this.worker.start();
    }

    private void startProgress() {
        this.timerListener.setMCS(this.libmcs);
        if (this.progressPanel != null) {
            this.progressPanel.setMessage("Calculating Library MCS");
            this.progressPanel.reset(0, this.libmcs.getLengthOfTask());
            this.jKlustor.getClusterViewer().setProgressMode(true);
        } else {
            this.progressMonitor = new JKProgressMonitor(this.jKlustor.getClusterViewer(), "Calculating Library MCS", " ", 0, this.libmcs.getLengthOfTask());
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setProgress(this.libmcs.getLengthOfTask() / 100);
        }
        this.timer.start();
    }

    private void stopProgress() {
        if (this.progressPanel != null) {
            this.jKlustor.getClusterViewer().setProgressMode(false);
        } else {
            this.progressMonitor.close();
        }
        this.searchDone = true;
        this.timer.stop();
    }

    private void setProgress(int p) {
        if (this.progressPanel != null) {
            this.progressPanel.setProgressValue(p);
            this.progressPanel.setInformationString(0, "" + this.libmcs.getLevelCount());
            this.progressPanel.setInformationString(1, "" + this.libmcs.getTotalClusterCount());
            this.progressPanel.setInformationString(2, "" + this.libmcs.getTopLevelClusterCount());
            this.progressPanel.setInformationString(3, "" + this.libmcs.getOpenedNodeCount());
        } else {
            this.progressMonitor.setProgress(p);
        }
    }

    private void setProgressNote(String s) {
        if (this.progressPanel != null) {
            this.progressPanel.setNote(s);
        } else {
            this.progressMonitor.setNote(s);
        }
    }

    private boolean isProgressCanceled() {
        return this.progressPanel == null ? this.progressMonitor.isCanceled() : this.progressPanel.isCanceled();
    }

    public void calculateLibMCS() {
        this.setOptions(this.libmcs);
        this.startProgress();
        this.startSearch();
    }

    public void resetLibMCS() {
        this.libmcs.reset();
    }

    public void levelClustering() {
        this.setOptions(this.libmcs);
        boolean b = this.libmcs.step();
        if (!b && this.libmcs.getStopCause() == 6) {
            JOptionPane.showMessageDialog(this.jKlustor.getClusterViewer(), this.libmcs.getStopCauseExplanation(), "Add One Level failed", 2);
        }
    }

    private static String formatProgressText(long remainingTime) {
        long h = remainingTime / 3600L;
        long m = (remainingTime - h * 3600L) / 60L;
        long s = remainingTime - h * 3600L - m * 60L;
        String hs = h < 10L ? "0" + h : "" + h;
        String ms = m < 10L ? "0" + m : "" + m;
        String ss = s < 10L ? "0" + s : "" + s;
        return hs + ":" + ms + ":" + ss;
    }

    private void selectProperties(int[] selected) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("selectProperties( " + U.sel(selected) + " ) propKeys: " + U.sel(this.getPropertyKeys()) + " propTypes: " + U.sel(this.getPropertyTypes())), new Throwable());
        }
        if (selected == null) {
            this.selectedKeys = new String[0];
            this.selectedTypes = new int[0];
            return;
        }
        String[] propKeys = this.getPropertyKeys();
        int[] propTypes = this.getPropertyTypes();
        if (propKeys.length == 0) {
            return;
        }
        this.selectedKeys = new String[selected.length];
        this.selectedTypes = new int[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            this.selectedKeys[i] = propKeys[selected[i] - 1];
            this.selectedTypes[i] = propTypes[selected[i] - 1];
        }
    }

    private boolean selectProperties(Component parent) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("selectProperties() dilog propKeys: " + U.sel(this.getPropertyKeys()) + " propTypes: " + U.sel(this.getPropertyTypes())));
        }
        String[] propKeys = this.getPropertyKeys();
        int[] propTypes = this.getPropertyTypes();
        if (propKeys.length == 0) {
            return true;
        }
        JPanel dp = new JPanel();
        JPanel propKeyPanel = new JPanel();
        propKeyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Properties"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        int r = 8;
        int c = propKeys.length / 8 + 1;
        if (c > 4) {
            c = 4;
            r = propKeys.length / 4;
        } else if (c == 1) {
            r = propKeys.length;
        }
        propKeyPanel.setLayout(new GridLayout(r, c));
        final JCheckBox[] propKeyCheckBox = new JCheckBox[propKeys.length];
        for (int i = 0; i < propKeys.length; ++i) {
            propKeyCheckBox[i] = new JCheckBox(propKeys[i], propTypes[i] != 3);
            propKeyPanel.add(propKeyCheckBox[i]);
        }
        JCheckBox selectAll = new JCheckBox("Select all");
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                for (int i = 0; i < propKeyCheckBox.length; ++i) {
                    propKeyCheckBox[i].setSelected(cb.isSelected());
                }
            }
        });
        JPanel cp = new JPanel();
        cp.setLayout(new BoxLayout(cp, 0));
        cp.add(selectAll);
        dp.setLayout(new BoxLayout(dp, 1));
        dp.add(propKeyPanel);
        dp.add(cp);
        int mode = JOptionPane.showConfirmDialog(parent, dp, "Select properties to import", 2, -1);
        if (mode == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"OK hit");
            }
            int countSelected = 0;
            for (int i = 0; i < propKeyCheckBox.length; ++i) {
                if (!propKeyCheckBox[i].isSelected()) continue;
                ++countSelected;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("countSelected=" + countSelected));
            }
            if (countSelected == 0) {
                return true;
            }
            this.selectedKeys = new String[countSelected];
            this.selectedTypes = new int[countSelected];
            int actual = 0;
            for (int i = 0; i < propKeyCheckBox.length; ++i) {
                if (!propKeyCheckBox[i].isSelected()) continue;
                this.selectedKeys[actual] = propKeys[i];
                this.selectedTypes[actual] = propTypes[i];
                ++actual;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("selectedKeys=" + U.sel(this.selectedKeys) + " selectedTypes=" + U.sel(this.selectedTypes)));
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"NOT OK hit");
        }
        return false;
    }

    public void readStructures(InputStream is) throws Exception {
        block5: {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"readStructures()");
            }
            properties.clear();
            this.selectedKeys = null;
            this.selectedTypes = null;
            MolImporter molimp = this.getMolImporter(is);
            Molecule mol = this.readNext(molimp);
            while (mol != null) {
                this.updateProperties(mol);
                this.libmcs.addMolecule(mol);
                mol = this.readNext(molimp);
                Thread.sleep(1L);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"done, close is");
            }
            try {
                is.close();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)"Exception on closing input", (Throwable)e);
            }
        }
    }

    private void updateProperties(Molecule mol) {
        if (this.log.isTraceEnabled()) {
            // empty if block
        }
        String[] pKeys = mol.properties().getKeys();
        for (int i = 0; i < pKeys.length; ++i) {
            String key = pKeys[i];
            int type = this.guessType(mol.getProperty(key));
            if (!properties.containsKey(key)) {
                properties.put(key, new Integer(type));
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("updateProperties() size: " + properties.size() + " properties.put( " + key + " , " + type + " )"));
                continue;
            }
            int to = (Integer)properties.get(key);
            int tn = this.getType(type, (Integer)properties.get(key));
            if (tn == to) continue;
            properties.remove(key);
            properties.put(key, new Integer(tn));
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("updateProperties() size: " + properties.size() + " properties change type from " + to + " to " + tn));
        }
    }

    private int guessType(String propertyValue) {
        try {
            if (propertyValue.trim().length() == 0) {
                System.err.println("Warning! Empty property value.");
                return 2;
            }
            double dvalue = Double.valueOf(propertyValue);
            if (Math.abs(dvalue - Math.rint(dvalue)) < 1.0E-8) {
                if (dvalue != Math.rint(dvalue)) {
                    System.err.println("Warning! Non exact integer match for property value: " + propertyValue);
                }
                return 2;
            }
            return 1;
        }
        catch (NumberFormatException e1) {
            return 3;
        }
    }

    private int getType(int type, int currentType) {
        if (currentType == 2 && type == 1) {
            return type;
        }
        return currentType;
    }

    public String[] getPropertyKeys() {
        String[] keys = new String[properties.size()];
        int i = 0;
        Enumeration pKeys = properties.keys();
        while (pKeys.hasMoreElements()) {
            keys[i++] = (String)pKeys.nextElement();
        }
        return keys;
    }

    public int[] getPropertyTypes() {
        int[] types = new int[properties.size()];
        int i = 0;
        Enumeration pValues = properties.elements();
        while (pValues.hasMoreElements()) {
            types[i++] = (Integer)pValues.nextElement();
        }
        return types;
    }

    private MolImporter getMolImporter(InputStream is) throws Exception {
        if (is == null) {
            is = System.in;
        }
        return new MolImporter(new MolInputStream(is));
    }

    private Molecule readNext(MolImporter molimp) throws IOException {
        Molecule mol = molimp.read();
        return mol != null ? this.prepare(mol) : null;
    }

    private Molecule prepare(Molecule mol) {
        mol.aromatize();
        if (mol.getDim() < 2) {
            mol.clean(2, "");
        }
        mol.calcHybridization();
        return mol;
    }

    public MGraph createDefaultTestGraph() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"createDefaultTestGraph()");
        }
        this.workGraph = new MGraph();
        this.libmcs = new LibraryMCS(this.workGraph);
        this.jKlustor.setLibMCS(this.libmcs);
        this.setOptions(this.libmcs);
        for (int i = 0; i < DefaultMols.length; ++i) {
            this.libmcs.addMolecule(MolImporter.importMol(DefaultMols[i]));
        }
        this.libmcs.search();
        return this.workGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MGraph createTestGraph() {
        System.out.println(" - Creating a test Graph -");
        String[] propKeys = new String[]{"mass"};
        int[] propTypes = new int[]{1};
        MGraph tempGraph = new MGraph(propKeys, propTypes);
        Molecule molec = new Molecule();
        MolImporter mip = null;
        ElementalAnalyser analyser = new ElementalAnalyser();
        int nextID = 0;
        Molecule clstr = null;
        try {
            clstr = MolImporter.importMol("CCCCCCCCCCCC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        analyser.setMolecule(clstr);
        clstr.setPropertyObject("mass", new Double(analyser.exactMass()));
        molec.setProperty("ID", String.valueOf(nextID));
        tempGraph.addCluster(new MMoleculeNode(clstr));
        molec.setProperty("ID", String.valueOf(++nextID));
        tempGraph.addCluster(new MMoleculeNode(clstr));
        molec.setProperty("ID", String.valueOf(++nextID));
        ++nextID;
        tempGraph.addCluster(new MMoleculeNode(clstr));
        System.out.println("3 main clusters added.");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                molec.setProperty("ID", String.valueOf(nextID));
                ++nextID;
                tempGraph.addCluster(tempGraph.getTopLevelCluster(i), new MMoleculeNode(clstr));
            }
        }
        System.out.println("10-10-10 sub clusters added.");
        System.out.println("Importing 30000 nodes...");
        try {
            int i;
            try {
                mip = new MolImporter("ncitest10000.smiles");
            }
            catch (FileNotFoundException e) {
                mip = new MolImporter(Environment.getCodeBase() + "ncitest10000.smiles");
            }
            for (i = 0; i < 10000; ++i) {
                molec = mip.read();
                analyser.setMolecule(molec);
                molec.setPropertyObject("mass", new Double(analyser.exactMass()));
                molec.setProperty("ID", String.valueOf(nextID));
                ++nextID;
                tempGraph.addNode(tempGraph.getTopLevelCluster(0).getChild(i % 10), new MMoleculeNode(molec));
            }
            mip.close();
            mip = new MolImporter("ncitest10000.smiles");
            for (i = 0; i < 10000; ++i) {
                int j;
                MMultiMoleculeNode tmp;
                if (i % 10 == 3) {
                    molec = mip.read();
                    analyser.setMolecule(molec);
                    molec.setPropertyObject("mass", new Double(analyser.exactMass()));
                    molec.setProperty("ID", String.valueOf(nextID));
                    ++nextID;
                    tmp = new MMultiMoleculeNode(molec);
                    tempGraph.addNode(tempGraph.getTopLevelCluster(1).getChild(i % 10), tmp);
                    for (j = 0; j < 10; j += 2) {
                        tempGraph.addNode(tempGraph.getTopLevelCluster(2).getChild(j), new MMultiMoleculeNode(tmp));
                    }
                    continue;
                }
                if (i % 10 == 6) {
                    molec = mip.read();
                    analyser.setMolecule(molec);
                    molec.setPropertyObject("mass", new Double(analyser.exactMass()));
                    molec.setProperty("ID", String.valueOf(nextID));
                    ++nextID;
                    tmp = new MMultiMoleculeNode(molec);
                    tempGraph.addNode(tempGraph.getTopLevelCluster(1).getChild(i % 10), tmp);
                    for (j = 1; j < 10; j += 2) {
                        tempGraph.addNode(tempGraph.getTopLevelCluster(2).getChild(j), new MMultiMoleculeNode(tmp));
                    }
                    continue;
                }
                molec = mip.read();
                analyser.setMolecule(molec);
                molec.setPropertyObject("mass", new Double(analyser.exactMass()));
                molec.setProperty("ID", String.valueOf(nextID));
                ++nextID;
                tempGraph.addNode(tempGraph.getTopLevelCluster(1).getChild(i % 10), new MMoleculeNode(molec));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                mip.close();
            }
            catch (Exception e) {}
        }
        System.out.println("Graph ready.");
        System.out.println();
        return tempGraph;
    }

    public void loadGraph(InputStream is) {
        try {
            ObjectInputStream oi = new ObjectInputStream(is);
            MGraph g = new MGraph();
            g.loadGraph(oi);
            oi.close();
            this.workGraph = g;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JKlustorImport.this.jKlustor.setGraph(JKlustorImport.this.workGraph);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class TimerListener
    implements ActionListener {
        LibraryMCS mcs = null;
        long initialTime;
        long timeTotal = -1L;

        public void setMCS(LibraryMCS mcs) {
            this.mcs = mcs;
            this.initialTime = System.currentTimeMillis();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int c = this.mcs.getCurrent();
            c = c >= this.mcs.getLengthOfTask() / 100 ? c : this.mcs.getLengthOfTask() / 100;
            JKlustorImport.this.setProgress(c);
            String cs = JKlustorImport.formatProgressText((System.currentTimeMillis() - this.initialTime) / 1000L);
            String s = JKlustorImport.formatProgressText(this.mcs.getRemainingTime());
            if (s != null) {
                JKlustorImport.this.setProgressNote(cs + " / " + s);
            }
            if (JKlustorImport.this.searchDone) {
                JKlustorImport.this.stopProgress();
            }
            if (JKlustorImport.this.isProgressCanceled()) {
                JKlustorImport.this.worker.interrupt();
                JKlustorImport.this.stopProgress();
            }
        }
    }

    class SearchTask {
        SearchTask() {
            try {
                JKlustorImport.this.libmcs.search();
                JKlustorImport.this.searchDone = true;
            }
            catch (InterruptedException ie) {
                JKlustorImport.this.stopProgress();
                JKlustorImport.this.searchDone = false;
            }
            catch (Throwable t) {
                JKlustorImport.this.jKlustor.handleError(t);
                JKlustorImport.this.stopProgress();
            }
        }
    }

    class LoadTask {
        LoadTask(InputStream is) {
            try {
                JKlustorImport.this.loadDone = false;
                JKlustorImport.this.readStructures(is);
                JKlustorImport.this.loadDone = true;
            }
            catch (InterruptedIOException ie) {
            }
            catch (Throwable t) {
                JKlustorImport.this.jKlustor.handleError(t);
            }
        }
    }
}

