/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.Cluster;
import java.util.Iterator;
import java.util.Vector;

final class JPCluster
extends Vector
implements Cluster {
    private static int idseed = 1;
    private int id;
    private int size = 0;
    private ACompoundInTheSpace centroid = null;
    private ChemicalSpace space = null;

    public JPCluster(ChemicalSpace space, ACompoundInTheSpace seed, int id) {
        this.space = space;
        this.id = id;
        this.add(seed);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void clear() {
        Iterator t = this.iterator();
        while (t.hasNext()) {
            ((ACompoundInTheSpace)t.next()).clearNeighbours();
        }
        super.clear();
    }

    public double distance(ACompoundInTheSpace c) {
        Iterator i = this.iterator();
        double dist = 0.0;
        while (i.hasNext()) {
            ACompoundInTheSpace ac = (ACompoundInTheSpace)i.next();
            dist += (double)this.space.distance(c, ac);
        }
        return dist;
    }

    public ACompoundInTheSpace getCentroid() {
        if (this.centroid == null) {
            this.centroid = this.findCentroid();
        }
        return this.centroid;
    }

    private ACompoundInTheSpace findCentroid() {
        Iterator i = this.iterator();
        ACompoundInTheSpace c = null;
        double min = Double.MAX_VALUE;
        while (i.hasNext()) {
            ACompoundInTheSpace ac = (ACompoundInTheSpace)i.next();
            double dist = this.distance(ac);
            if (!(dist < min)) continue;
            c = ac;
            min = dist;
        }
        return c;
    }

    @Override
    public boolean add(Object c) {
        ((ACompoundInTheSpace)c).setCluster(this);
        this.centroid = null;
        return super.add(c);
    }
}

