/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.JKlustorImport;
import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.SimilarityMatrix;
import chemaxon.clustering.SimpleMoleculeNode;
import chemaxon.clustering.gui.JKlustor;
import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.formats.MolExporter;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modules.MCS;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import chemaxon.util.CmdLine;
import chemaxon.util.Heap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryMCS
implements Licensable {
    Log log = LogFactory.getLog(LibraryMCS.class);
    public static final int DEFAULT_REQUIRED_CLUSTER_COUNT = 1;
    public static final int DEFAULT_ALLOWED_LEVEL_COUNT = 10;
    public static final int ATOM_COUNT_UPPER_BOUND = 50;
    public static final int MAX_LEVEL_COUNT = 100;
    static final int DEFAULT_FINGERPRINT_LENGTH = 512;
    static final int DEFAULT_FINGEPRINT_PATH = 5;
    static final int DEFAULT_FINGERPRINT_BITS = 1;
    public static final int DEFAULT_MCS_MODE = 3;
    public static final boolean DEFAULT_ATOM_TYPE_MATCH = true;
    public static final boolean DEFAULT_BOND_TYPE_MATCH = true;
    public static final boolean DEFAULT_CHARGE_MATCH = true;
    public static final boolean DEFAULT_KEEP_RINGS = true;
    public static final int DEFAULT_MIN_MCS_SIZE = 9;
    private int requiredClusterCount = 1;
    private int allowedLevelCount = 10;
    private int MCSmode = 3;
    private int atomCountUpperBound = 50;
    private int fingerprintLength = 512;
    private int fingerprintPath = 5;
    private int fingerprintBits = 1;
    private float maxAllowedPairRatio = 0.1f;
    private int maxMemoryKB = 4096;
    private MGraph clusters;
    private CFParameters cfp;
    private ArrayList openedNodes = new ArrayList();
    private int openedNodesCount;
    private ChemicalFingerprint[] cfps;
    private ArrayList newNodes = null;
    private ChemicalFingerprint[] newCfps;
    private int newNodesCount;
    private int inputStructureCount;
    private int levelCount = 0;
    private int nextClusterId = 0;
    private SearchOptions[] searchOptions;
    private SearchOptions currentSearchOptions = new SearchOptions();
    private MCS mcsSearch = new MCS();
    private SubstructureSearch ssSearch = new SubstructureSearch();
    private SimilarityMatrix simMatr = null;
    private static final int SIMILARITY_CALC_TIME = 0;
    private static final int SIMILARITY_SEARCH_TIME = 1;
    private static final int MCS_TIME = 2;
    private static final int SSS_TIME = 3;
    private static final int TIME_COMPONENT_COUNT = 4;
    private int[] unitTime = new int[]{2, 1, 300, 10};
    private long[] timeTotal = new long[4];
    private long[] timeStat = new long[4];
    private int[] samplingCount = new int[4];
    private int[] samplingFreq = new int[]{1000, 10000, 50, 1000};
    private int[] avgClusterSize = new int[]{2};
    private long startTime;
    private long stopTime;
    private int mcsCalls = 0;
    private int mcsOK = 0;
    private int[] mcsHitDistrBySimilarity = new int[11];
    private int[] mcsNonHitDistrBySimilarity = new int[11];
    private int sssCalls = 0;
    private int sssOK = 0;
    private int[] sssHitDistrBySimilarity = new int[11];
    private int[] sssNonHitDistrBySimilarity = new int[11];
    public static final int TERMINATION_UNKNOWN = 0;
    public static final int TERMINATION_ERROR = 1;
    public static final int TERMINATION_LEVEL_COUNT = 2;
    public static final int TERMINATION_CLUSTER_COUNT = 3;
    public static final int TERMINATION_MCS_SIZE_LIMIT = 4;
    public static final int TERMINATION_CANCEL = 5;
    public static final int TERMINATION_SAME_PARAMETERS = 6;
    public static final int TERMINATION_STEP_NOT_ALLOWED = 7;
    private static final String[] TERMINATION_EXPLANATION = new String[]{"Clustering stopped for an unknown reason.", "Clustering stopped due to an internal error.", "Clustering terminated normally. Maximum allowed number of levels was reached.", "Clustering terminated normally. Top level cluster count was reached.", "Clustering terminated normally. Minimal MCS size limit was reached.", "Clustering was cancelled by user. ", "Nothing to do, MCS parameters have not been changed from last level.", "step() is not allowed prior to search()."};
    private int terminationCondition = 0;
    private String licenseEnvironment = "";
    private static final String NL = System.getProperty("line.separator");
    private static final String PrgName = "Library MCS";
    private static final String PrgHeader = NL + "Library MCS" + " - " + "Maximum Common Substructure Clustering " + JKlustor.version + ", (C) 2006-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Clusters input structure with respect to shared common substructures." + NL + "" + NL + "Usage: " + "Library MCS" + " [input file] [options] " + NL + "" + NL + "Options: " + NL + "  -h, --help                   this help message" + NL + "  -v, --verbose                progres monitoring and other messages" + NL + "  -e, --exact                  exact MCS recognition" + NL + "  -f, --fast                   fast, yet fairly accurate MCS recognition" + NL + "  -t, --turbo                  fastest and less reliable MCS recognition" + NL + "  -n, --minMCS <size>          integer value specifying the MCS size " + NL + "                               where clustering terminates" + NL + "  -m, --match (a|b|c|r) (+|-)  turns matching contraints on (+), off (-)" + NL + "                               for atom types (a), bond types (b), " + NL + "                               formak charges (c) and rings (r)" + NL + "  -o, --output <filename>      SDF output file, terminal if -o omitted" + NL + "  -o, --output CSV <filename>  CSV output file" + NL + "  -r, --report                 generate report (cluster statistics)" + NL + "" + NL;
    private static int OUTPUT_CSV = 1;
    private static int OUTPUT_SDF;
    private static int outputType;
    private static LibraryMCS libMCS;
    private static String outputFileName;
    private static boolean verbose;
    private static boolean report;
    private static boolean diag;

    @Override
    public final boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("JKlustor", this.licenseEnvironment);
    }

    @Override
    public final void setLicenseEnvironment(String string) {
        this.licenseEnvironment = string;
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("JKlustor", this.licenseEnvironment);
    }

    LibraryMCS(MGraph clusteredGraph) throws LicenseException {
        this.checkLicense();
        this.clusters = clusteredGraph;
    }

    public LibraryMCS() throws LicenseException {
        this.checkLicense();
        this.clusters = new MGraph();
    }

    void setMGraph(MGraph clusters) {
        this.clusters = clusters;
    }

    private void init() {
        if (this.cfp != null) {
            return;
        }
        this.cfp = new CFParameters();
        this.cfp.setLength(this.fingerprintLength);
        this.cfp.setBondCount(this.fingerprintPath);
        this.cfp.setBitCount(this.fingerprintBits);
    }

    public void reset() {
        this.nextClusterId = 0;
        this.levelCount = 1;
        this.openedNodes.clear();
        this.openedNodesCount = 0;
        this.newNodes.clear();
        this.newNodesCount = 0;
        this.clusters.getLeafNodes(this.openedNodes);
        this.openedNodesCount = this.openedNodes.size();
        this.sort();
        this.clusters.clear();
        this.nextClusterId = this.inputStructureCount = this.openedNodesCount;
        this.simMatr.clear();
    }

    private void sort() {
        for (int sortedTo = 0; sortedTo < this.openedNodes.size() - 1; ++sortedTo) {
            int currentID = Integer.parseInt(((SimpleMoleculeNode)this.openedNodes.get(sortedTo)).getProperty("ID"));
            int minPos = this.findMinPos(sortedTo + 1);
            SimpleMoleculeNode min = (SimpleMoleculeNode)this.openedNodes.get(minPos);
            int minID = Integer.parseInt(((SimpleMoleculeNode)this.openedNodes.get(minPos)).getProperty("ID"));
            if (minID >= currentID) continue;
            Object current = this.openedNodes.get(sortedTo);
            this.openedNodes.set(sortedTo, this.openedNodes.get(minPos));
            this.openedNodes.set(minPos, current);
        }
    }

    private int findMinPos(int from) {
        int minPos = from;
        int min = Integer.parseInt(((SimpleMoleculeNode)this.openedNodes.get(minPos)).getProperty("ID"));
        for (int i = from + 1; i < this.openedNodes.size(); ++i) {
            int id = Integer.parseInt(((SimpleMoleculeNode)this.openedNodes.get(i)).getProperty("ID"));
            if (id >= min) continue;
            min = id;
            minPos = i;
        }
        return minPos;
    }

    public void setDissimCutoff(float dissimCutoff) {
    }

    public void setMCSSimilarityThreshold(float mcsSimilarityThreshold) {
    }

    public void setMinimalSimilarityMeasurement(float minSimilarity) {
        this.setMCSSimilarityThreshold(minSimilarity);
    }

    public void setRequiredClusterCount(int requiredClusterCount) {
        this.requiredClusterCount = requiredClusterCount;
    }

    public void setAllowedLevelCount(int allowedLevelCount) {
        this.allowedLevelCount = allowedLevelCount;
    }

    public void setAtomCountUpperBound(int atomCountUpperBound) {
        this.atomCountUpperBound = atomCountUpperBound;
    }

    public void setFastSearch(boolean toggleFastSearch) {
    }

    public void setMCSMode(int mode) {
        this.MCSmode = mode;
    }

    public void setMode(int mode) {
        this.MCSmode = mode;
    }

    public void setMinimumMCSSize(int mcsSize) {
        this.currentSearchOptions.minMCSSize = mcsSize;
    }

    public void setAtomTypeMatch(boolean b) {
        this.currentSearchOptions.atomTypeMatch = b;
    }

    public void setBondTypeMatch(boolean b) {
        this.currentSearchOptions.bondTypeMatch = b;
    }

    public void setChargeMatch(boolean b) {
        this.currentSearchOptions.chargeMatch = b;
    }

    void setHybridizationMatch(boolean b) {
        this.currentSearchOptions.hybridizationMatch = b;
        throw new RuntimeException("Method LibraryMCS.setHybridizationMatch() is not implemented.");
    }

    void setIsotopeMatch(boolean b) {
        throw new RuntimeException("Method LibraryMCS.setIsotopeMatch() is not implemented.");
    }

    public void setKeepRings(boolean b) {
        this.currentSearchOptions.keepRings = b;
    }

    void setFingerprintLength(int fingeprintLength) {
        this.fingerprintLength = fingeprintLength;
    }

    void setFingerprintPath(int fingerprintPath) {
        this.fingerprintPath = fingerprintPath;
    }

    void setFingerprintBits(int fingerpintBits) {
        this.fingerprintBits = fingerpintBits;
    }

    public void addMolecule(Molecule mol) {
        this.init();
        SimpleMoleculeNode newNode = new SimpleMoleculeNode(mol);
        int cid = this.openedNodes.size();
        newNode.setID(cid);
        ((MBaseNode)newNode).setProperty("ID", Integer.toString(cid));
        ((MBaseNode)newNode).setPropertyObject("CF", this.generateCFp(mol));
        this.openedNodes.add(newNode);
        this.inputStructureCount = this.openedNodes.size();
        ++this.openedNodesCount;
        ++this.nextClusterId;
    }

    private boolean isCoordinationCompound(Molecule m) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtno() != 137) continue;
            return true;
        }
        return false;
    }

    public boolean search() throws InterruptedException {
        this.startTime = System.currentTimeMillis();
        this.initSearch();
        this.levelCount = 1;
        this.nextClusterId = this.inputStructureCount = this.openedNodes.size();
        boolean merged = this.clusterOneLevel();
        Thread.sleep(1L);
        while (merged && !this.finished()) {
            this.gatherOpenedNodes();
            merged = this.clusterOneLevel();
            Thread.sleep(1L);
        }
        ArrayList toplevel = merged ? this.newNodes : this.openedNodes;
        for (int i = 0; i < toplevel.size(); ++i) {
            MBaseNode n = (MBaseNode)toplevel.get(i);
            n.setID(this.nextClusterId++);
            this.clusters.addNode(n);
        }
        if (!merged) {
            this.terminationCondition = 4;
        } else {
            this.gatherOpenedNodes();
        }
        this.stopTime = System.currentTimeMillis();
        return this.terminationOk();
    }

    public boolean step() {
        if (this.levelCount == 0) {
            this.terminationCondition = 7;
            return false;
        }
        if (this.currentSearchOptions.equals(this.searchOptions[this.levelCount - 1])) {
            this.terminationCondition = 6;
            return false;
        }
        if (this.clusterOneLevel()) {
            this.clusters.dropOldRoot();
            for (int i = 0; i < this.newNodes.size(); ++i) {
                MBaseNode n = (MBaseNode)this.newNodes.get(i);
                n.setID(this.nextClusterId++);
                this.clusters.addNode(n);
            }
            this.terminationCondition = 4;
            this.gatherOpenedNodes();
        }
        return this.terminationOk();
    }

    private boolean terminationOk() {
        return this.terminationCondition == 3 || this.terminationCondition == 4;
    }

    private void initSearch() {
        this.alloc();
        this.getCFPs();
    }

    private void alloc() {
        if (this.simMatr != null) {
            return;
        }
        this.simMatr = new SimilarityMatrix(this.openedNodesCount);
        this.simMatr.maxMemoryKB(45536);
        this.simMatr.initialize();
        this.cfps = new ChemicalFingerprint[this.openedNodes.size()];
        this.newNodes = new ArrayList();
        this.newCfps = new ChemicalFingerprint[this.openedNodes.size()];
        this.searchOptions = new SearchOptions[100];
    }

    private void getCFPs() {
        for (int i = 0; i < this.openedNodes.size(); ++i) {
            SimpleMoleculeNode n = (SimpleMoleculeNode)this.openedNodes.get(i);
            this.cfps[i] = (ChemicalFingerprint)n.getPropertyObject("CF");
        }
    }

    private ChemicalFingerprint generateCFp(StaticMolecule m) {
        ChemicalFingerprint cf = new ChemicalFingerprint(this.cfp);
        try {
            cf.generate(m.toMolecule());
            return cf;
        }
        catch (MDGeneratorException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ChemicalFingerprint generateCFp(Molecule m) {
        ChemicalFingerprint cf = new ChemicalFingerprint(this.cfp);
        try {
            cf.generate(m);
            return cf;
        }
        catch (MDGeneratorException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initMCS() {
        this.mcsSearch = new MCS();
        this.mcsSearch.setMinimumCommonSize(this.currentSearchOptions.minMCSSize);
        this.mcsSearch.setIgnoreAtomType(!this.currentSearchOptions.atomTypeMatch);
        this.mcsSearch.setIgnoreBondType(!this.currentSearchOptions.bondTypeMatch);
        this.mcsSearch.setIgnoreCharge(!this.currentSearchOptions.chargeMatch);
        this.mcsSearch.setIgnoreHybridization(!this.currentSearchOptions.hybridizationMatch);
        this.mcsSearch.setDontBreakRingBonds(this.currentSearchOptions.keepRings);
        this.mcsSearch.setMode(this.MCSmode);
    }

    MGraph getResultGraph() {
        return this.clusters;
    }

    public ClusterEnumerator getClusterEnumerator(boolean leavesOnly) {
        return new ClusterEnumerator(this.clusters, leavesOnly);
    }

    public ClusterEnumerator getClusterEnumerator(boolean leavesOnly, boolean selectedOnly) {
        return new ClusterEnumerator(this.clusters, leavesOnly, selectedOnly);
    }

    public int getStopCause() {
        return this.terminationCondition;
    }

    public String getStopCauseExplanation() {
        return TERMINATION_EXPLANATION[this.terminationCondition];
    }

    String getDiagnosticMessage() {
        return "MCS calls = " + this.mcsCalls + " Hits = " + this.mcsOK + "\n" + "SSS calls = " + this.sssCalls + " Hits = " + this.sssOK + "\n" + "MCS time: " + this.timeTotal[2] + " (avg: " + this.unitTime[2] + " )" + "\n" + "SSS time: " + this.timeTotal[3] + " (avg: " + this.unitTime[3] + " )" + "\n" + "Similarity search time: " + this.timeTotal[1] + " (avg: " + this.unitTime[1] + " )" + "\n" + "Similarity calc. time: " + this.timeTotal[0] + " (avg: " + this.unitTime[0] + " )" + "\n";
    }

    public int getInputStructureCount() {
        return this.inputStructureCount;
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public int getTotalClusterCount() {
        return this.nextClusterId - this.inputStructureCount;
    }

    public int getTopLevelClusterCount() {
        int n = this.newNodes == null ? 0 : this.newNodes.size();
        return this.levelCount == 1 ? n : this.openedNodesCount + n;
    }

    int getOpenedNodeCount() {
        return this.openedNodesCount;
    }

    long getRunningTime() {
        return this.stopTime - this.startTime;
    }

    long getRemainingTime() {
        int mcsCountOnCurrentLevel = this.openedNodes.size() / this.avgClusterSize[0];
        int sssCountOnCurrentLevel = this.openedNodes.size() * this.openedNodes.size() / 2;
        long currentLevelCompletionTime = mcsCountOnCurrentLevel * (this.unitTime[2] + this.unitTime[1]) + sssCountOnCurrentLevel * this.unitTime[3];
        int remainingClusterCount = this.getTopLevelClusterCount() - 1;
        int levelsToComplete = Math.min(this.allowedLevelCount - this.levelCount, (int)Math.sqrt(remainingClusterCount));
        long totalTime = (long)(remainingClusterCount * (this.unitTime[2] + this.unitTime[0]) + remainingClusterCount * remainingClusterCount * (this.unitTime[1] + this.unitTime[3])) + currentLevelCompletionTime;
        return totalTime / 1000L;
    }

    int getLengthOfTask() {
        return this.inputStructureCount;
    }

    int getCurrent() {
        return this.inputStructureCount - this.openedNodesCount;
    }

    private boolean finished() {
        if (this.levelCount == this.allowedLevelCount) {
            this.terminationCondition = 2;
            return true;
        }
        if (this.newNodes.size() <= this.requiredClusterCount) {
            this.terminationCondition |= 3;
            return true;
        }
        return false;
    }

    private void gatherOpenedNodes() {
        ArrayList swapNodes = this.openedNodes;
        this.openedNodes = this.newNodes;
        this.newNodes = swapNodes;
        this.openedNodesCount = this.openedNodes.size();
        ChemicalFingerprint[] swapCfps = this.cfps;
        this.cfps = this.newCfps;
        this.newCfps = swapCfps;
        this.newNodes.clear();
        this.newNodesCount = 0;
    }

    private boolean clusterOneLevel() {
        try {
            this.initSimilars();
            boolean merged = false;
            while (!this.simMatr.empty()) {
                boolean bl = merged = this.merge() || merged;
                if (!this.simMatr.empty()) continue;
                this.simMatr.renew();
            }
            if (!merged) {
                return false;
            }
            for (int i = 0; i < this.openedNodes.size(); ++i) {
                if (this.simMatr.isDeleted(i)) continue;
                MBaseNode n = (MBaseNode)this.openedNodes.get(i);
                MBaseNode newCluster = n.copy();
                newCluster.setID(this.nextClusterId++);
                this.clusters.addNode(newCluster, n);
                this.newNodes.add(newCluster);
                this.newCfps[this.newNodesCount++] = this.cfps[i];
            }
            this.searchOptions[this.levelCount] = new SearchOptions(this.currentSearchOptions);
            ++this.levelCount;
            return true;
        }
        catch (Heap.HeapException e) {
            e.printStackTrace();
            return false;
        }
        catch (MDGeneratorException e) {
            System.err.println("Failed to import structure, skipped.\n" + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean merge() {
        int i1 = this.simMatr.getSimIndex1();
        MBaseNode n1 = (MBaseNode)this.openedNodes.get(i1);
        int i2 = this.simMatr.getSimIndex2();
        MBaseNode n2 = (MBaseNode)this.openedNodes.get(i2);
        StaticMolecule m1 = (StaticMolecule)n1.getContent();
        StaticMolecule m2 = (StaticMolecule)n2.getContent();
        if (m1.getAtomCount() > this.atomCountUpperBound || m2.getAtomCount() > this.atomCountUpperBound) {
            this.simMatr.deleteMostSimilarPair();
            return false;
        }
        StaticMolecule mcs = this.findMCS(m1, m2, this.cfps[i1], this.cfps[i2]);
        if (mcs == null) {
            this.simMatr.deleteMostSimilarPair();
            return false;
        }
        MBaseNode newCluster = this.createCluster(mcs);
        if (newCluster == null) {
            this.simMatr.deleteMostSimilarPair();
            return false;
        }
        this.clusters.addNode(newCluster, n1);
        this.clusters.addNode(newCluster, n2);
        this.openedNodesCount -= 2;
        this.simMatr.deleteMostSimilarMolecules();
        this.newNodes.add(newCluster);
        this.newCfps[this.newNodesCount++] = this.generateCFp(mcs);
        this.expandCluster(newCluster, mcs, this.newCfps[this.newNodesCount - 1]);
        return true;
    }

    private StaticMolecule findMCS(StaticMolecule m1, StaticMolecule m2, ChemicalFingerprint f1, ChemicalFingerprint f2) {
        long t0 = System.currentTimeMillis();
        StaticMolecule mcs = null;
        try {
            if (this.checkSSS(m1, m2, f1, f2)) {
                mcs = m1.getAtomCount() < m2.getAtomCount() ? m1 : m2;
                ++this.mcsOK;
            } else {
                this.initMCS();
                this.mcsSearch.setMolecules(m1, m2);
                if (this.mcsSearch.findFirst()) {
                    mcs = this.mcsSearch.getResultAsStaticMolecule();
                    ++this.mcsOK;
                }
            }
            long t1 = System.currentTimeMillis();
            this.updateTimeStatistics(2, t0, t1);
            ++this.mcsCalls;
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            System.out.println("Something went wrong... Ignored, clustering continued.");
            System.out.println("m1=" + m1.toMolecule().toFormat("smiles"));
            System.out.println("f1=" + f1.toBinaryString());
            System.out.println("m2=" + m2.toMolecule().toFormat("smiles"));
            System.out.println("f2=" + f2.toBinaryString());
            System.out.println("common bit count = " + f1.getCommonBitCount(f2));
            System.out.println("levelCount = " + this.levelCount);
            ai.printStackTrace(System.out);
        }
        catch (Exception e) {
            System.err.println("Something went wrong... Ignored, clustering continued.");
            e.printStackTrace();
            return null;
        }
        return mcs;
    }

    private boolean checkSSS(StaticMolecule m1, StaticMolecule m2, ChemicalFingerprint f1, ChemicalFingerprint f2) {
        StaticMolecule qm = m2;
        StaticMolecule tm = m1;
        ChemicalFingerprint qfp = f2;
        ChemicalFingerprint tfp = f1;
        if (m1.getAtomCount() < m2.getAtomCount()) {
            qm = m1;
            tm = m2;
            qfp = f1;
            tfp = f2;
        }
        if (!qfp.isSubSetOf(tfp)) {
            return false;
        }
        this.ssSearch.setMolecules(qm, tm);
        return this.ssSearch.findFirst();
    }

    private MBaseNode createCluster(StaticMolecule mcs) {
        SimpleMoleculeNode newCluster = new SimpleMoleculeNode(mcs);
        newCluster.setID(this.nextClusterId++);
        return newCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandCluster(MBaseNode cluster, StaticMolecule mcs, ChemicalFingerprint mcsCF) {
        int delSkippedCount = 0;
        int cfpSkippedCount = 0;
        int sssc = 0;
        int sssh = 0;
        int elementCount = 2;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < this.openedNodes.size(); ++i) {
            if (this.simMatr.isDeleted(i)) {
                ++delSkippedCount;
                continue;
            }
            ChemicalFingerprint cfi = this.cfps[i];
            if (!mcsCF.isSubSetOf(cfi)) {
                ++cfpSkippedCount;
                continue;
            }
            MBaseNode n = (MBaseNode)this.openedNodes.get(i);
            StaticMolecule m = (StaticMolecule)n.getContent();
            this.ssSearch.setMolecules(mcs, m);
            boolean sssfound = this.ssSearch.findFirst();
            ++this.sssCalls;
            ++sssc;
            if (!sssfound) continue;
            this.clusters.addNode(cluster, n);
            --this.openedNodesCount;
            this.simMatr.deleteItem(i);
            ++this.sssOK;
            ++sssh;
            ++elementCount;
        }
        int[] i = this.avgClusterSize;
        synchronized (this.avgClusterSize) {
            this.avgClusterSize[0] = (this.avgClusterSize[0] + elementCount) / 2;
            // ** MonitorExit[i] (shouldn't be in output)
            long t1 = System.currentTimeMillis();
            this.updateTimeStatistics(3, t0, t1);
            return;
        }
    }

    private void initSimilars() throws MDGeneratorException {
        long t0 = System.currentTimeMillis();
        this.simMatr.clear();
        for (int i = 0; i < this.openedNodes.size(); ++i) {
            MBaseNode n = (MBaseNode)this.openedNodes.get(i);
            this.simMatr.addMolecule((StaticMolecule)n.getContent(), this.cfps[i]);
        }
        long t1 = System.currentTimeMillis();
        this.updateTimeStatistics(0, t0, t1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTimeStatistics(int which, long start, long stop) {
        int n = which;
        this.timeTotal[n] = this.timeTotal[n] + (stop - start);
        int n2 = which;
        this.timeStat[n2] = this.timeStat[n2] + (stop - start);
        int n3 = which;
        this.samplingCount[n3] = this.samplingCount[n3] + 1;
        if (this.samplingCount[n3] != this.samplingFreq[which]) return;
        int[] nArray = this.unitTime;
        synchronized (this.unitTime) {
            this.unitTime[which] = (int)((long)this.unitTime[which] + this.timeStat[which] / (long)this.samplingFreq[which]) / 2;
            if (this.unitTime[which] < 10) {
                int n4 = which;
                this.samplingFreq[n4] = this.samplingFreq[n4] * 2;
            }
            this.timeStat[which] = 0L;
            this.samplingCount[which] = 0;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    void dump() {
        System.out.println("==== dump ====");
        System.out.println("clusters: " + this.clusters);
        System.out.println("openednodes: " + this.openedNodes);
        System.out.println("newnodes" + this.newNodes);
        System.out.println("");
        System.out.println("levelCount: " + this.levelCount);
        System.out.println("nextClusterId: " + this.nextClusterId);
        System.out.println("\n==== dump ====");
    }

    public static void main(String[] args) {
        Log log = LogFactory.getLog(LibraryMCS.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"main()");
        }
        if (args.length == 0) {
            JKlustor.main(args);
            return;
        }
        CmdLine cmdLine = new CmdLine(args);
        LibraryMCS.processCmdLine(cmdLine);
        String inputFileName = cmdLine.getUnused();
        JKlustorImport jci = new JKlustorImport(libMCS, LibraryMCS.libMCS.clusters);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading structures from " + inputFileName));
            }
            if (verbose) {
                System.out.print("Reading structures from " + inputFileName + " ... ");
            }
            jci.readStructures(JKlustorImport.getInputStream(inputFileName, false));
            if (verbose) {
                System.out.println("done.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start clustering. ");
            }
            if (verbose) {
                System.out.print("Clustering ... ");
            }
            long startTime = System.currentTimeMillis();
            libMCS.search();
            long endTime = System.currentTimeMillis();
            if (verbose) {
                System.out.println("done.");
            }
            LibraryMCS.writeOutput();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cluster count: " + libMCS.getTotalClusterCount()));
                log.debug((Object)("Top level cluster count: " + libMCS.getTopLevelClusterCount()));
                log.debug((Object)("Level count: " + libMCS.getLevelCount()));
            }
            if (report) {
                System.out.println("Cluster count: " + libMCS.getTotalClusterCount());
                System.out.println("Top level cluster count: " + libMCS.getTopLevelClusterCount());
                System.out.println("Level count: " + libMCS.getLevelCount());
            }
            if (diag) {
                System.out.println(libMCS.getDiagnosticMessage());
                System.out.println("Total search time (real, not CPU!!!): " + (endTime - startTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processCmdLine(CmdLine cmdLine) {
        try {
            if (cmdLine.exists('h', "help")) {
                System.out.println(UsageInfo);
                System.exit(-1);
            }
            if (cmdLine.find('f', "fast") != -1) {
                libMCS.setMCSMode(2);
            } else if (cmdLine.find('t', "turbo") != -1) {
                libMCS.setMCSMode(3);
            } else if (cmdLine.find('e', "exact") != -1) {
                libMCS.setMCSMode(1);
            }
            int minMCSPos = cmdLine.find('n', "minMCS", 1);
            if (minMCSPos != -1) {
                libMCS.setMinimumMCSSize(cmdLine.getInt(minMCSPos + 1));
            }
            int matchPos = cmdLine.find('m', "match", 1);
            while (matchPos != -1) {
                String type = cmdLine.getString(matchPos + 1);
                if (type.charAt(0) == 'a') {
                    libMCS.setAtomTypeMatch(type.charAt(1) == '+');
                } else if (type.charAt(0) == 'b') {
                    libMCS.setBondTypeMatch(type.charAt(1) == '+');
                } else if (type.charAt(0) == 'c') {
                    libMCS.setChargeMatch(type.charAt(1) == '+');
                } else if (type.charAt(0) == 'r') {
                    libMCS.setKeepRings(type.charAt(1) == '+');
                }
                matchPos = cmdLine.find('m', "match", 1);
            }
            int ofPos = cmdLine.find('o', "output", 1, 3);
            if (ofPos != -1) {
                if (cmdLine.getParamCount(ofPos) == 2) {
                    String ot = cmdLine.getString(ofPos + 1);
                    if (ot.equalsIgnoreCase("CSV")) {
                        outputType = OUTPUT_CSV;
                    } else if (ot.equalsIgnoreCase("SDF")) {
                        outputType = OUTPUT_SDF;
                    }
                    outputFileName = cmdLine.getString(ofPos + 2);
                } else {
                    outputFileName = cmdLine.getString(ofPos + 1);
                }
            }
            verbose = cmdLine.exists('v', "verbose");
            report = cmdLine.exists('r', "report");
            diag = cmdLine.exists('d', "diag");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeOutput() throws Exception {
        if (verbose) {
            System.out.print("Writing output ... ");
        }
        PrintStream out = outputFileName == null ? System.out : null;
        OutputStream outputStream = out = out == null ? new FileOutputStream(new File(outputFileName)) : out;
        if (outputType == OUTPUT_SDF) {
            LibraryMCS.writeSDFOutput(out);
        } else {
            LibraryMCS.writeCSVOutput(out);
        }
        if (verbose) {
            System.out.println("done.");
        }
    }

    private static void writeSDFOutput(OutputStream out) throws Exception {
        MolExporter mo = new MolExporter(new BufferedOutputStream(out), outputType == OUTPUT_SDF ? "sdf" : "smiles");
        ClusterEnumerator results = libMCS.getClusterEnumerator(true);
        while (results.hasNext()) {
            mo.write(results.next());
        }
        mo.close();
    }

    private static int levelCount(String hierId) {
        int lc = 1;
        for (int i = 0; i < hierId.length(); ++i) {
            if (hierId.charAt(i) != '.') continue;
            ++lc;
        }
        return lc;
    }

    private static void writeCSVOutput(OutputStream out) throws Exception {
        PrintStream outs = new PrintStream(out);
        int levelCount = libMCS.getLevelCount();
        int[] counters = new int[levelCount];
        ClusterEnumerator results = libMCS.getClusterEnumerator(false);
        while (results.hasNext()) {
            Molecule m = results.next();
            String hierId = (String)m.getPropertyObject("HierarchyID");
            int level = LibraryMCS.levelCount(hierId);
            int n = level - 1;
            counters[n] = counters[n] + 1;
            outs.println(m.toFormat("smiles") + "," + level + "," + counters[level - 1]);
        }
        outs.close();
    }

    static {
        outputType = OUTPUT_SDF = 2;
        libMCS = new LibraryMCS();
        verbose = false;
        report = false;
        diag = false;
    }

    public class ClusterEnumerator {
        MBaseNode lastNodeOnCurrentLevel;
        MBaseNode currentNode;
        MBaseNode rootNode;
        private boolean hasNext = true;
        private boolean leavesOnly = false;

        protected ClusterEnumerator(MGraph g, boolean leavesOnly) {
            this(g, leavesOnly, false);
        }

        protected ClusterEnumerator(MGraph g, boolean leavesOnly, boolean selectedOnly) {
            this.leavesOnly = leavesOnly;
            this.rootNode = g.getRootNode();
            this.lastNodeOnCurrentLevel = this.rootNode.getLastChild();
            this.currentNode = this.rootNode.getFirstChild();
            LibraryMCS.this.clusters.setNodeProperties();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Molecule next() {
            MBaseNode ret = this.currentNode;
            ret.convertPropertiesToStringProperties();
            if (this.currentNode.hasChildren()) {
                this.currentNode = this.currentNode.getFirstChild();
                this.lastNodeOnCurrentLevel = this.currentNode.getParent().getLastChild();
                if (!this.leavesOnly) {
                    return ret.getMoleculeWithProperty();
                }
                return this.next();
            }
            if (this.currentNode != this.lastNodeOnCurrentLevel) {
                this.currentNode = this.currentNode.getFollower();
                return ret.getMoleculeWithProperty();
            }
            this.currentNode = this.currentNode.getParent().getFollower();
            this.lastNodeOnCurrentLevel = this.currentNode.getParent().getLastChild();
            while (this.currentNode == this.lastNodeOnCurrentLevel.getFollower()) {
                if (this.currentNode.getParent() == this.rootNode) {
                    this.hasNext = false;
                    return ret.getMoleculeWithProperty();
                }
                this.currentNode = this.currentNode.getParent().getFollower();
                this.lastNodeOnCurrentLevel = this.currentNode.getParent().getLastChild();
            }
            return ret.getMoleculeWithProperty();
        }
    }

    class SearchOptions {
        public int minMCSSize = 9;
        public boolean atomTypeMatch = true;
        public boolean bondTypeMatch = true;
        public boolean chargeMatch = true;
        public boolean hybridizationMatch = false;
        public boolean keepRings = true;

        public SearchOptions() {
        }

        public SearchOptions(SearchOptions c) {
            this.minMCSSize = c.minMCSSize;
            this.atomTypeMatch = c.atomTypeMatch;
            this.bondTypeMatch = c.bondTypeMatch;
            this.chargeMatch = c.chargeMatch;
            this.keepRings = c.keepRings;
        }

        public boolean equals(SearchOptions o) {
            return this.minMCSSize == o.minMCSSize && this.atomTypeMatch == o.atomTypeMatch && this.bondTypeMatch == o.bondTypeMatch && this.chargeMatch == o.chargeMatch && this.keepRings == o.keepRings;
        }
    }
}

