/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MGraph;
import chemaxon.clustering.MultiNode;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class MBaseNode {
    protected transient MGraph parentGraph = null;
    protected transient MBaseNode parent = null;
    protected transient MBaseNode lastChild = null;
    protected transient MBaseNode follower = this;
    protected transient boolean mark = false;
    protected transient int colorNode = 0;
    protected transient boolean hidden = false;
    protected transient boolean newnode = false;
    protected transient int id = 0;

    public MBaseNode() {
    }

    public MBaseNode(MGraph g) {
        this();
        this.setGraph(g);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.parentGraph = null;
        this.parent = null;
        this.follower = null;
        this.lastChild = null;
    }

    public void onRemove() {
        this.parentGraph = null;
        this.parent = null;
        this.follower = null;
        this.lastChild = null;
    }

    public boolean isAttached() {
        return this.parentGraph != null;
    }

    public MBaseNode getParent() {
        return this.parent;
    }

    public MGraph getGraph() {
        return this.parentGraph;
    }

    public MBaseNode getFirstChild() {
        return this.lastChild == null ? null : this.lastChild.getFollower();
    }

    public MBaseNode getFirstVisibleChild() {
        if (this.lastChild == null) {
            return null;
        }
        MBaseNode firstChild = this.getFirstChild();
        if (!firstChild.isHidden()) {
            return firstChild;
        }
        for (MBaseNode tmp = firstChild.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
            if (tmp.isHidden()) continue;
            return tmp;
        }
        return null;
    }

    public MBaseNode getLastChild() {
        return this.lastChild == null ? null : this.lastChild;
    }

    public MBaseNode getLastVisibleChild() {
        MBaseNode firstNotHiddenChild = this.getFirstVisibleChild();
        if (firstNotHiddenChild == null) {
            return null;
        }
        MBaseNode lastNotHiddenChild = firstNotHiddenChild;
        for (MBaseNode tmp = firstNotHiddenChild.getVisibleFollower(); tmp != firstNotHiddenChild; tmp = tmp.getVisibleFollower()) {
            lastNotHiddenChild = tmp;
        }
        return lastNotHiddenChild;
    }

    public MBaseNode getChild(int num) {
        int tmpnum = num;
        if (tmpnum >= 0 && tmpnum < this.getChildCount()) {
            MBaseNode chld = this.getFirstChild();
            while (tmpnum > 0) {
                chld = chld.getFollower();
                --tmpnum;
            }
            return chld;
        }
        return null;
    }

    public MBaseNode getFollower() {
        return this.follower;
    }

    public MBaseNode getVisibleFollower() {
        for (MBaseNode tmp = this.getFollower(); tmp != this; tmp = tmp.getFollower()) {
            if (tmp.isHidden()) continue;
            return tmp;
        }
        return this.isHidden() ? null : this;
    }

    protected void setParent(MBaseNode newParent) {
        this.parent = newParent;
    }

    public int getDepth() {
        int depth = 0;
        MBaseNode tmp = this;
        while (tmp.getParent() != null) {
            ++depth;
            tmp = tmp.getParent();
        }
        return depth;
    }

    protected void setGraph(MGraph g) {
        this.parentGraph = g;
        if (this.parentGraph != null && this.lastChild != null) {
            this.lastChild.setGraph(this.parentGraph);
            for (MBaseNode tmp = this.lastChild.getFollower(); tmp != this.lastChild; tmp = tmp.getFollower()) {
                tmp.setGraph(this.parentGraph);
            }
        }
    }

    protected void putBefore(MBaseNode followNode) {
        if (followNode != null) {
            MBaseNode tmp;
            for (tmp = followNode; tmp != null && tmp.follower != followNode; tmp = tmp.getFollower()) {
            }
            this.putAfter(tmp);
        }
    }

    protected void putAfter(MBaseNode prevNode) {
        if (prevNode != null) {
            this.follower = prevNode.follower;
            prevNode.follower = this;
            this.setParent(prevNode.parent);
            this.setGraph(prevNode.getGraph());
        }
    }

    public MBaseNode addChild(MBaseNode child) {
        if (this.lastChild != null) {
            child.putAfter(this.lastChild);
        } else {
            child.setParent(this);
            child.follower = child;
            child.setGraph(this.getGraph());
        }
        this.lastChild = child;
        return this.lastChild;
    }

    public void mark() {
        if (this.isHidden()) {
            return;
        }
        if (!this.mark) {
            this.mark = true;
            this.getGraph().attachToMarkedList(this);
        }
    }

    public void unmark() {
        if (this.hidden) {
            return;
        }
        if (this.mark) {
            this.mark = false;
            this.getGraph().unattachFromMarkedList(this);
        }
    }

    public void unmarkNoRemove() {
        this.mark = false;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public boolean isNewnode() {
        return this.newnode;
    }

    public void setNewnode(boolean newnode) {
        this.newnode = newnode;
    }

    public Object getContent() {
        return null;
    }

    public Molecule getMolecule() {
        return null;
    }

    public Molecule getMoleculeWithProperty() {
        return null;
    }

    protected void setParentColor() {
        if (this.getParent() == null) {
            return;
        }
        int colr = 0;
        colr |= this.getColor();
        for (MBaseNode tmp = this.getFollower(); tmp != this; tmp = tmp.getFollower()) {
            colr |= tmp.getColor();
        }
        this.getParent().colorNode = colr;
        this.getParent().setParentColor();
    }

    public int getColor() {
        return this.colorNode;
    }

    public boolean hasColor(int color) {
        return (this.colorNode & 1 << color) != 0;
    }

    public void setColor(int color) {
        if (!this.hasColor(color)) {
            this.colorNode = 1 << color;
            this.setParentColor();
        }
    }

    public void addColor(int color) {
        this.colorNode |= 1 << color;
        this.addParentColor(color);
    }

    protected void addParentColor(int color) {
        if (this.getParent() != null) {
            this.getParent().addColor(color);
        }
    }

    public void removeColor(int color) {
        if (this.hasColor(color)) {
            this.colorNode &= ~(1 << color);
            this.setParentColor();
        }
    }

    public void clearColor() {
        if (this.colorNode != 0) {
            this.colorNode = 0;
            this.setParentColor();
        }
    }

    protected void hideAllChildren() {
        MBaseNode tmp = this.lastChild;
        if (tmp == null) {
            return;
        }
        tmp.hide();
        for (tmp = tmp.getFollower(); tmp != this.lastChild; tmp = tmp.getFollower()) {
            tmp.hide();
        }
    }

    public void hide() {
        this.hidden = true;
        this.hideAllChildren();
    }

    public void hideUnmarkedNodesUnder() {
        MBaseNode firstNotHiddenChild = this.getFirstVisibleChild();
        if (firstNotHiddenChild != null) {
            if (!firstNotHiddenChild.isMarked()) {
                firstNotHiddenChild.hide();
            } else {
                firstNotHiddenChild.hideUnmarkedNodesUnder();
            }
            for (MBaseNode next = firstNotHiddenChild.getFollower(); next != firstNotHiddenChild; next = next.getFollower()) {
                if (next.isHidden()) continue;
                if (!next.isMarked()) {
                    next.hide();
                    continue;
                }
                next.hideUnmarkedNodesUnder();
            }
        }
    }

    public void show() {
        this.hidden = false;
        if (this.getParent() != null) {
            this.getParent().show();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasChildren() {
        return this.getLastChild() != null;
    }

    public boolean hasVisibleChildren() {
        return this.visibleChildCount() > 0;
    }

    protected int getValidChildCount(int level) {
        if (0 == level) {
            return 1;
        }
        int num = this.lastChild.getValidChildCount(level - 1);
        for (MBaseNode tmp = this.lastChild.getFollower(); tmp != this.lastChild; tmp = tmp.getFollower()) {
            num += tmp.getValidChildCount(level - 1);
        }
        return num;
    }

    public int getChildCount() {
        if (this.lastChild == null) {
            return 0;
        }
        return this.getValidChildCount(1);
    }

    public int numberOfChildren(int level) {
        if (this.getDepth() + level > this.getGraph().getDepth() || level < 0) {
            return 0;
        }
        return this.getValidChildCount(level);
    }

    protected int numberOfNotHiddenChildrenValid(int level) {
        if (0 == level) {
            return this.isHidden() ? 0 : 1;
        }
        int num = this.lastChild.numberOfNotHiddenChildrenValid(level - 1);
        for (MBaseNode tmp = this.lastChild.getFollower(); tmp != this.lastChild; tmp = tmp.getFollower()) {
            num += tmp.numberOfNotHiddenChildrenValid(level - 1);
        }
        return num;
    }

    public int getNewNodeChildrenCount(int level) {
        if (0 == level) {
            return this.isNewnode() ? 1 : 0;
        }
        int num = this.lastChild.getNewNodeChildrenCount(level - 1);
        for (MBaseNode tmp = this.lastChild.getFollower(); tmp != this.lastChild; tmp = tmp.getFollower()) {
            num += tmp.getNewNodeChildrenCount(level - 1);
        }
        return num;
    }

    public int visibleChildCount() {
        if (this.lastChild == null) {
            return 0;
        }
        return this.numberOfNotHiddenChildrenValid(1);
    }

    public int visibleChildCount(int level) {
        if (this.getDepth() + level > this.getGraph().getDepth() || level < 0) {
            return 0;
        }
        return this.numberOfNotHiddenChildrenValid(level);
    }

    public int getLeafNodeCount() {
        return this.visibleChildCount(this.getGraph().getDepth() - this.getDepth());
    }

    public int getLeafNodeCount(int level) {
        return this.numberOfNotHiddenChildrenValid(level);
    }

    public void markLevelUnder(int i) {
        if (i == 0) {
            this.mark();
        } else if (i > 0 && this.lastChild != null) {
            MBaseNode firstChild;
            MBaseNode tmp = firstChild = this.getFirstChild();
            tmp.markLevelUnder(i - 1);
            for (tmp = tmp.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
                tmp.markLevelUnder(i - 1);
            }
        }
    }

    public void unmarkLevelUnder(int i) {
        if (i == 0) {
            this.unmark();
        } else if (i > 0 && this.lastChild != null) {
            MBaseNode firstChild;
            MBaseNode tmp = firstChild = this.getFirstChild();
            tmp.unmarkLevelUnder(i - 1);
            for (tmp = tmp.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
                tmp.unmarkLevelUnder(i - 1);
            }
        }
    }

    public void setID(int newID) {
        this.id = newID;
    }

    public int getID() {
        return this.id;
    }

    public String whoamI() {
        String who = "";
        if (this.parent != null) {
            int num = 0;
            for (MBaseNode tmp = this.parent.getFirstChild(); tmp != this; tmp = tmp.getFollower()) {
                ++num;
            }
            who = this.parent.whoamI() + "," + num;
        } else {
            who = "root";
        }
        return who;
    }

    protected void loadNodeData(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        this.colorNode = in.readInt();
        this.hidden = in.readBoolean();
        this.id = in.readInt();
        this.mark = in.readBoolean();
        if (this.parentGraph != null && this.mark) {
            this.parentGraph.attachToMarkedList(this);
        }
    }

    private void loadNodeChildren(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        int numOfChldrn = in.readInt();
        for (int i = 0; i < numOfChldrn; ++i) {
            MBaseNode insertNode;
            try {
                insertNode = (MBaseNode)((Class)in.readObject()).newInstance();
            }
            catch (Exception e) {
                throw new ClassNotFoundException(e.getMessage());
            }
            this.addChild(insertNode);
            insertNode.loadNode(in, multiNodes);
        }
    }

    public void loadNode(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        this.loadNodeData(in, multiNodes);
        this.loadNodeChildren(in, multiNodes);
    }

    public void saveNodeData(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        out.writeInt(this.colorNode);
        out.writeBoolean(this.hidden);
        out.writeInt(this.id);
        out.writeBoolean(this.mark);
    }

    private void saveNodeChildren(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        int numOfChldrn = this.getChildCount();
        out.writeInt(numOfChldrn);
        for (int i = 0; i < numOfChldrn; ++i) {
            MBaseNode childi = this.getChild(i);
            out.writeObject(childi.getClass());
            childi.saveNode(out, multiNodes, actualSerialForMultiNodes);
        }
    }

    public void saveNode(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        this.saveNodeData(out, multiNodes, actualSerialForMultiNodes);
        this.saveNodeChildren(out, multiNodes, actualSerialForMultiNodes);
    }

    public int getPropertyCount() {
        return 0;
    }

    public String getPropertyKey(int i) {
        return null;
    }

    public String getProperty(String key) {
        return null;
    }

    public Object getPropertyObject(String key) {
        return null;
    }

    public void setProperty(String key, String value) {
    }

    public void setPropertyObject(String key, Object value) {
    }

    public void convertPropertiesToStringProperties() {
    }

    public boolean isMultiNode() {
        return this instanceof MultiNode;
    }

    public MBaseNode copy() {
        MBaseNode copy = new MBaseNode();
        return copy;
    }
}

