/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MLevelEnumeration;
import chemaxon.clustering.scaffolding.logging.LogHistory;
import chemaxon.marvin.modelling.util.U;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MGraph {
    Log log = LogFactory.getLog(MGraph.class);
    public Log logh = new LogHistory(this.log, "MGraph history log", true);
    public static final String ID = "ID";
    public static final String PARENT_ID = "ParentID";
    public static final String CLUSTER_ID = "ClusterID";
    public static final String ELEMENT_COUNT = "ElementCount";
    public static final String CLUSTER_MEMBER = "Cluster.Member";
    public static final String RECOVERY_ID = "RecoveryID";
    public static final String HIERARCHY_ID = "HierarchyID";
    public static final int FLOAT_TYPE = 0;
    public static final int DOUBLE_TYPE = 1;
    public static final int INT_TYPE = 2;
    public static final int OTHER_TYPE = 3;
    private static final int RANGE_TYPE_UPPER_BORDER = 2;
    private transient MBaseNode root = null;
    private transient Vector markedList;
    private transient int position = 0;
    private transient int nextClusterID = 1;
    private int recoveryID;
    private int memberID;
    private transient boolean[] markedInIntervals = null;
    private transient String[] propertyKeys = null;
    private transient int[] propertyTypes = null;

    public MGraph() {
        this(null, null);
    }

    public MGraph(String[] propKeys, int[] propTypes) {
        if (this.log.isTraceEnabled()) {
            this.logh.trace((Object)"Constructor call", new Throwable().fillInStackTrace());
            this.logh.trace((Object)U.sel(propTypes));
        }
        this.root = new MBaseNode(this);
        this.markedList = new Vector(500, 500);
        this.markedList.clear();
        this.setProperties(propKeys, propTypes);
    }

    public void onRemove() {
        this.root = null;
        this.markedList.clear();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.root = null;
        this.markedList.clear();
    }

    public void addCluster(MBaseNode cluster) {
        this.addCluster(this.root, cluster);
    }

    public void addCluster(MBaseNode cluster, int clusterID) {
        this.addCluster(this.root, cluster, clusterID);
    }

    public void addCluster(MBaseNode parent, MBaseNode cluster) {
        this.addCluster(parent, cluster, this.nextClusterID);
        ++this.nextClusterID;
    }

    public void addCluster(MBaseNode parent, MBaseNode cluster, int clusterID) {
        parent.addChild(cluster);
        cluster.setID(clusterID);
    }

    public void addNode(MBaseNode node) {
        this.addNode(this.root, node);
    }

    public void addNode(MBaseNode parent, MBaseNode node) {
        parent.addChild(node);
    }

    public void dropOldRoot() {
        this.root = new MBaseNode(this);
    }

    public void clear() {
        if (this.log.isTraceEnabled()) {
            this.logh.trace((Object)"clear()");
        }
        if (this.root.getFirstChild() != null) {
            this.clearNodeData();
        }
        this.root = new MBaseNode(this);
    }

    private void clearNodeData() {
        if (!this.root.hasChildren()) {
            return;
        }
        ArrayList nodes = new ArrayList();
        this.putNodesToList(this.root, nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            ((MBaseNode)nodes.get(i)).onRemove();
        }
    }

    private void putNodesToList(MBaseNode node, ArrayList nodes) {
        nodes.add(node);
        if (!node.hasChildren()) {
            return;
        }
        MBaseNode cnode = node.getFirstChild();
        this.putNodesToList(cnode, nodes);
        for (MBaseNode tmp = cnode.getFollower(); tmp != cnode; tmp = tmp.getFollower()) {
            this.putNodesToList(tmp, nodes);
        }
    }

    public int getDepth() {
        int depth = 0;
        MBaseNode tmp = this.root;
        while (tmp.getFirstChild() != null) {
            ++depth;
            tmp = tmp.getFirstChild();
        }
        return depth;
    }

    public void markNode(MBaseNode nod) {
        nod.mark();
    }

    public void attachToMarkedList(MBaseNode nod) {
        this.markedList.add(nod);
    }

    public void unmarkNode(MBaseNode nod) {
        nod.unmark();
    }

    public void unattachFromMarkedList(MBaseNode nod) {
        this.markedList.remove(nod);
    }

    public void unmarkAllNodes() {
        int size = this.markedList.size();
        for (int i = size - 1; i >= 0; --i) {
            ((MBaseNode)this.markedList.elementAt(i)).unmarkNoRemove();
        }
        this.markedList.removeAllElements();
    }

    public void setMarkedColor(int color) {
        int size = this.markedList.size();
        for (int i = 0; i < size; ++i) {
            ((MBaseNode)this.markedList.elementAt(i)).setColor(color);
        }
    }

    public void clearMarkedColor() {
        int size = this.markedList.size();
        for (int i = 0; i < size; ++i) {
            ((MBaseNode)this.markedList.elementAt(i)).clearColor();
        }
    }

    private void clearAllColorUnder(MBaseNode nod) {
        MBaseNode firstChld = nod.getFirstChild();
        if (firstChld != null) {
            firstChld.clearColor();
            this.clearAllColorUnder(firstChld);
            for (MBaseNode tmp = firstChld.getFollower(); tmp != firstChld; tmp = tmp.getFollower()) {
                tmp.clearColor();
                this.clearAllColorUnder(tmp);
            }
        }
    }

    public void clearAllColor() {
        this.clearAllColorUnder(this.root);
    }

    public MBaseNode firstMarked() {
        this.position = 0;
        return this.markedList.isEmpty() ? null : (MBaseNode)this.markedList.firstElement();
    }

    public boolean hasNextMarked() {
        return this.position + 1 < this.markedList.size();
    }

    public MBaseNode nextMarked() {
        if (this.hasNextMarked()) {
            ++this.position;
            return (MBaseNode)this.markedList.elementAt(this.position);
        }
        return null;
    }

    public int getTopLevelClusterCount() {
        return this.root.getChildCount();
    }

    public MBaseNode getTopLevelCluster(int index) {
        return this.root.getChild(index);
    }

    public MBaseNode getTopLevelCluster(MBaseNode node) {
        MBaseNode tlc = node;
        while (tlc.getParent() != this.root) {
            tlc = tlc.getParent();
        }
        return tlc;
    }

    public MBaseNode getUppermostSelectedCluster(MBaseNode node) {
        MBaseNode tlc = node;
        MBaseNode tmp = node;
        while (tmp.getParent() != this.root) {
            if (!(tmp = tmp.getParent()).isMarked()) continue;
            tlc = tmp;
        }
        return tlc;
    }

    public MBaseNode getFirstNotHiddenTopLevelCluster() {
        return this.root.getFirstVisibleChild();
    }

    public void writeOutMarkedNodes() {
        MBaseNode m = this.firstMarked();
        while (m != null) {
            System.out.println(" " + m.whoamI());
            m = this.nextMarked();
        }
    }

    public void hideMarkedNodes() {
        if (this.getMarkedNodeCount() < 1) {
            return;
        }
        MBaseNode tmp = this.firstMarked();
        tmp.hide();
        while (this.hasNextMarked()) {
            this.nextMarked().hide();
        }
    }

    public void hideMarkedNodesAndUnmark() {
        this.hideMarkedNodes();
        this.unmarkAllNodes();
    }

    public void hideUnmarkedNodes() {
        this.root.hideUnmarkedNodesUnder();
    }

    private boolean isSingleton(MBaseNode node) {
        if (node.getFirstChild() == null) {
            return true;
        }
        if (node.getFirstChild() != node.getFirstChild().getFollower()) {
            return false;
        }
        return this.isSingleton(node.getFirstChild());
    }

    private void setSingletonsVisible(boolean b) {
        MBaseNode firstChild = this.root.getFirstChild();
        if (firstChild != null) {
            if (this.isSingleton(firstChild)) {
                this.showAllUnder(firstChild, b);
            }
            for (MBaseNode tmp = firstChild.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
                if (!this.isSingleton(tmp)) continue;
                this.showAllUnder(tmp, b);
            }
        }
    }

    public void hideSingletons() {
        this.setSingletonsVisible(false);
    }

    public void showSingletons() {
        this.setSingletonsVisible(true);
    }

    public int getSingletonCount() {
        int scount = 0;
        MBaseNode firstChild = this.root.getFirstChild();
        if (firstChild != null) {
            if (this.isSingleton(firstChild)) {
                ++scount;
            }
            for (MBaseNode tmp = firstChild.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
                if (!this.isSingleton(tmp)) continue;
                ++scount;
            }
        }
        return scount;
    }

    private void showAllUnder(MBaseNode nod, boolean show) {
        if (show) {
            nod.show();
        } else {
            nod.hide();
        }
        MBaseNode firstChild = nod.getFirstChild();
        if (firstChild == null) {
            return;
        }
        this.showAllUnder(firstChild, show);
        for (MBaseNode tmp = firstChild.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
            this.showAllUnder(tmp, show);
        }
    }

    public void showAll() {
        this.showAllUnder(this.root, true);
    }

    public void hideAll() {
        this.showAllUnder(this.root, false);
    }

    public void showSingletonsOnly() {
        this.hideAll();
        this.showSingletons();
    }

    public void markLevel(int level) {
        if (level > 0) {
            this.root.markLevelUnder(level);
        }
    }

    public void unmarkLevel(int level) {
        if (level > 0) {
            this.root.unmarkLevelUnder(level);
        }
    }

    private void writeAllColorUnder(MBaseNode nod) {
        MBaseNode firstChld = nod.getFirstChild();
        if (firstChld != null) {
            if (!firstChld.isHidden()) {
                System.out.println(firstChld.whoamI() + " color:" + firstChld.getColor());
            }
            this.writeAllColorUnder(firstChld);
            for (MBaseNode tmp = firstChld.getFollower(); tmp != firstChld; tmp = tmp.getFollower()) {
                if (!tmp.isHidden()) {
                    System.out.println(tmp.whoamI() + " color:" + tmp.getColor());
                }
                this.writeAllColorUnder(tmp);
            }
        }
    }

    public void writeAllColor() {
        this.writeAllColorUnder(this.root);
    }

    private void searchNodesUnder(MBaseNode nod, String[] propKeys, int[] propTypes, Object[] condition, boolean mark, int color) {
        MBaseNode firstChild = nod.getFirstChild();
        if (firstChild == null) {
            block16: for (int i = 0; i < propTypes.length; ++i) {
                switch (propTypes[i]) {
                    case 0: {
                        try {
                            float value = Float.valueOf(nod.getProperty(propKeys[i])).floatValue();
                            if (!(value < ((float[])condition[i])[0]) && !(value > ((float[])condition[i])[1])) continue block16;
                            return;
                        }
                        catch (NumberFormatException e) {
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    case 1: {
                        try {
                            double value = Double.valueOf(nod.getProperty(propKeys[i]));
                            if (!(value < ((double[])condition[i])[0]) && !(value > ((double[])condition[i])[1])) continue block16;
                            return;
                        }
                        catch (NumberFormatException e) {
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    case 2: {
                        try {
                            int value = MGraph.intValueOf(nod.getProperty(propKeys[i]));
                            if (value >= ((int[])condition[i])[0] && value <= ((int[])condition[i])[1]) continue block16;
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    case 3: {
                        try {
                            int numOfPossibilities = ((String[])condition[i]).length;
                            String value = String.valueOf(nod.getProperty(propKeys[i]));
                            boolean found = false;
                            for (int j = 0; j < numOfPossibilities; ++j) {
                                found = found || value.equals(((String[])condition)[j]);
                            }
                            if (found) continue block16;
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
            if (mark) {
                nod.mark();
            } else {
                nod.addColor(color);
            }
            return;
        }
        MBaseNode tmp = firstChild;
        this.searchNodesUnder(firstChild, propKeys, propTypes, condition, mark, color);
        while ((tmp = tmp.getFollower()) != firstChild) {
            this.searchNodesUnder(tmp, propKeys, propTypes, condition, mark, color);
        }
    }

    private void searchNodesUnder(MBaseNode nod, String[] propKeys, Object[] condition, boolean mark, int color) {
        if (nod.getGraph() != this) {
            return;
        }
        int[] propTypes = new int[propKeys.length];
        for (int i = 0; i < propKeys.length; ++i) {
            for (int j = 0; j < this.propertyKeys.length; ++j) {
                if (!this.propertyKeys[j].equals(propKeys[i])) continue;
                propTypes[i] = this.propertyTypes[j];
            }
        }
        this.searchNodesUnder(nod, propKeys, propTypes, condition, mark, color);
    }

    public void searchAndMarkNodesUnder(MBaseNode nod, String[] propKeys, Object[] condition) {
        this.searchNodesUnder(nod, propKeys, condition, true, 0);
    }

    public void searchAndColorNodesUnder(MBaseNode nod, String[] propKeys, Object[] condition, int color) throws IllegalArgumentException {
        if (color < 1 || color > 15) {
            throw new IllegalArgumentException("Argument color must be between 1 and 15.");
        }
        this.searchNodesUnder(nod, propKeys, condition, false, color);
    }

    public void searchAndMarkNodes(String[] propKeys, Object[] condition) {
        this.searchAndMarkNodesUnder(this.root, propKeys, condition);
    }

    public void searchAndColorNodes(String[] propKeys, Object[] condition, int color) throws IllegalArgumentException {
        this.searchAndColorNodesUnder(this.root, propKeys, condition, color);
    }

    public void searchNewNodes(boolean mark, int min, int max, int color) {
        MBaseNode first = this.root.getFirstChild();
        MBaseNode next = this.root.getFirstChild();
        int newnodes = next.getNewNodeChildrenCount(this.getDepth() - 1);
        if (newnodes > min && newnodes < max) {
            if (mark) {
                next.mark();
            } else {
                next.addColor(color);
            }
        }
        while ((next = next.getFollower()) != first) {
            newnodes = next.getNewNodeChildrenCount(this.getDepth() - 1);
            if (newnodes < min || newnodes > max) continue;
            if (mark) {
                next.mark();
                continue;
            }
            next.addColor(color);
        }
    }

    public static int intValueOf(String s) throws NumberFormatException {
        if (s.trim().length() == 0) {
            return 0;
        }
        Double d = Double.valueOf(s);
        if (Math.abs(Math.rint(d) - d) > 1.0E-8) {
            throw new NumberFormatException("For input string: " + s);
        }
        return d.intValue();
    }

    private Object getPropertySpecificValue(String propKey, MBaseNode nod, String valueType) throws IllegalArgumentException {
        int i;
        if (nod.getGraph() != this || !nod.hasVisibleChildren()) {
            throw new IllegalArgumentException("Invalid node.");
        }
        for (i = 0; i < this.propertyKeys.length && !this.propertyKeys[i].equals(propKey); ++i) {
        }
        if (i < this.propertyKeys.length) {
            switch (this.propertyTypes[i]) {
                case 1: {
                    MLevelEnumeration nodes = new MLevelEnumeration(nod.getGraph(), nod, nod.getGraph().getDepth() - nod.getDepth());
                    if (!nodes.hasMoreElements()) {
                        throw new IllegalArgumentException("No nodes found.");
                    }
                    double value = valueType.equals("min") ? Double.POSITIVE_INFINITY : (valueType.equals("max") ? Double.NEGATIVE_INFINITY : 0.0);
                    int countNodes = 0;
                    while (nodes.hasMoreElements()) {
                        MBaseNode n = nodes.nextNode();
                        if (n.getProperty(propKey) == null) continue;
                        if (valueType.equals("min")) {
                            value = Math.min(value, Double.valueOf(n.getProperty(propKey)));
                            continue;
                        }
                        if (valueType.equals("max")) {
                            value = Math.max(value, Double.valueOf(n.getProperty(propKey)));
                            continue;
                        }
                        if (!valueType.equals("average")) continue;
                        value += Double.valueOf(n.getProperty(propKey)).doubleValue();
                        ++countNodes;
                    }
                    if (Double.isInfinite(value)) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                    try {
                        return valueType.equals("average") ? new Double(value / (double)countNodes) : new Double(value);
                    }
                    catch (ArithmeticException e) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                }
                case 0: {
                    MLevelEnumeration nodes = new MLevelEnumeration(nod.getGraph(), nod, nod.getGraph().getDepth() - nod.getDepth());
                    if (!nodes.hasMoreElements()) {
                        throw new IllegalArgumentException("Invalid node.");
                    }
                    float value = valueType.equals("min") ? Float.POSITIVE_INFINITY : (valueType.equals("max") ? Float.NEGATIVE_INFINITY : 0.0f);
                    int countNodes = 0;
                    while (nodes.hasMoreElements()) {
                        if (valueType.equals("min")) {
                            value = Math.min(value, Float.valueOf(nodes.nextNode().getProperty(propKey)).floatValue());
                            continue;
                        }
                        if (valueType.equals("max")) {
                            value = Math.max(value, Float.valueOf(nodes.nextNode().getProperty(propKey)).floatValue());
                            continue;
                        }
                        if (!valueType.equals("average")) continue;
                        value += Double.valueOf(nodes.nextNode().getProperty(propKey)).floatValue();
                        ++countNodes;
                    }
                    if (Float.isInfinite(value)) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                    try {
                        return valueType.equals("average") ? new Float(value / (float)countNodes) : new Float(value);
                    }
                    catch (ArithmeticException e) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                }
                case 2: {
                    MLevelEnumeration nodes = new MLevelEnumeration(nod.getGraph(), nod, nod.getGraph().getDepth() - nod.getDepth());
                    if (!nodes.hasMoreElements()) {
                        throw new IllegalArgumentException("Invalid node.");
                    }
                    int value = valueType.equals("min") ? Integer.MAX_VALUE : (valueType.equals("max") ? Integer.MIN_VALUE : 0);
                    int countNodes = 0;
                    while (nodes.hasMoreElements()) {
                        int propValue = MGraph.intValueOf(nodes.nextNode().getProperty(propKey));
                        if (valueType.equals("min")) {
                            value = Math.min(value, propValue);
                            continue;
                        }
                        if (valueType.equals("max")) {
                            value = Math.max(value, propValue);
                            continue;
                        }
                        if (!valueType.equals("average")) continue;
                        value += propValue;
                        ++countNodes;
                    }
                    if (value == Integer.MAX_VALUE || value == Integer.MIN_VALUE) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                    try {
                        if (valueType.equals("average")) {
                            return new Float(1.0f * (float)value / (float)countNodes);
                        }
                        return new Integer(value);
                    }
                    catch (ArithmeticException e) {
                        throw new IllegalArgumentException("No nodes with property:" + propKey);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Invalid key");
    }

    public Object getPropertyMin(String propKey, MBaseNode nod) throws IllegalArgumentException {
        return this.getPropertySpecificValue(propKey, nod, "min");
    }

    public Object getPropertyMin(String propKey) throws IllegalArgumentException {
        return this.getPropertyMin(propKey, this.root);
    }

    public Object getPropertyMax(String propKey, MBaseNode nod) throws IllegalArgumentException {
        return this.getPropertySpecificValue(propKey, nod, "max");
    }

    public Object getPropertyMax(String propKey) throws IllegalArgumentException {
        return this.getPropertyMax(propKey, this.root);
    }

    public Object getPropertyAverage(String propKey, MBaseNode nod) throws IllegalArgumentException {
        return this.getPropertySpecificValue(propKey, nod, "average");
    }

    public Object getProperty(String propKey, MBaseNode nod) throws IllegalArgumentException {
        int i;
        if (nod.getGraph() != this) {
            throw new IllegalArgumentException("Invalid node.");
        }
        for (i = 0; i < this.propertyKeys.length && !this.propertyKeys[i].equals(propKey); ++i) {
        }
        if (i < this.propertyKeys.length) {
            if (nod.getProperty(propKey) == null) {
                return null;
            }
            switch (this.propertyTypes[i]) {
                case 1: {
                    return Double.valueOf(nod.getProperty(propKey));
                }
                case 0: {
                    return Float.valueOf(nod.getProperty(propKey));
                }
                case 2: {
                    return new Integer(MGraph.intValueOf(nod.getProperty(propKey)));
                }
            }
        }
        throw new IllegalArgumentException("Invalid key");
    }

    public int[] getPropertyInIntervalCountsNextLevel(String propKey, MBaseNode nod, Object intervalMin, Object intervalMax, int numberOfIntervals) {
        int i;
        this.markedInIntervals = null;
        if (numberOfIntervals < 1) {
            return null;
        }
        if (nod.getGraph() != this || !nod.hasVisibleChildren()) {
            return null;
        }
        for (i = 0; i < this.propertyKeys.length && !this.propertyKeys[i].equals(propKey); ++i) {
        }
        if (i < this.propertyKeys.length) {
            int[] retValue = new int[numberOfIntervals];
            this.markedInIntervals = new boolean[numberOfIntervals];
            for (int j = 0; j < retValue.length; ++j) {
                retValue[j] = 0;
                this.markedInIntervals[j] = false;
            }
            switch (this.propertyTypes[i]) {
                case 2: {
                    int value;
                    float min = 1.0f * (float)((Integer)intervalMin).intValue();
                    float diff = (1.0f * (float)((Integer)intervalMax).intValue() - min) / (float)numberOfIntervals;
                    if (diff <= 0.0f) {
                        this.markedInIntervals = null;
                        return null;
                    }
                    MBaseNode first = nod.getFirstVisibleChild();
                    try {
                        value = MGraph.intValueOf(first.getProperty(propKey));
                        for (int j = 0; j < numberOfIntervals; ++j) {
                            if (!((float)value >= min + diff * (float)j)) continue;
                            float f = value;
                            float f2 = min + diff * (float)(j + 1);
                            float f3 = j == numberOfIntervals - 1 ? diff / 100000.0f : 0.0f;
                            if (!(f < f2 + f3)) continue;
                            int n = j;
                            retValue[n] = retValue[n] + 1;
                            if (!first.isMarked()) continue;
                            this.markedInIntervals[j] = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (MBaseNode tmp = first.getVisibleFollower(); tmp != first; tmp = tmp.getVisibleFollower()) {
                        try {
                            value = MGraph.intValueOf(first.getProperty(propKey));
                            for (int j = 0; j < numberOfIntervals; ++j) {
                                if (!((float)value >= min + diff * (float)j)) continue;
                                float f = value;
                                float f4 = min + diff * (float)(j + 1);
                                float f5 = j == numberOfIntervals - 1 ? diff / 100000.0f : 0.0f;
                                if (!(f < f4 + f5)) continue;
                                int n = j;
                                retValue[n] = retValue[n] + 1;
                                if (!tmp.isMarked()) continue;
                                this.markedInIntervals[j] = true;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return retValue;
                }
                case 0: {
                    float value;
                    float min = ((Float)intervalMin).floatValue();
                    float diff = (((Float)intervalMax).floatValue() - min) / (float)numberOfIntervals;
                    if (diff <= 0.0f) {
                        this.markedInIntervals = null;
                        return null;
                    }
                    MBaseNode first = nod.getFirstVisibleChild();
                    try {
                        value = Float.valueOf(first.getProperty(propKey)).floatValue();
                        for (int j = 0; j < numberOfIntervals; ++j) {
                            if (!(value >= min + diff * (float)j)) continue;
                            float f = min + diff * (float)(j + 1);
                            float f6 = j == numberOfIntervals - 1 ? diff / 100000.0f : 0.0f;
                            if (!(value < f + f6)) continue;
                            int n = j;
                            retValue[n] = retValue[n] + 1;
                            if (!first.isMarked()) continue;
                            this.markedInIntervals[j] = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (MBaseNode tmp = first.getVisibleFollower(); tmp != first; tmp = tmp.getVisibleFollower()) {
                        try {
                            value = Float.valueOf(first.getProperty(propKey)).floatValue();
                            for (int j = 0; j < numberOfIntervals; ++j) {
                                if (!(value >= min + diff * (float)j)) continue;
                                float f = min + diff * (float)(j + 1);
                                float f7 = j == numberOfIntervals - 1 ? diff / 100000.0f : 0.0f;
                                if (!(value <= f + f7)) continue;
                                int n = j;
                                retValue[n] = retValue[n] + 1;
                                if (!tmp.isMarked()) continue;
                                this.markedInIntervals[j] = true;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return retValue;
                }
                case 1: {
                    double value;
                    double min = (Double)intervalMin;
                    double diff = ((Double)intervalMax - min) / (double)numberOfIntervals;
                    if (diff <= 0.0) {
                        this.markedInIntervals = null;
                        return null;
                    }
                    MBaseNode first = nod.getFirstVisibleChild();
                    try {
                        value = Double.valueOf(first.getProperty(propKey));
                        for (int j = 0; j < numberOfIntervals; ++j) {
                            if (!(value >= min + diff * (double)j)) continue;
                            double d = min + diff * (double)(j + 1);
                            double d2 = j == numberOfIntervals - 1 ? diff / 100000.0 : 0.0;
                            if (!(value <= d + d2)) continue;
                            int n = j;
                            retValue[n] = retValue[n] + 1;
                            if (!first.isMarked()) continue;
                            this.markedInIntervals[j] = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (MBaseNode tmp = first.getVisibleFollower(); tmp != first; tmp = tmp.getVisibleFollower()) {
                        try {
                            value = (Double)tmp.getPropertyObject(propKey);
                            for (int j = 0; j < numberOfIntervals; ++j) {
                                if (!(value >= min + diff * (double)j)) continue;
                                double d = min + diff * (double)(j + 1);
                                double d3 = j == numberOfIntervals - 1 ? diff / 100000.0 : 0.0;
                                if (!(value < d + d3)) continue;
                                int n = j;
                                retValue[n] = retValue[n] + 1;
                                if (!tmp.isMarked()) continue;
                                this.markedInIntervals[j] = true;
                            }
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return retValue;
                }
            }
        }
        return null;
    }

    public int[] getPropertyInIntervalCountsNodeLevel(String propKey, MBaseNode nod, Object intervalMin, Object intervalMax, int numberOfIntervals) throws IllegalArgumentException {
        int i;
        this.markedInIntervals = null;
        if (numberOfIntervals < 1) {
            return null;
        }
        if (nod.getGraph() != this) {
            return null;
        }
        boolean leaf = false;
        if (!nod.hasVisibleChildren()) {
            leaf = true;
        }
        for (i = 0; i < this.propertyKeys.length && !this.propertyKeys[i].equals(propKey); ++i) {
        }
        if (i < this.propertyKeys.length) {
            MLevelEnumeration nodes;
            double max;
            int[] retValue = new int[numberOfIntervals];
            this.markedInIntervals = new boolean[numberOfIntervals];
            for (int j = 0; j < retValue.length; ++j) {
                retValue[j] = 0;
                this.markedInIntervals[j] = false;
            }
            double min = ((Number)intervalMin).doubleValue();
            if (min > (max = ((Number)intervalMax).doubleValue())) {
                double tmp = max;
                max = min;
                min = tmp;
            }
            if (max == min && numberOfIntervals != 1) {
                throw new IllegalArgumentException("Zero interval length can not be divided into multiple bands");
            }
            MLevelEnumeration mLevelEnumeration = nodes = leaf ? null : new MLevelEnumeration(nod.getGraph(), nod, nod.getGraph().getDepth() - nod.getDepth());
            while (leaf || nodes != null && nodes.hasMoreElements()) {
                MBaseNode nextNode = leaf ? nod : nodes.nextNode();
                leaf = false;
                try {
                    double value = Double.valueOf(nextNode.getProperty(propKey));
                    if (value < min || value > max) {
                        throw new IllegalArgumentException("Property value " + value + " exceeds boundaries (" + min + ":" + max + ")");
                    }
                    int interval = 0;
                    if (numberOfIntervals <= 1 || (interval = (int)Math.floor((double)numberOfIntervals * (value - min) / (max - min))) == numberOfIntervals) {
                        // empty if block
                    }
                    int n = --interval;
                    retValue[n] = retValue[n] + 1;
                    if (!nextNode.isMarked()) continue;
                    this.markedInIntervals[interval] = true;
                }
                catch (Exception e) {
                    System.err.println("Node has no such property error: " + propKey);
                }
            }
            return retValue;
        }
        System.err.println("Invalid property key: " + propKey);
        return null;
    }

    public double[] getPropertyInIntervalDistributionNodeLevel(String propKey, MBaseNode nod, double intervalMin, double intervalMax, int numberOfIntervals) throws IllegalArgumentException {
        int i;
        this.markedInIntervals = null;
        if (numberOfIntervals < 1) {
            return null;
        }
        if (nod.getGraph() != this) {
            return null;
        }
        boolean leaf = false;
        if (!nod.hasVisibleChildren()) {
            leaf = true;
        }
        for (i = 0; i < this.propertyKeys.length && !this.propertyKeys[i].equals(propKey); ++i) {
        }
        if (i < this.propertyKeys.length) {
            MLevelEnumeration nodes;
            double[] retValue = new double[numberOfIntervals];
            if (intervalMin > intervalMax) {
                double tmp = intervalMax;
                intervalMax = intervalMin;
                intervalMin = tmp;
            }
            if (intervalMax == intervalMin && numberOfIntervals != 1) {
                throw new IllegalArgumentException("Zero interval length can not be divided into multiple bands");
            }
            MLevelEnumeration mLevelEnumeration = nodes = leaf ? null : new MLevelEnumeration(nod.getGraph(), nod, nod.getGraph().getDepth() - nod.getDepth());
            while (leaf || nodes != null && nodes.hasMoreElements()) {
                MBaseNode nextNode = leaf ? nod : nodes.nextNode();
                leaf = false;
                try {
                    double value = Double.valueOf(nextNode.getProperty(propKey));
                    if (value < intervalMin || value > intervalMax) {
                        throw new IllegalArgumentException("Property value " + value + " exceeds boundaries (" + intervalMin + ":" + intervalMax + ")");
                    }
                    double max = 0.0;
                    int f = 0;
                    int t = retValue.length;
                    for (i = f; i < t; ++i) {
                        double iv = intervalMin + (intervalMax - intervalMin) * (double)i / (double)retValue.length;
                        double d = iv - value;
                        double x = 20.0 * d / (intervalMax - intervalMin);
                        int n = i;
                        retValue[n] = retValue[n] + Math.exp(-x * x);
                        if (!(retValue[i] > max)) continue;
                        max = retValue[i];
                    }
                    if (!(max > 0.0)) continue;
                    i = 0;
                    while (i < retValue.length) {
                        int n = i++;
                        retValue[n] = retValue[n] / max;
                    }
                }
                catch (Exception e) {
                    System.err.println("Node has no such property error: " + propKey);
                }
            }
            return retValue;
        }
        System.err.println("Invalid property key: " + propKey);
        return null;
    }

    public boolean[] isMarkedInIntervals() {
        return this.markedInIntervals;
    }

    public int getMarkedNodeCount() {
        return this.markedList.size();
    }

    public int getNodeCount(int level) {
        return this.root.numberOfChildren(level);
    }

    public int numberOfNotHiddenNodes(int level) {
        return this.root.visibleChildCount(level);
    }

    private MBaseNode getClusterUnder(MBaseNode nod, int clusterID) {
        if (nod.getFirstChild() == null) {
            return null;
        }
        MBaseNode firstChild = nod.getFirstChild();
        if (firstChild.getID() == clusterID) {
            return firstChild;
        }
        MBaseNode underNode = this.getClusterUnder(firstChild, clusterID);
        if (underNode != null) {
            return underNode;
        }
        for (MBaseNode tmp = firstChild.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
            if (tmp.getID() == clusterID) {
                return tmp;
            }
            MBaseNode underNode2 = this.getClusterUnder(tmp, clusterID);
            if (underNode2 == null) continue;
            return underNode2;
        }
        return null;
    }

    public MBaseNode getCluster(int clusterID) {
        return this.getClusterUnder(this.root, clusterID);
    }

    public int getPropertyCount() {
        int ret = this.propertyKeys == null || this.propertyKeys.length == 0 ? 0 : this.propertyKeys.length;
        return ret;
    }

    public int getRangePropertyCount() {
        int numORP = 0;
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            if (this.propertyTypes[i] > 2) continue;
            ++numORP;
        }
        return numORP;
    }

    public int[] getRangePropertyIndices() {
        int[] returnValue = new int[this.getRangePropertyCount()];
        int j = 0;
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            if (this.propertyTypes[i] > 2) continue;
            returnValue[j] = i;
            ++j;
        }
        return returnValue;
    }

    public String getPropertyKey(int index) throws IllegalArgumentException {
        try {
            return this.propertyKeys[index];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such property");
        }
    }

    public int getPropertyType(int index) throws IllegalArgumentException {
        try {
            return this.propertyTypes[index];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such property");
        }
    }

    public boolean isRangedProperty(int index) throws IllegalArgumentException {
        try {
            return this.propertyTypes[index] <= 2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such property");
        }
    }

    public String getRangePropertyKey(int index) throws IllegalArgumentException {
        try {
            return this.getPropertyKey(this.getRangePropertyIndices()[index]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such property");
        }
    }

    public int getRangePropertyType(int index) throws IllegalArgumentException {
        try {
            return this.getPropertyType(this.getRangePropertyIndices()[index]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such property");
        }
    }

    public void saveGraph(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.nextClusterID);
        out.writeInt(this.propertyKeys == null ? 0 : this.propertyKeys.length);
        if (this.propertyKeys != null) {
            for (int i = 0; i < this.propertyKeys.length; ++i) {
                out.writeObject(this.propertyKeys[i]);
                out.writeInt(this.propertyTypes[i]);
            }
        }
        Vector multiNodes = new Vector(10, 10);
        this.root.saveNode(out, multiNodes, new Integer(0));
    }

    public void loadGraph(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != 1) {
            throw new IOException("Cannot deserialize node with future version (" + version + ")");
        }
        this.nextClusterID = in.readInt();
        int propLengh = in.readInt();
        if (propLengh > 0) {
            this.propertyKeys = new String[propLengh];
            this.propertyTypes = new int[propLengh];
        } else {
            this.propertyKeys = null;
            this.propertyTypes = null;
        }
        for (int i = 0; i < propLengh; ++i) {
            this.propertyKeys[i] = (String)in.readObject();
            this.propertyTypes[i] = in.readInt();
        }
        Vector actualMultiNodes = new Vector(10, 10);
        this.root = new MBaseNode(this);
        this.root.loadNode(in, actualMultiNodes);
    }

    public void setNodeProperties() {
        MBaseNode firstChild;
        int length = Integer.toString(this.getMaxLeafNodeCount()).length();
        String mask = "";
        for (int i = 0; i < length; ++i) {
            mask = "0" + mask;
        }
        DecimalFormat df = new DecimalFormat(mask);
        MBaseNode tmp = firstChild = this.root.getFirstChild();
        int hierarchyID = 1;
        this.recoveryID = 1;
        this.memberID = 1;
        int clusterIdx = 1;
        this.setNodeProperties(tmp, "" + hierarchyID, clusterIdx, df);
        ++hierarchyID;
        ++clusterIdx;
        for (tmp = tmp.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
            if (!tmp.hasChildren()) continue;
            this.memberID = 1;
            this.setNodeProperties(tmp, "" + hierarchyID, clusterIdx, df);
            ++hierarchyID;
            ++clusterIdx;
        }
    }

    private int getMaxLeafNodeCount() {
        MBaseNode firstChild = this.root.getFirstChild();
        int maxCount = firstChild.getLeafNodeCount();
        MBaseNode tmp = firstChild;
        for (tmp = tmp.getFollower(); tmp != firstChild; tmp = tmp.getFollower()) {
            int count = tmp.getLeafNodeCount();
            if (count <= maxCount) continue;
            maxCount = count;
        }
        return maxCount;
    }

    private void setNodeProperties(MBaseNode n, String hierarchyID, int clusterIdx, DecimalFormat df) {
        if (n.hasChildren()) {
            n.setProperty(CLUSTER_ID, String.valueOf(n.getID()));
        } else {
            n.setProperty(ID, String.valueOf(n.getID()));
        }
        if (n.getParent() != null) {
            n.setProperty(PARENT_ID, String.valueOf(n.getParent().getID()));
        }
        if (n.hasChildren()) {
            n.setProperty(ELEMENT_COUNT, String.valueOf(n.getLeafNodeCount()));
        }
        n.setProperty(HIERARCHY_ID, hierarchyID);
        if (!n.hasChildren()) {
            n.setProperty(RECOVERY_ID, "" + this.recoveryID);
            n.setProperty(CLUSTER_MEMBER, clusterIdx + "." + df.format(this.memberID));
            ++this.recoveryID;
            ++this.memberID;
            return;
        }
        int i = 1;
        for (MBaseNode tmp = n.getFirstChild(); tmp != n.lastChild; tmp = tmp.getFollower()) {
            this.setNodeProperties(tmp, hierarchyID + "." + i, clusterIdx, df);
            ++i;
        }
        this.setNodeProperties(n.lastChild, hierarchyID + "." + i, clusterIdx, df);
    }

    public void saveSmiles(OutputStream out, boolean saveOnlyMarked, boolean saveParentSmiles, boolean saveID, boolean saveParentID, boolean saveElementCount) throws IOException {
        for (int i = 1; i <= this.getDepth(); ++i) {
            MLevelEnumeration levelEnum = new MLevelEnumeration(this, i);
            while (levelEnum.hasMoreElements()) {
                MBaseNode next = levelEnum.nextNode();
                if (next.isHidden() || (!saveOnlyMarked || !next.isMarked()) && saveOnlyMarked) continue;
                StringBuffer buffer = new StringBuffer();
                if (i > 1 && saveParentSmiles) {
                    buffer.append(next.getParent().getMolecule().toFormat("smiles"));
                    buffer.append(" ");
                }
                buffer.append(next.getMolecule().toFormat("smiles"));
                if (saveID) {
                    if (i < this.getDepth()) {
                        buffer.append(" ");
                        buffer.append(next.getProperty(ID));
                    } else {
                        buffer.append(" ");
                        buffer.append(String.valueOf(next.getID()));
                    }
                }
                if (saveParentID && i > 1) {
                    buffer.append(" ");
                    buffer.append(next.getParent().getID());
                }
                if (saveElementCount) {
                    buffer.append(" ");
                    buffer.append(i == this.getDepth() ? "0" : String.valueOf(next.visibleChildCount()));
                }
                buffer.append("\n");
                out.write(buffer.toString().getBytes());
            }
        }
    }

    public void saveDotFormat(OutputStream out) throws IOException {
        out.write("strict digraph G{/n".getBytes());
        if (this.getDepth() > 0) {
            MLevelEnumeration levelEnum = new MLevelEnumeration(this, 1);
            while (levelEnum.hasMoreElements()) {
                MBaseNode next = levelEnum.nextNode();
                StringBuffer buffer = new StringBuffer(" root -> ");
                buffer.append(this.getDepth() == 1 ? "m" + next.getProperty(ID) : "c" + String.valueOf(next.getID()));
                buffer.append("\n");
                out.write(buffer.toString().getBytes());
            }
        }
        for (int i = 1; i <= this.getDepth(); ++i) {
            MLevelEnumeration levelEnum = new MLevelEnumeration(this, i);
            while (levelEnum.hasMoreElements()) {
                MBaseNode next = levelEnum.nextNode();
                StringBuffer buffer = new StringBuffer(" c");
                buffer.append(String.valueOf(next.getID()));
                buffer.append(" -> ");
                MLevelEnumeration childenum = new MLevelEnumeration(this, next, 1);
                while (childenum.hasMoreElements()) {
                    MBaseNode nextChild = childenum.nextNode();
                    buffer.append(this.getDepth() == i ? "m" + nextChild.getProperty(ID) : "c" + String.valueOf(nextChild.getID()));
                }
                buffer.append("\n");
                out.write(buffer.toString().getBytes());
            }
        }
        out.write("\n".getBytes());
    }

    public void setProperties(String[] propKeys, int[] propTypes) {
        if (this.log.isTraceEnabled()) {
            this.logh.trace((Object)("SetProperties() " + U.sel(propKeys) + ":" + U.sel(propTypes)), new Throwable().fillInStackTrace());
        }
        this.propertyKeys = propKeys;
        this.propertyTypes = propTypes;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    public int[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public int getNextClusterID() {
        return this.nextClusterID;
    }

    public MBaseNode getRootNode() {
        return this.root;
    }

    public String toString() {
        String s = "---MGraph---\n";
        s = s + "ClusterCount: " + this.root.getChildCount() + "\n";
        s = s + "Depth: " + this.getDepth() + "\n";
        s = s + "NextClusterID: " + this.nextClusterID + "\n";
        return s;
    }

    public ArrayList getLeafNodes() {
        ArrayList leaves = new ArrayList();
        this.getLeafNodes(leaves);
        return leaves;
    }

    public void getLeafNodes(ArrayList list) {
        this.detachLeafNodes(this.root, list);
    }

    public void keepLeavesOnly() {
        int depth = this.getDepth();
        if (depth == 1) {
            return;
        }
        MBaseNode[] leaves = new MBaseNode[this.getNodeCount(depth)];
        this.putLeafNodes(this.root, leaves, 0);
        this.dropOldRoot();
        this.nextClusterID = 1;
        for (int i = 0; i < leaves.length; ++i) {
            this.addCluster(leaves[i], i);
        }
    }

    private int putLeafNodes(MBaseNode node, MBaseNode[] leaves, int leafIndex) {
        int idx = leafIndex;
        if (!node.hasChildren()) {
            leaves[idx++] = node;
        } else {
            MBaseNode cnode = node.getFirstChild();
            idx = this.putLeafNodes(cnode, leaves, idx);
            for (MBaseNode tmp = cnode.getFollower(); tmp != cnode; tmp = tmp.getFollower()) {
                idx = this.putLeafNodes(tmp, leaves, idx);
            }
        }
        return idx;
    }

    private void detachLeafNodes(MBaseNode node, ArrayList leaves) {
        if (!node.hasChildren()) {
            node.parent.lastChild = null;
            leaves.add(node);
        } else {
            MBaseNode cnode = node.getFirstChild();
            this.detachLeafNodes(cnode, leaves);
            for (MBaseNode tmp = cnode.getFollower(); tmp != cnode; tmp = tmp.getFollower()) {
                this.detachLeafNodes(tmp, leaves);
            }
        }
    }
}

