/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MLevelEnumeration
implements Enumeration {
    private MGraph graph;
    private MBaseNode rootNode;
    private int level;
    private MBaseNode currentElement = null;
    private MBaseNode nextElement = null;
    private boolean nextFound = false;
    private int searchDepth;

    public MLevelEnumeration(MGraph graph, int level) {
        this.graph = graph;
        this.rootNode = null;
        this.level = level;
    }

    public MLevelEnumeration(MGraph graph, MBaseNode rootNode, int level) {
        this.graph = graph;
        this.rootNode = rootNode;
        this.level = level;
    }

    @Override
    public synchronized boolean hasMoreElements() {
        if (!this.nextFound) {
            this.searchNextElement();
        }
        return this.nextElement != null;
    }

    public synchronized Object nextElement() throws NoSuchElementException {
        if (!this.nextFound) {
            this.searchNextElement();
        }
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        this.nextFound = false;
        this.currentElement = this.nextElement;
        return this.nextElement;
    }

    public MBaseNode nextNode() throws NoSuchElementException {
        Object next = this.nextElement();
        return next == null ? null : (MBaseNode)next;
    }

    private void searchNextElement() {
        this.nextFound = true;
        if (this.currentElement == null) {
            if (this.rootNode == null) {
                if (this.level < 1) {
                    this.nextElement = null;
                    return;
                }
                this.rootNode = this.graph.getTopLevelCluster(0).getParent();
            }
            if (this.level < 1 || this.level > this.graph.getDepth() - this.rootNode.getDepth()) {
                this.nextElement = null;
                return;
            }
            this.nextElement = this.rootNode;
            for (int i = 1; i <= this.level; ++i) {
                this.nextElement = this.nextElement.getFirstChild();
            }
            if (!this.nextElement.isHidden()) {
                return;
            }
        }
        do {
            this.nextElement = this.nextElement.getFollower();
            while (this.nextElement != this.rootNode.getFollower() && this.nextElement == this.nextElement.getParent().getFirstChild()) {
                this.nextElement = this.nextElement.getParent().getFollower();
                if (this.nextElement == this.rootNode.getFollower()) continue;
                while (this.nextElement.isHidden() && this.nextElement != this.nextElement.getParent().getFirstChild()) {
                    this.nextElement = this.nextElement.getFollower();
                }
            }
            if (this.nextElement == this.rootNode.getFollower()) {
                this.nextElement = null;
                return;
            }
            while (this.nextElement.getDepth() < this.level + this.rootNode.getDepth()) {
                this.nextElement = this.nextElement.getFirstChild();
            }
        } while (this.nextElement.isHidden());
    }
}

