/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.ClusteringException;
import chemaxon.clustering.Common;
import chemaxon.clustering.InvalidLicenseKeyException;
import chemaxon.clustering.SpaceDBLoader;
import chemaxon.clustering.SpaceInputStream;
import chemaxon.clustering.SpaceLoader;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;

public class NearestNeighbors
extends Common {
    float avgDist = 0.0f;
    float maxDist = Float.MIN_VALUE;
    float minDist = Float.MAX_VALUE;
    float threshold = 1.0f;
    ChemicalSpace space = null;
    private static final String helptext = "NNeib " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Generates nearest neighbor list for Jarp." + lineSep + "Usage:" + lineSep + "  nneib [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <filepath>        input file to cluster (text file input)" + lineSep + "  -q  --query <sql>             SQL query for reading input " + lineSep + "                                (database input)" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output text file" + lineSep + "  -v  --verbose                 verbose output" + lineSep + "" + lineSep + "" + "Data properties" + lineSep + "" + "  -m  --dimensions <dim>        number of floating-point descriptors" + lineSep + "  -f  --fingerprint-size <bits> binary fingerprint size in bits." + lineSep + "                                fpsize should be a multiple of 32" + lineSep + "  -w  --weights <w1> <w2> ...   the weights of the floating-point descriptors" + lineSep + "  -g  --generate-id             generate id for each compound." + lineSep + "" + lineSep + "Clustering conditions" + lineSep + "  -t  --threshold <threshold>   maximum dissimilarity of two compounds " + lineSep;

    public void setInput(ConnectionHandler conh, String querySQL) throws SQLException {
        this.input = null;
        this.db_input = new SpaceDBLoader(conh, querySQL);
    }

    public void setInput(File file) throws FileNotFoundException {
        this.input = new FileInputStream(file);
        this.db_input = null;
    }

    public void setInput(String fileName) throws FileNotFoundException {
        this.input = new FileInputStream(fileName);
        this.db_input = null;
    }

    public void setInput(InputStream is) {
        this.input = is;
        this.db_input = null;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    synchronized void calcNeighbours(float threshold) {
        ACompoundInTheSpace c;
        int i;
        if (this.space.getDim() == 0) {
            for (i = 0; i < this.space.size(); ++i) {
                c = (ACompoundInTheSpace)this.space.elementAt(i);
                int cb = c.fingerprint().brightness();
                for (int j = i + 1; j < this.space.size(); ++j) {
                    ACompoundInTheSpace q = (ACompoundInTheSpace)this.space.elementAt(j);
                    int qb = q.fingerprint().brightness();
                    int min = cb < qb ? cb : qb;
                    float lb = 1.0f - (float)min / (float)(cb + qb - min);
                    if (!(lb <= threshold) && !this.statsNeeded) continue;
                    float dist = this.space.distance(q, c);
                    if (dist <= threshold) {
                        c.neighbours().add(q);
                        q.neighbours().add(c);
                    }
                    if (!this.statsNeeded) continue;
                    this.avgDist += dist;
                    if (dist < this.minDist) {
                        this.minDist = dist;
                    }
                    if (!(dist > this.maxDist)) continue;
                    this.maxDist = dist;
                }
            }
        } else {
            for (i = 0; i < this.space.size(); ++i) {
                c = (ACompoundInTheSpace)this.space.elementAt(i);
                for (int j = i + 1; j < this.space.size(); ++j) {
                    ACompoundInTheSpace q = (ACompoundInTheSpace)this.space.elementAt(j);
                    float dist = this.space.distance(q, c);
                    if (dist <= threshold) {
                        c.neighbours().add(q);
                        q.neighbours().add(c);
                    }
                    if (!this.statsNeeded) continue;
                    this.avgDist += dist;
                    if (dist < this.minDist) {
                        this.minDist = dist;
                    }
                    if (!(dist > this.maxDist)) continue;
                    this.maxDist = dist;
                }
            }
        }
        this.avgDist /= (float)(this.space.size() * (this.space.size() - 1) / 2);
        for (i = 0; i < this.space.size(); ++i) {
            c = (ACompoundInTheSpace)this.space.elementAt(i);
            c.neighbours().trimToSize();
            Collections.sort(c.neighbours());
        }
    }

    public void run() throws ClusteringException, IOException, SQLException, InvalidLicenseKeyException {
        this.startTime = System.currentTimeMillis();
        this.checkWeights();
        if (this.fpSize % 32 != 0) {
            throw new ClusteringException("Binary fingerprint size must be dividable by 32");
        }
        SpaceLoader loader = this.input != null ? new SpaceInputStream(this.input) : this.db_input;
        this.space = loader.loadSpace(this.fpSize, this.dimensions, this.weights, !this.generateID);
        long minMemory = this.startMemory;
        long retrTime = System.currentTimeMillis();
        this.calcNeighbours(this.threshold);
        long neibTime = System.currentTimeMillis();
        for (ACompoundInTheSpace c : this.space) {
            this.output.setInt(c.getId());
            for (ACompoundInTheSpace neib : c.neighbours()) {
                this.output.setInt(neib.getIndex() + 1);
            }
            this.output.writeln();
        }
        long printTime = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        ConnectionHandler conh = null;
        long startTime = System.currentTimeMillis();
        CLQ.Parameter verbose = null;
        Properties p = new Properties();
        SettingsHandler settingsHandler = null;
        NearestNeighbors nn = new NearestNeighbors();
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            // empty catch block
        }
        CLQ clq = new CLQ(args, p);
        try {
            String s;
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
            long startMemory = 0L;
            if (verbose != null) {
                System.err.println("NNeib started at " + new Date());
                Runtime.getRuntime().gc();
                startMemory = Runtime.getRuntime().freeMemory();
                System.err.println("Free memory at start: " + startMemory + " bytes ");
            }
            CLQ.Parameter inputfile = clq.lookup("-i", "--input", "", 2, false, false);
            CLQ.Parameter inputquery = clq.lookup("-q", "--query", "", 2, false, false);
            CLQ.Parameter genid = clq.lookup("-g", "--generate-id", "", 1, false, false);
            if (inputfile == null && inputquery == null) {
                nn.setInput(System.in);
            } else {
                if (inputfile != null && inputquery != null) {
                    throw new ArgumentException("Ambiguous input");
                }
                if (inputfile != null) {
                    nn.setInput(inputfile.getString());
                } else if (inputquery != null) {
                    conh = NearestNeighbors.openConn(clq);
                    nn.setInput(conh, inputquery.getString());
                }
            }
            CLQ.Parameter dimensions = clq.lookup("-m", "--dimensions", "", 2, false, false);
            CLQ.Parameter fpsize = clq.lookup("-f", "--fingerprint-size", "fingerprint.size", 2, true, true);
            if (fpsize.getInt() % 32 != 0) {
                throw new ArgumentException("Binary fingerprint size must be dividable by 32");
            }
            int wnum = dimensions != null ? dimensions.getInt() : 0;
            CLQ.Parameter pweights = clq.lookup("-w", "--weights", "", wnum + 1, false, false);
            float[] weights = new float[wnum];
            for (int i = 0; i < wnum; ++i) {
                weights[i] = pweights != null ? (float)pweights.getDouble(i) : 1.0f;
            }
            CLQ.Parameter willett = clq.lookup("-willett", "--willett", "", 1, false, false);
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            if (outputfile == null) {
                nn.setOutput(System.out);
            } else {
                nn.setOutput(outputfile.getString());
            }
            CLQ.Parameter threshold = clq.lookup("-t", "--threshold", "NearestNeighbors.threshold", 2, true, true);
            CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
            if (store != null) {
                settingsHandler.save(p);
            }
            if ((s = clq.notUsed()) != null) {
                throw new ArgumentException("Unknown or unnecessary parameter: " + s);
            }
            nn.setDimensions(dimensions != null ? dimensions.getInt() : 0);
            nn.setFpSize(fpsize != null ? fpsize.getInt() : 0);
            nn.setWeights(weights);
            nn.setThreshold(threshold == null ? 0.0f : (float)threshold.getDouble());
            nn.setIdGeneration(genid != null);
            nn.run();
            if (verbose != null) {
                System.err.println("NNeib finished at " + new Date());
                System.err.println("Elapsed time: " + nn.getElapsedTime() / 1000L + " sec.");
            }
            System.exit(0);
        }
        catch (InvalidLicenseKeyException exi) {
            System.err.println(exi.getMessage());
            System.exit(1);
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }
}

