/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class SmilesNode
extends MBaseNode {
    protected String smilesRepresent = null;
    protected MPropertyContainer propertyContainer;

    public SmilesNode() {
    }

    public SmilesNode(Molecule m) {
        this.createRepresentation(m);
    }

    public SmilesNode(Molecule m, MGraph g) {
        super(g);
        this.createRepresentation(m);
    }

    private void createRepresentation(Molecule m) {
        this.smilesRepresent = m.toFormat("smiles");
        this.propertyContainer = (MPropertyContainer)m.properties().clone();
    }

    @Override
    public Object getContent() {
        return this.smilesRepresent;
    }

    @Override
    public Molecule getMolecule() {
        try {
            return MolImporter.importMol(this.smilesRepresent);
        }
        catch (MolFormatException e) {
            return null;
        }
    }

    @Override
    public Molecule getMoleculeWithProperty() {
        Molecule tmpmol = this.getMolecule();
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            tmpmol.setPropertyObject(this.getPropertyKey(i), this.getPropertyObject(this.getPropertyKey(i)));
        }
        return tmpmol;
    }

    @Override
    public int getPropertyCount() {
        return this.propertyContainer.size();
    }

    @Override
    public String getPropertyKey(int i) {
        return this.propertyContainer.getKey(i);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyContainer.getString(key);
    }

    @Override
    public Object getPropertyObject(String key) {
        return this.propertyContainer.getObject(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.propertyContainer.setString(key, value);
    }

    @Override
    public void setPropertyObject(String key, Object value) {
        this.propertyContainer.setObject(key, value);
    }

    @Override
    public void convertPropertiesToStringProperties() {
        for (int j = 0; j < this.propertyContainer.size(); ++j) {
            String propKey = this.propertyContainer.getKey(j);
            if (this.propertyContainer.getObject(propKey) instanceof String) continue;
            this.propertyContainer.setString(propKey, this.propertyContainer.getObject(propKey).toString());
        }
    }

    @Override
    protected void loadNodeData(ObjectInputStream in, Vector multiNodes) throws IOException, ClassNotFoundException {
        super.loadNodeData(in, multiNodes);
        this.smilesRepresent = (String)in.readObject();
        this.propertyContainer = (MPropertyContainer)in.readObject();
    }

    @Override
    public void saveNodeData(ObjectOutputStream out, Vector multiNodes, Integer actualSerialForMultiNodes) throws IOException {
        super.saveNodeData(out, multiNodes, actualSerialForMultiNodes);
        out.writeObject(this.smilesRepresent == null ? new String() : this.smilesRepresent);
        out.writeObject(this.propertyContainer == null ? new MPropertyContainer() : this.propertyContainer);
    }

    @Override
    public MBaseNode copy() {
        SmilesNode copy = new SmilesNode();
        copy.propertyContainer = (MPropertyContainer)this.propertyContainer.clone();
        copy.smilesRepresent = this.smilesRepresent;
        return copy;
    }
}

