/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.SimpleMoleculeNode;
import chemaxon.clustering.gui.JKlustor;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.struc.Molecule;
import chemaxon.struc.StaticMolecule;
import chemaxon.util.FindCodeBase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;

public class SphereExclusion {
    private static final float TANIMOTO_THRESHOLD = 0.15f;
    public static final int SELECT_SMALLEST_DISTANCE = 1;
    public static final int SELECT_LARGEST_DISTANCE = 2;
    public static final int SELECT_RANDOMLY = 3;
    private CFParameters cfp = new CFParameters();
    private float threshold = 0.15f;
    private int selectionMode = 1;
    Random randomGenerator = null;
    private Vector storedMolecules = new Vector();
    private ArrayList openedNodes = new ArrayList();
    private int inputStructureCount = 0;
    private boolean[] excluded = null;
    private boolean[] selected = null;
    private ChemicalFingerprint[] fingerprints = null;
    private Hashtable indexLists = new Hashtable();
    private Hashtable tanimotoLists = new Hashtable();
    private int currentLength = -1;
    private Hashtable clusters = new Hashtable();
    private int clusterCount = 0;
    private int exclusionCount = 0;
    private int singletonCount = 0;
    private int currentMol = -1;
    private boolean dump = false;

    public static void main(String[] args) {
        try {
            SphereExclusion spex = new SphereExclusion();
            spex.importStructures("C:/data/libmcs/omg1000.sdf");
            spex.run();
            final MGraph graph = spex.buildGraph();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFrame mainFrame = new JFrame("Library MCS " + JKlustor.version);
                    final JKlustor jKlustor = new JKlustor(mainFrame);
                    mainFrame.setLocationRelativeTo(null);
                    mainFrame.setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jKlustor.setGraph(graph);
                        }
                    });
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setTanimotoThreshold(float th) {
        this.threshold = th;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public void run() {
        long time1 = System.currentTimeMillis();
        this.init();
        boolean select = this.selectFirstMolecule();
        int[] prevIdxList = null;
        int prevExcl = 0;
        while (select) {
            this.createLists(prevIdxList, prevExcl);
            Integer key = new Integer(this.currentMol);
            float[] dList = (float[])this.tanimotoLists.get(key);
            int[] idxList = (int[])this.indexLists.get(key);
            this.order(idxList, dList);
            prevExcl = this.exclusion(idxList, dList);
            this.updateLists();
            prevIdxList = idxList;
            select = this.selectMolecule();
            this.dumpln("---> " + this.currentLength);
            this.dumpln("=>" + (float)(this.inputStructureCount - this.currentLength) / (float)this.inputStructureCount * 100.0f + "%");
        }
        long time2 = System.currentTimeMillis();
        System.out.println("------------");
        System.out.println("TERMINATED in " + (time2 - time1) + " ms.");
        System.out.println("clusters: " + this.clusterCount);
        System.out.println("->singletons: " + this.singletonCount);
        System.out.println("excluded: " + this.exclusionCount);
        System.out.println("------------");
    }

    public MGraph buildGraph() {
        MGraph graph = new MGraph();
        Enumeration i = this.clusters.keys();
        int clusterID = 0;
        while (i.hasMoreElements()) {
            Integer key = (Integer)i.nextElement();
            MBaseNode cluster = (MBaseNode)this.openedNodes.get(key);
            graph.addCluster(cluster, key);
            ArrayList nodes = (ArrayList)this.clusters.get(key);
            for (int j = 0; j < nodes.size(); ++j) {
                MBaseNode n = (MBaseNode)this.openedNodes.get((Integer)nodes.get(j));
                MBaseNode newCluster = n.copy();
                newCluster.setID(clusterID);
                graph.addNode(cluster, newCluster);
            }
            ++clusterID;
        }
        return graph;
    }

    private void init() {
        this.openedNodes.clear();
        this.fingerprints = new ChemicalFingerprint[this.storedMolecules.size()];
        for (int i = 0; i < this.storedMolecules.size(); ++i) {
            this.addMolecule((Molecule)this.storedMolecules.get(i));
        }
        this.excluded = new boolean[this.inputStructureCount];
        this.selected = new boolean[this.inputStructureCount];
        this.currentLength = this.inputStructureCount;
        if (this.selectionMode == 3 && this.randomGenerator == null) {
            this.randomGenerator = new Random();
        }
    }

    private boolean selectFirstMolecule() {
        this.currentMol = 0;
        this.selected[this.currentMol] = true;
        return true;
    }

    private boolean selectMolecule() {
        switch (this.selectionMode) {
            case 1: {
                return this.selectMoleculeSmallestDist();
            }
            case 2: {
                return this.selectMoleculeLargestDist();
            }
            case 3: {
                return this.selectMoleculeRandomly();
            }
        }
        return false;
    }

    private boolean selectMoleculeSmallestDist() {
        if (this.currentLength == 0) {
            return false;
        }
        Enumeration i = this.tanimotoLists.keys();
        float minDistance = Float.MAX_VALUE;
        int minIndex = -1;
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            float[] dist = (float[])this.tanimotoLists.get(key);
            int[] idx = (int[])this.indexLists.get(key);
            int first = 0;
            while (this.selected[idx[first]]) {
                if (++first != this.currentLength) continue;
                return false;
            }
            if (!(dist[first] < minDistance)) continue;
            minDistance = dist[first];
            minIndex = idx[first];
        }
        this.currentMol = minIndex;
        this.selected[this.currentMol] = true;
        return true;
    }

    private boolean selectMoleculeLargestDist() {
        if (this.currentLength == 0) {
            return false;
        }
        Enumeration i = this.tanimotoLists.keys();
        float maxDistance = 0.0f;
        int maxIndex = -1;
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            float[] dist = (float[])this.tanimotoLists.get(key);
            int[] idx = (int[])this.indexLists.get(key);
            int last = idx.length - 1;
            while (this.selected[idx[last]]) {
                if (--last != 0) continue;
                return false;
            }
            if (!(dist[last] > maxDistance)) continue;
            maxDistance = dist[last];
            maxIndex = idx[last];
        }
        this.currentMol = maxIndex;
        this.selected[this.currentMol] = true;
        return true;
    }

    private boolean selectMoleculeRandomly() {
        if (this.currentLength == 0) {
            return false;
        }
        int r = this.randomGenerator.nextInt(this.currentLength);
        int ri = -1;
        for (int i = 0; i < this.inputStructureCount; ++i) {
            if (!this.excluded[i]) {
                ++ri;
            }
            if (ri != r) continue;
            this.currentMol = i;
            break;
        }
        this.selected[this.currentMol] = true;
        return true;
    }

    private void createLists(int[] prevIdxList, int prevExcl) {
        int i;
        this.dumpln("Creating lists");
        Integer key = new Integer(this.currentMol);
        float[] dList = new float[this.currentLength];
        int[] idxList = new int[this.currentLength];
        if (prevIdxList == null) {
            for (i = 0; i < this.inputStructureCount; ++i) {
                idxList[i] = i;
            }
        } else {
            System.arraycopy(prevIdxList, prevExcl, idxList, 0, this.currentLength);
        }
        for (i = 0; i < this.currentLength; ++i) {
            dList[i] = idxList[i] == this.currentMol ? 0.0f : this.fingerprints[this.currentMol].getTanimoto(this.fingerprints[idxList[i]]);
        }
        this.tanimotoLists.put(key, dList);
        this.indexLists.put(key, idxList);
        this.dumpln("    done.");
        this.dumpln("------------");
    }

    private int exclusion(int[] idxList, float[] vList) {
        int exCount = 0;
        this.dumpln("Exclusion");
        this.dump(this.currentMol + " | ");
        ArrayList<Integer> cluster = new ArrayList<Integer>();
        for (int i = 0; i < this.currentLength && vList[i] <= this.threshold; ++i) {
            cluster.add(new Integer(idxList[i]));
            this.excluded[idxList[i]] = true;
            ++exCount;
            this.dump(idxList[i] + ", ");
        }
        if (exCount > 0) {
            if (exCount == 1) {
                ++this.singletonCount;
            }
            this.currentLength -= exCount;
            this.exclusionCount += exCount;
            ++this.clusterCount;
            this.clusters.put(new Integer(this.currentMol), cluster);
        }
        this.dumpln("\n" + exCount + " structures excluded.");
        this.dumpln("------------");
        return exCount;
    }

    private void updateLists() {
        Enumeration i = this.tanimotoLists.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            float[] dist = (float[])this.tanimotoLists.get(key);
            int[] idx = (int[])this.indexLists.get(key);
            float[] newdist = new float[this.currentLength];
            int[] newidx = new int[this.currentLength];
            int k = 0;
            for (int j = 0; j < idx.length; ++j) {
                if (this.excluded[idx[j]]) continue;
                newidx[k] = idx[j];
                newdist[k] = dist[j];
                ++k;
            }
            this.tanimotoLists.remove(key);
            this.indexLists.remove(key);
            this.tanimotoLists.put(key, newdist);
            this.indexLists.put(key, newidx);
        }
    }

    private void order(int[] idxList, float[] vList) {
        for (int i = 0; i < vList.length - 1; ++i) {
            for (int j = i + 1; j < vList.length; ++j) {
                if (!(vList[i] > vList[j])) continue;
                float tmp = vList[i];
                int tmpi = idxList[i];
                vList[i] = vList[j];
                idxList[i] = idxList[j];
                vList[j] = tmp;
                idxList[j] = tmpi;
            }
        }
        this.dump(idxList);
    }

    public void addMolecule(Molecule mol) {
        this.addMolecule(new StaticMolecule(mol));
    }

    public void addMolecule(StaticMolecule mol) {
        try {
            SimpleMoleculeNode newNode = new SimpleMoleculeNode(mol);
            ChemicalFingerprint cf = new ChemicalFingerprint(this.cfp);
            cf.generate(mol.toMolecule());
            int cid = this.openedNodes.size();
            newNode.setID(cid);
            ((MBaseNode)newNode).setProperty("ID", "" + cid);
            ((MBaseNode)newNode).setPropertyObject("CF", cf);
            this.fingerprints[cid] = cf;
            this.openedNodes.add(newNode);
            this.inputStructureCount = this.openedNodes.size();
        }
        catch (Exception e) {
            System.err.println("Failed to import structure, skipped.\n" + e.getMessage());
        }
    }

    public void importStructures(String fileName) throws IOException {
        this.importStructures(SphereExclusion.getInputStream(fileName));
    }

    public void importStructures(InputStream is) throws IOException {
        try {
            this.readStructures(is);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void readStructures(InputStream is) throws Exception {
        this.storedMolecules.clear();
        MolImporter molimp = this.getMolImporter(is);
        Molecule mol = this.readNext(molimp);
        while (mol != null) {
            this.storedMolecules.add(mol);
            mol = this.readNext(molimp);
        }
    }

    private Molecule readNext(MolImporter molimp) throws IOException {
        Molecule mol = molimp.read();
        return mol != null ? this.prepare(mol) : null;
    }

    private Molecule prepare(Molecule mol) {
        mol.aromatize();
        if (mol.getDim() < 2) {
            mol.clean(2, "");
        }
        mol.calcHybridization();
        return mol;
    }

    private MolImporter getMolImporter(InputStream is) throws Exception {
        if (is == null) {
            is = System.in;
        }
        return new MolImporter(new MolInputStream(is));
    }

    public static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    public static InputStream getInputStream(String s) throws IOException {
        InputStream is;
        if (SphereExclusion.isURL(s)) {
            URLConnection conn = new URL(s).openConnection();
            is = conn.getInputStream();
            is = new MonitorableInputStream(is, conn.getContentLength());
        } else {
            File f = new File(s);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                File f2 = new File(FindCodeBase.getCodeBaseDir() + File.separator + s);
                if (f2.exists()) {
                    is = new FileInputStream(f2);
                } else {
                    is = BasicEnvironment.getResourceAsStream(SphereExclusion.class, "/" + s);
                    if (is == null) {
                        is = new ByteArrayInputStream(s.getBytes());
                    }
                }
            }
        }
        is = new BufferedInputStream(new ProgressMonitorInputStream(null, "Reading " + s, is));
        if (s.endsWith(".gz")) {
            return new GZIPInputStream(is);
        }
        if (s.endsWith(".zip")) {
            System.out.println("zipped");
            return new ZipInputStream(is);
        }
        return is;
    }

    private void dump(String s) {
        if (this.dump) {
            System.out.print(s);
        }
    }

    private void dumpln(String s) {
        if (this.dump) {
            System.out.println(s);
        }
    }

    private void dump(float[] list) {
        if (this.dump) {
            for (int i = 0; i < list.length; ++i) {
                if (i > 0 && i % 9 == 0) {
                    System.out.println(list[i]);
                    continue;
                }
                System.out.print(list[i] + ", ");
            }
            System.out.println("");
        }
    }

    private void dump(int[] list) {
        if (this.dump) {
            for (int i = 0; i < list.length; ++i) {
                if (i > 0 && i % 9 == 0) {
                    System.out.println(list[i]);
                    continue;
                }
                System.out.print(list[i] + ", ");
            }
            System.out.println("");
        }
    }
}

