/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering;

import chemaxon.clustering.ACompoundInTheSpace;
import chemaxon.clustering.ChemicalSpace;
import chemaxon.clustering.ClusteringException;
import chemaxon.clustering.Common;
import chemaxon.clustering.InvalidLicenseKeyException;
import chemaxon.clustering.ResultPrintStream;
import chemaxon.clustering.ResultProcessor;
import chemaxon.clustering.SpaceDBLoader;
import chemaxon.clustering.SpaceInputStream;
import chemaxon.clustering.SpaceLoader;
import chemaxon.clustering.WardCluster;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Ward
extends Common {
    public static final int RNN_AND_CLUSTERING = 0;
    public static final int ONLY_RNN = 1;
    public static final int ONLY_CLUSTERING = 2;
    private float fingerprintWeight = 0.0f;
    private float kelley_Weight = 1.0f;
    private boolean singletonsNegative = false;
    private boolean showCentroid = false;
    private int clusterCount;
    private ChemicalSpace space;
    private ResultProcessor indexStream = null;
    private int mode = 0;
    private BufferedReader rnnInput = null;
    private static final String helptext = "Ward " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Ward type clustring using the RNN approach." + lineSep + "Usage:" + lineSep + "  ward [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -P  --proptable <table>       property table" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <filepath>        input file path (text file input)" + lineSep + "  -q  --query <sql>             SQL query for reading input " + lineSep + "                                (database input)" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output file path (text file output)" + lineSep + "  -a  --statement <sql>         SQL statement for inserting results" + lineSep + "                                (database output)" + lineSep + "  -x  --central                 calculate and sign central objects" + lineSep + "  -y  --singlet                 singletons get negative cluster ids" + lineSep + "  -z  --statistics              print statistics" + lineSep + "  -Z  --only-statistics         print only statistics" + lineSep + "  -K  --Kelley <filepath>       print Kelley statistics into text file" + lineSep + "  -v  --verbose                 verbose output" + lineSep + "" + lineSep + "" + "Data properties" + lineSep + "" + "  -m  --dimensions <dim>        number of floating-point descriptors" + lineSep + "  -f  --fingerprint-size <bits> binary fingerprint size in bits" + lineSep + "                                fpsize should be a multiple of 32" + lineSep + "  -w  --weights <w1> <w2> ...   the weights of the floating-point descriptors" + lineSep + "  -g  --generate-id             generate id for each compound" + lineSep + "" + lineSep + "" + "Clustering parameter" + lineSep + "  -c  --cluster-count <count>   number of clusters to be generated " + lineSep + "  -C  --only-clustering         clusters are generated using input RNN list" + lineSep + "  If --cluster-count is not set, then RNN list is generated on output." + lineSep;

    public void setInput(ConnectionHandler conh, String querySQL) throws SQLException {
        this.input = null;
        this.db_input = new SpaceDBLoader(conh, querySQL);
    }

    public void setInput(File file) throws FileNotFoundException {
        this.input = new FileInputStream(file);
        this.db_input = null;
    }

    public void setInput(String fileName) throws FileNotFoundException {
        this.input = new FileInputStream(fileName);
        this.db_input = null;
    }

    public void setInput(InputStream is) {
        this.input = is;
        this.db_input = null;
    }

    public void setCentralShown(boolean b) {
        this.showCentroid = b;
    }

    public boolean getCentralShown() {
        return this.showCentroid;
    }

    public void setKelleyStats(PrintStream ps) {
        this.indexStream = ps != null ? new ResultPrintStream(ps) : null;
    }

    public void setKelleyStats(File file) throws FileNotFoundException {
        if (file != null) {
            try {
                this.setKelleyStats(new PrintStream(new FileOutputStream(file)));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException iOException) {}
        } else {
            this.indexStream = null;
        }
    }

    public void setKelleyStats(String fileName) throws FileNotFoundException {
        if (fileName != null) {
            this.setKelleyStats(new File(fileName));
        } else {
            this.indexStream = null;
        }
    }

    public void setSingletonNegative(boolean b) {
        this.singletonsNegative = b;
    }

    public boolean isSingletonNegative() {
        return this.singletonsNegative;
    }

    public void setClusterCount(int count) {
        this.clusterCount = count;
    }

    public int getClusterCount() {
        return this.clusterCount;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void run() throws ClusteringException, IOException, SQLException, InvalidLicenseKeyException {
        Object[] distances;
        int basespaceNo;
        this.startTime = System.currentTimeMillis();
        this.checkWeights();
        if (this.fpSize % 32 != 0) {
            throw new ClusteringException("Binary fingerprint size must be dividable by 32");
        }
        if (this.onlyStat) {
            this.statsNeeded = true;
        }
        float f = this.fingerprintWeight = this.fpSize != 0 ? this.weights[0] : 0.0f;
        if (this.mode == 1) {
            ((ResultPrintStream)this.output).setFormating(false);
        }
        if (this.mode == 2) {
            this.rnnInput = new BufferedReader(new InputStreamReader(this.input));
            this.space = Ward.loadSpaceFromRNNFile(this.rnnInput);
            basespaceNo = this.space.size();
            ChemicalSpace elements = (ChemicalSpace)this.space.clone();
            distances = this.loadDistancesFromRNNFile(this.rnnInput, elements);
        } else {
            SpaceLoader loader = this.input != null ? new SpaceInputStream(this.input) : this.db_input;
            this.space = loader.loadSpace(this.fpSize, this.dimensions, this.weights, !this.generateID);
            this.space.ensureCapacity(this.space.size() * 2);
            basespaceNo = this.space.size();
            int maxSpace = basespaceNo + basespaceNo - 1;
            int[] counter = new int[]{0};
            ACompoundInTheSpace seed = null;
            ChemicalSpace elements = (ChemicalSpace)this.space.clone();
            distances = new Distance[basespaceNo - 1];
            long startTime = System.currentTimeMillis();
            ChemicalSpace RNNChain = new ChemicalSpace(this.space.getWeights(), this.space.getFpsize(), this.space.getDim());
            while (elements.size() > 1) {
                long roundStart = System.currentTimeMillis();
                seed = (ACompoundInTheSpace)elements.elementAt(0);
                RNNChain.add(seed);
                this.RNN(seed, RNNChain, elements, (Distance[])distances, counter);
            }
            Arrays.sort(distances);
        }
        if (this.mode == 1) {
            int i;
            for (i = 0; i < basespaceNo; ++i) {
                ACompoundInTheSpace c = (ACompoundInTheSpace)this.space.elementAt(i);
                this.output.setInt(c.getId());
                this.output.writeln();
            }
            this.output.writeln();
            for (i = 0; i < distances.length; ++i) {
                this.output.setInt(distances[i].A.getIndex() + 1);
                this.output.setInt(distances[i].B.getIndex() + 1);
                this.output.setInt(distances[i].C.getIndex() + 1);
                this.output.setFloat(((Distance)distances[i]).dist);
                this.output.writeln();
            }
        } else {
            int i;
            WardCluster[] cluster = new WardCluster[distances.length];
            int[] clid = new int[]{1};
            for (int i2 = 0; i2 <= distances.length - this.clusterCount; ++i2) {
                ACompoundInTheSpace a = distances[i2].A;
                ACompoundInTheSpace b = distances[i2].B;
                ACompoundInTheSpace c = distances[i2].C;
                this.joinCluster(a, b, c, clid, cluster, basespaceNo);
            }
            if (!this.onlyStat) {
                this.output.printHeader(this.showCentroid);
            }
            int[] clids = new int[basespaceNo - 1];
            for (int i3 = 0; i3 < basespaceNo - 1; ++i3) {
                clids[i3] = Integer.MIN_VALUE;
            }
            WardCluster[] clusters = new WardCluster[this.clusterCount];
            int clcounter = 0;
            int sid = 1;
            for (i = 0; i < basespaceNo; ++i) {
                ACompoundInTheSpace c = (ACompoundInTheSpace)this.space.elementAt(i);
                WardCluster cl = (WardCluster)c.getCluster();
                if (cl != null) {
                    int clindex = cl.getId() - 1;
                    if (clids[clindex] == Integer.MIN_VALUE) {
                        clusters[clcounter] = cl;
                        clids[clindex] = clcounter++;
                    }
                    if (this.onlyStat) continue;
                    if (this.showCentroid) {
                        this.output.process(c.getId(), clids[clindex] + 1, cl.size(), c.equals(cl.getCentroid(this.fingerprintWeight)), c.neighbours().size());
                        continue;
                    }
                    this.output.process(c.getId(), clids[clindex] + 1, cl.size(), c.neighbours().size());
                    continue;
                }
                if (!this.singletonsNegative) {
                    clusters[clcounter] = cl = new WardCluster(c, -1);
                }
                if (!this.onlyStat) {
                    if (this.showCentroid) {
                        this.output.process(c.getId(), this.singletonsNegative ? -sid++ : clcounter + 1, 1, true, c.neighbours().size());
                    } else {
                        this.output.process(c.getId(), this.singletonsNegative ? -sid++ : clcounter + 1, 1, c.neighbours().size());
                    }
                }
                if (this.singletonsNegative) continue;
                ++clcounter;
            }
            if (this.statsNeeded) {
                this.statStream.println();
                this.statStream.println("STATISTICS");
                this.statStream.println();
                this.statStream.println("Number of objects = " + basespaceNo);
                this.statStream.println("Number of clusters = " + this.clusterCount);
                this.statStream.println();
                this.statStream.println("List of clusters" + (this.singletonsNegative ? " (without singletons)" : "") + ":");
                this.statStream.println("clid\tsize" + (this.showCentroid ? "\tcentr" : ""));
                for (i = 0; i < clcounter; ++i) {
                    WardCluster cl = clusters[i];
                    int size = 0;
                    size = cl.size();
                    this.statStream.println(i + 1 + "\t" + size + (this.showCentroid ? "\t" + cl.getCentroid(this.fingerprintWeight) : ""));
                }
                this.statStream.println();
            }
        }
        if (this.indexStream != null) {
            float[] kelleyIndex = new float[distances.length + 1];
            float[] pointbis = null;
            float[] wb = null;
            float[] vrc = null;
            this.indexCalc((Distance[])distances, basespaceNo, kelleyIndex, pointbis, wb, vrc);
            if (kelleyIndex != null) {
                float kelleyminValue = this.findmin(kelleyIndex);
                int kelleymin = -1;
                this.indexStream.writeHeader("Kelley Indexes for All Cluster Levels");
                this.indexStream.writeln();
                this.indexStream.writeHeader("level\tindex");
                for (int k = 1; k < kelleyIndex.length; ++k) {
                    this.indexStream.setInt(k);
                    this.indexStream.setFloat(kelleyIndex[k]);
                    this.indexStream.writeln();
                    if (kelleyminValue != kelleyIndex[k]) continue;
                    kelleymin = k;
                }
                this.indexStream.writeln();
                this.indexStream.writeHeader("Optimal number of clusters: " + kelleymin);
                this.indexStream.writeln();
            }
            if (pointbis != null) {
                for (int k = 1; k < pointbis.length; ++k) {
                    this.indexStream.setInt(k);
                    this.indexStream.setFloat((float)pointbis[k]);
                    this.indexStream.writeln();
                }
            }
            if (wb != null) {
                for (int k = 1; k < wb.length; ++k) {
                    this.indexStream.setInt(k);
                    this.indexStream.setFloat((float)wb[k]);
                    this.indexStream.writeln();
                }
            }
            if (vrc != null) {
                for (int k = 1; k < vrc.length; ++k) {
                    this.indexStream.setInt(k);
                    this.indexStream.setFloat((float)vrc[k]);
                    this.indexStream.writeln();
                }
            }
        }
    }

    private int joinCluster(ACompoundInTheSpace a, ACompoundInTheSpace b, ACompoundInTheSpace c, int[] clid, WardCluster[] cluster, int basespaceNo) {
        int cdiff = 0;
        int cno = c.getIndex() - basespaceNo;
        if (a.getIndex() < basespaceNo && b.getIndex() < basespaceNo) {
            int n = clid[0];
            clid[0] = n + 1;
            cluster[cno] = new WardCluster(a, n);
            cluster[cno].add(b);
            ++cdiff;
        } else if (a.getIndex() < basespaceNo) {
            int bno = b.getIndex() - basespaceNo;
            cluster[cno] = cluster[bno];
            cluster[cno].add(a);
        } else if (b.getIndex() < basespaceNo) {
            int ano = a.getIndex() - basespaceNo;
            cluster[cno] = cluster[ano];
            cluster[cno].add(b);
        } else {
            int id2;
            int ano = a.getIndex() - basespaceNo;
            int bno = b.getIndex() - basespaceNo;
            int id1 = cluster[ano].getId();
            if (id1 < (id2 = cluster[bno].getId())) {
                cluster[cno] = cluster[ano];
                cluster[cno].addAll(cluster[bno]);
                cluster[bno] = cluster[cno];
            } else {
                cluster[cno] = cluster[bno];
                cluster[cno].addAll(cluster[ano]);
                cluster[ano] = cluster[cno];
            }
            --cdiff;
        }
        cluster[cno].setCluster();
        return cdiff;
    }

    private int RNN(ACompoundInTheSpace cmp, ChemicalSpace RNNChain, ChemicalSpace elements, Distance[] distances, int[] counter) {
        int retID = -73;
        int cmpID = cmp.getIndex();
        do {
            cmp.calcNeighbours(elements, 5, this.fingerprintWeight);
            ACompoundInTheSpace cmpNN = cmp.getFirstNeighbour(elements, 5, this.fingerprintWeight);
            if (RNNChain.size() > 1 && cmpNN == RNNChain.elementAt(RNNChain.size() - 2)) {
                ACompoundInTheSpace newElem = this.createNewElement(cmp, cmpNN, this.space, elements, RNNChain, distances, counter);
                return cmpNN.getIndex();
            }
            RNNChain.add(cmpNN);
            retID = this.RNN(cmpNN, RNNChain, elements, distances, counter);
            if (cmpID == retID) {
                return -1;
            }
            if (retID == -1) continue;
            return retID;
        } while (elements.size() > 1);
        return -73;
    }

    private ACompoundInTheSpace createNewElement(ACompoundInTheSpace e1, ACompoundInTheSpace e2, ChemicalSpace sfull, ChemicalSpace sred, ChemicalSpace RNNChain, Distance[] dist, int[] counter) {
        ACompoundInTheSpace newElement = new ACompoundInTheSpace(sfull.size(), e1, e2);
        Distance d = new Distance(e1, e2, newElement, e1.wardDistance(e2, this.fingerprintWeight));
        int n = counter[0];
        counter[0] = n + 1;
        dist[n] = d;
        sred.add(newElement);
        sred.removeElement(e1);
        sred.removeElement(e2);
        RNNChain.removeElement(e1);
        RNNChain.removeElement(e2);
        sfull.add(newElement);
        return newElement;
    }

    private static ChemicalSpace loadSpaceFromRNNFile(BufferedReader br) throws IOException {
        ChemicalSpace space = new ChemicalSpace(null, 0, 0);
        int index = 0;
        String line = null;
        while ((line = br.readLine()) != null && !line.equals("")) {
            StringTokenizer st = new StringTokenizer(line);
            int id = Integer.parseInt(st.nextToken());
            ACompoundInTheSpace c = new ACompoundInTheSpace(index, id, null, 0, null);
            space.add(c);
            ++index;
        }
        return space;
    }

    private Distance[] loadDistancesFromRNNFile(BufferedReader br, ChemicalSpace space) throws IOException {
        Distance[] distances = new Distance[space.size() - 1];
        String line = null;
        int index = 0;
        while ((line = br.readLine()) != null && !line.equals("")) {
            StringTokenizer st = new StringTokenizer(line);
            int indexA = Integer.parseInt(st.nextToken()) - 1;
            int indexB = Integer.parseInt(st.nextToken()) - 1;
            int indexC = Integer.parseInt(st.nextToken()) - 1;
            float d = Float.parseFloat(st.nextToken());
            if (space.size() <= indexC) {
                space.setSize(indexC + 1);
            }
            ACompoundInTheSpace c = new ACompoundInTheSpace(indexC, -1, null, 0, null);
            space.set(indexC, c);
            Distance dist = new Distance((ACompoundInTheSpace)space.elementAt(indexA), (ACompoundInTheSpace)space.elementAt(indexB), c, d);
            distances[index++] = dist;
        }
        return distances;
    }

    private void indexCalc(Distance[] distances, int basespaceNo, float[] kelley, float[] pointbis, float[] wb, float[] vrc) {
        boolean KELLEY = kelley != null;
        boolean POINTBIS = pointbis != null;
        boolean WB = wb != null;
        boolean VRC = vrc != null;
        int joinS = distances.length;
        int Num_of_dist = basespaceNo * (basespaceNo - 1) / 2;
        float spread = 0.0f;
        float d_com = 0.0f;
        float d_diff = 0.0f;
        float d_com_avg = 0.0f;
        float d_diff_avg = 0.0f;
        float stddev = 0.0f;
        int n_com = 0;
        boolean n_diff = false;
        float[] avg_spread = null;
        float[] d_sum = null;
        int[] clNo = null;
        WardCluster[] cluster = new WardCluster[distances.length];
        int[] clid = new int[]{1};
        if (KELLEY) {
            avg_spread = new float[joinS];
            d_sum = new float[joinS];
            clNo = new int[joinS];
            kelley[0] = Float.MAX_VALUE;
        }
        int n_c = basespaceNo;
        for (int k = 0; k < joinS; ++k) {
            ACompoundInTheSpace a = distances[k].A;
            ACompoundInTheSpace b = distances[k].B;
            ACompoundInTheSpace c = distances[k].C;
            Iterator i = null;
            Iterator j = null;
            int ano = -1;
            int bno = -1;
            int cno = c.getIndex() - basespaceNo;
            if (a.getIndex() >= basespaceNo) {
                ano = a.getIndex() - basespaceNo;
                i = cluster[ano].iterator();
            }
            if (b.getIndex() >= basespaceNo) {
                bno = b.getIndex() - basespaceNo;
                j = cluster[bno].iterator();
            }
            if (i == null) {
                if (j == null) {
                    d_sum[cno] = a.wardDistance(b, this.fingerprintWeight);
                    ++n_com;
                } else {
                    while (j.hasNext()) {
                        ACompoundInTheSpace tmpb = (ACompoundInTheSpace)j.next();
                        int n = cno;
                        d_sum[n] = d_sum[n] + a.wardDistance(tmpb, this.fingerprintWeight);
                        ++n_com;
                    }
                }
            } else {
                while (i.hasNext()) {
                    ACompoundInTheSpace tmpa = (ACompoundInTheSpace)i.next();
                    if (j == null) {
                        int n = cno;
                        d_sum[n] = d_sum[n] + tmpa.wardDistance(b, this.fingerprintWeight);
                        ++n_com;
                        continue;
                    }
                    j = cluster[bno].iterator();
                    while (j.hasNext()) {
                        ACompoundInTheSpace tmpb = (ACompoundInTheSpace)j.next();
                        int n = cno;
                        d_sum[n] = d_sum[n] + tmpa.wardDistance(tmpb, this.fingerprintWeight);
                        ++n_com;
                    }
                }
            }
            n_c = basespaceNo - k - 1;
            int cdiff = this.joinCluster(a, b, c, clid, cluster, basespaceNo);
            if (!KELLEY) continue;
            clNo[k] = k == 0 ? 1 : clNo[k - 1] + cdiff;
            spread += d_sum[cno] / (float)cluster[cno].size();
            if (i != null) {
                spread -= d_sum[ano] / (float)cluster[ano].size();
            }
            if (j != null) {
                spread -= d_sum[bno] / (float)cluster[bno].size();
            }
            avg_spread[k] = spread / (float)clNo[k];
        }
        if (KELLEY) {
            float min_d = this.findmin(avg_spread);
            float max_d = this.findmax(avg_spread);
            for (int k = 0; k < joinS; ++k) {
                n_c = basespaceNo - k - 1;
                kelley[n_c] = (float)(basespaceNo - 2) * ((avg_spread[k] - min_d) / (max_d - min_d)) + 1.0f + this.kelley_Weight * (float)n_c;
            }
        }
    }

    private float findmin(float[] pool) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < pool.length; ++i) {
            min = pool[i] < min ? pool[i] : min;
        }
        return min;
    }

    private float findmax(float[] pool) {
        float max = Float.MIN_VALUE;
        for (int i = 0; i < pool.length; ++i) {
            max = pool[i] > max ? pool[i] : max;
        }
        return max;
    }

    public static void main(String[] args) {
        ConnectionHandler conh = null;
        long startTime = System.currentTimeMillis();
        CLQ.Parameter verbose = null;
        Properties p = new Properties();
        CLQ clq = new CLQ(args, p);
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            String s;
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            Object input = null;
            Object output = null;
            Object rnnInput = null;
            Object indexStream = null;
            Ward ward = new Ward();
            CLQ.Parameter clusterCount = clq.lookup("-c", "--cluster-count", "", 2, false, false);
            CLQ.Parameter onlyClustering = clq.lookup("-C", "--only-clustering", "", 1, false, false);
            CLQ.Parameter inputfile = clq.lookup("-i", "--input", "", 2, false, false);
            CLQ.Parameter inputquery = clq.lookup("-q", "--query", "", 2, false, false);
            CLQ.Parameter genid = clq.lookup("-g", "--generate-id", "", 1, false, false);
            if (inputfile == null && inputquery == null) {
                ward.setInput(System.in);
            } else {
                if (inputfile != null && inputquery != null) {
                    throw new ArgumentException("Ambiguous input");
                }
                if (inputfile != null) {
                    ward.setInput(inputfile.getString());
                } else if (inputquery != null) {
                    conh = Ward.openConn(clq);
                    ward.setInput(conh, inputquery.getString());
                }
            }
            CLQ.Parameter dimensions = null;
            CLQ.Parameter fpsize = null;
            if (onlyClustering == null) {
                dimensions = clq.lookup("-m", "--dimensions", "", 2, false, false);
                fpsize = clq.lookup("-f", "--fingerprint-size", "fingerprint.size", 2, true, true);
                if (fpsize.getInt() % 32 != 0) {
                    throw new ArgumentException("Binary fingerprint size must be dividable by 32");
                }
            }
            int wnum = dimensions != null ? dimensions.getInt() : 0;
            CLQ.Parameter pweights = clq.lookup("-w", "--weights", "", wnum + 1, false, false);
            float[] weights = new float[wnum];
            for (int i = 0; i < wnum; ++i) {
                weights[i] = pweights != null ? (float)pweights.getDouble(i) : 1.0f;
            }
            CLQ.Parameter centroid = null;
            CLQ.Parameter stat = null;
            CLQ.Parameter onlyStat = null;
            CLQ.Parameter singletonsNegative = null;
            if (clusterCount != null) {
                stat = clq.lookup("-z", "--statistics", "", 1, false, false);
                onlyStat = clq.lookup("-Z", "--only-statistics", "", 1, false, false);
                singletonsNegative = clq.lookup("-y", "--singlet", "", 1, false, false);
            }
            if (onlyClustering == null) {
                centroid = clq.lookup("-x", "--central", "", 1, false, false);
            }
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            CLQ.Parameter outputquery = clq.lookup("-a", "--statement", "", 2, false, false);
            CLQ.Parameter index = clq.lookup("-K", "--Kelley", "", 2, false, false);
            CLQ.Parameter kelleyWeight = clq.lookup("-W", "--KelleyWeight", "", 2, false, false);
            verbose = clq.lookup("-v", "--verbose", "", 1, false, false);
            if (index != null) {
                ward.setKelleyStats(index.getString());
            }
            if (outputfile == null && outputquery == null) {
                ward.setOutput(System.out);
            } else {
                if (outputfile != null && outputquery != null) {
                    throw new ArgumentException("Ambiguous output");
                }
                if (outputfile != null) {
                    ward.setOutput(outputfile.getString());
                } else if (outputquery != null) {
                    if (conh == null) {
                        conh = Ward.openConn(clq);
                    }
                    ward.setOutput(conh.getConnection(), outputquery.getString());
                }
            }
            CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
            if (store != null) {
                settingsHandler.save(p);
            }
            if ((s = clq.notUsed()) != null) {
                throw new ArgumentException("Unknown or unnecessary parameter: " + s);
            }
            if (verbose != null) {
                System.err.println("Ward started at " + new Date());
            }
            ward.setDimensions(dimensions != null ? dimensions.getInt() : 0);
            ward.setFpSize(fpsize != null ? fpsize.getInt() : 0);
            ward.setWeights(weights);
            ward.setClusterCount(clusterCount == null ? 0 : clusterCount.getInt());
            ward.setCentralShown(centroid != null);
            ward.setSingletonNegative(singletonsNegative != null);
            ward.setStatNeeded(stat != null);
            ward.setOnlyStat(onlyStat != null);
            ward.setIdGeneration(genid != null);
            if (clusterCount == null) {
                ward.setMode(1);
            } else if (onlyClustering != null) {
                ward.setMode(2);
            } else {
                ward.setMode(0);
            }
            ward.run();
            if (verbose != null) {
                System.err.println("Ward finished at " + new Date());
                System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime) / 1000L + " sec.");
            }
            return;
        }
        catch (InvalidLicenseKeyException exi) {
            System.err.println(exi.getMessage());
            return;
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            return;
        }
    }

    private class Distance
    implements Comparable {
        ACompoundInTheSpace A = null;
        ACompoundInTheSpace B = null;
        ACompoundInTheSpace C = null;
        float dist = 0.0f;

        public Distance(ACompoundInTheSpace a, ACompoundInTheSpace b, ACompoundInTheSpace c, float d) {
            this.A = a;
            this.B = b;
            this.C = c;
            this.dist = d;
        }

        public int compareTo(Object o) {
            return this.compareTo((Distance)o);
        }

        public int compareTo(Distance o) {
            float d = this.dist - o.dist;
            if (d == 0.0f) {
                return 0;
            }
            return d > 0.0f ? 1 : -1;
        }

        public String toString() {
            return this.A.getId() + "-" + this.B.getId() + ":" + this.dist;
        }
    }
}

