/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.BitSetPropertyGroup;
import chemaxon.clustering.backend.DoublePropertyGroup;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.Events;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.IntPropertyGroup;
import chemaxon.clustering.backend.ObjectPropertyGroup;
import chemaxon.clustering.util.IntegerSet;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.clustering.util.SimpleIntegerSet;
import chemaxon.clustering.util.SimpleRAIterator;
import java.util.ConcurrentModificationException;

public class ArbitraryEntityGroup
implements EntityGroup {
    private EntityStore store = null;
    private IntegerSet idx = null;
    private Events.DefaultGroupEventHandler geh = null;
    private int cc = 0;
    private EntityProperties p = null;

    public ArbitraryEntityGroup(EntityStore s, EntityProperties p) {
        this(s, -1, -1, p);
    }

    @Override
    public int getIndex() {
        return this.p.indexOfEntity();
    }

    public ArbitraryEntityGroup(EntityStore s, int initialCapacity, int initialIDXRange, EntityProperties p) {
        this.idx = initialCapacity >= 0 ? new SimpleIntegerSet(initialCapacity, initialIDXRange) : new SimpleIntegerSet();
        this.store = s;
        this.geh = null;
        this.cc = 0;
        this.p = p;
    }

    public ArbitraryEntityGroup(EntityStore s, IntegerSet iidx, EntityProperties p) {
        this(s, iidx.size(), iidx.max(), p);
        for (int i = 0; i < iidx.size(); ++i) {
            this.idx.add(iidx.get(i));
        }
    }

    @Override
    public RAIterator<Entity> iterator() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        return new SimpleRAIterator<Entity>(this);
    }

    @Override
    public int size() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        return this.idx.size();
    }

    @Override
    public Entity get(int i) {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        return this.store.getEntity(this.idx.get(i));
    }

    @Override
    public void add(Entity e) {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        ++this.cc;
        this.idx.add(this.store.indexOf(e));
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, e, true);
        }
    }

    public void addAll() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        ++this.cc;
        this.idx.addInterval(0, this.store.size() - 1);
        if (this.geh != null) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean remove(Entity e) {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        ++this.cc;
        boolean ret = this.idx.remove(this.store.indexOf(e));
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, e, false);
        }
        return ret;
    }

    @Override
    public boolean contains(Entity e) {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        return this.idx.contains(this.store.indexOf(e));
    }

    @Override
    public IntPropertyGroup getIntPropertyGroup(int iPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DoublePropertyGroup getDoublePropertyGroup(int dPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSetPropertyGroup getBitSetPropertyGroup(int bPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectPropertyGroup getObjectPropertyGroup(int oPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseEntityGroup() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        if (this.geh != null) {
            this.geh.entityGroupReleased(this);
            this.geh.releaseHandler();
        }
        this.store = null;
        this.idx = null;
        this.geh = null;
    }

    @Override
    public Events.GroupEventHandler getEventHandler() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        if (this.geh == null) {
            this.geh = new Events.DefaultGroupEventHandler(this);
        }
        return this.geh;
    }

    @Override
    public EntityProperties properties() {
        return this.p;
    }

    @Override
    public boolean isReleased() {
        return this.store == null;
    }

    public String toString() {
        return ArbitraryEntityGroup.toString(this);
    }

    public static String toString(EntityGroup g) {
        StringBuffer b = new StringBuffer(50 + 5 * g.size());
        b.append(g.getClass().getName() + " size: " + g.size() + " items:");
        if (g.isGetSupported()) {
            for (int i = 0; i < g.size(); ++i) {
                if (i == 0) {
                    b.append(" ");
                } else {
                    b.append(",");
                }
                b.append(((Entity)g.get(i)).getIndex());
            }
        } else {
            b.append("<get not supported>");
        }
        return b.toString();
    }

    public static RAIterator<Entity> iterator(EntityGroup g) {
        return new SimpleRAIterator<Entity>(g);
    }

    @Override
    public int getCC() {
        if (this.store == null) {
            throw new UnsupportedOperationException();
        }
        return this.cc;
    }

    public static RAIterator<Entity> emptyRAIterator(final EntityGroup g, final boolean getSupported) {
        return new SimpleRAIterator<Entity>(new RandomAccess<Entity>(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Entity get(int i) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getCC() {
                return g.getCC();
            }

            @Override
            public int indexOf(Entity e) {
                return SimpleRAIterator.naiveIndexOf(this, e);
            }

            @Override
            public boolean isGetSupported() {
                return getSupported;
            }
        });
    }

    @Override
    public int indexOf(Entity e) {
        return SimpleRAIterator.naiveIndexOf(this, e);
    }

    @Override
    public boolean isGetSupported() {
        return true;
    }

    @Override
    public boolean isHierarchic() {
        return false;
    }

    @Override
    public HierarchicEntityGroup getHierarchic() {
        return null;
    }
}

