/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.PQValue;
import chemaxon.clustering.backend.SimplePQValue;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.backend.oa.OALevelSelect;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BemisMurcko
extends ClustorImpl {
    Log log = LogFactory.getLog(BemisMurcko.class);
    private FrameworkReduction fw = new SimpleBMFrameworkReduction();
    OALevelSelect prefl = OALevelSelect.parseStatement("finest-1");

    public BemisMurcko(ChemFormatFactory ff) {
        super(ff, 2);
        this.setStoreClusterRepresentantIntermediate();
        this.setStoreFirstParentID();
        if (ff.isLeavesStored()) {
            this.setStoreLeavesFirstParentID();
        }
        for (int i = 1; i < this.fw.getLevelCount(); ++i) {
            this.getHC().addLevel();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"construct BemisMurcko");
        }
        HC.Callback<Molecule> ccb = new HC.Callback<Molecule>(0){

            @Override
            public void processNewLeaf(Entity node, Entity rawnode, Molecule rawmol) {
                int i;
                super.processNewLeaf(node, rawnode, rawmol);
                if (BemisMurcko.this.log.isTraceEnabled()) {
                    BemisMurcko.this.log.trace((Object)("processNewLeaf() node: " + node));
                }
                Molecule[] bmf = BemisMurcko.this.fw.reduce(rawmol);
                String[] smi = new String[bmf.length];
                if (BemisMurcko.this.log.isTraceEnabled()) {
                    BemisMurcko.this.log.trace((Object)("Original:\n" + rawmol.toFormat("sdf")));
                    for (i = 0; i < bmf.length; ++i) {
                        BemisMurcko.this.log.trace((Object)("BMF " + i + ":\n" + bmf[i].toFormat("sdf")));
                    }
                }
                for (i = 0; i < bmf.length; ++i) {
                    smi[i] = bmf[i].toFormat("smiles:u");
                    if (smi[i] != null) continue;
                    smi[i] = "";
                }
                if (BemisMurcko.this.log.isTraceEnabled()) {
                    BemisMurcko.this.log.trace((Object)("..Murcko smiles series: " + U.sel(smi)));
                }
                EntityGroup g = null;
                for (int i2 = smi.length - 1; i2 >= 0; --i2) {
                    SimplePQValue gq = new SimplePQValue(BemisMurcko.this.crSmiles.getPropertyDescriptor());
                    gq.setStringValue(smi[i2]);
                    if (g == null) {
                        g = this.hc.getGroup(i2 + 1, (PQValue)gq);
                        if (g != null) continue;
                        if (BemisMurcko.this.log.isTraceEnabled()) {
                            BemisMurcko.this.log.trace((Object)"..Alloc new top level groupgroup");
                        }
                        g = BemisMurcko.this.addGroup(i2 + 1, "murckogroup", bmf[i2], smi[i2], null, null);
                        continue;
                    }
                    EntityGroup gn = this.hc.getGroup(g.getHierarchic(), (PQValue)gq);
                    if (gn == null) {
                        gn = BemisMurcko.this.addGroup(i2 + 1, "murckogroup", bmf[i2], smi[i2], null, null);
                        g.getHierarchic().AddSubtree(gn);
                        if (BemisMurcko.this.isFirstParentIDStored()) {
                            BemisMurcko.this.firstParent.setPropertyInt(gn.properties(), g.getIndex());
                        }
                    }
                    g = gn;
                }
                g.add(node);
                if (BemisMurcko.this.isLeavesFirstParentIDStored()) {
                    BemisMurcko.this.setFirstParentAssociation(node, g);
                }
                if (BemisMurcko.this.log.isTraceEnabled()) {
                    BemisMurcko.this.log.trace((Object)"..finished.");
                }
            }
        };
        this.getHC().addRMDecorator(ccb);
    }

    @Override
    public String getShortName() {
        return "BM";
    }

    @Override
    public String getLongName() {
        return "Bemis and Murcko framework based clustering";
    }

    @Override
    public String getClusteringSummary() {
        return "Single level BM clustering using default framework reduction";
    }

    @Override
    public OALevelSelect getPreferredLevel() {
        return this.prefl;
    }

    public static class SimpleBMFrameworkReduction
    implements FrameworkReduction {
        protected Molecule bmf;
        private BondClassifier bc = new BondClassifier();

        protected void generalize(boolean keepAtomTypes, boolean keepBondTypes) {
            int i;
            this.bmf.hydrogenize(false);
            for (i = 0; i < this.bmf.getAtomCount(); ++i) {
                MolAtom ma = this.bmf.getAtom(i);
                ma.setCharge(0);
                ma.setFlags(0);
                ma.clearQProps();
                ma.clearExtraLabel();
                ma.clear();
                if (keepAtomTypes) continue;
                ma.setAtno(6);
            }
            for (i = 0; i < this.bmf.getBondCount(); ++i) {
                MolBond mb = this.bmf.getBond(i);
                mb.setFlags(0, -16);
                if (keepBondTypes) continue;
                mb.setType(1);
            }
        }

        private void reduceGraph() {
            boolean found = true;
            while (found) {
                found = false;
                for (int i = 0; !found && i < this.bmf.getAtomCount(); ++i) {
                    MolAtom a2;
                    MolAtom a1;
                    MolAtom ai = this.bmf.getAtom(i);
                    if (ai.getBondCount() != 2 || (a1 = ai.getLigand(0)).getBondTo(a2 = ai.getLigand(1)) != null) continue;
                    this.bmf.add(new MolBond(a1, a2));
                    this.bmf.removeBond(ai.getBond(0));
                    this.bmf.removeBond(ai.getBond(1));
                    this.bmf.removeAtom(ai);
                    found = true;
                }
            }
        }

        private void removeSideChains(boolean keepStub) {
            this.bc.classify(this.bmf);
            boolean found = true;
            while (found) {
                found = false;
                for (int i = 0; !found && i < this.bmf.getAtomCount(); ++i) {
                    int j;
                    if (this.bmf.getAtom(i).getBondCount() == 1) {
                        if (keepStub) {
                            MolAtom n = this.bmf.getAtom(i).getLigand(0);
                            if (n.getBondCount() != 1) continue;
                            this.bmf.removeAtom(i);
                            found = true;
                            continue;
                        }
                        this.bmf.removeAtom(i);
                        found = true;
                        continue;
                    }
                    if (!keepStub) continue;
                    int nmn = 0;
                    MolAtom ai = this.bmf.getAtom(i);
                    MolAtom[] ligands = ai.getLigands();
                    for (j = 0; j < ligands.length; ++j) {
                        if (ligands[j].getBondCount() <= 1) continue;
                        ligands[j] = null;
                        if (++nmn > 1) break;
                    }
                    if (nmn > true) continue;
                    for (j = 0; j < ligands.length; ++j) {
                        if (ligands[j] == null) continue;
                        this.bmf.removeAtom(ligands[j]);
                        found = true;
                    }
                }
            }
        }

        private void removeSmallFragments() {
            Molecule[] frags = this.bmf.convertToFrags();
            if (frags.length > 0) {
                this.bmf = frags[0];
                int bmfs = this.bmf.getAtomCount() + this.bmf.getImplicitHcount();
                for (int i = 1; i < frags.length; ++i) {
                    int fs = frags[i].getAtomCount() + frags[i].getImplicitHcount();
                    if (fs <= bmfs) continue;
                    this.bmf = frags[i];
                    bmfs = fs;
                }
            }
        }

        @Override
        public int getLevelCount() {
            return 3;
        }

        @Override
        public Molecule[] reduce(Molecule input) {
            Molecule[] ret = new Molecule[3];
            this.bmf = input.cloneMolecule();
            this.bmf.clearProperties();
            this.removeSmallFragments();
            this.generalize(true, true);
            this.removeSideChains(false);
            if (this.bmf.getAtomCount() == 1) {
                this.bmf.getAtom(0).setAtno(6);
            }
            ret[0] = this.bmf.cloneMolecule();
            this.generalize(false, false);
            ret[1] = this.bmf.cloneMolecule();
            this.reduceGraph();
            ret[2] = this.bmf;
            return ret;
        }
    }

    public static class CalculatorFrameworkReduction
    implements FrameworkReduction {
        CalculatorPlugin calc;

        public CalculatorFrameworkReduction(CalculatorPlugin calc) {
            this.calc = calc;
        }

        @Override
        public Molecule[] reduce(Molecule input) {
            Molecule m = input.cloneMolecule();
            this.calc.standardize(m);
            try {
                this.calc.setMolecule(m);
                this.calc.run();
                return new Molecule[]{this.calc.getResultMolecule()};
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int getLevelCount() {
            return 1;
        }
    }

    public static interface FrameworkReduction {
        public Molecule[] reduce(Molecule var1);

        public int getLevelCount();
    }
}

