/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.EPropValue;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.Events;
import chemaxon.clustering.backend.FlatProperties;
import chemaxon.clustering.backend.PropertyHandler;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.StoreProperties;
import chemaxon.clustering.scaffolding.logging.NoLevelLog;
import chemaxon.clustering.util.RAIterator;
import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DefaultEntityStore
implements EntityStore<Entity>,
Events.ChangeCountListener {
    private int size = 0;
    private int initialSize = 0;
    private StoreProperties prop = null;
    private int sscc = 0;
    private int scc = 0;
    private int cc = 0;
    private Events.DefaultStoreEventHandler dseh = null;
    int[] intArryay = null;
    int intArrayModulo = 0;
    double[] doubleArray = null;
    int doubleArrayModulo = 0;
    BitSet bitSet = null;
    int bitSetModulo = 0;
    Object[] objectArry = null;
    int objectArrayModulo = 0;
    int generalObjectPropertyCount = 0;
    Vector accessoryArray = null;
    IntVector propertyDescriptors = null;
    Map<PropertyTypes, IntVector> propIndex = null;

    @Override
    public Events.StoreEventHandler getStoreEventHandler() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StoreProperties properties() {
        if (this.prop == null) {
            this.prop = new PropertyHandler.DefaultEntityStorePropertyHandler(this);
        }
        return this.prop;
    }

    @Override
    public RAIterator<Entity> iterator() {
        return DefaultEntityStore.RAIterator(this);
    }

    public static RAIterator<Entity> RAIterator(final EntityStore s) {
        return new RAIterator<Entity>(){
            int ccexp;
            int i;
            {
                this.ccexp = s.getCC();
                this.i = 0;
            }

            void checkCC() {
                if (s.getCC() != this.ccexp) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.checkCC();
                return this.i < s.size();
            }

            @Override
            public Entity next() {
                this.checkCC();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return s.getEntity(this.i++);
            }

            @Override
            public void remove() {
                this.checkCC();
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int size() {
                this.checkCC();
                return s.size();
            }

            @Override
            public Entity get(int i) {
                this.checkCC();
                return s.getEntity(i);
            }

            @Override
            public void reset() {
                this.checkCC();
                this.i = 0;
            }

            @Override
            public int getCC() {
                return s.getCC();
            }

            @Override
            public int indexOf(Entity e) {
                this.checkCC();
                return e.getIndex();
            }

            @Override
            public boolean isGetSupported() {
                return true;
            }
        };
    }

    @Override
    public int getSSCC() {
        return this.sscc;
    }

    @Override
    public int getSCC() {
        return this.scc;
    }

    @Override
    public int getCC() {
        return this.cc;
    }

    @Override
    public void storeStructureChanged() {
        ++this.cc;
        ++this.scc;
        ++this.sscc;
        if (this.dseh != null) {
            this.dseh.storeStructureChanged();
        }
    }

    @Override
    public void storeChanged() {
        ++this.cc;
        ++this.scc;
        if (this.dseh != null) {
            this.dseh.storeChanged();
        }
    }

    @Override
    public void changed() {
        ++this.cc;
        if (this.dseh != null) {
            this.dseh.changed();
        }
    }

    public DefaultEntityStore(int initialSize, int initialIntPropCount, int initialBitSetPropCount, int initialBitSetPropBitCount, int initialDoublePropCount, int initialObjectPropertyCount) {
        if (initialSize < 0 || initialBitSetPropBitCount < 0 || initialDoublePropCount < 0 || initialIntPropCount < 0 || initialObjectPropertyCount < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.size = 0;
        this.initialSize = initialSize;
        this.propIndex = new EnumMap<PropertyTypes, IntVector>(PropertyTypes.class);
        for (PropertyTypes pt : PropertyTypes.values()) {
            this.propIndex.put(pt, new IntVector(5));
        }
        int pdic = (initialIntPropCount + initialBitSetPropCount + initialDoublePropCount + initialObjectPropertyCount) * 3;
        this.propertyDescriptors = new IntVector(pdic);
        this.intArrayModulo = initialIntPropCount;
        this.doubleArrayModulo = initialDoublePropCount;
        this.bitSetModulo = initialBitSetPropBitCount;
        this.objectArrayModulo = initialObjectPropertyCount;
        this.accessoryArray = new Vector(10);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clearEntities() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.storeChanged();
    }

    public Entity addEntity() {
        if (this.size == this.initialSize) {
            throw new IndexOutOfBoundsException();
        }
        ++this.size;
        this.storeChanged();
        return this.getEntity(this.size - 1);
    }

    @Override
    public Entity getEntity(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new LightWeightEntityImpl(index);
    }

    @Override
    public int indexOf(Entity e) {
        return ((LightWeightEntityImpl)e).id;
    }

    @Override
    public int getPropertyIndex(String propName) {
        for (PropertyTypes pt : PropertyTypes.values()) {
            for (int i = 0; i < this.getPropertyCount(pt); ++i) {
                String pn = this.getPropertyName(pt, i);
                if (!pn.equals(propName)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int[] getPropertyIndex(String[] propName) {
        int[] ret = new int[propName.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getPropertyIndex(propName[i]);
        }
        return ret;
    }

    @Override
    public PropertyTypes getPropertyType(String propName) {
        for (PropertyTypes pt : PropertyTypes.values()) {
            for (int i = 0; i < this.getPropertyCount(pt); ++i) {
                String pn = this.getPropertyName(pt, i);
                if (!pn.equals(propName)) continue;
                return pt;
            }
        }
        return null;
    }

    private int getPropertyCount(PropertyTypes type) {
        return this.propIndex.get((Object)type).size();
    }

    private String[] getPropertyNames(PropertyTypes type) {
        IntVector iv = this.propIndex.get((Object)type);
        String[] ret = new String[iv.size()];
        for (int i = 0; i < iv.size(); ++i) {
            int base = iv.get(i);
            ret[i] = (String)this.accessoryArray.get(this.propertyDescriptors.get(base + PROPDESCITEMS.NAMEINDEX.id()));
        }
        return ret;
    }

    private String getPropertyName(PropertyTypes type, int pi) {
        IntVector iv = this.propIndex.get((Object)type);
        if (pi < 0 || pi >= iv.size()) {
            throw new IndexOutOfBoundsException();
        }
        int base = iv.get(pi);
        return (String)this.accessoryArray.get(this.propertyDescriptors.get(base + PROPDESCITEMS.NAMEINDEX.id()));
    }

    @Override
    public String getIntPropertyName(int iPropIndex) {
        return this.getPropertyName(PropertyTypes.INTPROP, iPropIndex);
    }

    @Override
    public String[] getIntPropertyNames() {
        return this.getPropertyNames(PropertyTypes.INTPROP);
    }

    @Override
    public String getDoublePropertyName(int dPropIndex) {
        return this.getPropertyName(PropertyTypes.DOUBLEPROP, dPropIndex);
    }

    @Override
    public String[] getDoublePropertyNames() {
        return this.getPropertyNames(PropertyTypes.DOUBLEPROP);
    }

    @Override
    public String getStringPropertyName(int sPropIndex) {
        return this.getPropertyName(PropertyTypes.STRINGPROP, sPropIndex);
    }

    @Override
    public String[] getStringPropertyNames() {
        return this.getPropertyNames(PropertyTypes.STRINGPROP);
    }

    @Override
    public String getObjectPropertyName(int oPropIndex) {
        return this.getPropertyName(PropertyTypes.OBJECTPROP, oPropIndex);
    }

    @Override
    public String[] getObjectPropertyNames() {
        return this.getPropertyNames(PropertyTypes.OBJECTPROP);
    }

    @Override
    public String getBitSetPropertyName(int bPropIndex) {
        return this.getPropertyName(PropertyTypes.BITSETPROP, bPropIndex);
    }

    @Override
    public String[] getBitSetPropertyNames() {
        return this.getPropertyNames(PropertyTypes.BITSETPROP);
    }

    @Override
    public int[] getBitSetPropertyBitCounts() {
        int[] ret = new int[this.getBitSetPropertyCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getBitSetPropertyBitCount(i);
        }
        return ret;
    }

    @Override
    public int getIntPropertyCount() {
        return this.getPropertyCount(PropertyTypes.INTPROP);
    }

    @Override
    public int getDoublePropertyCount() {
        return this.getPropertyCount(PropertyTypes.DOUBLEPROP);
    }

    @Override
    public int getStringPropertyCount() {
        return this.getPropertyCount(PropertyTypes.STRINGPROP);
    }

    @Override
    public int getObjectPropertyCount() {
        return this.getPropertyCount(PropertyTypes.OBJECTPROP);
    }

    @Override
    public int getBitSetPropertyCount() {
        return this.getPropertyCount(PropertyTypes.BITSETPROP);
    }

    private void checkPropNames(String[] propNames) {
        if (propNames.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int pn = 0; pn < propNames.length; ++pn) {
            String n = propNames[pn];
            if (this.getPropertyIndex(n) == -1) continue;
            throw new UnsupportedOperationException("Property name already present " + n);
        }
    }

    @Override
    public int[] addIntProperties(String[] propNames) {
        this.storeStructureChanged();
        this.checkPropNames(propNames);
        if (this.intArryay == null) {
            if (this.intArrayModulo < propNames.length) {
                this.intArrayModulo = propNames.length;
            }
            this.intArryay = new int[this.initialSize * this.intArrayModulo];
        }
        int[] ret = new int[propNames.length];
        for (int pn = 0; pn < propNames.length; ++pn) {
            String n = propNames[pn];
            int base = this.propertyDescriptors.size();
            IntVector piv = this.propIndex.get((Object)PropertyTypes.INTPROP);
            int propct = piv.size();
            ret[pn] = piv.size();
            piv.add(base);
            for (int i = 0; i < PROPDESCITEMS.valueCount(); ++i) {
                this.propertyDescriptors.add(-1);
            }
            this.propertyDescriptors.set(base + PROPDESCITEMS.NAMEINDEX.id(), this.accessoryArray.size());
            this.accessoryArray.add(n);
            if (propct < this.intArrayModulo) {
                this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.BIGARRAY.id());
                this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), propct);
                continue;
            }
            int[] newaa = new int[this.initialSize];
            this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.ACCESSORYARRAY.id());
            this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), this.accessoryArray.size());
            this.accessoryArray.add(newaa);
        }
        return ret;
    }

    @Override
    public int[] addDoubleProperties(String[] propNames) {
        this.storeStructureChanged();
        this.checkPropNames(propNames);
        if (this.doubleArray == null) {
            if (this.doubleArrayModulo < propNames.length) {
                this.doubleArrayModulo = propNames.length;
            }
            this.doubleArray = new double[this.initialSize * this.doubleArrayModulo];
        }
        int[] ret = new int[propNames.length];
        for (int pn = 0; pn < propNames.length; ++pn) {
            String n = propNames[pn];
            int base = this.propertyDescriptors.size();
            IntVector piv = this.propIndex.get((Object)PropertyTypes.DOUBLEPROP);
            int propct = piv.size();
            ret[pn] = piv.size();
            piv.add(base);
            for (int i = 0; i < PROPDESCITEMS.valueCount(); ++i) {
                this.propertyDescriptors.add(-1);
            }
            this.propertyDescriptors.set(base + PROPDESCITEMS.NAMEINDEX.id(), this.accessoryArray.size());
            this.accessoryArray.add(n);
            if (propct < this.doubleArrayModulo) {
                this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.BIGARRAY.id());
                this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), propct);
                continue;
            }
            double[] newaa = new double[this.initialSize];
            this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.ACCESSORYARRAY.id());
            this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), this.accessoryArray.size());
            this.accessoryArray.add(newaa);
        }
        return ret;
    }

    private int getPropDescBase(PropertyTypes ptype, int pindex) {
        if (pindex < 0) {
            throw new IndexOutOfBoundsException("Property index out of range: " + pindex + " type: " + (Object)((Object)ptype));
        }
        if (pindex >= this.getPropertyCount(ptype)) {
            throw new IndexOutOfBoundsException("Property index out of range: " + pindex + " type: " + (Object)((Object)ptype));
        }
        return this.propIndex.get((Object)ptype).get(pindex);
    }

    @Override
    public int getBitSetPropertyBitCount(int bPropIndex) {
        int base = this.getPropDescBase(PropertyTypes.BITSETPROP, bPropIndex);
        return this.propertyDescriptors.get(base + PROPDESCITEMS.BITSETBITCOUNT.id());
    }

    private int getPropStorageOffset(PropertyTypes ptype, int propIndex) {
        int base = this.getPropDescBase(ptype, propIndex);
        return this.propertyDescriptors.get(base + PROPDESCITEMS.OFFSET.id());
    }

    private PROPSTORAGELOC getPropStorageLoc(PropertyTypes ptype, int propIndex) {
        int base = this.getPropDescBase(ptype, propIndex);
        return PROPSTORAGELOC.valueOf(this.propertyDescriptors.get(base + PROPDESCITEMS.LOCATION.id()));
    }

    private int getFirstMainBitIndex(int bitCount) {
        int retc = 0;
        boolean retcm = true;
        block0: while (retcm) {
            retcm = false;
            for (int i = 0; i < this.getBitSetPropertyCount(); ++i) {
                if (this.getPropStorageLoc(PropertyTypes.BITSETPROP, i) != PROPSTORAGELOC.BIGARRAY) continue;
                int of = this.getPropStorageOffset(PropertyTypes.BITSETPROP, i);
                int bc = this.getBitSetPropertyBitCount(i);
                if (retc < of && retc + bitCount > of) {
                    retc = of + bc;
                    retcm = true;
                    continue block0;
                }
                if (retc < of || retc >= of + bc) continue;
                retc = of + bc;
                retcm = true;
                continue block0;
            }
        }
        if (this.bitSetModulo >= retc + bitCount) {
            return retc;
        }
        return -1;
    }

    @Override
    public int[] addBitSetProperties(String[] propNames, int[] bitCounts) {
        this.storeStructureChanged();
        this.checkPropNames(propNames);
        if (this.bitSet == null) {
            if (this.bitSetModulo < U.sum(bitCounts)) {
                this.bitSetModulo = U.sum(bitCounts);
            }
            this.bitSet = new BitSet(this.initialSize * this.bitSetModulo);
        }
        int[] ret = new int[propNames.length];
        IntVector piv = this.propIndex.get((Object)PropertyTypes.BITSETPROP);
        for (int pn = 0; pn < propNames.length; ++pn) {
            String n = propNames[pn];
            int base = this.propertyDescriptors.size();
            int ofs = this.getFirstMainBitIndex(bitCounts[pn]);
            ret[pn] = piv.size();
            piv.add(base);
            for (int i = 0; i < PROPDESCITEMS.valueCount(); ++i) {
                this.propertyDescriptors.add(-1);
            }
            this.propertyDescriptors.set(base + PROPDESCITEMS.NAMEINDEX.id(), this.accessoryArray.size());
            this.propertyDescriptors.set(base + PROPDESCITEMS.BITSETBITCOUNT.id(), bitCounts[pn]);
            this.accessoryArray.add(n);
            if (ofs >= 0) {
                this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.BIGARRAY.id());
                this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), ofs);
                continue;
            }
            BitSet newbs = new BitSet(bitCounts[pn] * this.initialSize);
            this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.ACCESSORYARRAY.id());
            this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), this.accessoryArray.size());
            this.accessoryArray.add(newbs);
        }
        return ret;
    }

    private int[] addGeneralalObjectProperties(PropertyTypes propType, String[] propNames) {
        this.storeStructureChanged();
        this.checkPropNames(propNames);
        if (this.objectArry == null) {
            if (this.objectArrayModulo < propNames.length) {
                this.objectArrayModulo = propNames.length;
            }
            this.objectArry = new Object[this.initialSize * this.objectArrayModulo];
        }
        int[] ret = new int[propNames.length];
        for (int pn = 0; pn < propNames.length; ++pn) {
            String n = propNames[pn];
            int base = this.propertyDescriptors.size();
            IntVector piv = this.propIndex.get((Object)propType);
            ret[pn] = piv.size();
            piv.add(base);
            for (int i = 0; i < PROPDESCITEMS.valueCount(); ++i) {
                this.propertyDescriptors.add(-1);
            }
            this.propertyDescriptors.set(base + PROPDESCITEMS.NAMEINDEX.id(), this.accessoryArray.size());
            this.accessoryArray.add(n);
            if (this.generalObjectPropertyCount < this.objectArrayModulo) {
                this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.BIGARRAY.id());
                this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), this.generalObjectPropertyCount);
            } else {
                Object[] newaa = new Object[this.initialSize];
                this.propertyDescriptors.set(base + PROPDESCITEMS.LOCATION.id(), PROPSTORAGELOC.ACCESSORYARRAY.id());
                this.propertyDescriptors.set(base + PROPDESCITEMS.OFFSET.id(), this.accessoryArray.size());
                this.accessoryArray.add(newaa);
            }
            ++this.generalObjectPropertyCount;
        }
        return ret;
    }

    @Override
    public int[] addStringProperties(String[] propNames) {
        this.storeStructureChanged();
        return this.addGeneralalObjectProperties(PropertyTypes.STRINGPROP, propNames);
    }

    @Override
    public int[] addObjectProperties(String[] propNames) {
        this.storeStructureChanged();
        return this.addGeneralalObjectProperties(PropertyTypes.OBJECTPROP, propNames);
    }

    public static void printDetails(EntityStore es, NoLevelLog log) {
        if (!log.isEnabled()) {
            return;
        }
        StringBuffer b = new StringBuffer(1000);
        DefaultEntityStore.printDetails(es, b);
        log.log(b.toString());
    }

    public static void printDetails(EntityStore es, StringBuffer b) {
        b.append("Store data:\n");
        for (int i = -1; i < es.size(); ++i) {
            int j;
            boolean head = i == -1;
            b.append(head ? "#" : i + "");
            Entity e = head ? null : es.getEntity(i);
            for (j = 0; j < es.getStringPropertyCount(); ++j) {
                b.append("\t");
                b.append(head ? es.getStringPropertyName(j) : e.flatProperties().getStringProperty(j));
            }
            for (j = 0; j < es.getIntPropertyCount(); ++j) {
                b.append("\t");
                b.append(head ? es.getIntPropertyName(j) : Integer.valueOf(e.flatProperties().getIntProperty(j)));
            }
            for (j = 0; j < es.getDoublePropertyCount(); ++j) {
                b.append("\t");
                b.append(head ? es.getDoublePropertyName(j) : Double.valueOf(e.flatProperties().getDoubleProperty(j)));
            }
            for (j = 0; j < es.getBitSetPropertyCount(); ++j) {
                b.append("\t");
                b.append(head ? es.getBitSetPropertyName(j) + "(" + es.getBitSetPropertyBitCount(j) + "bits)" : e.flatProperties().getStringProperty(j));
            }
            for (j = 0; j < es.getObjectPropertyCount(); ++j) {
                b.append("\t");
                b.append(head ? es.getObjectPropertyName(j) : e.flatProperties().getObjectProperty(j) + "");
            }
            b.append("\n");
        }
    }

    public static void printSummary(EntityStore es, NoLevelLog log) {
        if (!log.isEnabled()) {
            return;
        }
        StringBuffer b = new StringBuffer(100);
        DefaultEntityStore.printSummary(es, b);
        log.log(b);
    }

    public static void printSummary(EntityStore es, StringBuffer sb) {
        int i;
        sb.append("size: " + es.size() + "\n");
        sb.append("int properties (" + es.getIntPropertyCount() + "):");
        for (i = 0; i < es.getIntPropertyCount(); ++i) {
            sb.append(" " + es.getIntPropertyName(i));
        }
        sb.append("\n");
        sb.append("double properties (" + es.getDoublePropertyCount() + "):");
        for (i = 0; i < es.getDoublePropertyCount(); ++i) {
            sb.append(" " + es.getDoublePropertyName(i));
        }
        sb.append("\n");
        sb.append("String properties (" + es.getStringPropertyCount() + "):");
        for (i = 0; i < es.getStringPropertyCount(); ++i) {
            sb.append(" " + es.getStringPropertyName(i));
        }
        sb.append("\n");
        sb.append("BitSet properties (" + es.getBitSetPropertyCount() + "):");
        for (i = 0; i < es.getBitSetPropertyCount(); ++i) {
            sb.append(" " + es.getBitSetPropertyName(i) + " (" + es.getBitSetPropertyBitCount(i) + " bits)");
        }
        sb.append("\n");
        sb.append("Object properties (" + es.getObjectPropertyCount() + "):");
        for (i = 0; i < es.getObjectPropertyCount(); ++i) {
            sb.append(" " + es.getObjectPropertyName(i));
        }
        sb.append("\n");
        sb.append("\n");
    }

    public static void toString(EntityStore s, StringBuffer sb, String prefix, int level) {
        sb.append(prefix);
        sb.append("Store:\n");
        sb.append(prefix);
        sb.append("size:           " + s.size() + "\n");
        Vector<EPropDesc> props = s.properties().getProperties();
        sb.append(prefix);
        sb.append("property count: " + props.size() + "\n");
        if (level > 0) {
            sb.append(prefix);
            sb.append("Properties:\n");
            for (EPropDesc d : props) {
                sb.append(prefix);
                sb.append("  ");
                sb.append(d.toString());
                sb.append("\n");
            }
        }
        if (level > 1 && s.size() > 0) {
            sb.append(prefix);
            sb.append("Entities:\n");
            RAIterator i = s.iterator();
            while (i.hasNext()) {
                sb.append(prefix);
                sb.append("  ");
                sb.append(i.next().toString());
                sb.append("\n");
            }
        }
    }

    public void dumpContents(StringBuffer sb) {
        int i;
        sb.append("propIndex map\n");
        for (PropertyTypes pt : PropertyTypes.values()) {
            IntVector iv = this.propIndex.get((Object)pt);
            sb.append("  " + pt.toString() + " (siz=" + iv.size() + "): " + iv.toString() + "\n");
        }
        sb.append("propertyDescriptors array:\n");
        sb.append("#");
        for (i = 0; i < PROPDESCITEMS.valueCount(); ++i) {
            sb.append("\t" + PROPDESCITEMS.lookupID(i).toString());
        }
        sb.append("\n");
        i = 0;
        while (i < this.propertyDescriptors.size()) {
            sb.append(i);
            for (int j = 0; j < PROPDESCITEMS.valueCount() && i < this.propertyDescriptors.size(); ++j) {
                sb.append("\t");
                int pdv = this.propertyDescriptors.get(i++);
                sb.append(pdv);
                PROPDESCITEMS pdi = PROPDESCITEMS.lookupID(j);
                if (pdi == PROPDESCITEMS.NAMEINDEX) {
                    sb.append(" (->" + this.accessoryArray.get(pdv) + ")");
                    continue;
                }
                if (pdi != PROPDESCITEMS.LOCATION) continue;
                sb.append(" (" + (Object)((Object)PROPSTORAGELOC.valueOf(pdv)) + ")");
            }
            sb.append("\n");
        }
        sb.append("accessoryArray\n");
        sb.append("  #\ttype\tvalue\n");
        for (i = 0; i < this.accessoryArray.size(); ++i) {
            Object o = this.accessoryArray.get(i);
            String types = o.getClass().getSimpleName();
            sb.append("  " + i + "\t" + types + "\t" + o.toString() + "\n");
        }
    }

    public static String entityToString(Entity e) {
        EntityStore s = e.getStore();
        StringBuffer b = new StringBuffer();
        b.append("#" + e.getStore().indexOf(e));
        for (EPropValue i : e.properties()) {
            b.append(" " + i.getName() + ": " + i.getValue() + " (" + (Object)((Object)i.getType()) + ")");
        }
        return b.toString();
    }

    private class LightWeightEntityImpl
    implements Entity,
    FlatProperties {
        private int id = -1;
        private EntityProperties prop = null;

        private LightWeightEntityImpl(int id) {
            this.id = id;
        }

        @Override
        public EntityStore getStore() {
            return DefaultEntityStore.this;
        }

        @Override
        public int getIntProperty(int iPropIndex) {
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.INTPROP, iPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.INTPROP, iPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return DefaultEntityStore.this.intArryay[this.id * DefaultEntityStore.this.intArrayModulo + ofs];
            }
            int[] aa = (int[])DefaultEntityStore.this.accessoryArray.get(ofs);
            return aa[this.id];
        }

        @Override
        public void setIntProperty(int iPropIndex, int iPropValue) {
            DefaultEntityStore.this.changed();
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.INTPROP, iPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.INTPROP, iPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                DefaultEntityStore.this.intArryay[this.id * DefaultEntityStore.this.intArrayModulo + ofs] = iPropValue;
            } else {
                int[] aa = (int[])DefaultEntityStore.this.accessoryArray.get(ofs);
                aa[this.id] = iPropValue;
            }
        }

        @Override
        public double getDoubleProperty(int dPropIndex) {
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.DOUBLEPROP, dPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.DOUBLEPROP, dPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return DefaultEntityStore.this.doubleArray[this.id * DefaultEntityStore.this.doubleArrayModulo + ofs];
            }
            double[] aa = (double[])DefaultEntityStore.this.accessoryArray.get(ofs);
            return aa[this.id];
        }

        @Override
        public void setDoubleProperty(int dPropIndex, double dPropValue) {
            DefaultEntityStore.this.changed();
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.DOUBLEPROP, dPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.DOUBLEPROP, dPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                DefaultEntityStore.this.doubleArray[this.id * DefaultEntityStore.this.doubleArrayModulo + ofs] = dPropValue;
            } else {
                double[] aa = (double[])DefaultEntityStore.this.accessoryArray.get(ofs);
                aa[this.id] = dPropValue;
            }
        }

        @Override
        public String getStringProperty(int sPropIndex) {
            if (sPropIndex < 0) {
                throw new IndexOutOfBoundsException("String property index " + sPropIndex);
            }
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.STRINGPROP, sPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.STRINGPROP, sPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return (String)DefaultEntityStore.this.objectArry[this.id * DefaultEntityStore.this.objectArrayModulo + ofs];
            }
            Object[] aa = (Object[])DefaultEntityStore.this.accessoryArray.get(ofs);
            return (String)aa[this.id];
        }

        @Override
        public void setStringProperty(int sPropIndex, String sPropValue) {
            DefaultEntityStore.this.changed();
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.STRINGPROP, sPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.STRINGPROP, sPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                DefaultEntityStore.this.objectArry[this.id * DefaultEntityStore.this.objectArrayModulo + ofs] = sPropValue;
            } else {
                Object[] aa = (Object[])DefaultEntityStore.this.accessoryArray.get(ofs);
                aa[this.id] = sPropValue;
            }
        }

        @Override
        public void appendStringProperty(int sPropIndex, StringBuffer sb) {
            sb.append(this.getStringProperty(sPropIndex));
        }

        @Override
        public BitSet getBitSetProperty(int bPropIndex) {
            int bc = DefaultEntityStore.this.getBitSetPropertyBitCount(bPropIndex);
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.BITSETPROP, bPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.BITSETPROP, bPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return DefaultEntityStore.this.bitSet.get(this.id * DefaultEntityStore.this.bitSetModulo + ofs, this.id * DefaultEntityStore.this.bitSetModulo + ofs + bc);
            }
            BitSet bs = (BitSet)DefaultEntityStore.this.accessoryArray.get(ofs);
            return bs.get(bc * this.id, bc * this.id + bc);
        }

        @Override
        public boolean isBitSet(int bPropIndex, int bitIndex) {
            int bc = DefaultEntityStore.this.getBitSetPropertyBitCount(bPropIndex);
            if (bitIndex >= bc) {
                return false;
            }
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.BITSETPROP, bPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.BITSETPROP, bPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return DefaultEntityStore.this.bitSet.get(this.id * DefaultEntityStore.this.bitSetModulo + ofs + bitIndex);
            }
            BitSet bs = (BitSet)DefaultEntityStore.this.accessoryArray.get(ofs);
            return bs.get(this.id * bc + bitIndex);
        }

        @Override
        public void setBitSetProperty(int bPropIndex, BitSet b) {
            DefaultEntityStore.this.changed();
            int bc = DefaultEntityStore.this.getBitSetPropertyBitCount(bPropIndex);
            if (b.length() > bc) {
                throw new IndexOutOfBoundsException();
            }
            BitSet bs = null;
            int from = 0;
            int to = 0;
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.BITSETPROP, bPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.BITSETPROP, bPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                bs = DefaultEntityStore.this.bitSet;
                from = this.id * DefaultEntityStore.this.bitSetModulo + ofs;
                to = this.id * DefaultEntityStore.this.bitSetModulo + ofs + bc;
            } else {
                bs = (BitSet)DefaultEntityStore.this.accessoryArray.get(ofs);
                from = this.id * bc;
                to = this.id * bc + bc;
            }
            bs.clear(from, to);
            int i = b.nextSetBit(0);
            while (i < bc && i >= 0) {
                bs.set(from + i);
                i = b.nextSetBit(i + 1);
            }
        }

        @Override
        public void getBitSetProperty(int bPropIndex, BitSet b) {
            int bc = DefaultEntityStore.this.getBitSetPropertyBitCount(bPropIndex);
            if (b.length() > bc) {
                throw new IndexOutOfBoundsException();
            }
            BitSet bs = null;
            int from = 0;
            int to = 0;
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.BITSETPROP, bPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.BITSETPROP, bPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                bs = DefaultEntityStore.this.bitSet;
                from = this.id * DefaultEntityStore.this.bitSetModulo + ofs;
                to = this.id * DefaultEntityStore.this.bitSetModulo + ofs + bc;
            } else {
                bs = (BitSet)DefaultEntityStore.this.accessoryArray.get(ofs);
                from = this.id * bc;
                to = this.id * bc + bc;
            }
            b.clear(from, to);
            int i = bs.nextSetBit(from);
            while (i < to && i >= 0) {
                b.set(i - from);
                i = bs.nextSetBit(i + 1);
            }
        }

        @Override
        public Object getObjectProperty(int oPropIndex) {
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.OBJECTPROP, oPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.OBJECTPROP, oPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                return DefaultEntityStore.this.objectArry[this.id * DefaultEntityStore.this.objectArrayModulo + ofs];
            }
            Object[] aa = (Object[])DefaultEntityStore.this.accessoryArray.get(ofs);
            return aa[this.id];
        }

        @Override
        public void setObjectProperty(int oPropIndex, Object o) {
            DefaultEntityStore.this.changed();
            int ofs = DefaultEntityStore.this.getPropStorageOffset(PropertyTypes.OBJECTPROP, oPropIndex);
            if (DefaultEntityStore.this.getPropStorageLoc(PropertyTypes.OBJECTPROP, oPropIndex) == PROPSTORAGELOC.BIGARRAY) {
                DefaultEntityStore.this.objectArry[this.id * DefaultEntityStore.this.objectArrayModulo + ofs] = o;
            } else {
                Object[] aa = (Object[])DefaultEntityStore.this.accessoryArray.get(ofs);
                aa[this.id] = o;
            }
        }

        @Override
        public void releaseEntity() {
            this.id = -1;
        }

        @Override
        public EntityProperties properties() {
            return new PropertyHandler.DefaultEntityPropertyHandler(this);
        }

        @Override
        public FlatProperties flatProperties() {
            return this;
        }

        @Override
        public int getIndex() {
            return this.id;
        }
    }

    static enum PROPDESCITEMS {
        LOCATION(0),
        OFFSET(1),
        NAMEINDEX(2),
        BITSETBITCOUNT(3);

        private final int ID;

        private PROPDESCITEMS(int id) {
            this.ID = id;
        }

        public int id() {
            return this.ID;
        }

        public static int valueCount() {
            return PROPDESCITEMS.values().length;
        }

        public static PROPDESCITEMS lookupID(int id) {
            for (PROPDESCITEMS pdi : PROPDESCITEMS.values()) {
                if (pdi.id() != id) continue;
                return pdi;
            }
            return null;
        }
    }

    static enum PROPSTORAGELOC {
        BIGARRAY(0),
        ACCESSORYARRAY(1);

        private final int ID;

        private PROPSTORAGELOC(int id) {
            this.ID = id;
        }

        public int id() {
            return this.ID;
        }

        public static PROPSTORAGELOC valueOf(int i) {
            switch (i) {
                case 0: {
                    return BIGARRAY;
                }
                case 1: {
                    return ACCESSORYARRAY;
                }
            }
            throw new IndexOutOfBoundsException("Invalud id: " + i);
        }
    }
}

