/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.EPropValue;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.MRTree;
import chemaxon.clustering.backend.PQValue;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.StoreIO;
import chemaxon.clustering.backend.StoreProperties;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.IteratorWithException;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.scaffolding.logging.VLog;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.Filter;
import chemaxon.clustering.util.IntStat;
import chemaxon.clustering.util.RAIterator;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HC {
    Log log = LogFactory.getLog(HC.class);
    private final boolean storeLeaves;
    private int levelCount;
    private final MRTree tree;
    private TreeNodeEntityGroup[] levels;
    private static final String LEVELNAMEPREFIX = "HC.LEVELGROUP.";
    boolean added = false;
    Vector<Callback> decorators;
    Vector<dectype> dectypes;
    int importedCount = 0;
    private final ComparableDescriptor desc;
    boolean allImportFinishedCalled = false;

    public HC(boolean storeLeaves, int levelCount) {
        this(storeLeaves, levelCount, null);
    }

    public HC(boolean storeLeaves, int levelCount, ComparableDescriptor desc) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct. storeLeaves=" + storeLeaves + " levelCount=" + levelCount + " desc: " + desc.toString()));
        }
        if (levelCount < 2) {
            throw new IndexOutOfBoundsException("Invalid level count " + levelCount);
        }
        this.storeLeaves = storeLeaves;
        this.levelCount = levelCount;
        this.tree = new MRTree(false, false, storeLeaves);
        this.decorators = new Vector();
        this.dectypes = new Vector();
        this.desc = desc;
        this.levels = new TreeNodeEntityGroup[levelCount];
        this.levels[0] = null;
        for (int i = 1; i < this.levelCount; ++i) {
            String n = LEVELNAMEPREFIX + i;
            this.levels[i] = (TreeNodeEntityGroup)this.tree.getGroup(n);
            if (this.levels[i] != null) continue;
            this.levels[i] = (TreeNodeEntityGroup)this.tree.select(MRTree.SELECT_EMPTY_TREENODE, true, n);
        }
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public int addLevel() {
        ++this.levelCount;
        TreeNodeEntityGroup[] newLevels = new TreeNodeEntityGroup[this.levelCount];
        System.arraycopy(this.levels, 0, newLevels, 0, this.levels.length);
        newLevels[this.levelCount - 1] = (TreeNodeEntityGroup)this.tree.select(MRTree.SELECT_EMPTY_TREENODE, true, LEVELNAMEPREFIX + (this.levelCount - 1));
        this.levels = newLevels;
        return this.levelCount - 1;
    }

    public StoreProperties getLeavesProperties() {
        if (!this.storeLeaves) {
            return null;
        }
        return this.tree.getLeavesProperties();
    }

    public StoreProperties getGroupsProperties() {
        return this.tree.getGroupsProperties();
    }

    public void setBatchSize(int bs) {
        this.tree.setBatchSize(bs);
    }

    public MRTree getTree() {
        return this.tree;
    }

    public void notifyAllImportFinished() {
        for (int i = 0; i < this.decorators.size(); ++i) {
            this.decorators.get(i).allImportFinished(this.allImportFinishedCalled);
        }
        this.allImportFinishedCalled = true;
    }

    public int importMolecules(IteratorWithException<Molecule, IOException> input, VLog vlog) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("importMolecules() from " + input.toString()));
        }
        DefaultVerboseCallbackImpl verbosecb = null;
        if (vlog != null && vlog.isVerboseEnabled()) {
            verbosecb = new DefaultVerboseCallbackImpl(vlog);
        }
        DefaultPreprocessorDispatcher pproc = new DefaultPreprocessorDispatcher();
        int sc = this.tree.importStructures(input, false, pproc, verbosecb);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Import finished, imported " + sc));
        }
        if (vlog != null && vlog.isVerboseEnabled()) {
            vlog.verbose("Imported " + sc + " structures");
        }
        this.importedCount += sc;
        return sc;
    }

    public void addRSDecorator(Callback<String> d) {
        this.addDecorator(d, dectype.rsmiles);
    }

    public void addRMDecorator(Callback<Molecule> d) {
        this.addDecorator(d, dectype.rmolecule);
    }

    public void addFirstRMDecorator(Callback<Molecule> d) {
        this.addDecorator(d, dectype.rmolecule, true);
    }

    public void addRDDecorator(Callback<CDescriptor> d) {
        this.addDecorator(d, dectype.rdescriptor);
    }

    public void addDecorator(Callback d) {
        this.addDecorator(d, dectype.unspecified);
    }

    void addDecorator(Callback d, dectype dt) {
        this.addDecorator(d, dt, false);
    }

    void addDecorator(Callback d, dectype dt, boolean first) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Add decorator callback: " + d + " type: " + (Object)((Object)dt) + " first: " + first));
        }
        if (d == null) {
            return;
        }
        if (this.added) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Decorator added after modification: " + d.toString()));
            }
            throw new UnsupportedOperationException();
        }
        d.setHC(this);
        if (first) {
            this.decorators.add(0, d);
            this.dectypes.add(0, dt);
        } else {
            this.decorators.add(d);
            this.dectypes.add(dt);
        }
    }

    public boolean isStoringLeaves() {
        return this.storeLeaves;
    }

    public int getLeavesCount() {
        if (!this.isStoringLeaves()) {
            return 0;
        }
        return this.getTree().getLeavesCount();
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public TreeNodeEntityGroup getLevelGroup(int level) {
        return this.levels[level];
    }

    public EntityGroup getGroup(int level, PQValue q) {
        TreeNodeEntityGroup lg = this.getLevelGroup(level);
        for (int i = 0; i < lg.getSubtreeCount(); ++i) {
            EntityGroup gi = lg.getSubtree(i);
            if (!q.match(gi.properties().getProperty(q))) continue;
            return gi;
        }
        return null;
    }

    public EntityGroup getGroup(HierarchicEntityGroup lg, PQValue q) {
        for (int i = 0; i < lg.getSubtreeCount(); ++i) {
            EntityGroup gi = lg.getSubtree(i);
            if (!q.match(gi.properties().getProperty(q))) continue;
            return gi;
        }
        return null;
    }

    public RAIterator<EntityGroup> getGroups(int level, Comparator<EntityGroup> comp) {
        return this.getGroups(level, comp, null);
    }

    public RAIterator<EntityGroup> getGroups(int level, Comparator<EntityGroup> comp, Filter<EntityGroup> filt) {
        TreeNodeEntityGroup lg = this.getLevelGroup(level);
        return lg.iterateSubtrees(comp, filt);
    }

    public EntityGroup addGroup(int level, String name) {
        if (level < 1) {
            throw new IndexOutOfBoundsException();
        }
        EntityGroup g = level == 1 ? (this.storeLeaves ? this.tree.select(MRTree.SELECT_EMPTY_ARBITRARY, true, name) : this.tree.select(MRTree.SELECT_EMPTY_PHANTOM, true, name)) : this.tree.select(MRTree.SELECT_EMPTY_TREENODE, true, name);
        this.levels[level].AddSubtree(g);
        return g;
    }

    public int indexOf(EntityGroup g) {
        return -1;
    }

    public static class StoreAdditionalRawmol
    extends Decorator<Molecule, Molecule> {
        public StoreAdditionalRawmol(String propname) {
            super(propname, PropertyTypes.OBJECTPROP, 0);
        }

        @Override
        public void processNewLeaf(Entity node, Entity rawnode, Molecule rawmol) {
            this.setPropertyObject(node, rawmol);
        }

        public Molecule getRawMolecule(Entity node) {
            return (Molecule)this.getPropertyObject(node);
        }
    }

    public static class StoreAdditionalDescriptor
    extends Decorator<CDescriptor, CDescriptor>
    implements RetrieveDescriptor {
        public StoreAdditionalDescriptor(String propname) {
            super(propname, PropertyTypes.OBJECTPROP, 0);
        }

        @Override
        public void processNewLeaf(Entity node, Entity rawnode, CDescriptor rawmol) {
            this.setPropertyObject(node, rawmol);
        }

        @Override
        public CDescriptor getDescriptor(Entity node) {
            return (CDescriptor)this.getPropertyObject(node);
        }

        @Override
        public CDescriptor getDescriptor(EntityProperties node) {
            return (CDescriptor)this.getPropertyObject(node);
        }
    }

    public static interface RetrieveDescriptor
    extends RetrievePropertyObject<CDescriptor> {
        public CDescriptor getDescriptor(Entity var1);

        public CDescriptor getDescriptor(EntityProperties var1);
    }

    public static interface RetrievePropertyInt {
        public int getPropertyInt(Entity var1);

        public int getPropertyInt(EntityProperties var1);
    }

    public static interface RetrievePropertyString {
        public String getPropertyString(Entity var1);

        public String getPropertyString(EntityProperties var1);
    }

    public static interface RetrievePropertyObject<T> {
        public T getPropertyObject(Entity var1);

        public T getPropertyObject(EntityProperties var1);
    }

    public static class StoreAdditionalMolS
    extends Decorator<Molecule, Object> {
        Log log = LogFactory.getLog(StoreAdditionalMolS.class);
        String format;

        public StoreAdditionalMolS(String propname, String format2) {
            super(propname, PropertyTypes.STRINGPROP, 0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Constructed. Propname: " + propname + " format: " + format2));
            }
            this.format = format2;
        }

        @Override
        public void processNewLeaf(Entity node, Entity rawnode, Molecule rawmol) {
            String s = rawmol.toFormat(this.format);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Process node " + s));
            }
            this.setPropertyString(node, s);
        }

        public String getStructure(Entity node) {
            return this.getPropertyString(node);
        }
    }

    public static abstract class Decorator<R, T>
    extends Callback<R>
    implements RetrievePropertyObject<T>,
    RetrievePropertyString,
    RetrievePropertyInt {
        StoreProperties sp = null;
        EPropDesc prop = null;
        final String name;
        final PropertyTypes type;

        public EPropDesc getPropertyDescriptor() {
            return this.prop;
        }

        public Decorator(String name, PropertyTypes type, int hierarchyPosition) {
            super(hierarchyPosition);
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "Additonal property level: " + this.hierarchyPosition + " name: " + this.name + " type: " + this.type.toString();
        }

        @Override
        public void setHC(HC hc) {
            super.setHC(hc);
            if (this.getHierarchyPosition() == 0) {
                this.sp = hc.getLeavesProperties();
            } else if (this.getHierarchyPosition() > 0) {
                this.sp = hc.getGroupsProperties();
            } else {
                throw new UnsupportedOperationException();
            }
            this.prop = this.sp.getOrAddProperty(this.type, this.name, 0);
        }

        public EPropValue getPropValue(Entity node) {
            return node.properties().getProperty(this.prop);
        }

        public void setPropertyString(EntityProperties eprop, String value) {
            eprop.getProperty(this.prop).setStringValue(value);
        }

        @Override
        public String getPropertyString(EntityProperties eprop) {
            return eprop.getProperty(this.prop).getStringValue();
        }

        public void setPropertyInt(EntityProperties eprop, int value) {
            eprop.getProperty(this.prop).setIntValue(value);
        }

        @Override
        public int getPropertyInt(EntityProperties eprop) {
            return eprop.getProperty(this.prop).getIntValue();
        }

        public void setPropertyObject(EntityProperties eprop, T value) {
            eprop.getProperty(this.prop).setValue(value);
        }

        @Override
        public T getPropertyObject(EntityProperties eprop) {
            return (T)eprop.getProperty(this.prop).getValue();
        }

        public void setPropertyString(Entity node, String value) {
            if (this.type != PropertyTypes.STRINGPROP) {
                throw new UnsupportedOperationException();
            }
            node.flatProperties().setStringProperty(this.prop.getPropertyIndex(), value);
        }

        @Override
        public String getPropertyString(Entity node) {
            if (this.type != PropertyTypes.STRINGPROP) {
                throw new UnsupportedOperationException();
            }
            return node.flatProperties().getStringProperty(this.prop.getPropertyIndex());
        }

        public void setPropertyInt(Entity node, int value) {
            if (this.type != PropertyTypes.INTPROP) {
                throw new UnsupportedOperationException();
            }
            node.flatProperties().setIntProperty(this.prop.getPropertyIndex(), value);
        }

        @Override
        public int getPropertyInt(Entity node) {
            if (this.type != PropertyTypes.INTPROP) {
                throw new UnsupportedOperationException();
            }
            return node.flatProperties().getIntProperty(this.prop.getPropertyIndex());
        }

        @Override
        public T getPropertyObject(Entity node) {
            if (this.type != PropertyTypes.OBJECTPROP) {
                throw new UnsupportedOperationException();
            }
            return (T)node.flatProperties().getObjectProperty(this.prop.getPropertyIndex());
        }

        public void setPropertyObject(Entity node, T value) {
            if (this.type != PropertyTypes.OBJECTPROP) {
                throw new UnsupportedOperationException();
            }
            node.flatProperties().setObjectProperty(this.prop.getPropertyIndex(), value);
        }
    }

    public static abstract class Callback<R> {
        final int hierarchyPosition;
        HC hc = null;
        R lastr = null;

        public Callback(int hierarchyPosition) {
            this.hierarchyPosition = hierarchyPosition;
        }

        public int getHierarchyPosition() {
            return this.hierarchyPosition;
        }

        void setHC(HC hc) {
            if (this.hc != null) {
                throw new UnsupportedOperationException();
            }
            this.hc = hc;
        }

        public void processNewLeaf(Entity node, Entity rawnode, R rawmol) {
            if (this.getHierarchyPosition() != 0) {
                throw new UnsupportedOperationException();
            }
            this.lastr = rawmol;
        }

        public void processNewGroup(EntityGroup g) {
            if (this.getHierarchyPosition() == 0) {
                throw new UnsupportedOperationException();
            }
        }

        public R getLastRaw() {
            if (this.getHierarchyPosition() != 0) {
                throw new UnsupportedOperationException();
            }
            return this.lastr;
        }

        public void allImportFinished(boolean cleanupRequired) {
        }
    }

    class DefaultVerboseCallbackImpl
    implements StoreIO.AddMoleculeNode {
        long startTime;
        long lastTime;
        VLog vlog;

        public DefaultVerboseCallbackImpl(VLog vlog) {
            this.lastTime = this.startTime = System.currentTimeMillis();
            this.vlog = vlog;
        }

        @Override
        public void addNode(Molecule m, StoreIO io) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void importFinished(StoreIO io) {
            int i;
            if (this.vlog == null || !this.vlog.isVerboseEnabled()) {
                return;
            }
            long time = System.currentTimeMillis();
            StringBuffer b = new StringBuffer();
            b.append("Leaves: ");
            b.append(HC.this.tree.getLeavesCount());
            for (i = 1; i < HC.this.levels.length; ++i) {
                b.append(" Level ");
                b.append(i);
                b.append(": ");
                b.append(HC.this.levels[i].getSubtreeCount());
                b.append(" / ");
                b.append(HC.this.levels[i].size());
                b.append(" ");
            }
            b.append(TextUtils.formatTimeSMMM(time - this.startTime));
            b.append(" s / ");
            b.append(TextUtils.formatTimeSMMM(time - this.lastTime));
            b.append(" s");
            this.vlog.verbose(b.toString());
            if (this.vlog.isVVerboseEnabled()) {
                for (i = 1; i < HC.this.levels.length; ++i) {
                    IntStat is = HC.this.levels[i].getSubtreeSizeStat(true);
                    this.vlog.vverbose("Cluster size statistics at level " + i + ":");
                    this.vlog.vverbose(is.toString());
                }
            }
            this.lastTime = time;
        }
    }

    class DefaultPreprocessorDispatcher
    implements MRTree.Preprocessor<Molecule> {
        Log log = LogFactory.getLog(DefaultPreprocessorDispatcher.class);

        DefaultPreprocessorDispatcher() {
        }

        @Override
        public void processNewNode(MRTree tree, Entity node, Entity rawnode, Molecule raw) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("processNewNode() node: " + node + " rawmol size: " + raw.getAtomCount()));
            }
            CDescriptor cd = null;
            String rsmi = null;
            boolean cdcalc = false;
            for (int i = 0; i < HC.this.decorators.size(); ++i) {
                Callback ci = HC.this.decorators.get(i);
                if (ci.getHierarchyPosition() != 0) continue;
                dectype dti = HC.this.dectypes.get(i);
                if (dti == dectype.rmolecule) {
                    Callback rci = ci;
                    rci.processNewLeaf(node, rawnode, raw);
                    continue;
                }
                if (dti == dectype.rdescriptor) {
                    if (HC.this.desc != null && !cdcalc) {
                        cdcalc = true;
                        cd = HC.this.desc.constructDescriptor(raw);
                    }
                    Callback dci = ci;
                    dci.processNewLeaf(node, rawnode, cd);
                    continue;
                }
                if (dti == dectype.rsmiles) {
                    if (rsmi == null) {
                        rsmi = raw.toFormat("smiles:u");
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Create smiles: " + rsmi));
                        }
                        if (rsmi.length() == 0 && raw.getAtomCount() != 0) {
                            if (this.log.isErrorEnabled()) {
                                try {
                                    this.log.error((Object)("Empty uniqe smiles for " + raw.toFormat("smiles")));
                                }
                                catch (Exception e) {
                                    this.log.error((Object)"Error printing errorneus smiles", (Throwable)e);
                                }
                            }
                            rsmi = raw.toFormat("smiles:u+H");
                        }
                    }
                    Callback sci = ci;
                    sci.processNewLeaf(node, rawnode, rsmi);
                    continue;
                }
                ci.processNewLeaf(node, rawnode, null);
            }
        }
    }

    static enum dectype {
        unspecified,
        rmolecule,
        rdescriptor,
        rsmiles;

    }
}

