/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.boundary.LDescriptor;
import chemaxon.clustering.boundary.LinearDescriptor;
import chemaxon.clustering.util.RandomAccess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KMeans
extends ClustorImpl {
    Log log = LogFactory.getLog(KMeans.class);
    int k;
    HC.RetrieveDescriptor rdesc;
    HC.StoreAdditionalMolS mols;
    ComparableDescriptor desc;
    LinearDescriptor ldesc;

    public KMeans(ChemFormatFactory ff, final int k) {
        super(ff, 2);
        this.k = k;
        ff.setLeavesRequired();
        ff.setStoreDescriptors();
        ff.setStoreIntermediate();
        this.setStoreClusterMeanDescriptor();
        this.setStoreClusterRepresentantIntermediate();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct. ff: " + ff.toString() + " k: " + k));
        }
        this.k = k;
        this.desc = ff.getDescriptor();
        this.rdesc = ff.getRetrieveLeaveDescriptor();
        this.ldesc = this.desc.getFactory().getLinearDescriptor();
        HC.Callback ccb = new HC.Callback(0){

            @Override
            public void allImportFinished(boolean cleanupRequired) {
                super.allImportFinished(cleanupRequired);
                if (KMeans.this.log.isDebugEnabled()) {
                    KMeans.this.log.debug((Object)"Start k-means clustering");
                }
                if (cleanupRequired) {
                    if (KMeans.this.log.isErrorEnabled()) {
                        KMeans.this.log.error((Object)"Unexpected recall of clustering process");
                    }
                    throw new UnsupportedOperationException();
                }
                int cc = Math.min(this.hc.getLeavesCount(), k);
                if (KMeans.this.log.isTraceEnabled()) {
                    KMeans.this.log.trace((Object)("Allocate " + cc + " clusters"));
                }
                EntityGroup[] clus = new EntityGroup[cc];
                for (int i = 0; i < cc; ++i) {
                    clus[i] = KMeans.this.getHC().addGroup(1, "kmeansgroup");
                }
                int n = 0;
                for (int i = 0; i < cc; ++i) {
                    Entity e = this.hc.getTree().getLeaf(n++);
                    clus[i].add(e);
                    KMeans.this.cmDesc.setPropertyObject(clus[i].properties(), KMeans.this.ldesc.linearize(KMeans.this.rdesc.getDescriptor(e)));
                }
                while (n < this.hc.getLeavesCount()) {
                    Entity e = this.hc.getTree().getLeaf(n);
                    CDescriptor d = KMeans.this.rdesc.getDescriptor(e);
                    clus[KMeans.this.nearestCluster(d, clus)].add(e);
                    ++n;
                }
                if (KMeans.this.log.isTraceEnabled()) {
                    KMeans.this.log.trace((Object)"Initial assignment done");
                }
                int modct = 1;
                while (modct != 0) {
                    int i;
                    modct = 0;
                    LinearDescriptor.MeanResult[] mr = new LinearDescriptor.MeanResult[cc];
                    for (i = 0; i < cc; ++i) {
                        mr[i] = KMeans.this.ldesc.calcMean(new DescR(clus[i], KMeans.this.rdesc));
                        KMeans.this.cmDesc.setPropertyObject(clus[i].properties(), mr[i].getMean());
                    }
                    for (i = 0; i < cc; ++i) {
                        for (int j = clus[i].size() - 1; j >= 0; --j) {
                            Entity e = (Entity)clus[i].get(j);
                            CDescriptor d = KMeans.this.rdesc.getDescriptor(e);
                            int nc = KMeans.this.nearestCluster(d, clus);
                            if (nc == i) continue;
                            ++modct;
                            clus[i].remove(e);
                            clus[nc].add(e);
                        }
                    }
                    if (KMeans.this.log.isTraceEnabled()) {
                        KMeans.this.log.trace((Object)("Modification count: " + modct));
                    }
                    if (modct != 0) continue;
                    for (i = 0; i < cc; ++i) {
                        CDescriptor d = mr[i].getMeanRepresentant();
                        String smi = null;
                        if (KMeans.this.mols != null) {
                            int cridx = mr[i].getMeanRepresentantIndex();
                            smi = KMeans.this.mols.getStructure((Entity)clus[i].get(cridx));
                        }
                        KMeans.this.updateRepresentant(clus[i], null, smi, d, mr[i].getMean());
                    }
                }
                if (KMeans.this.log.isTraceEnabled()) {
                    KMeans.this.log.trace((Object)"Clustering done");
                }
            }
        };
        this.getHC().addDecorator(ccb);
    }

    int nearestCluster(CDescriptor d, EntityGroup[] g) {
        int dmin = 0;
        double dmind = 0.0;
        for (int i = 0; i < g.length; ++i) {
            LDescriptor gd = (LDescriptor)this.cmDesc.getPropertyObject(g[i].properties());
            double dd = this.ldesc.calcDistance(d, gd);
            if (i != 0 && !(dd < dmind)) continue;
            dmin = i;
            dmind = dd;
        }
        return dmin;
    }

    @Override
    public String getShortName() {
        return "KMEANS";
    }

    @Override
    public String getLongName() {
        return "K-Means clustering";
    }

    @Override
    public String getClusteringSummary() {
        return "K-Means clustering. Structures are grouped into " + this.k + " clusters.";
    }

    static class DescR
    implements RandomAccess<CDescriptor> {
        EntityGroup g;
        HC.RetrieveDescriptor r;

        DescR(EntityGroup g, HC.RetrieveDescriptor r) {
            this.g = g;
            this.r = r;
        }

        @Override
        public int size() {
            return this.g.size();
        }

        @Override
        public CDescriptor get(int i) {
            return this.r.getDescriptor((Entity)this.g.get(i));
        }

        @Override
        public int indexOf(CDescriptor e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCC() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGetSupported() {
            return true;
        }
    }
}

