/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.BitSetPropertyGroup;
import chemaxon.clustering.backend.DoublePropertyGroup;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.Events;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.IntPropertyGroup;
import chemaxon.clustering.backend.ObjectPropertyGroup;
import chemaxon.clustering.util.RAIterator;
import java.util.ConcurrentModificationException;

public class PhantomEntityGroup
implements EntityGroup {
    int size = 0;
    int cc = 0;
    EntityProperties props = null;
    Events.DefaultGroupEventHandler geh = null;
    boolean released = false;

    public PhantomEntityGroup(EntityProperties props) {
        this.props = props;
    }

    @Override
    public int getIndex() {
        return this.props.indexOfEntity();
    }

    @Override
    public void add(Entity e) {
        if (this.released) {
            throw new UnsupportedOperationException();
        }
        ++this.size;
        ++this.cc;
        if (this.geh != null) {
            this.geh.entityAddedOrRemoved((EntityGroup)this, e, true);
        }
    }

    @Override
    public boolean remove(Entity e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Entity e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Events.GroupEventHandler getEventHandler() {
        if (this.released) {
            throw new UnsupportedOperationException();
        }
        if (this.geh == null) {
            this.geh = new Events.DefaultGroupEventHandler(this);
        }
        return this.geh;
    }

    @Override
    public void releaseEntityGroup() {
        if (this.released) {
            throw new UnsupportedOperationException();
        }
        if (this.geh != null) {
            this.geh.entityGroupReleased(this);
            this.geh.releaseHandler();
        }
        this.released = true;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    @Override
    public IntPropertyGroup getIntPropertyGroup(int iPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DoublePropertyGroup getDoublePropertyGroup(int dPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSetPropertyGroup getBitSetPropertyGroup(int bPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ObjectPropertyGroup getObjectPropertyGroup(int oPropIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EntityProperties properties() {
        return this.props;
    }

    @Override
    public boolean isGetSupported() {
        return false;
    }

    @Override
    public RAIterator<Entity> iterator() {
        final int ccold = this.getCC();
        return new RAIterator<Entity>(){

            void check() {
                if (this.getCC() != ccold) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void reset() {
                this.check();
            }

            @Override
            public boolean hasNext() {
                this.check();
                return this.size() > 0;
            }

            @Override
            public Entity next() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                this.check();
                return PhantomEntityGroup.this.size;
            }

            @Override
            public Entity get(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOf(Entity e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getCC() {
                this.check();
                return PhantomEntityGroup.this.cc;
            }

            @Override
            public boolean isGetSupported() {
                return false;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entity get(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Entity e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCC() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "Phantom group size: " + this.size + " released: " + this.released;
    }

    @Override
    public boolean isHierarchic() {
        return false;
    }

    @Override
    public HierarchicEntityGroup getHierarchic() {
        return null;
    }
}

