/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.EPropValue;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.StoreProperties;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyHandler {

    public static class DefaultEntityPropertyValue
    implements EPropValue {
        Entity e;
        PropertyTypes t;
        int pi;

        public DefaultEntityPropertyValue(Entity e, PropertyTypes t, int propindex) {
            this.e = e;
            this.t = t;
            this.pi = propindex;
            if (this.pi < 0) {
                throw new IndexOutOfBoundsException("Property index " + propindex);
            }
        }

        @Override
        public Object getValue() {
            switch (this.t) {
                case BITSETPROP: {
                    return this.e.flatProperties().getBitSetProperty(this.pi);
                }
                case DOUBLEPROP: {
                    return new Double(this.e.flatProperties().getDoubleProperty(this.pi));
                }
                case INTPROP: {
                    return new Integer(this.e.flatProperties().getIntProperty(this.pi));
                }
                case OBJECTPROP: {
                    return this.e.flatProperties().getObjectProperty(this.pi);
                }
                case STRINGPROP: {
                    return this.e.flatProperties().getStringProperty(this.pi);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object value) {
            switch (this.t) {
                case BITSETPROP: {
                    this.e.flatProperties().setBitSetProperty(this.pi, (BitSet)value);
                    break;
                }
                case DOUBLEPROP: {
                    this.e.flatProperties().setDoubleProperty(this.pi, (Double)value);
                    break;
                }
                case INTPROP: {
                    this.e.flatProperties().setIntProperty(this.pi, (Integer)value);
                    break;
                }
                case OBJECTPROP: {
                    this.e.flatProperties().setObjectProperty(this.pi, value);
                    break;
                }
                case STRINGPROP: {
                    this.e.flatProperties().setStringProperty(this.pi, (String)value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        public int getIntValue() {
            if (this.t != PropertyTypes.INTPROP) {
                throw new UnsupportedOperationException();
            }
            return this.e.flatProperties().getIntProperty(this.pi);
        }

        @Override
        public void setIntValue(int v) {
            if (this.t != PropertyTypes.INTPROP) {
                throw new UnsupportedOperationException();
            }
            this.e.flatProperties().setIntProperty(this.pi, v);
        }

        @Override
        public double getDoubleValue() {
            if (this.t != PropertyTypes.DOUBLEPROP) {
                throw new UnsupportedOperationException();
            }
            return this.e.flatProperties().getDoubleProperty(this.pi);
        }

        @Override
        public void setDoubleValue(double d) {
            if (this.t != PropertyTypes.DOUBLEPROP) {
                throw new UnsupportedOperationException();
            }
            this.e.flatProperties().setDoubleProperty(this.pi, d);
        }

        @Override
        public String getStringValue() {
            if (this.t != PropertyTypes.STRINGPROP) {
                throw new UnsupportedOperationException();
            }
            return this.e.flatProperties().getStringProperty(this.pi);
        }

        @Override
        public void setStringValue(String s) {
            if (this.t != PropertyTypes.STRINGPROP) {
                throw new UnsupportedOperationException();
            }
            this.e.flatProperties().setStringProperty(this.pi, s);
        }

        @Override
        public BitSet getBitSetValue() {
            if (this.t != PropertyTypes.BITSETPROP) {
                throw new UnsupportedOperationException();
            }
            return this.e.flatProperties().getBitSetProperty(this.pi);
        }

        @Override
        public void getBitSetValue(BitSet b) {
            if (this.t != PropertyTypes.BITSETPROP) {
                throw new UnsupportedOperationException();
            }
            this.e.flatProperties().getBitSetProperty(this.pi, b);
        }

        @Override
        public boolean isBitSet(int bindex) {
            if (this.t != PropertyTypes.BITSETPROP) {
                throw new UnsupportedOperationException();
            }
            return this.e.flatProperties().isBitSet(this.pi, bindex);
        }

        @Override
        public void setBitSetValue(BitSet b) {
            if (this.t != PropertyTypes.BITSETPROP) {
                throw new UnsupportedOperationException();
            }
            this.e.flatProperties().setBitSetProperty(this.pi, b);
        }

        @Override
        public int getBitSetBitCount() {
            if (this.t != PropertyTypes.BITSETPROP) {
                return -1;
            }
            return this.e.getStore().getBitSetPropertyBitCount(this.pi);
        }

        @Override
        public PropertyTypes getType() {
            return this.t;
        }

        @Override
        public String getName() {
            switch (this.t) {
                case BITSETPROP: {
                    return this.e.getStore().getBitSetPropertyName(this.pi);
                }
                case DOUBLEPROP: {
                    return this.e.getStore().getDoublePropertyName(this.pi);
                }
                case INTPROP: {
                    return this.e.getStore().getIntPropertyName(this.pi);
                }
                case OBJECTPROP: {
                    return this.e.getStore().getObjectPropertyName(this.pi);
                }
                case STRINGPROP: {
                    return this.e.getStore().getStringPropertyName(this.pi);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int getPropertyIndex() {
            return this.pi;
        }
    }

    public static class DefaultEntityPropertyDescriptor
    implements EPropDesc {
        EntityStore s;
        PropertyTypes t;
        int pi;

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DefaultEntityPropertyDescriptor objc = (DefaultEntityPropertyDescriptor)obj;
            return this.s == objc.s && this.t == objc.t && this.pi == objc.pi;
        }

        public int hashCode() {
            int hash = this.pi;
            hash = hash * 17 + this.t.ordinal();
            hash = hash * 13 + this.s.hashCode();
            return hash ^= this.s.hashCode();
        }

        public DefaultEntityPropertyDescriptor(EntityStore s, PropertyTypes t, int propindex) {
            if (s == null) {
                throw new UnsupportedOperationException();
            }
            if (t == null) {
                throw new UnsupportedOperationException();
            }
            if (propindex < 0) {
                throw new UnsupportedOperationException("propindex=" + propindex);
            }
            this.s = s;
            this.t = t;
            this.pi = propindex;
        }

        @Override
        public PropertyTypes getType() {
            return this.t;
        }

        @Override
        public String getName() {
            switch (this.t) {
                case BITSETPROP: {
                    return this.s.getBitSetPropertyName(this.pi);
                }
                case DOUBLEPROP: {
                    return this.s.getDoublePropertyName(this.pi);
                }
                case INTPROP: {
                    return this.s.getIntPropertyName(this.pi);
                }
                case OBJECTPROP: {
                    return this.s.getObjectPropertyName(this.pi);
                }
                case STRINGPROP: {
                    return this.s.getStringPropertyName(this.pi);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBitSetBitCount() {
            if (this.t != PropertyTypes.BITSETPROP) {
                return -1;
            }
            return this.s.getBitSetPropertyBitCount(this.pi);
        }

        @Override
        public int getPropertyIndex() {
            return this.pi;
        }

        public String toString() {
            return this.getName() + " [" + (Object)((Object)this.getType()) + "@" + this.getPropertyIndex() + "," + this.getBitSetBitCount() + "b;HASH=" + this.hashCode() + "]";
        }
    }

    public static class DefaultEntityPropertyHandler
    implements EntityProperties {
        private final Entity e;

        public DefaultEntityPropertyHandler(Entity e) {
            this.e = e;
        }

        @Override
        public EPropValue getProperty(EPropDesc prop) {
            return new DefaultEntityPropertyValue(this.e, prop.getType(), prop.getPropertyIndex());
        }

        @Override
        public EPropValue getProperty(String propname) {
            PropertyTypes t = this.e.getStore().getPropertyType(propname);
            int idx = this.e.getStore().getPropertyIndex(propname);
            return new DefaultEntityPropertyValue(this.e, t, idx);
        }

        @Override
        public EPropValue getProperty(PropertyTypes type, int propindex) {
            return new DefaultEntityPropertyValue(this.e, type, propindex);
        }

        @Override
        public Iterator<EPropValue> iterator() {
            return new Iterator<EPropValue>(){
                int cc;
                Iterator<EPropDesc> it;
                {
                    this.cc = DefaultEntityPropertyHandler.this.e.getStore().getCC();
                    this.it = DefaultEntityPropertyHandler.this.e.getStore().properties().iterator();
                }

                private void checkCC() {
                    if (DefaultEntityPropertyHandler.this.e.getStore().getCC() != this.cc) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkCC();
                    return this.it.hasNext();
                }

                @Override
                public EPropValue next() {
                    this.checkCC();
                    return DefaultEntityPropertyHandler.this.e.properties().getProperty(this.it.next());
                }

                @Override
                public void remove() {
                    this.checkCC();
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }

        @Override
        public StoreProperties getMetaProperties() {
            return this.e.getStore().properties();
        }

        @Override
        public int indexOfEntity() {
            return this.e.getIndex();
        }
    }

    public static class DefaultEntityStorePropertyHandler
    implements StoreProperties {
        Log log = LogFactory.getLog(StoreProperties.class);
        EntityStore s;

        public DefaultEntityStorePropertyHandler(EntityStore s) {
            this.s = s;
        }

        @Override
        public EPropDesc[] addProperties(PropertyTypes type, String[] names, int[] bitct) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("addProperties: " + (Object)((Object)type) + " " + U.sel(names) + " " + U.sel(bitct)));
            }
            int[] idx = null;
            switch (type) {
                case BITSETPROP: {
                    idx = this.s.addBitSetProperties(names, bitct);
                    break;
                }
                case DOUBLEPROP: {
                    idx = this.s.addDoubleProperties(names);
                    break;
                }
                case INTPROP: {
                    idx = this.s.addIntProperties(names);
                    break;
                }
                case OBJECTPROP: {
                    idx = this.s.addObjectProperties(names);
                    break;
                }
                case STRINGPROP: {
                    idx = this.s.addStringProperties(names);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            EPropDesc[] ret = new EPropDesc[idx.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new DefaultEntityPropertyDescriptor(this.s, type, idx[i]);
            }
            return ret;
        }

        @Override
        public EPropDesc addProperty(PropertyTypes type, String name, int bsbits) {
            return this.addProperties(type, new String[]{name}, new int[]{bsbits})[0];
        }

        @Override
        public EPropDesc getProperty(String name) {
            PropertyTypes t = this.s.getPropertyType(name);
            int pi = this.s.getPropertyIndex(name);
            if (t == null) {
                return null;
            }
            return new DefaultEntityPropertyDescriptor(this.s, t, pi);
        }

        @Override
        public Vector<EPropDesc> getProperties() {
            return this.getProperties(null);
        }

        @Override
        public Vector<EPropDesc> getProperties(PropertyTypes type) {
            DefaultEntityPropertyDescriptor d;
            int i;
            Vector<EPropDesc> ret = new Vector<EPropDesc>();
            if (type == PropertyTypes.BITSETPROP || type == null) {
                for (i = 0; i < this.s.getBitSetPropertyCount(); ++i) {
                    d = new DefaultEntityPropertyDescriptor(this.s, PropertyTypes.BITSETPROP, i);
                    ret.add(d);
                }
            }
            if (type == PropertyTypes.DOUBLEPROP || type == null) {
                for (i = 0; i < this.s.getDoublePropertyCount(); ++i) {
                    d = new DefaultEntityPropertyDescriptor(this.s, PropertyTypes.DOUBLEPROP, i);
                    ret.add(d);
                }
            }
            if (type == PropertyTypes.INTPROP || type == null) {
                for (i = 0; i < this.s.getIntPropertyCount(); ++i) {
                    d = new DefaultEntityPropertyDescriptor(this.s, PropertyTypes.INTPROP, i);
                    ret.add(d);
                }
            }
            if (type == PropertyTypes.OBJECTPROP || type == null) {
                for (i = 0; i < this.s.getObjectPropertyCount(); ++i) {
                    d = new DefaultEntityPropertyDescriptor(this.s, PropertyTypes.OBJECTPROP, i);
                    ret.add(d);
                }
            }
            if (type == PropertyTypes.STRINGPROP || type == null) {
                for (i = 0; i < this.s.getStringPropertyCount(); ++i) {
                    d = new DefaultEntityPropertyDescriptor(this.s, PropertyTypes.STRINGPROP, i);
                    ret.add(d);
                }
            }
            return ret;
        }

        @Override
        public Iterator<EPropDesc> iterator(final PropertyTypes type) {
            return new Iterator<EPropDesc>(){
                int cc;
                PropertyTypes ct;
                int ci;
                EPropDesc npd;
                {
                    this.cc = DefaultEntityStorePropertyHandler.this.s.getSSCC();
                    this.ct = type;
                    this.ci = 0;
                    this.npd = null;
                }

                private void checkCC() {
                    if (this.cc != DefaultEntityStorePropertyHandler.this.s.getSSCC()) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public boolean hasNext() {
                    block4: {
                        this.checkCC();
                        if (this.npd == null) {
                            if (this.ct == null) {
                                this.ct = PropertyTypes.values()[0];
                                this.ci = 0;
                            }
                            while (this.ci >= DefaultEntityStorePropertyHandler.this.getPropertyCount(this.ct)) {
                                if (this.ct.ordinal() < PropertyTypes.values().length - 1 && type == null) {
                                    this.ct = PropertyTypes.values()[this.ct.ordinal() + 1];
                                    this.ci = 0;
                                    continue;
                                }
                                break block4;
                            }
                            this.npd = DefaultEntityStorePropertyHandler.this.getProperty(this.ct, this.ci);
                            ++this.ci;
                        }
                    }
                    return this.npd != null;
                }

                @Override
                public EPropDesc next() {
                    this.checkCC();
                    if (!this.hasNext()) {
                        return null;
                    }
                    EPropDesc ret = this.npd;
                    this.npd = null;
                    return ret;
                }

                @Override
                public void remove() {
                    this.checkCC();
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }

        @Override
        public Iterator<EPropDesc> iterator() {
            return this.iterator(null);
        }

        @Override
        public int getPropertyCount(PropertyTypes type) {
            switch (type) {
                case BITSETPROP: {
                    return this.s.getBitSetPropertyCount();
                }
                case DOUBLEPROP: {
                    return this.s.getDoublePropertyCount();
                }
                case INTPROP: {
                    return this.s.getIntPropertyCount();
                }
                case OBJECTPROP: {
                    return this.s.getObjectPropertyCount();
                }
                case STRINGPROP: {
                    return this.s.getStringPropertyCount();
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public EPropDesc getProperty(PropertyTypes type, int index) {
            return new DefaultEntityPropertyDescriptor(this.s, type, index);
        }

        @Override
        public EPropDesc getOrAddProperty(PropertyTypes type, String name, int bsbits) {
            int idx = this.s.getPropertyIndex(name);
            if (idx == -1) {
                return this.addProperty(type, name, bsbits);
            }
            PropertyTypes t = this.s.getPropertyType(name);
            if (t != type) {
                throw new UnsupportedOperationException();
            }
            return this.getProperty(name);
        }
    }
}

