/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.ClustorImpl;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.backend.MRTree;
import chemaxon.clustering.backend.TreeNodeEntityGroup;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.backend.oa.FormatFactory;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.marvin.modelling.TextUtils;
import chemaxon.struc.Molecule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SphereExclusion
extends ClustorImpl {
    Log log = LogFactory.getLog(SphereExclusion.class);
    HC.Callback<Molecule> cbInputMolecule;
    HC.Callback<CDescriptor> cbInputDescriptor;
    HC.Callback<String> cbInputSmiles;
    final double rsep;

    public SphereExclusion(final ChemFormatFactory ff, int levelCount, final double rsep) {
        super(ff, levelCount);
        this.setStoreClusterRepresentantDescriptor();
        this.setStoreClusterRepresentantIntermediate();
        if (ff.isLeavesStored()) {
            this.setStoreLeavesFirstParentID();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("SphereExclusion constructed. levelCount=" + levelCount + " rsep=" + rsep));
        }
        this.rsep = rsep;
        final ComparableDescriptor desc = ff.getDescriptor();
        this.cbInputMolecule = new HC.Callback<Molecule>(0){};
        this.getHC().addRMDecorator(this.cbInputMolecule);
        this.cbInputDescriptor = new HC.Callback<CDescriptor>(0){};
        this.getHC().addRDDecorator(this.cbInputDescriptor);
        this.cbInputSmiles = new HC.Callback<String>(0){};
        this.getHC().addRSDecorator(this.cbInputSmiles);
        HC.Callback ccb = new HC.Callback(0){

            @Override
            public void allImportFinished(boolean cleanupRequired) {
                super.allImportFinished(cleanupRequired);
                if (!ff.isLeavesStored()) {
                    if (SphereExclusion.this.log.isTraceEnabled()) {
                        SphereExclusion.this.log.trace((Object)"No leaves stored, skip reassignment");
                    }
                    return;
                }
                SphereExclusion.reassignLeaves(SphereExclusion.this.log, SphereExclusion.this, ff);
            }

            public void processNewLeaf(Entity node, Entity rawnode, Object rawmol) {
                if (SphereExclusion.this.log.isTraceEnabled()) {
                    SphereExclusion.this.log.trace((Object)("Process new leaf node: " + node));
                }
                CDescriptor d = SphereExclusion.this.cbInputDescriptor.getLastRaw();
                TreeNodeEntityGroup l = this.hc.getLevelGroup(1);
                EntityGroup bestg = null;
                double bestd = 0.0;
                for (int i = 0; i < l.getSubtreeCount(); ++i) {
                    EntityGroup si = l.getSubtree(i);
                    CDescriptor di = (CDescriptor)SphereExclusion.this.getClusterRepresentantDescriptor().getPropertyObject(si.properties());
                    double dist = desc.calcDistance(d, di);
                    if (SphereExclusion.this.log.isTraceEnabled()) {
                        SphereExclusion.this.log.trace((Object)("D from group " + i + ": " + dist));
                    }
                    if (!(dist < bestd) && bestg != null) continue;
                    bestd = dist;
                    bestg = si;
                }
                if (bestg == null || bestd > rsep) {
                    if (SphereExclusion.this.log.isTraceEnabled()) {
                        SphereExclusion.this.log.trace((Object)("Alloc new cluster. bestd=" + bestd));
                    }
                    Molecule m = SphereExclusion.this.cbInputMolecule.getLastRaw();
                    String s = SphereExclusion.this.cbInputSmiles.getLastRaw();
                    bestg = SphereExclusion.this.addGroup(1, "CHEMAXON.SPHEX.CLUSTER", m, s, d, null);
                    if (SphereExclusion.this.log.isTraceEnabled()) {
                        SphereExclusion.this.log.trace((Object)"Alloc new group");
                    }
                }
                bestg.add(node);
                if (SphereExclusion.this.isLeavesFirstParentIDStored()) {
                    SphereExclusion.this.setFirstParentAssociation(node, bestg);
                }
            }
        };
        this.getHC().addDecorator(ccb);
    }

    public static void reassignLeaves(Log log, Clustor clus, FormatFactory ff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Reading finished, invoke reassignment step");
        }
        MRTree tree = clus.getHC().getTree();
        HC.RetrievePropertyInt lfp = clus.getLeavesFirstParentID();
        HierarchicEntityGroup l1 = clus.getHC().getLevelGroup(1).getHierarchic();
        for (int i = 0; i < tree.getLeavesCount(); ++i) {
            Entity ei = tree.getLeaf(i);
            int pid = lfp.getPropertyInt(ei);
            CDescriptor di = ff.getRetrieveLeaveDescriptor().getDescriptor(ei);
            EntityGroup bestg = null;
            double bestd = 0.0;
            for (int j = 0; j < l1.getSubtreeCount(); ++j) {
                EntityGroup sj = l1.getSubtree(j);
                CDescriptor dj = clus.getClusterRepresentantDescriptor().getDescriptor(sj.properties());
                double dist = clus.getDesc().calcDistance(di, dj);
                if (!(dist < bestd) && bestg != null) continue;
                bestd = dist;
                bestg = sj;
            }
            if (pid == bestg.getIndex()) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Move leave " + i + " from group " + pid + " to group " + bestg.getIndex()));
            }
            tree.getGroup(pid).remove(ei);
            bestg.add(ei);
            clus.setFirstParentAssociation(ei, bestg);
        }
    }

    @Override
    public String getShortName() {
        return "SPHEX";
    }

    @Override
    public String getLongName() {
        return "Sphere exclusion clustering";
    }

    @Override
    public String getClusteringSummary() {
        return "Single level sphere exclusion clustering. Minimal separation between centroids: " + TextUtils.formatNumber(this.rsep, 4);
    }
}

