/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.EPropDesc;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.StretchingEntityStore;
import chemaxon.clustering.backend.oa.IteratorWithException;
import chemaxon.clustering.scaffolding.logging.LogTrace;
import chemaxon.clustering.scaffolding.logging.NoLevelLog;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreIO {
    private StretchingEntityStore s = null;
    private Log log = LogFactory.getLog(StoreIO.class);
    private NoLevelLog logt = new LogTrace(this.log);
    public static final String MOLPROP = "MOLECULE";
    public static final String MOLNAME = "MOLNAME";
    public static final String RAWPROPPREFIX = "RAWPROP.";
    private Entity lastAddedEntity = null;
    private int mNamePropSPIndex = -1;
    private int mRawmolPropOPIndex = -1;
    private PropertyMapper pm = null;

    public StoreIO() {
    }

    public Entity addEntity() {
        if (this.s == null) {
            this.getStore();
        }
        this.lastAddedEntity = this.s.add();
        return this.lastAddedEntity;
    }

    public int getNPSI() {
        if (this.mNamePropSPIndex < 0) {
            this.mNamePropSPIndex = this.s.addStringProperties(new String[]{MOLNAME})[0];
        }
        return this.mNamePropSPIndex;
    }

    public int getRMPOI() {
        if (this.mRawmolPropOPIndex < 0) {
            this.mRawmolPropOPIndex = this.s.addObjectProperties(new String[]{MOLPROP})[0];
        }
        return this.mRawmolPropOPIndex;
    }

    public void setRawProperties(Molecule m, Entity e, boolean careMolName, boolean careRawMol) {
        if (careMolName) {
            if (m.getName() != null && m.getName().length() > 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("..Name: " + m.getName()));
                }
                e.flatProperties().setStringProperty(this.getNPSI(), m.getName());
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"..No name specified");
            }
        }
        for (int i = 0; i < m.getPropertyCount(); ++i) {
            String pk = m.getPropertyKey(i);
            String pv = m.getProperty(pk);
            if (this.pm == null) {
                this.pm = new PropertyMapper(this.s, RAWPROPPREFIX);
            }
            this.pm.set(e, pk, pv);
        }
        if (careRawMol) {
            m.properties().clear();
            e.flatProperties().setObjectProperty(this.getRMPOI(), m);
        }
    }

    public StoreIO(IteratorWithException<Molecule, IOException> input) throws IOException {
        this(input, new DefaultAddMoleculeNode());
    }

    public StoreIO(IteratorWithException<Molecule, IOException> input, AddMoleculeNode adder) throws IOException {
        this.addMolecules(input, adder);
    }

    public int addMolecules(IteratorWithException<Molecule, IOException> input, AddMoleculeNode adder) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Add molecules");
        }
        EntityStore bs = this.getStore();
        int rdct = 0;
        Molecule m = null;
        while (input.hasNext()) {
            m = input.next();
            for (int i = 0; i < m.getAtomCount(); ++i) {
                MolAtom a = m.getAtom(i);
                a.clearQProps();
            }
            ++rdct;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("New structure read. SMILES: " + m.toFormat("smiles")));
            }
            this.lastAddedEntity = null;
            adder.addNode(m, this);
        }
        adder.importFinished(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("All done. Read count: " + rdct + " size: " + bs.size()));
        }
        return rdct;
    }

    public EntityStore getStore() {
        if (this.s == null) {
            this.s = StretchingEntityStore.constructDefaultStretchingStore(0, 0, 0, 0, 2);
        }
        return this.s;
    }

    public static class PropertyMapper {
        Log log = LogFactory.getLog(PropertyMapper.class);
        private EntityStore<?> base = null;
        private String prefix = null;

        public PropertyMapper(EntityStore<?> s, String p) {
            this.base = s;
            this.prefix = p;
        }

        public void set(Entity e, String name, String value) {
            String spk = this.prefix + name;
            int spi = this.base.getPropertyIndex(spk);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("..Set name=" + name + " value=" + value + " spk=" + spk + " spi=" + spi));
            }
            if (spi < 0) {
                spi = this.base.addStringProperties(new String[]{spk})[0];
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("....Property added. spi=" + spi));
                }
            }
            e.flatProperties().setStringProperty(spi, value);
        }
    }

    public static class PropertyProjection {
        Log log = LogFactory.getLog(PropertyProjection.class);
        private Map<EPropDesc, MapAction> paction = null;
        private Map<EPropDesc, EPropDesc> pmap = null;
        EntityStore<?> from = null;
        EntityStore<?> to = null;

        public PropertyProjection(EntityStore<?> from, EntityStore<?> to) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Property projection constructed");
            }
            this.from = from;
            this.to = to;
            this.paction = new HashMap<EPropDesc, MapAction>();
            this.pmap = new HashMap<EPropDesc, EPropDesc>();
        }

        public Vector<EPropDesc> getUnknowns() {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"getUnknowns()");
            }
            Vector<EPropDesc> ret = null;
            Vector<EPropDesc> fp = this.from.properties().getProperties();
            for (EPropDesc d : fp) {
                if (this.paction.containsKey(d)) continue;
                if (ret == null) {
                    ret = new Vector<EPropDesc>();
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Unknown: " + d));
                }
                ret.add(d);
            }
            return ret;
        }

        public void ensureIgnore(EPropDesc prop) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ensureIgnore(): " + prop));
            }
            this.ensureAction(prop, MapAction.ignore, null);
        }

        public EPropDesc ensureCopy(EPropDesc prop) {
            EPropDesc tp;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("ensureCopy(): " + prop));
            }
            if (this.paction.get(prop) != MapAction.copyValue) {
                this.paction.put(prop, MapAction.copyValue);
            }
            if ((tp = this.pmap.get(prop)) == null || !tp.getName().equals(prop.getName()) || tp.getType() != prop.getType()) {
                tp = this.to.properties().getOrAddProperty(prop.getType(), prop.getName(), prop.getBitSetBitCount());
                this.pmap.put(prop, tp);
            }
            return tp;
        }

        public void ensureAction(EPropDesc prop, MapAction action, EPropDesc targetprop) {
            if (this.paction.get(prop) != action) {
                this.paction.put(prop, action);
            }
            if (action == MapAction.ignore) {
                if (this.pmap.containsKey(prop)) {
                    this.pmap.remove(prop);
                }
            } else if (!this.pmap.get(prop).equals(targetprop)) {
                this.pmap.put(prop, targetprop);
            }
        }

        public void projectProperties(Entity src, Entity trg) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("projectProperties() src: " + src));
            }
            if (src.getStore() != this.from) {
                throw new UnsupportedOperationException();
            }
            if (trg.getStore() != this.to) {
                throw new UnsupportedOperationException();
            }
            EntityProperties sp = src.properties();
            EntityProperties tp = trg.properties();
            for (EPropDesc i : this.paction.keySet()) {
                MapAction ma = this.paction.get(i);
                if (ma != MapAction.copyValue) continue;
                EPropDesc tpd = this.pmap.get(i);
                tp.getProperty(tpd).setValue(sp.getProperty(i).getValue());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(".. trg after: " + trg));
            }
        }

        public static enum MapAction {
            ignore,
            copyValue;

        }
    }

    public static class DefaultAddMoleculeNode
    implements AddMoleculeNode {
        Log log = LogFactory.getLog(DefaultAddMoleculeNode.class);
        int rdct = 0;
        AddMoleculeNode partialCallback = null;
        int partialCallbackCount = 0;

        @Override
        public void addNode(Molecule m, StoreIO io) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Node added");
            }
            Entity e = io.addEntity();
            io.setRawProperties(m, e, true, true);
            ++this.rdct;
            if (this.partialCallback != null && this.partialCallbackCount > 0 && this.rdct >= this.partialCallbackCount) {
                this.rdct = 0;
                this.partialCallback.importFinished(io);
            }
        }

        @Override
        public void importFinished(StoreIO io) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"importFinished() called");
            }
            if (this.partialCallback != null && this.rdct > 0) {
                this.rdct = 0;
                this.partialCallback.importFinished(io);
            }
        }

        public void setPartialCallback(AddMoleculeNode callback, int count) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("setPartialCallback(); count=" + count));
            }
            this.partialCallback = callback;
            this.partialCallbackCount = count;
        }
    }

    public static interface AddMoleculeNode {
        public void addNode(Molecule var1, StoreIO var2);

        public void importFinished(StoreIO var1);
    }
}

