/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend;

import chemaxon.clustering.backend.DefaultEntityStore;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityProperties;
import chemaxon.clustering.backend.EntityStore;
import chemaxon.clustering.backend.Events;
import chemaxon.clustering.backend.FlatProperties;
import chemaxon.clustering.backend.PropertyHandler;
import chemaxon.clustering.backend.PropertyTypes;
import chemaxon.clustering.backend.StoreProperties;
import chemaxon.clustering.util.IntPermutation;
import chemaxon.clustering.util.IntPermutationImpl;
import chemaxon.clustering.util.RAIterator;
import chemaxon.marvin.modelling.util.U;
import java.util.BitSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StretchingEntityStore
implements EntityStore<Entity>,
Events.ChangeCountListener {
    static int ln = 0;
    Log log = LogFactory.getLog((String)(StretchingEntityStore.class.getName() + ".Stretching-" + ln++));
    private int basesize = 1 << this.basesizeExp;
    private int basesizeExp = 14;
    private int basemask = this.basesize - 1;
    BaseEntityStoreConstructor constructor = null;
    BaseEntityStoreAdder adder = null;
    Vector<EntityStore> bases = null;
    Vector<IntPermutation> intPropPerm = null;
    Vector<IntPermutation> doublePropPerm = null;
    Vector<IntPermutation> stringPropPerm = null;
    Vector<IntPermutation> objectPropPerm = null;
    Vector<IntPermutation> bitSetPropPerm = null;
    Events.DefaultStoreEventHandler seh = null;
    int size = 0;
    private int sscc = 0;
    private int scc = 0;
    private int cc = 0;

    public StretchingEntityStore(BaseEntityStoreConstructor c, BaseEntityStoreAdder a) {
        this.constructor = c;
        this.adder = a;
        this.size = 0;
        this.bases = new Vector();
        this.intPropPerm = new Vector();
        this.doublePropPerm = new Vector();
        this.stringPropPerm = new Vector();
        this.objectPropPerm = new Vector();
        this.bitSetPropPerm = new Vector();
        this.bases.add(this.constructor.construct(this.basesize, null));
        this.intPropPerm.add(IntPermutationImpl.getUniversalIdentityMapping());
        this.doublePropPerm.add(IntPermutationImpl.getUniversalIdentityMapping());
        this.stringPropPerm.add(IntPermutationImpl.getUniversalIdentityMapping());
        this.objectPropPerm.add(IntPermutationImpl.getUniversalIdentityMapping());
        this.bitSetPropPerm.add(IntPermutationImpl.getUniversalIdentityMapping());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Constructed. basesize=" + this.basesize), new Throwable());
        }
    }

    public Entity add() {
        EntityStore s = this.bases.lastElement();
        if (s.size() == this.basesize) {
            String[] pn;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("last base size=" + s.size() + " == basesize; stretching"));
            }
            EntityStore fs = this.bases.firstElement();
            s = this.constructor.construct(this.basesize, fs);
            this.bases.add(s);
            if (fs.getIntPropertyCount() != 0) {
                pn = fs.getIntPropertyNames();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("fs int property names: " + U.sel(pn)));
                }
                this.intPropPerm.add(IntPermutationImpl.checkIdentityMapping(fs.getPropertyIndex(pn), s.addIntProperties(pn)));
            }
            if (fs.getDoublePropertyCount() != 0) {
                pn = fs.getDoublePropertyNames();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("fs double property names: " + U.sel(pn)));
                }
                this.doublePropPerm.add(IntPermutationImpl.checkIdentityMapping(fs.getPropertyIndex(pn), s.addDoubleProperties(pn)));
            }
            if (fs.getStringPropertyCount() != 0) {
                pn = fs.getStringPropertyNames();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("fs string property names: " + U.sel(pn)));
                }
                this.stringPropPerm.add(IntPermutationImpl.checkIdentityMapping(fs.getPropertyIndex(pn), s.addStringProperties(pn)));
            }
            if (fs.getObjectPropertyCount() != 0) {
                pn = fs.getObjectPropertyNames();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("fs object property names: " + U.sel(pn)));
                }
                this.objectPropPerm.add(IntPermutationImpl.checkIdentityMapping(fs.getPropertyIndex(pn), s.addObjectProperties(pn)));
            }
            if (fs.getBitSetPropertyCount() != 0) {
                pn = fs.getBitSetPropertyNames();
                int[] bn = fs.getBitSetPropertyBitCounts();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("fs bitset property names: " + U.sel(pn)));
                }
                this.bitSetPropPerm.add(IntPermutationImpl.checkIdentityMapping(fs.getPropertyIndex(pn), s.addBitSetProperties(pn, bn)));
            }
        }
        this.adder.addEntity(s);
        ++this.size;
        Entity e = this.getEntity(this.size() - 1);
        this.storeChanged();
        if (this.seh != null) {
            this.seh.entityAdded(s, this.size - 1);
        }
        return e;
    }

    @Override
    public void clearEntities() {
        this.size = 0;
        EntityStore e = U.removeAllButFirst(this.bases);
        e.clearEntities();
        U.removeAllButFirst(this.bitSetPropPerm);
        U.removeAllButFirst(this.intPropPerm);
        U.removeAllButFirst(this.doublePropPerm);
        U.removeAllButFirst(this.stringPropPerm);
        U.removeAllButFirst(this.objectPropPerm);
        this.storeChanged();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entity getEntity(int index) {
        return new EntityProxy(index);
    }

    @Override
    public int indexOf(Entity e) {
        return ((EntityProxy)e).id;
    }

    @Override
    public int getPropertyIndex(String propName) {
        return this.bases.firstElement().getPropertyIndex(propName);
    }

    @Override
    public PropertyTypes getPropertyType(String propName) {
        return this.bases.firstElement().getPropertyType(propName);
    }

    @Override
    public String getIntPropertyName(int iPropIndex) {
        return this.bases.firstElement().getIntPropertyName(iPropIndex);
    }

    @Override
    public String getDoublePropertyName(int dPropIndex) {
        return this.bases.firstElement().getDoublePropertyName(dPropIndex);
    }

    @Override
    public String getStringPropertyName(int sPropIndex) {
        return this.bases.firstElement().getStringPropertyName(sPropIndex);
    }

    @Override
    public String getObjectPropertyName(int oPropIndex) {
        return this.bases.firstElement().getObjectPropertyName(oPropIndex);
    }

    @Override
    public String getBitSetPropertyName(int bPropIndex) {
        return this.bases.firstElement().getBitSetPropertyName(bPropIndex);
    }

    @Override
    public int getIntPropertyCount() {
        return this.bases.firstElement().getIntPropertyCount();
    }

    @Override
    public int getDoublePropertyCount() {
        return this.bases.firstElement().getDoublePropertyCount();
    }

    @Override
    public int getStringPropertyCount() {
        return this.bases.firstElement().getStringPropertyCount();
    }

    @Override
    public int getObjectPropertyCount() {
        return this.bases.firstElement().getObjectPropertyCount();
    }

    @Override
    public int getBitSetPropertyCount() {
        return this.bases.firstElement().getBitSetPropertyCount();
    }

    @Override
    public int getBitSetPropertyBitCount(int bPropIndex) {
        return this.bases.firstElement().getBitSetPropertyBitCount(bPropIndex);
    }

    @Override
    public int[] addIntProperties(String[] propNames) {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addIntProperties: " + U.sel(propNames)));
        }
        EntityStore fs = this.bases.firstElement();
        int[] fpi = fs.addIntProperties(propNames);
        for (i = 1; i < this.bases.size(); ++i) {
            EntityStore is = this.bases.get(i);
            int[] ipi = is.addIntProperties(propNames);
            if (this.intPropPerm.get(i).canAdd(fpi, ipi)) {
                this.intPropPerm.get(i).add(fpi, ipi);
                continue;
            }
            this.intPropPerm.setElementAt(new IntPermutationImpl(fpi, ipi), i);
        }
        if (this.seh != null) {
            for (i = 0; i < propNames.length; ++i) {
                this.seh.propertyAdded(this, PropertyTypes.INTPROP, fpi[i], propNames[i]);
            }
        }
        this.storeStructureChanged();
        return fpi;
    }

    @Override
    public int[] addDoubleProperties(String[] propNames) {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addDoubleProperties: " + U.sel(propNames)));
        }
        EntityStore fs = this.bases.firstElement();
        int[] fpi = fs.addDoubleProperties(propNames);
        for (i = 1; i < this.bases.size(); ++i) {
            EntityStore is = this.bases.get(i);
            int[] ipi = is.addDoubleProperties(propNames);
            if (this.doublePropPerm.get(i).canAdd(fpi, ipi)) {
                this.doublePropPerm.get(i).add(fpi, ipi);
                continue;
            }
            this.doublePropPerm.setElementAt(new IntPermutationImpl(fpi, ipi), i);
        }
        if (this.seh != null) {
            for (i = 0; i < propNames.length; ++i) {
                this.seh.propertyAdded(this, PropertyTypes.DOUBLEPROP, fpi[i], propNames[i]);
            }
        }
        this.storeStructureChanged();
        return fpi;
    }

    @Override
    public int[] addBitSetProperties(String[] propNames, int[] bitCounts) {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addBitSetProperties: " + U.sel(propNames)));
        }
        EntityStore fs = this.bases.firstElement();
        int[] fpi = fs.addBitSetProperties(propNames, bitCounts);
        for (i = 1; i < this.bases.size(); ++i) {
            EntityStore is = this.bases.get(i);
            int[] ipi = is.addBitSetProperties(propNames, bitCounts);
            if (this.bitSetPropPerm.get(i).canAdd(fpi, ipi)) {
                this.bitSetPropPerm.get(i).add(fpi, ipi);
                continue;
            }
            this.bitSetPropPerm.setElementAt(new IntPermutationImpl(fpi, ipi), i);
        }
        if (this.seh != null) {
            for (i = 0; i < propNames.length; ++i) {
                this.seh.propertyAdded(this, PropertyTypes.BITSETPROP, fpi[i], propNames[i]);
            }
        }
        this.storeStructureChanged();
        return fpi;
    }

    @Override
    public int[] addStringProperties(String[] propNames) {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addStringProperties: " + U.sel(propNames)));
        }
        EntityStore fs = this.bases.firstElement();
        int[] fpi = fs.addStringProperties(propNames);
        for (i = 1; i < this.bases.size(); ++i) {
            EntityStore is = this.bases.get(i);
            int[] ipi = is.addStringProperties(propNames);
            if (this.stringPropPerm.get(i).canAdd(fpi, ipi)) {
                this.stringPropPerm.get(i).add(fpi, ipi);
                continue;
            }
            this.stringPropPerm.setElementAt(new IntPermutationImpl(fpi, ipi), i);
        }
        if (this.seh != null) {
            for (i = 0; i < propNames.length; ++i) {
                this.seh.propertyAdded(this, PropertyTypes.STRINGPROP, fpi[i], propNames[i]);
            }
        }
        this.storeStructureChanged();
        return fpi;
    }

    @Override
    public int[] addObjectProperties(String[] propNames) {
        int i;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addObjectProperties: " + U.sel(propNames)));
        }
        EntityStore fs = this.bases.firstElement();
        int[] fpi = fs.addObjectProperties(propNames);
        for (i = 1; i < this.bases.size(); ++i) {
            EntityStore is = this.bases.get(i);
            int[] ipi = is.addIntProperties(propNames);
            if (this.objectPropPerm.get(i).canAdd(fpi, ipi)) {
                this.objectPropPerm.get(i).add(fpi, ipi);
                continue;
            }
            this.objectPropPerm.setElementAt(new IntPermutationImpl(fpi, ipi), i);
        }
        if (this.seh != null) {
            for (i = 0; i < propNames.length; ++i) {
                this.seh.propertyAdded(this, PropertyTypes.OBJECTPROP, fpi[i], propNames[i]);
            }
        }
        this.storeStructureChanged();
        return fpi;
    }

    @Override
    public int[] getPropertyIndex(String[] propName) {
        return this.bases.firstElement().getPropertyIndex(propName);
    }

    @Override
    public String[] getIntPropertyNames() {
        return this.bases.firstElement().getIntPropertyNames();
    }

    @Override
    public String[] getDoublePropertyNames() {
        return this.bases.firstElement().getDoublePropertyNames();
    }

    @Override
    public String[] getStringPropertyNames() {
        return this.bases.firstElement().getStringPropertyNames();
    }

    @Override
    public String[] getObjectPropertyNames() {
        return this.bases.firstElement().getObjectPropertyNames();
    }

    @Override
    public String[] getBitSetPropertyNames() {
        return this.bases.firstElement().getBitSetPropertyNames();
    }

    @Override
    public int[] getBitSetPropertyBitCounts() {
        return this.bases.firstElement().getBitSetPropertyBitCounts();
    }

    @Override
    public Events.StoreEventHandler getStoreEventHandler() {
        if (this.seh == null) {
            this.seh = new Events.DefaultStoreEventHandler(this);
        }
        return this.seh;
    }

    @Override
    public StoreProperties properties() {
        return new PropertyHandler.DefaultEntityStorePropertyHandler(this);
    }

    @Override
    public int getSSCC() {
        return this.sscc;
    }

    @Override
    public int getSCC() {
        return this.scc;
    }

    @Override
    public int getCC() {
        return this.cc;
    }

    @Override
    public RAIterator<Entity> iterator() {
        return DefaultEntityStore.RAIterator(this);
    }

    @Override
    public void storeStructureChanged() {
        ++this.sscc;
        ++this.scc;
        ++this.cc;
        if (this.seh != null) {
            this.seh.storeStructureChanged();
        }
    }

    @Override
    public void storeChanged() {
        ++this.scc;
        ++this.cc;
        if (this.seh != null) {
            this.seh.storeChanged();
        }
    }

    @Override
    public void changed() {
        ++this.cc;
        if (this.seh != null) {
            this.seh.changed();
        }
    }

    public static StretchingEntityStore constructDefaultStretchingStore(final int ipc, final int bpc, final int bbc, final int dpc, final int opc) {
        BaseEntityStoreConstructor c = new BaseEntityStoreConstructor(){

            @Override
            public EntityStore construct(int capacity, EntityStore referenceStore) {
                if (referenceStore == null) {
                    return new DefaultEntityStore(capacity, ipc, bpc, bbc, dpc, opc);
                }
                return new DefaultEntityStore(capacity, referenceStore.getIntPropertyCount(), referenceStore.getBitSetPropertyCount(), U.sum(referenceStore.getBitSetPropertyBitCounts()), referenceStore.getDoublePropertyCount(), referenceStore.getObjectPropertyCount() + referenceStore.getStringPropertyCount());
            }
        };
        BaseEntityStoreAdder a = new BaseEntityStoreAdder(){

            @Override
            public Entity addEntity(EntityStore s) {
                return ((DefaultEntityStore)s).addEntity();
            }
        };
        return new StretchingEntityStore(c, a);
    }

    private class EntityProxy
    implements Entity,
    FlatProperties {
        private int id = -1;
        private Entity e = null;

        private EntityProxy(int id) {
            this.id = id;
            this.e = StretchingEntityStore.this.bases.get(id >> StretchingEntityStore.this.basesizeExp).getEntity(id & StretchingEntityStore.this.basemask);
        }

        @Override
        public EntityStore getStore() {
            return StretchingEntityStore.this;
        }

        @Override
        public int getIntProperty(int iPropIndex) {
            return this.e.flatProperties().getIntProperty(StretchingEntityStore.this.intPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(iPropIndex));
        }

        @Override
        public void setIntProperty(int iPropIndex, int iPropValue) {
            StretchingEntityStore.this.changed();
            this.e.flatProperties().setIntProperty(StretchingEntityStore.this.intPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(iPropIndex), iPropValue);
            if (StretchingEntityStore.this.seh != null) {
                StretchingEntityStore.this.seh.propertyChanged(StretchingEntityStore.this, this.id, PropertyTypes.INTPROP, iPropIndex);
            }
        }

        @Override
        public double getDoubleProperty(int dPropIndex) {
            return this.e.flatProperties().getDoubleProperty(StretchingEntityStore.this.doublePropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(dPropIndex));
        }

        @Override
        public void setDoubleProperty(int dPropIndex, double dPropValue) {
            StretchingEntityStore.this.changed();
            this.e.flatProperties().setDoubleProperty(StretchingEntityStore.this.doublePropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(dPropIndex), dPropValue);
            if (StretchingEntityStore.this.seh != null) {
                StretchingEntityStore.this.seh.propertyChanged(StretchingEntityStore.this, this.id, PropertyTypes.DOUBLEPROP, dPropIndex);
            }
        }

        @Override
        public String getStringProperty(int sPropIndex) {
            if (sPropIndex < 0) {
                throw new IndexOutOfBoundsException("String property index " + sPropIndex);
            }
            return this.e.flatProperties().getStringProperty(StretchingEntityStore.this.stringPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(sPropIndex));
        }

        @Override
        public void setStringProperty(int sPropIndex, String sPropValue) {
            StretchingEntityStore.this.changed();
            this.e.flatProperties().setStringProperty(StretchingEntityStore.this.stringPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(sPropIndex), sPropValue);
            if (StretchingEntityStore.this.seh != null) {
                StretchingEntityStore.this.seh.propertyChanged(StretchingEntityStore.this, this.id, PropertyTypes.STRINGPROP, sPropIndex);
            }
        }

        @Override
        public void appendStringProperty(int sPropIndex, StringBuffer sb) {
            this.e.flatProperties().appendStringProperty(StretchingEntityStore.this.stringPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(sPropIndex), sb);
        }

        @Override
        public BitSet getBitSetProperty(int bPropIndex) {
            return this.e.flatProperties().getBitSetProperty(StretchingEntityStore.this.bitSetPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(bPropIndex));
        }

        @Override
        public boolean isBitSet(int bPropIndex, int bitIndex) {
            return this.e.flatProperties().isBitSet(StretchingEntityStore.this.bitSetPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(bPropIndex), bitIndex);
        }

        @Override
        public void setBitSetProperty(int bPropIndex, BitSet b) {
            StretchingEntityStore.this.changed();
            this.e.flatProperties().setBitSetProperty(StretchingEntityStore.this.bitSetPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(bPropIndex), b);
            if (StretchingEntityStore.this.seh != null) {
                StretchingEntityStore.this.seh.propertyChanged(StretchingEntityStore.this, this.id, PropertyTypes.BITSETPROP, bPropIndex);
            }
        }

        @Override
        public void getBitSetProperty(int bPropIndex, BitSet b) {
            this.e.flatProperties().getBitSetProperty(StretchingEntityStore.this.bitSetPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(bPropIndex), b);
        }

        @Override
        public Object getObjectProperty(int oPropIndex) {
            return this.e.flatProperties().getObjectProperty(StretchingEntityStore.this.objectPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(oPropIndex));
        }

        @Override
        public void setObjectProperty(int oPropIndex, Object o) {
            StretchingEntityStore.this.changed();
            this.e.flatProperties().setObjectProperty(StretchingEntityStore.this.objectPropPerm.get(this.id >> StretchingEntityStore.this.basesizeExp).getTo(oPropIndex), o);
            if (StretchingEntityStore.this.seh != null) {
                StretchingEntityStore.this.seh.propertyChanged(StretchingEntityStore.this, this.id, PropertyTypes.OBJECTPROP, oPropIndex);
            }
        }

        @Override
        public void releaseEntity() {
            this.e.releaseEntity();
            this.e = null;
            this.id = -1;
        }

        @Override
        public EntityProperties properties() {
            return new PropertyHandler.DefaultEntityPropertyHandler(this);
        }

        public String toString() {
            return DefaultEntityStore.entityToString(this);
        }

        @Override
        public FlatProperties flatProperties() {
            return this;
        }

        @Override
        public int getIndex() {
            return this.id;
        }
    }

    public static interface BaseEntityStoreAdder {
        public Entity addEntity(EntityStore var1);
    }

    public static interface BaseEntityStoreConstructor {
        public EntityStore construct(int var1, EntityStore var2);
    }
}

