/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.Clustor;
import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.oa.ChemFormatFactory;
import chemaxon.clustering.backend.oa.Format;
import chemaxon.struc.Molecule;

public class ChemFormat
implements Format<String> {
    private HC.RetrievePropertyObject<String> crsmi = null;
    private HC.RetrievePropertyObject<Molecule> crmol = null;
    private format f;
    private ChemFormatFactory ff;
    private Clustor c;

    @Override
    public String toString() {
        switch (this.f) {
            case sdf: {
                return "sdf";
            }
            case smiles: {
                return "smiles";
            }
        }
        return null;
    }

    @Override
    public String getHelpString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClustor(Clustor c) {
        this.crsmi = c.getClusterRepresentantIntermediate();
        this.crmol = c.getClusterRepresentantRaw();
        this.c = c;
    }

    ChemFormat(ChemFormatFactory ff, format f) {
        this.f = f;
        this.ff = ff;
    }

    @Override
    public String getLeaf(int id, EntityGroup g, Entity e) {
        HC.RetrievePropertyObject<String> lsmi = this.ff.getRetrieveLeaveIntermediate();
        HC.RetrievePropertyObject<Molecule> lmol = this.ff.getRetrieveLeaveRaw();
        switch (this.f) {
            case smiles: {
                String msmi = lsmi.getPropertyObject(e);
                String ret = msmi + "\tGID: " + id + " GSIZE: " + g.size() + "\n";
                return ret;
            }
            case sdf: {
                Molecule rm = lmol.getPropertyObject(e);
                rm = rm.cloneMolecule();
                rm.setName("" + id);
                rm.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERID", "" + id);
                rm.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERSIZE", "" + g.size());
                rm.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERSMILES", this.crsmi.getPropertyObject(g.properties()));
                return rm.toFormat("sdf");
            }
        }
        return null;
    }

    @Override
    public String getCluster(EntityGroup g) {
        return this.getCluster(g.getIndex(), g);
    }

    @Override
    public String getCluster(int id, EntityGroup g) {
        String smi = this.crsmi.getPropertyObject(g.properties());
        switch (this.f) {
            case smiles: {
                String ret = smi + "\tID: " + id + " SIZE: " + g.size() + "\n";
                return ret;
            }
            case sdf: {
                Molecule m = this.crmol.getPropertyObject(g.properties());
                m = m.cloneMolecule();
                m.setName("" + id);
                m.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERID", "" + id);
                m.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERSIZE", "" + g.size());
                m.setProperty("CHEMAXON." + this.c.getShortName() + ".CLUSTERSMILES", smi);
                return m.toFormat("sdf");
            }
        }
        return null;
    }

    static enum format {
        smiles,
        sdf;

    }
}

