/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.backend.oa;

import chemaxon.clustering.backend.oa.CreatePS;
import chemaxon.clustering.backend.oa.PrintStreamWrapper;
import chemaxon.clustering.util.VectorUtils;
import chemaxon.marvin.modelling.util.U;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePS
implements CreatePS<PrintStreamWrapper> {
    Log log = LogFactory.getLog(FilePS.class);
    String[] fnameParts;
    int[] paramPositions;
    int[] paramPaddedWidth;

    public FilePS(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Construct " + name));
        }
        int sp = name.indexOf(42);
        int qp = name.indexOf(63);
        if (sp == -1 && qp == -1) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"No WC, use plain filename");
            }
            this.fnameParts = new String[]{name};
            this.paramPositions = new int[0];
            this.paramPaddedWidth = new int[0];
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Parse parameters");
        }
        ArrayList<String> fnp = new ArrayList<String>();
        ArrayList<Integer> ppos = new ArrayList<Integer>();
        ArrayList<Integer> ppwd = new ArrayList<Integer>();
        int i = 0;
        int pp = 1;
        while (i < name.length()) {
            int i2 = name.length();
            int p = name.indexOf(42, i);
            int q = name.indexOf(63, i);
            if (p != -1 && (p < q || q == -1)) {
                i2 = p;
            } else if (q != -1 && (q < p || p == -1)) {
                i2 = q;
            }
            String ss = name.substring(i, i2);
            if (i2 < name.length() && ss.length() >= 2 && ss.charAt(ss.length() - 2) == '0') {
                ss = ss.substring(0, ss.length() - 2);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Next position: " + i2 + " p: " + p + " q: " + q + " i: " + i + " fnp: " + ss));
                if (i2 < name.length()) {
                    this.log.trace((Object)("..charAt(" + i2 + ")=" + name.charAt(i2)));
                }
            }
            fnp.add(ss);
            i = i2 + 1;
            if (i2 >= name.length()) continue;
            if (i2 == p) {
                ppos.add(0);
            } else if (i2 == q && sp == -1) {
                ppos.add(0);
            } else {
                ppos.add(pp++);
            }
            if (i2 >= 2 && name.charAt(i2 - 2) == '0') {
                ppwd.add(name.charAt(i2 - 1) - 48);
                continue;
            }
            ppwd.add(0);
        }
        this.fnameParts = VectorUtils.toStringArray(fnp);
        this.paramPositions = VectorUtils.toIntArray(ppos);
        this.paramPaddedWidth = VectorUtils.toIntArray(ppwd);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("fnameParts: " + U.sel(this.fnameParts)));
            this.log.trace((Object)("paramPositions: " + U.sel(this.paramPositions)));
            this.log.trace((Object)("paramPaddedWidthL: " + U.sel(this.paramPaddedWidth)));
        }
    }

    @Override
    public PrintStreamWrapper getPS() throws IOException {
        return this.getPS(null);
    }

    @Override
    public PrintStreamWrapper getPS(int i) throws IOException {
        return this.getPS(new int[]{i});
    }

    @Override
    public PrintStreamWrapper getPS(int i, int j) throws IOException {
        return this.getPS(new int[]{i, j});
    }

    @Override
    public String getHelpString() {
        return "  Output file name can be specified using a string. Characters '*' and '?' are\n  handled specially: The application might be able to distribute the output into\n  several files (parts). Apart from the unique part ID more - not necessarily\n  uniqe - identifier(s) might be available. Characters '*' and '?' might can be\n  used to request spliting and specify file name generation.\n  - If no '*' or '?' is given then the output will be a single file with\n    the specified name.\n  - First occurence of '*' or if it is not present, first occurence of '?'\n    will be substituted with the uniqe part ID\n  - Further occurence(s) of '*' and '?' will be substituted with the further\n    id(s).\n  - Use [*|?]0[0-9] to left pad the substitution with '0' character(s) to\n    the desired length\n  - Extra, not used '*' and '?' characters will be substituted with '_'\n    characters.";
    }

    @Override
    public int getParamCount() {
        return this.paramPositions.length;
    }

    @Override
    public void setMaxParamCount(int n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setMaxParamCount to " + n));
        }
        if (n >= this.paramPositions.length) {
            return;
        }
        String[] newFnameParts = new String[n + 1];
        int[] newParamPositions = new int[n];
        int[] newParamPaddedWidth = new int[n];
        newFnameParts[0] = this.fnameParts[0];
        int p = 0;
        for (int i = 0; i < this.paramPositions.length; ++i) {
            if (this.paramPositions[i] >= n) {
                if (newFnameParts[p] == null) {
                    newFnameParts[p] = "";
                }
                newFnameParts[p] = newFnameParts[p] + "_" + this.fnameParts[i + 1];
                continue;
            }
            newParamPositions[p] = this.paramPositions[i];
            newParamPaddedWidth[p] = this.paramPaddedWidth[i];
            newFnameParts[p + 1] = this.fnameParts[i + 1];
            ++p;
        }
        this.fnameParts = newFnameParts;
        this.paramPositions = newParamPositions;
        this.paramPaddedWidth = newParamPaddedWidth;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("fnameParts: " + U.sel(this.fnameParts)));
            this.log.trace((Object)("paramPositions: " + U.sel(this.paramPositions)));
            this.log.trace((Object)("paramPaddedWidthL: " + U.sel(this.paramPaddedWidth)));
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.fnameParts.length; ++i) {
            ret.append(this.fnameParts[i]);
            if (i >= this.paramPositions.length) continue;
            if (this.paramPositions[i] == 0) {
                ret.append('*');
            } else {
                ret.append('?');
            }
            if (this.paramPaddedWidth[i] <= 0) continue;
            ret.append('0');
            ret.append(this.paramPaddedWidth[i]);
        }
        return ret.toString();
    }

    @Override
    public PrintStreamWrapper getPS(int[] param) throws IOException {
        return new PrintStreamWrapper(new PrintStream(this.getPSname(param)), true);
    }

    String getPSname(int[] param) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getPSname: " + U.sel(param)));
        }
        if (this.paramPositions.length == 0 ? param != null && param.length > 0 : this.paramPositions.length != param.length) {
            throw new IndexOutOfBoundsException();
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.fnameParts.length; ++i) {
            ret.append(this.fnameParts[i]);
            if (i >= this.paramPositions.length) continue;
            String s = String.valueOf(param[this.paramPositions[i]]);
            if (this.paramPaddedWidth[i] > 0) {
                for (int j = this.paramPaddedWidth[i]; j > s.length(); --j) {
                    ret.append('0');
                }
            }
            ret.append(s);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("PS name: " + ret.toString()));
        }
        return ret.toString();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

