/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.boundary;

import chemaxon.clustering.boundary.BinaryFPFactory;
import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CDescriptorImpl;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.boundary.LDescriptor;
import chemaxon.clustering.boundary.LDescriptorImpl;
import chemaxon.clustering.boundary.LinearDescriptor;
import chemaxon.clustering.boundary.MeanResultImpl;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.descriptors.FPRetriever;
import chemaxon.descriptors.Metrics;
import chemaxon.struc.Molecule;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class BinaryFPImpl
implements ComparableDescriptor,
LinearDescriptor {
    BinaryFPFactory f;
    Log log = LogFactory.getLog(BinaryFPImpl.class);

    public BinaryFPImpl(BinaryFPFactory f) {
        this.f = f;
    }

    @Override
    public double calcDistance(CDescriptor m1, CDescriptor m2) {
        if (m1 == null || m2 == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"null descriptor passed, distance NaN");
            }
            return Double.NaN;
        }
        try {
            int[] fp1 = ((CDescriptorImpl)m1).getDesc();
            int[] fp2 = ((CDescriptorImpl)m2).getDesc();
            double dis = 0.0;
            switch (this.f.m) {
                case euclid: {
                    for (int i = 0; i < fp1.length; ++i) {
                        dis += (double)Metrics.calcBitCount(fp1[i] ^ fp2[i]);
                    }
                    dis /= 32.0 * (double)fp1.length;
                    dis = Math.sqrt(dis);
                    break;
                }
                case euclidsqr: 
                case manhattan: {
                    for (int i = 0; i < fp1.length; ++i) {
                        dis += (double)Metrics.calcBitCount(fp1[i] ^ fp2[i]);
                    }
                    dis /= 32.0 * (double)fp1.length;
                    break;
                }
                case tanimoto: {
                    dis = Metrics.binaryTanimoto(fp1, fp2);
                    break;
                }
                case commonbits: {
                    dis = 0.0;
                    for (int i = 0; i < fp1.length; ++i) {
                        dis += 32.0 - (double)Metrics.calcBitCount(fp1[i] & fp2[i]);
                    }
                    dis /= 32.0 * (double)fp1.length;
                }
            }
            if (Double.isNaN(dis)) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("Dissimilarity is NaN. Return 0.0, fingerprints: " + this.toString(m1) + " and " + this.toString(m2)));
                }
                return 0.0;
            }
            return dis;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Exception calculating distance, use NaN", (Throwable)e);
            }
            return Double.NaN;
        }
    }

    @Override
    public double calcDistance(CDescriptor desc1, LDescriptor desc2) {
        LDescriptor ld = this.linearize(desc1);
        return this.calcDistance(ld, desc2);
    }

    @Override
    public double calcDistance(LDescriptor desc1, LDescriptor desc2) {
        float[] fp1 = ((LDescriptorImpl)desc1).getDesc();
        float[] fp2 = ((LDescriptorImpl)desc2).getDesc();
        double dis = 0.0;
        switch (this.f.m) {
            case euclid: {
                dis = Metrics.euclidean(fp1, fp2);
                break;
            }
            case euclidsqr: {
                dis = Metrics.euclidean(fp1, fp2);
                dis *= dis;
                break;
            }
            case manhattan: {
                for (int i = 0; i < fp1.length; ++i) {
                    dis += (double)Math.abs(fp1[i] - fp2[i]);
                }
                break;
            }
            case tanimoto: {
                dis = Metrics.tanimoto(fp1, fp2);
                break;
            }
            case commonbits: {
                for (int i = 0; i < fp1.length; ++i) {
                    dis += 1.0 - (double)Math.min(fp1[i], fp2[i]);
                }
                break;
            }
        }
        if (Double.isNaN(dis)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Dissimilarity is NaN. Return 0.0");
            }
            return 0.0;
        }
        return dis;
    }

    @Override
    public LinearDescriptor.MeanResult calcMean(RandomAccess<CDescriptor> desc) {
        if (desc.size() == 0) {
            return null;
        }
        return new MeanResultImpl(this, desc);
    }

    @Override
    public abstract CDescriptor constructDescriptor(Molecule var1);

    @Override
    public boolean contains(CDescriptor outer, CDescriptor inner) {
        int[] fpO = ((CDescriptorImpl)outer).getDesc();
        int[] fpI = ((CDescriptorImpl)inner).getDesc();
        for (int i = 0; i < fpO.length; ++i) {
            if (fpI[i] == (fpO[i] & fpI[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(CDescriptor m1, CDescriptor m2) {
        int[] fp1 = ((CDescriptorImpl)m1).getDesc();
        int[] fp2 = ((CDescriptorImpl)m2).getDesc();
        for (int i = 0; i < fp1.length; ++i) {
            if (fp1[i] == fp2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ComparableDescriptor.Factory getFactory() {
        return this.f;
    }

    @Override
    public LDescriptor linearize(CDescriptor desc) {
        int[] fp = ((CDescriptorImpl)desc).getDesc();
        float[] ret = new float[32 * fp.length];
        int pos = 0;
        for (int i = 0; i < fp.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                ret[pos++] = (fp[i] & 1 << 31 - j) == 0 ? 0.0f : 1.0f;
            }
        }
        return new LDescriptorImpl(ret);
    }

    @Override
    public CDescriptor parseString(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s, "\t ");
            int l = st.countTokens();
            int[] fp = new int[l];
            for (int i = 0; i < fp.length; ++i) {
                fp[i] = Integer.parseInt(st.nextToken());
            }
            return new CDescriptorImpl(fp);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Exception constructing descripptor from " + s), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String toHumanReadableString(CDescriptor desc) {
        return FPRetriever.toBinaryString(((CDescriptorImpl)desc).getDesc());
    }

    @Override
    public String toString(CDescriptor desc) {
        return FPRetriever.toDecimalString(((CDescriptorImpl)desc).getDesc());
    }

    static enum metrics {
        tanimoto,
        manhattan,
        euclid,
        euclidsqr,
        commonbits;

    }
}

