/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.boundary;

import chemaxon.clustering.boundary.BinaryFPFactory;
import chemaxon.clustering.boundary.BinaryFPImpl;
import chemaxon.clustering.boundary.ComparableDescriptor;
import chemaxon.clustering.boundary.ECFPImpl;
import chemaxon.clustering.boundary.LinearDescriptor;
import chemaxon.clustering.tools.simplexml.parse.Callback;
import chemaxon.clustering.tools.simplexml.parse.SimpleNode;
import chemaxon.clustering.tools.simplexml.parse.SimpleParser;
import chemaxon.descriptors.ECFPParameters;
import java.io.File;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ECFPDFactory
extends BinaryFPFactory {
    Log log = LogFactory.getLog(ECFPDFactory.class);
    String cfg = null;
    String summary = null;
    ECFPParameters cfp = null;
    ECFPImpl lastdesc = null;

    public ECFPDFactory() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Factory constructed.");
        }
    }

    @Override
    public ComparableDescriptor getDescriptor(String cfg) {
        try {
            if (this.lastdesc == null) {
                this.lastdesc = this.getDescriptor_0(cfg);
            }
            return this.lastdesc;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Exception parsing cfg " + cfg), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public LinearDescriptor getLinearDescriptor() {
        return this.lastdesc;
    }

    ECFPImpl getDescriptor_0(String cfg) throws ParseException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getDescriptor() called; cfg: " + cfg));
        }
        ParseCFG p = new ParseCFG();
        SimpleParser pars = new SimpleParser(p);
        if (cfg == null) {
            this.cfg = "";
        } else {
            pars.lineRead(cfg);
            pars.eof();
        }
        if (p.cfparamsfile != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Initialize ECFPParameters from file " + p.cfparamsfile));
            }
            File f = new File(p.cfparamsfile);
            this.cfp = new ECFPParameters(f);
        } else if (p.cfparamsxml != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Initialize ECFPParameters from XML content " + p.cfparamsxml));
            }
            this.cfp = new ECFPParameters(p.cfparamsxml);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Initialize default ECFPParameters");
            }
            this.cfp = new ECFPParameters();
        }
        this.summary = "ECFP fingerprint; metric: ";
        if (p.metric == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Default: ");
            }
            this.m = BinaryFPImpl.metrics.tanimoto;
            this.summary = this.summary + "default ";
        } else {
            this.m = BinaryFPImpl.metrics.valueOf(p.metric);
            this.summary = this.summary + p.metric + " ";
        }
        this.summary = this.summary + this.m.toString();
        this.summary = this.summary + " | ECFP length=" + this.cfp.getLength() + "; ECFP diameter=" + this.cfp.getDiameter() + "; ECFP keepCounts=" + this.cfp.getKeepCounts();
        this.cfg = p.toString();
        return new ECFPImpl(this);
    }

    @Override
    public String getConfigString() {
        return this.cfg;
    }

    @Override
    public String getSummaryString() {
        return this.summary;
    }

    class ParseCFG
    implements Callback {
        String cfparamsfile = null;
        String cfparamsxml = null;
        String metric = null;
        int pos = 0;

        ParseCFG() {
        }

        @Override
        public void nodeOpened(SimpleNode node, SimpleNode parent) {
            if (ECFPDFactory.this.log.isTraceEnabled()) {
                ECFPDFactory.this.log.trace((Object)("nodeOpened. node: " + node.getName() + " nodedata: " + node.getData() + " parent: " + (parent == null ? "null" : parent.getName())));
            }
            switch (this.pos) {
                case 0: {
                    if (parent != null) {
                        throw new UnsupportedOperationException("node: " + node.getName() + " parent: " + parent.getName());
                    }
                    if (node.getName().equals("ecfpparams")) {
                        this.pos = 1;
                        break;
                    }
                    if (node.getName().equals("metric")) {
                        this.pos = 2;
                        break;
                    }
                    throw new UnsupportedOperationException("Unknown tag: " + node.getName());
                }
                case 1: {
                    break;
                }
            }
        }

        @Override
        public void nodeClosed(SimpleNode node, SimpleNode parent) {
            if (ECFPDFactory.this.log.isTraceEnabled()) {
                ECFPDFactory.this.log.trace((Object)("nodeClosed. node: " + node.getName() + " nodedata: " + node.getData() + " parent: " + (parent == null ? "null" : parent.getName())));
            }
            switch (this.pos) {
                case 0: {
                    throw new UnsupportedOperationException();
                }
                case 1: {
                    if (node.getName().equals("configfile")) {
                        this.cfparamsfile = node.getData();
                        break;
                    }
                    if (node.getName().equals("xmlparameters")) {
                        this.cfparamsxml = node.getData();
                        break;
                    }
                    this.pos = 0;
                    break;
                }
                case 2: {
                    this.metric = node.getData();
                    this.pos = 0;
                }
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("<ecfpparams>");
            if (this.cfparamsfile != null) {
                b.append("<configfile>");
                b.append(this.cfparamsfile);
                b.append("</configfile>");
            } else if (this.cfparamsxml != null) {
                b.append("<xmlparameters>");
                b.append(this.cfparamsxml);
                b.append("</xmlparameters>");
            }
            b.append("</ecfpparams>");
            b.append("<metric>");
            b.append(this.metric);
            b.append("</metric>");
            return b.toString();
        }

        @Override
        public void error(String msg) {
            throw new UnsupportedOperationException("Error parsing config: " + msg);
        }
    }
}

