/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.boundary;

import chemaxon.clustering.boundary.CDescriptor;
import chemaxon.clustering.boundary.CDescriptorImpl;
import chemaxon.clustering.boundary.LDescriptor;
import chemaxon.clustering.boundary.LDescriptorImpl;
import chemaxon.clustering.boundary.LinearDescriptor;
import chemaxon.clustering.util.RandomAccess;

class MeanResultImpl
implements LinearDescriptor.MeanResult {
    RandomAccess<CDescriptor> desc;
    LDescriptor mean;
    CDescriptor meanRepr = null;
    int menReprIndex = 0;
    double d = 0.0;
    LinearDescriptor dd;

    MeanResultImpl(LinearDescriptor dd, RandomAccess<CDescriptor> desc) {
        this.desc = desc;
        this.dd = dd;
        float[] m = null;
        for (int n = 0; n < desc.size(); ++n) {
            int[] fp = ((CDescriptorImpl)desc.get(n)).getDesc();
            if (m == null) {
                m = new float[32 * fp.length];
            }
            int k = 0;
            for (int i = 0; i < fp.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    int n2 = k++;
                    m[n2] = m[n2] + ((fp[i] & 1 << 31 - j) == 0 ? 0.0f : 1.0f);
                }
            }
        }
        int i = 0;
        while (i < m.length) {
            int n = i++;
            m[n] = (float)((double)m[n] / (double)desc.size());
        }
        this.mean = new LDescriptorImpl(m);
    }

    @Override
    public LDescriptor getMean() {
        return this.mean;
    }

    @Override
    public CDescriptor getMeanRepresentant() {
        if (this.meanRepr == null) {
            for (int i = 0; i < this.desc.size(); ++i) {
                CDescriptor cd = this.desc.get(i);
                double dist = this.dd.calcDistance(cd, this.mean);
                if (this.meanRepr != null && !(dist < this.d)) continue;
                this.meanRepr = cd;
                this.d = dist;
                this.menReprIndex = i;
            }
        }
        return this.meanRepr;
    }

    @Override
    public double getRepresentantDistance() {
        this.getMeanRepresentant();
        return this.d;
    }

    @Override
    public int getMeanRepresentantIndex() {
        this.getMeanRepresentant();
        return this.menReprIndex;
    }
}

