/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.chemistry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Fingerprint
implements Cloneable,
Serializable {
    public static final byte[] BITCOUNT_16_BIT = new byte[65536];
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private int brightness = -1;
    private static final long serialVersionUID = 7937454467884454553L;
    private long[] bits;
    private int nbits;
    private transient int unitsInUse = 0;

    public long[] bits() {
        return this.bits;
    }

    public int numOfLongs() {
        return this.unitsInUse;
    }

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private static long bit(int bitIndex) {
        return 1L << (bitIndex & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int i;
        for (i = this.unitsInUse - 1; i >= 0 && this.bits[i] == 0L; --i) {
        }
        this.unitsInUse = i + 1;
    }

    public Fingerprint() {
        this(64);
    }

    public Fingerprint(int nbits) {
        this.nbits = nbits;
        if (nbits < 0) {
            throw new NegativeArraySizeException(Integer.toString(nbits));
        }
        this.bits = new long[Fingerprint.unitIndex(nbits - 1) + 1];
    }

    public Fingerprint(int[] ibits, int nbits) {
        this.nbits = nbits;
        if (nbits < 0) {
            throw new NegativeArraySizeException(Integer.toString(nbits));
        }
        this.bits = new long[Fingerprint.unitIndex(nbits - 1) + 1];
        for (int i = 0; i < this.bits.length; ++i) {
            long l = (long)ibits[i * 2] & 0xFFFFFFFFL;
            long h = ibits.length > i * 2 + 1 ? (long)ibits[i * 2 + 1] & 0xFFFFFFFFL : 0L;
            this.bits[i] = h << 32 | l;
        }
        this.unitsInUse = this.bits.length;
    }

    private void ensureCapacity(int unitsRequired) {
        if (this.bits.length < unitsRequired) {
            int request = Math.max(2 * this.bits.length, unitsRequired);
            long[] newBits = new long[request];
            System.arraycopy(this.bits, 0, newBits, 0, this.unitsInUse);
            this.bits = newBits;
        }
    }

    public int length() {
        return this.nbits;
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bitIndex));
        }
        int unitIndex = Fingerprint.unitIndex(bitIndex);
        int unitsRequired = unitIndex + 1;
        if (this.unitsInUse < unitsRequired) {
            this.ensureCapacity(unitsRequired);
            int n = unitIndex;
            this.bits[n] = this.bits[n] | Fingerprint.bit(bitIndex);
            this.unitsInUse = unitsRequired;
        } else {
            int n = unitIndex;
            this.bits[n] = this.bits[n] | Fingerprint.bit(bitIndex);
        }
        this.brightness = -1;
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bitIndex));
        }
        int unitIndex = Fingerprint.unitIndex(bitIndex);
        if (unitIndex >= this.unitsInUse) {
            return;
        }
        int n = unitIndex;
        this.bits[n] = this.bits[n] & (Fingerprint.bit(bitIndex) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
        this.brightness = -1;
    }

    public void andNot(Fingerprint set) {
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        for (int i = 0; i < unitsInCommon; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (set.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateUnitsInUse();
        this.brightness = -1;
    }

    public boolean get(int bitIndex) {
        boolean result = false;
        result = (this.bits[bitIndex >> 6] & Fingerprint.bit(bitIndex)) != 0L;
        return result;
    }

    public void and(Fingerprint set) {
        int i;
        if (this == set) {
            return;
        }
        int oldUnitsInUse = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        for (i = 0; i < this.unitsInUse; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & set.bits[i];
        }
        while (i < oldUnitsInUse) {
            this.bits[i] = 0L;
            ++i;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
        this.brightness = -1;
    }

    public void or(Fingerprint set) {
        int i;
        if (this == set) {
            return;
        }
        this.ensureCapacity(set.unitsInUse);
        int unitsInCommon = Math.min(this.unitsInUse, set.unitsInUse);
        for (i = 0; i < unitsInCommon; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | set.bits[i];
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        if (this.unitsInUse < set.unitsInUse) {
            this.unitsInUse = set.unitsInUse;
        }
        this.brightness = -1;
    }

    public void xor(Fingerprint set) {
        int i;
        int unitsInCommon;
        if (this.unitsInUse >= set.unitsInUse) {
            unitsInCommon = set.unitsInUse;
        } else {
            unitsInCommon = this.unitsInUse;
            int newUnitsInUse = set.unitsInUse;
            this.ensureCapacity(newUnitsInUse);
            this.unitsInUse = newUnitsInUse;
        }
        for (i = 0; i < unitsInCommon; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ set.bits[i];
        }
        while (i < set.unitsInUse) {
            this.bits[i] = set.bits[i];
            ++i;
        }
        this.recalculateUnitsInUse();
        this.brightness = -1;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (--i >= 0) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null || !(obj instanceof Fingerprint)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Fingerprint set = (Fingerprint)obj;
        int minUnitsInUse = Math.min(this.unitsInUse, set.unitsInUse);
        for (i = 0; i < minUnitsInUse; ++i) {
            if (this.bits[i] == set.bits[i]) continue;
            return false;
        }
        if (this.unitsInUse > minUnitsInUse) {
            for (i = minUnitsInUse; i < this.unitsInUse; ++i) {
                if (this.bits[i] == 0L) continue;
                return false;
            }
        } else {
            for (i = minUnitsInUse; i < set.unitsInUse; ++i) {
                if (set.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        Fingerprint result = null;
        try {
            result = (Fingerprint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        result.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, result.bits, 0, this.unitsInUse);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
        this.brightness = -1;
    }

    public int brightness() {
        if (this.brightness >= 0) {
            return this.brightness;
        }
        this.brightness = 0;
        for (int i = 0; i < this.bits.length; ++i) {
            this.brightness += BITCOUNT_16_BIT[(int)(this.bits[i] >> 48 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(this.bits[i] >> 32 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(this.bits[i] >> 16 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(this.bits[i] & 0xFFFFL)];
        }
        return this.brightness;
    }

    public long getLong(int index) {
        return this.bits[index];
    }

    public static float tanimoto(Fingerprint fp1, Fingerprint fp2) {
        long[] bits1 = fp1.bits();
        long[] bits2 = fp2.bits();
        int len = fp1.numOfLongs();
        int ac = 0;
        int oc = 0;
        for (int i = 0; i < len; ++i) {
            long a = bits1[i] & bits2[i];
            long o = bits1[i] | bits2[i];
            ac += BITCOUNT_16_BIT[(int)(a >> 48 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(a >> 32 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(a >> 16 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(a & 0xFFFFL)];
            oc += BITCOUNT_16_BIT[(int)(o >> 48 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(o >> 32 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(o >> 16 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(o & 0xFFFFL)];
        }
        return oc == 0 ? 1.0f : (float)ac / (float)oc;
    }

    public static int hamming(Fingerprint fp1, Fingerprint fp2) {
        long[] bits1 = fp1.bits();
        long[] bits2 = fp2.bits();
        int len = fp1.numOfLongs();
        int xc = 0;
        for (int i = 0; i < len; ++i) {
            long x = bits1[i] ^ bits2[i];
            xc += BITCOUNT_16_BIT[(int)(x >> 48 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(x >> 32 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(x >> 16 & 0xFFFFL)] + BITCOUNT_16_BIT[(int)(x & 0xFFFFL)];
        }
        return xc;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            Fingerprint.BITCOUNT_16_BIT[i] = (byte)("\u0000\u0001\u0001\u0002\u0001\u0002\u0002\u0003\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004".charAt(i >> 12 & 0xF) + "\u0000\u0001\u0001\u0002\u0001\u0002\u0002\u0003\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004".charAt(i >> 8 & 0xF) + "\u0000\u0001\u0001\u0002\u0001\u0002\u0002\u0003\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004".charAt(i >> 4 & 0xF) + "\u0000\u0001\u0001\u0002\u0001\u0002\u0002\u0003\u0001\u0002\u0002\u0003\u0002\u0003\u0003\u0004".charAt(i & 0xF));
        }
    }
}

