/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.gnf.jext.swing.JDualThumbSlider;

public class JDTSlider
extends JDualThumbSlider {
    private static Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static Cursor eastCursor = Cursor.getPredefinedCursor(11);
    private static Cursor westCursor = Cursor.getPredefinedCursor(10);
    private static Cursor northCursor = Cursor.getPredefinedCursor(8);
    private static Cursor southCursor = Cursor.getPredefinedCursor(9);
    private int sh = -1;
    private int bw = 15;
    private int width;
    private int height;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private boolean horizontal = true;
    private Color[] colors = new Color[4];
    private GradientPaint hGradient;
    private GradientPaint vGradient;
    private Cursor cursor = defaultCursor;

    public JDTSlider(int orientation) {
        super(orientation);
        this.init(orientation);
    }

    public JDTSlider(int orientation, int minvalue, int maxvalue, int minimum, int maximum) {
        super(orientation, minvalue, maxvalue, minimum, maximum);
        this.init(orientation);
    }

    private void init(int orientation) {
        boolean bl = this.horizontal = orientation == 0;
        if (this.horizontal) {
            this.addHMouseListener();
        } else {
            this.addVMouseListener();
        }
        Color b = this.getBackground();
        this.colors[2] = this.getModifiedColor(b, -10);
        this.colors[1] = this.getModifiedColor(this.colors[2], 30);
        this.colors[0] = this.getModifiedColor(this.colors[2], 90);
        this.colors[3] = this.getModifiedColor(this.colors[2], 40);
        this.hGradient = new GradientPaint(0.0f, 0.0f, this.colors[1], 0.0f, 9.0f, this.colors[2], true);
        this.vGradient = new GradientPaint(0.0f, 0.0f, this.colors[1], 9.0f, 0.0f, this.colors[2], true);
    }

    private Color getModifiedColor(Color c, int mod) {
        int r = c.getRed() - mod;
        int g = c.getGreen() - mod;
        int b = c.getBlue() - mod;
        int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
        int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
        b = b < 0 ? 0 : (b > 255 ? 255 : b);
        return new Color(r, g, b);
    }

    public void set(int min, int minv, int maxv, int max) {
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValues(minv, maxv);
    }

    private int getMinCoord(int width, int height) {
        int w = this.getMinValue() - this.getMinimum();
        int s = this.getMaximum() - this.getMinimum();
        if (this.horizontal) {
            return this.bw + (int)((float)this.getAreaWidth(width) * (float)w / (float)s);
        }
        w = this.getMaximum() - this.getMaxValue();
        return this.bw + (int)((float)this.getAreaWidth(height) * (float)w / (float)s);
    }

    private int getAreaWidth(int width) {
        return width - 2 * this.bw;
    }

    private int getSliderWidth(int width, int height) {
        int w = this.getMaxValue() - this.getMinValue();
        int s = this.getMaximum() - this.getMinimum();
        if (this.horizontal) {
            return (int)((float)this.getAreaWidth(width) * (float)w / (float)s);
        }
        return (int)((float)this.getAreaWidth(height) * (float)w / (float)s);
    }

    protected void paintComponent(Graphics g) {
        if (this.sh == -1) {
            this.sh = this.horizontal ? Math.round((float)this.getHeight() / 5.0f) : Math.round((float)this.getWidth() / 5.0f);
        }
        Insets ins = this.getInsets();
        this.height = this.getHeight() - ins.top - ins.bottom;
        this.width = this.getWidth() - ins.left - ins.right;
        g.setColor(this.getBackground());
        g.fillRect(ins.left, ins.top, this.width, this.height);
        if (this.horizontal) {
            int y = this.height / 2;
            g.setColor(this.colors[0]);
            g.fill3DRect(y, y - 1, this.width - 2 * y, 2, false);
        } else {
            int x = this.width / 2;
            g.setColor(this.colors[0]);
            g.fill3DRect(x - 1, x, 2, this.height - 2 * x, false);
        }
        int min = this.getMinCoord(this.width, this.height);
        int swidth = this.getSliderWidth(this.width, this.height);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.horizontal) {
                this.paintHSlider(min, swidth, g2);
                this.paintHButtons(min, min + swidth, g2);
            } else {
                this.paintVSlider(min, swidth, g2);
                this.paintVButtons(min, min + swidth, g2);
            }
        }
    }

    private void paintHSlider(int min, int swidth, Graphics2D g) {
        g.setPaint(this.hGradient);
        g.fillRect(min, this.sh, swidth, this.height - 2 * this.sh);
        g.setPaint(this.colors[0]);
        g.drawRect(min, this.sh, swidth, this.height - 2 * this.sh);
        int c = min + swidth / 2;
        this.paintStripes(false, 5, this.height - 2 * (this.sh + 4), c, this.height / 2, g);
    }

    private void paintVSlider(int min, int swidth, Graphics2D g) {
        g.setPaint(this.vGradient);
        g.fillRect(this.sh, min, this.width - 2 * this.sh, swidth);
        g.setPaint(this.colors[0]);
        g.drawRect(this.sh, min, this.width - 2 * this.sh, swidth);
        int c = min + swidth / 2;
        this.paintStripes(true, 5, this.width - 2 * (this.sh + 4), this.width / 2, c, g);
    }

    private void paintStripes(boolean horizontal, int num, int l, int cx, int cy, Graphics g) {
        if (horizontal) {
            int i;
            int t1 = cx - l / 2;
            int t2 = cx + l / 2;
            g.setColor(this.colors[3]);
            int j = -3 * num / 2;
            for (i = 0; i < num; ++i) {
                g.drawLine(t1, cy - j - 1, t2, cy - j - 1);
                j += 3;
            }
            g.setColor(this.colors[2]);
            j = -3 * num / 2;
            for (i = 0; i < num; ++i) {
                g.drawLine(t1, cy - j, t2, cy - j);
                j += 3;
            }
        } else {
            int i;
            int t1 = cy - l / 2;
            int t2 = cy + l / 2;
            g.setColor(this.colors[3]);
            int j = -3 * num / 2;
            for (i = 0; i < num; ++i) {
                g.drawLine(cx - j - 1, t1, cx - j - 1, t2);
                j += 3;
            }
            g.setColor(this.colors[2]);
            j = -3 * num / 2;
            for (i = 0; i < num; ++i) {
                g.drawLine(cx - j, t1, cx - j, t2);
                j += 3;
            }
        }
    }

    private void paintHButtons(int min, int max, Graphics2D g) {
        this.left = min - this.bw + this.sh;
        this.right = max + this.bw - this.sh;
        int w = this.bw - this.sh;
        int h = this.height - 2 * this.sh;
        g.setPaint(this.hGradient);
        this.paintButton(this.left, this.sh, w, h, g);
        g.setPaint(this.hGradient);
        this.paintButton(max, this.sh, w, h, g);
        this.paintStripes(true, 3, 2, this.left + w / 2, this.height / 2, g);
        this.paintStripes(true, 3, 2, max + w / 2, this.height / 2, g);
    }

    private void paintVButtons(int min, int max, Graphics2D g) {
        this.top = min - this.bw + this.sh;
        this.bottom = max;
        int h = this.bw - this.sh;
        int w = this.width - 2 * this.sh;
        g.setPaint(this.vGradient);
        this.paintButton(this.sh, this.bottom, w, h, g);
        g.setPaint(this.vGradient);
        this.paintButton(this.sh, this.top, w, h, g);
        this.paintStripes(false, 3, 2, this.width / 2, this.bottom + h / 2, g);
        this.paintStripes(false, 3, 2, this.width / 2, this.top + h / 2, g);
    }

    private void paintButton(int left, int bottom, int w, int h, Graphics2D g) {
        g.fillRect(left, bottom, w, h);
        g.setPaint(this.colors[0]);
        g.drawRect(left, bottom, w, h);
    }

    private void addHMouseListener() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                if (x >= JDTSlider.this.left && x <= JDTSlider.this.left + JDTSlider.this.bw - JDTSlider.this.sh) {
                    JDTSlider.this.setCursor(westCursor);
                } else if (x >= JDTSlider.this.right - JDTSlider.this.bw + JDTSlider.this.sh && x <= JDTSlider.this.right) {
                    JDTSlider.this.setCursor(eastCursor);
                } else {
                    JDTSlider.this.setCursor(defaultCursor);
                }
            }
        });
    }

    private void addVMouseListener() {
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int y = e.getY();
                if (y >= JDTSlider.this.top && y <= JDTSlider.this.top + JDTSlider.this.bw - JDTSlider.this.sh) {
                    JDTSlider.this.setCursor(northCursor);
                } else if (y >= JDTSlider.this.bottom && y <= JDTSlider.this.bottom + JDTSlider.this.bw - JDTSlider.this.sh) {
                    JDTSlider.this.setCursor(southCursor);
                } else {
                    JDTSlider.this.setCursor(defaultCursor);
                }
            }
        });
    }

    public void setCursor(Cursor c) {
        if (this.cursor != c) {
            this.cursor = c;
            super.setCursor(this.cursor);
        }
    }

    public String toString() {
        String s = "";
        s = s + (this.horizontal ? "H: " : "V: ");
        s = s + "[ " + this.getMinimum() + " : " + this.getMinValue() + " -- " + this.getMaxValue() + " : " + this.getMaximum() + " ]";
        return s;
    }
}

