/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.gui.JKlustorDialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;

public class JKlustorOptionsDialog
extends JKlustorDialog {
    JTabbedPane tabbedPane = new JTabbedPane();
    JPanel mcsPanel;
    private static final String ATOM_TYPE = "Atom type";
    private static final String BOND_TYPE = "Bond type";
    private static final String CHARGE = "Charge";
    private static final String HYBRIDIZATION = "Hybridization";
    private static final String ISOTOPES = "Isotopes";
    private static final String KEEP_RINGS = "Keep rings";
    private JRadioButton normalMode;
    private JRadioButton fastMode;
    private JRadioButton veryFastMode;
    private JSpinner minMCSSpinner;
    private JSpinner rccSpinner;
    private JSpinner mlcSpinner;
    private JCheckBox atomTypeCB;
    private JCheckBox bondTypeCB;
    private JCheckBox chargeCB;
    private JCheckBox hybridCB;
    private JCheckBox isotopeCB;
    private JCheckBox keepRingsCB;

    public JKlustorOptionsDialog(JPanel owner) {
        super(owner);
        this.setTitle("Options");
        this.initGUI();
    }

    public void initMCS(int mode, int minimalMCSSize, boolean atomType, boolean bondType, boolean charge, boolean hybridization, boolean isotopes) {
        this.setMode(mode);
        this.setMinimalMCSSize(minimalMCSSize);
        this.setAtomTypeMatch(atomType);
        this.setBondTypeMatch(bondType);
        this.setChargeMatch(charge);
        this.setHybridizationMatch(hybridization);
        this.setIsotopeMatch(isotopes);
    }

    public void initClustering(boolean keepRings, int rcc, int maxlc) {
        this.setKeepRings(keepRings);
        this.setRequiredClusterCount(rcc);
        this.setMaximumLevelCount(maxlc);
    }

    public int getMode() {
        if (this.normalMode.isSelected()) {
            return 1;
        }
        if (this.fastMode.isSelected()) {
            return 2;
        }
        if (this.veryFastMode.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: {
                this.normalMode.setSelected(true);
                break;
            }
            case 2: {
                this.fastMode.setSelected(true);
                break;
            }
            case 3: {
                this.veryFastMode.setSelected(true);
            }
        }
    }

    public int getMinimalMCSSize() {
        return ((Number)this.minMCSSpinner.getValue()).intValue();
    }

    public void setMinimalMCSSize(int minimalMCSSize) {
        this.minMCSSpinner.setValue(new Integer(minimalMCSSize));
    }

    public boolean getAtomTypeMatch() {
        return this.atomTypeCB.isSelected();
    }

    public void setAtomTypeMatch(boolean atomType) {
        this.atomTypeCB.setSelected(atomType);
    }

    public boolean getBondTypeMatch() {
        return this.bondTypeCB.isSelected();
    }

    public void setBondTypeMatch(boolean bondType) {
        this.bondTypeCB.setSelected(bondType);
    }

    public boolean getChargeMatch() {
        return this.chargeCB.isSelected();
    }

    public void setChargeMatch(boolean charge) {
        this.chargeCB.setSelected(charge);
    }

    public boolean getHybridizationMatch() {
        return this.hybridCB.isSelected();
    }

    public void setHybridizationMatch(boolean hybridization) {
        this.hybridCB.setSelected(hybridization);
    }

    public boolean getIsotopeMatch() {
        return this.isotopeCB.isSelected();
    }

    public void setIsotopeMatch(boolean isotopes) {
        this.isotopeCB.setSelected(isotopes);
    }

    public boolean isKeepRings() {
        return this.keepRingsCB.isSelected();
    }

    public void setKeepRings(boolean keepRings) {
        this.keepRingsCB.setSelected(keepRings);
    }

    public int getRequiredClusterCount() {
        return ((Number)this.rccSpinner.getValue()).intValue();
    }

    public void setRequiredClusterCount(int requiredClusterCount) {
        this.rccSpinner.setValue(new Integer(requiredClusterCount));
    }

    public int getMaximumLevelCount() {
        return ((Number)this.mlcSpinner.getValue()).intValue();
    }

    public void setMaximumLevelCount(int maximumLevelCount) {
        this.mlcSpinner.setValue(new Integer(maximumLevelCount));
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.createTabbedPane();
        JPanel tabbedPanel = new JPanel();
        tabbedPanel.setLayout(new BoxLayout(tabbedPanel, 0));
        tabbedPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        tabbedPanel.add(this.tabbedPane);
        tabbedPanel.add(Box.createRigidArea(new Dimension(7, 0)));
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 7)));
        this.getContentPane().add(tabbedPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 17)));
        this.getContentPane().add(this.createButtonPane());
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 11)));
        this.pack();
    }

    protected JPanel createButtonPane() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JKlustorOptionsDialog.this.setVisible(false);
            }
        });
        JButton setButton = new JButton("Ok");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JKlustorOptionsDialog.this.setVisible(false);
            }
        });
        setButton.setActionCommand("Ok");
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.getRootPane().setDefaultButton(setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(setButton);
        buttonPane.add(Box.createRigidArea(new Dimension(11, 0)));
        return buttonPane;
    }

    protected void createTabbedPane() {
        JComponent vPanel = this.createMCSPanel();
        this.tabbedPane.addTab("MCS Options", vPanel);
        JComponent lPanel = this.createClusteringPanel();
        this.tabbedPane.addTab("Clustering Options", lPanel);
    }

    protected JComponent createMCSPanel() {
        JPanel vPanel = new JPanel(false);
        vPanel.setLayout(new BoxLayout(vPanel, 1));
        JLabel label1 = new JLabel("Minimal MCS Size: ");
        this.minMCSSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 40, 1));
        this.minMCSSpinner.setPreferredSize(new Dimension(40, 20));
        this.minMCSSpinner.setMaximumSize(new Dimension(40, 20));
        this.normalMode = new JRadioButton("Normal");
        this.normalMode.setActionCommand("Exact");
        this.fastMode = new JRadioButton("Fast");
        this.fastMode.setActionCommand("Fast");
        this.veryFastMode = new JRadioButton("Very Fast");
        this.veryFastMode.setActionCommand("Turbo");
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this.normalMode);
        rbg.add(this.fastMode);
        rbg.add(this.veryFastMode);
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new BoxLayout(rbPanel, 1));
        rbPanel.add(this.normalMode);
        rbPanel.add(this.fastMode);
        rbPanel.add(this.veryFastMode);
        JPanel rbxPanel = new JPanel();
        rbxPanel.setBorder(BorderFactory.createTitledBorder("MCS Mode"));
        rbxPanel.setLayout(new BoxLayout(rbxPanel, 0));
        rbxPanel.add(rbPanel);
        rbxPanel.add(Box.createHorizontalGlue());
        JPanel sPanel = new JPanel();
        sPanel.setLayout(new BoxLayout(sPanel, 0));
        sPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        sPanel.add(label1);
        sPanel.add(this.minMCSSpinner);
        sPanel.add(Box.createHorizontalGlue());
        vPanel.add(Box.createVerticalStrut(12));
        vPanel.add(sPanel);
        vPanel.add(Box.createVerticalStrut(11));
        vPanel.add(rbxPanel);
        vPanel.add(Box.createVerticalStrut(11));
        this.atomTypeCB = new JCheckBox(ATOM_TYPE);
        this.atomTypeCB.setActionCommand(ATOM_TYPE);
        this.bondTypeCB = new JCheckBox(BOND_TYPE);
        this.bondTypeCB.setActionCommand(BOND_TYPE);
        this.chargeCB = new JCheckBox(CHARGE);
        this.chargeCB.setActionCommand(CHARGE);
        this.hybridCB = new JCheckBox(HYBRIDIZATION);
        this.hybridCB.setActionCommand(HYBRIDIZATION);
        this.isotopeCB = new JCheckBox(ISOTOPES);
        this.isotopeCB.setActionCommand(ISOTOPES);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        cPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 0, 11, 0), BorderFactory.createTitledBorder("Matching Parameters")));
        cPanel.add(this.atomTypeCB);
        cPanel.add(this.bondTypeCB);
        cPanel.add(this.chargeCB);
        cPanel.add(this.hybridCB);
        cPanel.add(this.isotopeCB);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(12));
        panel.add(vPanel);
        panel.add(Box.createHorizontalStrut(11));
        panel.add(cPanel);
        panel.add(Box.createHorizontalStrut(11));
        return panel;
    }

    protected JComponent createClusteringPanel() {
        JPanel vPanel = new JPanel(false);
        vPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        vPanel.setLayout(gbl);
        this.keepRingsCB = new JCheckBox(KEEP_RINGS);
        c.anchor = 17;
        c.weighty = 2.0;
        c.weightx = 4.0;
        c.gridwidth = 0;
        gbl.setConstraints(this.keepRingsCB, c);
        vPanel.add(this.keepRingsCB);
        JLabel l1 = new JLabel("Required cluster count");
        this.rccSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 50, 1));
        this.rccSpinner.setPreferredSize(new Dimension(50, 20));
        this.rccSpinner.setMaximumSize(new Dimension(50, 20));
        c.gridwidth = 1;
        c.weightx = 3.0;
        gbl.setConstraints(l1, c);
        vPanel.add(l1);
        c.weightx = 1.0;
        c.gridwidth = 0;
        gbl.setConstraints(this.rccSpinner, c);
        vPanel.add(this.rccSpinner);
        JLabel l2 = new JLabel("Maximum level count");
        this.mlcSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 300, 5));
        this.mlcSpinner.setPreferredSize(new Dimension(50, 20));
        this.mlcSpinner.setMaximumSize(new Dimension(50, 20));
        c.gridwidth = 1;
        c.weightx = 3.0;
        gbl.setConstraints(l2, c);
        vPanel.add(l2);
        c.weightx = 1.0;
        c.gridwidth = 0;
        gbl.setConstraints(this.mlcSpinner, c);
        vPanel.add(this.mlcSpinner);
        return vPanel;
    }
}

