/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.clustering.MBaseNode;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.struc.Molecule;

public class MWrapNode {
    private MBaseNode node;
    private MWrapNode[] children;
    private int propertyCount;
    private MViewPane pane = null;

    public MWrapNode(MBaseNode nod) {
        this.node = nod;
        int numOfChld = this.node.visibleChildCount();
        MWrapNode[] mWrapNodeArray = this.children = numOfChld == 0 ? null : new MWrapNode[this.node.visibleChildCount()];
        if (numOfChld != 0) {
            MBaseNode tmp = nod.getFirstVisibleChild();
            this.children[0] = new MWrapNode(tmp);
            for (int i = 1; i < this.children.length; ++i) {
                tmp = tmp.getVisibleFollower();
                this.children[i] = new MWrapNode(tmp);
            }
        }
        this.propertyCount = this.node.getGraph().getRangePropertyCount();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.children = null;
        this.node = null;
        this.pane = null;
    }

    public MBaseNode getNode() {
        return this.node;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.length;
    }

    public MWrapNode getChild(int i) {
        return this.children[i];
    }

    public MBaseNode getChildNode(int i) {
        return this.getChild(i).getNode();
    }

    public String toString() {
        try {
            return this.getChildCount() == 0 ? this.getNode().getProperty("ID") : "" + this.getNode().getID();
        }
        catch (NullPointerException nullPointerException) {
            return super.toString();
        }
    }

    public MViewPane getViewPane() {
        if (this.pane == null) {
            this.pane = new MViewPane();
            String viewParams = "rows=1\ncols=1\nborder=1\nlayout=:1:1:M:1:0:1:1:c:b:1:1\nparam=:M:100:100\n";
            this.pane.setParams(viewParams);
            this.pane.setEditable(0);
            this.pane.setSelectable(false);
            this.pane.setDetachable(false);
            Molecule tmpmol = this.node.getMoleculeWithProperty();
            if (tmpmol != null) {
                this.pane.setM(0, tmpmol);
            }
        }
        return this.pane;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public Object getPropertyGlobalMin(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyMin(this.getNode().getGraph().getRangePropertyKey(i));
    }

    public Object getPropertyGlobalMax(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyMax(this.getNode().getGraph().getRangePropertyKey(i));
    }

    public Object getPropertyMin(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyMin(this.getNode().getGraph().getRangePropertyKey(i), this.getNode());
    }

    public Object getPropertyMax(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyMax(this.getNode().getGraph().getRangePropertyKey(i), this.getNode());
    }

    public Object getPropertyAverage(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyAverage(this.getNode().getGraph().getRangePropertyKey(i), this.getNode());
    }

    public Object getProperty(int i) {
        return this.getNode().getGraph().getProperty(this.getNode().getGraph().getRangePropertyKey(i), this.getNode());
    }

    public int getPropertyType(int i) throws IllegalArgumentException {
        return this.getNode().getGraph().getPropertyType(this.getNode().getGraph().getRangePropertyIndices()[i]);
    }

    public String getPropertyKey(int i) {
        return this.getNode().getGraph().getPropertyKey(this.getNode().getGraph().getRangePropertyIndices()[i]);
    }

    public void sortRecursively(String propertyKey) throws IllegalArgumentException {
        for (int i = 0; i < this.getNode().getGraph().getPropertyCount(); ++i) {
            if (!this.getNode().getGraph().getPropertyKey(i).equals(propertyKey)) continue;
            this.sortRecursively(i);
            return;
        }
        throw new IllegalArgumentException("No such property");
    }

    public void sortRecursively(int propertyNumber) throws IllegalArgumentException {
        int i;
        if (this.children == null || this.children.length < 1) {
            return;
        }
        for (i = 0; i < this.children.length; ++i) {
            for (int j = this.children.length - 1; j > i; --j) {
                String propi = this.getChild(i).getNode().getProperty(this.getNode().getGraph().getPropertyKey(propertyNumber));
                String propj = this.getChild(j).getNode().getProperty(this.getNode().getGraph().getPropertyKey(propertyNumber));
                try {
                    if (Long.parseLong(propi) <= Long.parseLong(propj)) continue;
                    MWrapNode change = this.children[i];
                    this.children[i] = this.children[j];
                    this.children[j] = change;
                    continue;
                }
                catch (NumberFormatException e) {
                    if (propi.compareTo(propj) <= 0) continue;
                    MWrapNode change = this.children[i];
                    this.children[i] = this.children[j];
                    this.children[j] = change;
                }
            }
        }
        for (i = 0; i < this.children.length; ++i) {
            this.getChild(i).sortRecursively(propertyNumber);
        }
    }

    private int calculateSize() {
        if (this.children == null || this.children.length < 1) {
            return 1;
        }
        if (this.children[0].children == null || this.children[0].children.length < 0) {
            return this.children.length;
        }
        int siz = 0;
        for (int i = 0; i < this.children.length; ++i) {
            siz += this.children[i].calculateSize();
        }
        return siz;
    }

    public void sortRecursivelyBySize() throws IllegalArgumentException {
        int i;
        if (this.children == null || this.children.length < 1) {
            return;
        }
        for (i = 0; i < this.children.length; ++i) {
            for (int j = this.children.length - 1; j > i; --j) {
                if (this.children[i].calculateSize() >= this.children[j].calculateSize()) continue;
                MWrapNode change = this.children[i];
                this.children[i] = this.children[j];
                this.children[j] = change;
            }
        }
        for (i = 0; i < this.children.length; ++i) {
            this.getChild(i).sortRecursivelyBySize();
        }
    }
}

