/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui;

import chemaxon.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.ToolTipUI;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    protected Timer enterTimer;
    protected Timer insideTimer;
    protected Point currentPoint = null;
    protected boolean moved = false;
    protected boolean tipsEnabled = true;
    protected int counter = 0;
    protected MolToolTip tooltip = new MolToolTip();
    protected JComponent parent = null;
    protected JWindow tooltipWindow;

    public ToolTipManager(JComponent parent) {
        this.parent = parent;
        parent.addMouseListener(this);
        parent.addMouseMotionListener(this);
        this.tooltipWindow = new JWindow();
        this.tooltipWindow.getContentPane().add(this.tooltip);
        this.tooltipWindow.setFocusable(false);
        this.tooltipWindow.pack();
        this.enterTimer = new Timer(20, new InsideTimerAction());
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new StillInsideTimerAction());
        this.insideTimer.setRepeats(false);
    }

    public void unregisterComponent(JComponent parent) {
        parent.removeMouseListener(this);
        parent.removeMouseMotionListener(this);
        this.parent = null;
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
        this.hideTip(true);
        this.enterTimer = null;
        this.insideTimer = null;
        this.tooltipWindow = null;
        this.tooltip = null;
    }

    public MolToolTip getToolTip() {
        return this.tooltip;
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setDelay(n);
    }

    protected void showTip() {
        if (this.tooltipWindow != null && !this.tooltipWindow.isVisible() && this.tooltip.ttui.tooltipImage != null) {
            Dimension d = this.tooltip.getPreferredSize();
            SwingUtilities.convertPointToScreen(this.currentPoint, this.parent);
            this.tooltip.setBounds(0, 0, d.width, d.height);
            this.tooltipWindow.setBounds(this.currentPoint.x + 15, this.currentPoint.y + 15, d.width, d.height);
            this.tooltipWindow.setVisible(true);
        }
    }

    public void hideTip() {
        this.hideTip(true);
    }

    protected void hideTip(boolean b) {
        if (this.tooltipWindow.isVisible() && b) {
            this.tooltipWindow.setVisible(false);
        }
    }

    public boolean isTipsEnabled() {
        return this.tipsEnabled;
    }

    public void enableTips(boolean b) {
        this.tipsEnabled = b;
        if (!this.tipsEnabled) {
            this.hideTip(true);
        } else {
            this.enterTimer.start();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.tipsEnabled) {
            this.enterTimer.start();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
        this.hideTip(true);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.currentPoint = e.getPoint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.tipsEnabled) {
            return;
        }
        this.moved = true;
        this.counter = -1;
        this.currentPoint = e.getPoint();
        this.hideTip(!this.tooltip.isUpdated());
        if (!this.tooltipWindow.isVisible()) {
            if (this.enterTimer.isRunning()) {
                this.enterTimer.restart();
            } else {
                this.enterTimer.start();
            }
        }
    }

    protected class StillInsideTimerAction
    implements ActionListener {
        protected StillInsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.hideTip(ToolTipManager.this.tooltip.isUpdated());
        }
    }

    protected class InsideTimerAction
    implements ActionListener {
        protected InsideTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.showTip();
            if (ToolTipManager.this.insideTimer != null) {
                ToolTipManager.this.insideTimer.start();
            }
        }
    }

    public final class MolToolTip
    extends JToolTip {
        private CToolTipUI ttui;
        private Image prevImage = null;
        Color backColor = new Color(255, 255, 215);

        public MolToolTip(Image molImage, String text) {
            this.setBackground(this.backColor);
            this.ttui = new CToolTipUI(molImage, text);
            this.setUI(this.ttui);
        }

        public MolToolTip() {
            this(null, null);
        }

        public void update(Image molImage, String text) {
            this.ttui.update(molImage, text);
        }

        public boolean isUpdated() {
            boolean updated = this.ttui.tooltipImage != null && this.prevImage == this.ttui.tooltipImage;
            this.prevImage = this.ttui.tooltipImage;
            return updated;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.ttui.getPreferredSize(ToolTipManager.this.parent);
        }

        private final class CToolTipUI
        extends ToolTipUI {
            private Image tooltipImage = null;
            private String[] tooltipText = null;
            private int maxLength = 0;

            public CToolTipUI(Image tooltipImage, String text) {
                this.update(tooltipImage, text);
            }

            public void update(Image tooltipImage, String text) {
                this.tooltipImage = tooltipImage;
                if (text == null) {
                    this.tooltipText = null;
                    return;
                }
                this.tooltipText = StringUtil.split(text, "\n");
                this.maxLength = 0;
                for (int i = 1; i < this.tooltipText.length; ++i) {
                    if (this.tooltipText[i].length() <= this.tooltipText[this.maxLength].length()) continue;
                    this.maxLength = i;
                }
            }

            @Override
            public void paint(Graphics g, JComponent c) {
                g.setColor(Color.black);
                if (this.tooltipImage != null) {
                    int x = (MolToolTip.this.getWidth() - this.tooltipImage.getWidth(c)) / 2;
                    g.drawImage(this.tooltipImage, x, 0, c);
                    if (this.tooltipText != null) {
                        int fontH = c.getFontMetrics(c.getFont()).getHeight();
                        for (int i = 0; i < this.tooltipText.length; ++i) {
                            g.drawString(this.tooltipText[i], 0, this.tooltipImage.getHeight(c) + (i + 1) * fontH - 1);
                        }
                    }
                }
            }

            @Override
            public Dimension getPreferredSize(JComponent c) {
                if (this.tooltipImage == null) {
                    return new Dimension(0, 0);
                }
                FontMetrics metrics2 = c.getFontMetrics(c.getFont());
                int width = Math.max(SwingUtilities.computeStringWidth(metrics2, this.tooltipText[this.maxLength]), this.tooltipImage.getWidth(c));
                int height = this.tooltipText.length * metrics2.getHeight() + this.tooltipImage.getHeight(c);
                return new Dimension(width, height);
            }
        }
    }
}

