/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.action;

import chemaxon.clustering.gui.JKlustor;
import chemaxon.clustering.gui.JKlustorActions;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ExportGraphAction
extends AbstractAction {
    private JKlustor jKlustor;
    private JFileChooser saveDialog;

    public ExportGraphAction(JKlustor jKlustor) {
        this.jKlustor = jKlustor;
        this.initFileChooser();
        this.putValue("Name", "Save Graph...");
        this.putValue("ShortDescription", "Save Graph");
        this.putValue("ActionCommandKey", "ExportGraph");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 8));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.saveDialog.showSaveDialog(this.jKlustor.getClusterViewer()) == 0) {
                String saveFileName;
                int lastDot;
                File saveFile = this.saveDialog.getSelectedFile();
                if (this.saveDialog.getFileFilter().getDescription().equals("Graph Save Files (*.gsf)") && ((lastDot = (saveFileName = saveFile.getName()).lastIndexOf(46)) < 1 || lastDot == saveFileName.length() - 1)) {
                    saveFile = new File(saveFile.getCanonicalPath() + ".gsf");
                }
                if (!this.overWriteCheck(saveFile)) {
                    return;
                }
                FileOutputStream fo = new FileOutputStream(saveFile);
                ObjectOutputStream oo = new ObjectOutputStream(fo);
                this.jKlustor.getGraph().saveGraph(oo);
                fo.close();
            }
        }
        catch (Exception ex) {
            this.jKlustor.handleError(ex);
        }
    }

    private void initFileChooser() {
        this.saveDialog = new JFileChooser();
        this.saveDialog.setDialogTitle("Library MCS: Save Graph");
        this.saveDialog.setMultiSelectionEnabled(false);
        JKlustorActions.addFileFilter(this.saveDialog, "gsf", "Graph Save Files (*.gsf)");
    }

    private boolean overWriteCheck(File f) {
        return !f.exists() || 1 != JOptionPane.showOptionDialog(this.jKlustor.getClusterViewer(), "Overwrite selected file?", "File exists", 0, 3, null, null, null);
    }
}

