/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.action;

import chemaxon.clustering.gui.JKlustor;
import chemaxon.clustering.gui.JKlustorActions;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

public class ImportGraphAction
extends AbstractAction {
    private JKlustor jKlustor;
    private JFileChooser loadDialog;

    public ImportGraphAction(JKlustor jKlustor) {
        this.jKlustor = jKlustor;
        this.initFileChooser();
        this.putValue("Name", "Open Graph...");
        this.putValue("ShortDescription", "Open Graph");
        this.putValue("ActionCommandKey", "ImportGraph");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 8));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.loadDialog.showOpenDialog(this.jKlustor.getClusterViewer()) == 0 && this.loadDialog.getSelectedFile().canRead()) {
                this.jKlustor.importStructures(this.loadDialog.getSelectedFile().getCanonicalPath());
            }
        }
        catch (Exception ex) {
            this.jKlustor.handleError(ex);
        }
    }

    private void initFileChooser() {
        this.loadDialog = new JFileChooser();
        this.loadDialog.setDialogTitle("Library MCS: Open Graph");
        this.loadDialog.setMultiSelectionEnabled(false);
        JKlustorActions.addFileFilter(this.loadDialog, "gsf", "Graph Save Files (*.gsf)");
    }
}

