/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.MGraph;
import chemaxon.clustering.gui.component.DendogramViewer;
import chemaxon.clustering.gui.component.MViewTablePanel;
import chemaxon.clustering.gui.component.ProgressMonitorPanel;
import chemaxon.clustering.gui.component.RGroupTablePanel;
import chemaxon.clustering.gui.component.TreeTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ClusterViewer
extends JPanel {
    public static final int EMPTY_MODE = 0;
    public static final int MVIEW_MODE = 1;
    public static final int TREETABLE_MODE = 2;
    public static final int RGROUPTABLE_MODE = 3;
    public static final Color MARK_COLOR = new Color(0, 160, 200);
    public static final Color MARK_COLOR_BRIGHT = Color.WHITE;
    public static final Color MARK_COLOR_SHADE = new Color(221, 221, 231);
    JSplitPane splitPane;
    DendogramViewer dendogramViewer;
    MViewTablePanel mviewTable;
    RGroupTablePanel rGroupTable;
    TreeTable treeTable;
    ProgressMonitorPanel progressPanel;
    MGraph graph = null;
    private int mode = 0;

    public ClusterViewer() {
        this.init();
    }

    public ClusterViewer(MGraph g) {
        this.init();
        this.setGraph(g);
    }

    public void onRemove() {
        this.mviewTable.onRemove();
        this.mviewTable = null;
        this.rGroupTable = null;
        this.treeTable.onRemove();
        this.treeTable = null;
        this.dendogramViewer.onRemove();
        this.dendogramViewer = null;
        this.graph = null;
        this.splitPane.removeAll();
        this.splitPane = null;
        this.removeAll();
    }

    public void setGraph(MGraph g) {
        this.graph = g;
        this.dendogramViewer.setGraph(g);
        this.treeTable.setGraph(g);
        this.update();
    }

    private void init() {
        this.dendogramViewer = new DendogramViewer();
        this.dendogramViewer.setClusterViewer(this);
        this.mviewTable = new MViewTablePanel();
        this.dendogramViewer.addMouseMotionListener(this.mviewTable);
        this.rGroupTable = new RGroupTablePanel(this);
        this.treeTable = new TreeTable();
        this.treeTable.setClusterViewer(this);
        this.progressPanel = new ProgressMonitorPanel(" ", " ", 0, 100);
        this.setLayout();
    }

    public void update() {
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                this.dendogramViewer.updateMarvinViewPanel(this.mviewTable);
                break;
            }
            case 3: {
                this.dendogramViewer.updateRGroupPanel(this.rGroupTable);
                break;
            }
        }
        this.repaint();
    }

    public void updateStructure() {
        this.dendogramViewer.setGraph(this.graph);
        this.treeTable.setGraph(this.graph);
        if (this.mode == 1) {
            this.dendogramViewer.updateMarvinViewPanel(this.mviewTable);
        } else if (this.mode == 3) {
            this.dendogramViewer.updateRGroupPanel(this.rGroupTable);
        }
        this.repaint();
    }

    public void setActiveNode(MBaseNode node) {
        this.dendogramViewer.setActiveNode(node);
        if (this.mode == 2) {
            // empty if block
        }
    }

    public ProgressMonitorPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void setProgressMode(boolean b) {
        if (b) {
            int divloc = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(this.progressPanel);
            this.splitPane.setDividerLocation(divloc);
            this.validate();
        } else {
            this.setMode(this.mode);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMViewMode() {
        return this.mode == 1;
    }

    public boolean isRGroupMode() {
        return this.mode == 3;
    }

    public boolean isTreeTableMode() {
        return this.mode == 2;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1: {
                this.setMViewMode();
                break;
            }
            case 2: {
                this.setTreeTableMode();
                break;
            }
            case 3: {
                this.setRGroupMode();
            }
        }
    }

    public void setMViewMode() {
        this.mode = 1;
        int divloc = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent(this.mviewTable);
        this.splitPane.setDividerLocation(divloc);
        this.update();
        this.validate();
    }

    public void setRGroupMode() {
        this.mode = 3;
        int divloc = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent(this.rGroupTable);
        this.splitPane.setDividerLocation(divloc);
        this.update();
        this.validate();
    }

    public void setTreeTableMode() {
        this.mode = 2;
        int divloc = this.splitPane.getDividerLocation();
        this.splitPane.setBottomComponent(new JScrollPane(this.treeTable));
        this.treeTable.sortBySize();
        this.splitPane.setDividerLocation(divloc);
        this.repaint();
    }

    public void setDisplayIDInDendogram(boolean b) {
        this.dendogramViewer.setDisplayID(b);
        this.update();
    }

    public void setDisplayPropertiesInTooltips(boolean b) {
        this.dendogramViewer.setDisplayPropertiesInTooltips(b);
        this.update();
    }

    public void setDisplayPropertiesInMViewTable(boolean b) {
        this.mviewTable.setDisplayProperties(b);
        this.update();
    }

    private void setLayout() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(0, this.dendogramViewer, this.mviewTable);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(200);
        this.add((Component)this.splitPane, "Center");
    }
}

