/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.DendogramViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class LevelPanel
extends JComponent
implements MouseInputListener {
    public static final int DEFAULT_ARROW_WIDTH = 4;
    public static final int DEFAULT_ARROW_HEIGHT = 8;
    public static final int DEFAULT_X_OFFSET = 4;
    int levelCount = 0;
    int currentLevel = -1;
    boolean[] selectedLevels;
    int[] xCoords = new int[3];
    int[] yCoords = new int[3];
    int arrowWidth = 4;
    int arrowHeight = 8;
    int xOffset = 4;
    DendogramViewer dendogram = null;
    RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    public LevelPanel(DendogramViewer dp) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setMinimumSize(new Dimension(10, 10));
        this.xCoords[0] = this.xOffset;
        this.xCoords[1] = this.xOffset;
        this.xCoords[2] = this.xOffset + this.arrowHeight;
        this.dendogram = dp;
    }

    public void onRemove() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.dendogram = null;
        this.xCoords = null;
        this.yCoords = null;
        this.selectedLevels = null;
    }

    public void graphChanged() {
        this.levelCount = this.dendogram.getLevelCount();
        this.selectedLevels = new boolean[this.levelCount];
        Arrays.fill(this.selectedLevels, false);
        this.repaint();
    }

    public void clearSelection() {
        Arrays.fill(this.selectedLevels, false);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.dendogram == null) {
            return;
        }
        if (this.levelCount != 0) {
            for (int i = 1; i <= this.levelCount; ++i) {
                this.paintArrow(g, this.dendogram.getCoordOfLevel(i), this.selectedLevels[i - 1], i == this.currentLevel);
            }
        }
    }

    private void paintArrow(Graphics g, int yCoord, boolean selected, boolean current) {
        this.yCoords[0] = yCoord - this.arrowWidth;
        this.yCoords[1] = yCoord + this.arrowWidth;
        this.yCoords[2] = yCoord;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHints(this.renderHints);
        }
        if (selected) {
            g.setColor(ClusterViewer.MARK_COLOR);
        } else {
            g.setColor(Color.white);
        }
        g.fillPolygon(this.xCoords, this.yCoords, 3);
        if (current) {
            g.setColor(ClusterViewer.MARK_COLOR_BRIGHT);
        } else {
            g.setColor(Color.black);
        }
        g.drawPolygon(this.xCoords, this.yCoords, 3);
    }

    private void paintMark(Graphics g, int yCoord, boolean selected) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHints(this.renderHints);
        }
        if (selected) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.white);
        }
        int x = this.getWidth() / 2;
        g.fillRect(x - 3, yCoord - 3, 6, 6);
        g.setColor(Color.black);
        g.drawRect(x - 3, yCoord - 3, 6, 6);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.dendogram == null) {
            return;
        }
        if (e.getX() < 0 || e.getX() > 15) {
            return;
        }
        int level = this.dendogram.getLevelFromCoord(e.getY());
        if (level != -1) {
            if (e.isControlDown()) {
                if (this.selectedLevels[level - 1]) {
                    this.selectedLevels[level - 1] = false;
                    this.dendogram.unmarkLevel(level);
                } else {
                    this.selectedLevels[level - 1] = true;
                    this.dendogram.markLevel(level);
                }
            } else if (e.isShiftDown()) {
                this.selectedLevels[level - 1] = true;
                this.dendogram.markLevel(level);
            } else {
                this.dendogram.unmarkAllNodes();
                this.dendogram.markLevel(level);
                Arrays.fill(this.selectedLevels, false);
                this.selectedLevels[level - 1] = true;
            }
            this.repaint();
            this.dendogram.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.currentLevel = -1;
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.currentLevel = -1;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int l = this.dendogram.getLevelFromCoord(e.getY());
        if (l >= 0 && l <= this.levelCount && l != this.currentLevel) {
            this.currentLevel = l;
            this.repaint();
        }
    }
}

