/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.gui.JDTSlider;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class MViewTablePanel
extends JPanel
implements MouseWheelListener {
    public static final int DEFAULT_SCROLLABLE_HEIGHT = 400;
    public static final int DEFAULT_COLUMN_WIDTH = 200;
    public static final int ONE_VISIBLE = 1;
    public static final int ALL_VISIBLE = 2;
    public static final int N_VISIBLE = 3;
    public static final int SCROLLING_INCREMENT = 20;
    protected JTable mviewTable;
    protected int molCount = 0;
    protected int rowCount = 2;
    protected int columnCount = 3;
    protected int visibleRowPolicy = 1;
    protected int visibleRowCount = 1;
    protected int rowHeight = 400 / this.visibleRowCount;
    protected int rowHeightUnit = 100;
    protected int columnWidth = 200;
    protected int columnHeightUnit = 100;
    protected boolean displayProperties = true;
    protected ArrayList molecules = new ArrayList();
    protected ArrayList texts = new ArrayList();
    protected ArrayList molFlag = new ArrayList();
    protected MViewTableModel model;
    protected MolRenderer molRenderer = null;
    protected MolRenderer molEditorRenderer = null;
    protected JDTSlider horizontalSlider;
    protected JDTSlider verticalSlider;
    protected HorizontalSliderChangeListener hSliderListener = new HorizontalSliderChangeListener();
    protected VerticalSliderChangeListener vSliderListener = new VerticalSliderChangeListener();
    protected JScrollPane scrollPane;
    boolean inverted = true;
    static Color topLevelColor = new Color(225, 225, 225);
    static Color innerLevelColor = new Color(240, 240, 240);

    public MViewTablePanel() {
        this.model = new MViewTableModel();
        this.mviewTable = new JTable(this.model);
        this.mviewTable.setRowSelectionAllowed(false);
        this.mviewTable.setRowHeight(this.rowHeight);
        this.mviewTable.setTableHeader(null);
        this.mviewTable.setAutoResizeMode(0);
        this.mviewTable.addMouseWheelListener(this);
        this.setUpMolRenderer();
        this.setUpMolEditor();
        this.setVisibleRowCount(2);
        this.horizontalSlider = new JDTSlider(0, 0, 100, 0, 100);
        this.verticalSlider = new JDTSlider(1, 0, 100, 0, 100);
        this.horizontalSlider.addChangeListener(this.hSliderListener);
        this.verticalSlider.addChangeListener(this.vSliderListener);
        JLabel cLabel = new JLabel("Columns: ");
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(this.columnCount, 1, 10, 1));
        spinner.setPreferredSize(new Dimension(40, 20));
        spinner.setMaximumSize(new Dimension(40, 20));
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                MViewTablePanel.this.columnCount = ((Number)spinner.getValue()).intValue();
                MViewTablePanel.this.setMolCount(MViewTablePanel.this.molCount);
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.add((Component)((Object)this.horizontalSlider));
        southPanel.add(Box.createHorizontalStrut(10));
        southPanel.add(cLabel);
        southPanel.add(spinner);
        this.scrollPane = new JScrollPane(this.mviewTable, 21, 31);
        this.setLayout(new BorderLayout());
        this.add((Component)southPanel, "South");
        this.add((Component)((Object)this.verticalSlider), "East");
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.molCount != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MViewTablePanel.this.vSliderListener.update();
                    MViewTablePanel.this.hSliderListener.update();
                }
            });
        }
    }

    public void setDisplayProperties(boolean b) {
        this.displayProperties = b;
    }

    public boolean isDisplayProperties() {
        return this.displayProperties;
    }

    public void onRemove() {
        this.horizontalSlider.removeChangeListener(this.hSliderListener);
        this.verticalSlider.removeChangeListener(this.vSliderListener);
        this.mviewTable.removeMouseWheelListener(this);
        this.removeAll();
    }

    private void setUpMolRenderer() {
        this.molRenderer = new MolRenderer();
        this.mviewTable.setDefaultRenderer(Molecule.class, this.molRenderer);
    }

    private void setUpMolEditor() {
        this.molEditorRenderer = new MolRenderer();
        this.molEditorRenderer.getMoleculeVisualizer().setEditable(0);
        this.molEditorRenderer.getMoleculeVisualizer().setDetachable(false);
        MolEditor molEditor = new MolEditor(this.molEditorRenderer);
        this.mviewTable.setDefaultEditor(Molecule.class, molEditor);
    }

    public void clear() {
        this.molecules.clear();
        this.texts.clear();
        this.molFlag.clear();
        this.model.clear();
    }

    public void setMolecule(int i, Molecule m) {
        this.model.setValueAt(m, i);
    }

    public void setMolecule(int i, Molecule m, int flag) {
        this.model.setValueAt(m, i);
        this.molFlag.add(i, new Integer(flag));
    }

    public void setMolCount(int i) {
        this.molCount = i;
        this.rowCount = (i - 1) / this.columnCount + 1;
        this.model.set(this.rowCount, this.columnCount);
    }

    public void setText(int i, String t) {
        this.texts.add(i, t);
    }

    public void setTextConstraints(Object c) {
        if (c == "North" || c == "East" || c == "South" || c == "West") {
            this.molRenderer.setTextConstraints(c);
            this.molEditorRenderer.setTextConstraints(c);
        }
    }

    public void setVisibleRowPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.visibleRowPolicy = policy;
                this.visibleRowCount = 1;
                break;
            }
            case 2: {
                this.visibleRowPolicy = policy;
                break;
            }
            case 3: {
                this.visibleRowPolicy = policy;
            }
        }
    }

    public void setVisibleRowCount(int n) {
        if (this.visibleRowPolicy != 3) {
            this.visibleRowPolicy = 3;
        }
        this.visibleRowCount = n;
    }

    public int getActiveCellIndex(Point p) {
        int r = this.mviewTable.rowAtPoint(p);
        int c = this.mviewTable.columnAtPoint(p);
        return this.model.getIdx(r, c);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int totalScrollAmount;
        if (e.getScrollType() != 0) {
            return;
        }
        int n = totalScrollAmount = e.getWheelRotation() > 0 ? this.rowHeightUnit : -this.rowHeightUnit;
        if (this.vSliderListener.isScrollable(totalScrollAmount)) {
            this.verticalSlider.setValues(this.verticalSlider.getMinValue() - totalScrollAmount, this.verticalSlider.getMaxValue() - totalScrollAmount);
        }
    }

    class HorizontalSliderChangeListener
    implements ChangeListener {
        private int prevDiff = 0;

        HorizontalSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int diff = MViewTablePanel.this.horizontalSlider.getMaxValue() - MViewTablePanel.this.horizontalSlider.getMinValue();
            if (Math.abs(diff - this.prevDiff) > 2) {
                int cw = this.getColumnWidth(diff);
                if (MViewTablePanel.this.columnWidth != cw) {
                    this.setColumnWidth(cw);
                }
                this.prevDiff = diff;
            } else {
                MViewTablePanel.this.scrollPane.getHorizontalScrollBar().setValue(this.getScrollValue(MViewTablePanel.this.horizontalSlider.getMinValue()));
            }
        }

        public void setColumnWidth(int width) {
            MViewTablePanel.this.columnWidth = width;
            for (int i = 0; i < MViewTablePanel.this.mviewTable.getColumnCount(); ++i) {
                MViewTablePanel.this.mviewTable.getColumnModel().getColumn(i).setPreferredWidth(MViewTablePanel.this.columnWidth);
            }
            MViewTablePanel.this.mviewTable.revalidate();
        }

        private int getScrollValue(int v) {
            return (int)((float)v / (float)MViewTablePanel.this.columnHeightUnit * (float)MViewTablePanel.this.columnWidth);
        }

        private int getColumnWidth(float diff) {
            if (diff == 0.0f) {
                diff = 1.0f;
            }
            float cw = MViewTablePanel.this.scrollPane.getWidth();
            return (int)(cw /= (diff /= (float)MViewTablePanel.this.columnHeightUnit));
        }

        public void update() {
            int diff = MViewTablePanel.this.horizontalSlider.getMaxValue() - MViewTablePanel.this.horizontalSlider.getMinValue();
            int cw = this.getColumnWidth(diff);
            if (MViewTablePanel.this.columnWidth != cw) {
                this.setColumnWidth(cw);
            }
        }

        public void setValues() {
            MViewTablePanel.this.horizontalSlider.setMinimum(0);
            MViewTablePanel.this.horizontalSlider.setMaximum(MViewTablePanel.this.columnCount * MViewTablePanel.this.columnHeightUnit);
            MViewTablePanel.this.horizontalSlider.setValues(0, MViewTablePanel.this.columnCount * MViewTablePanel.this.columnHeightUnit);
            this.setColumnWidth(this.getColumnWidth(MViewTablePanel.this.columnCount * MViewTablePanel.this.columnHeightUnit));
        }
    }

    class VerticalSliderChangeListener
    implements ChangeListener {
        VerticalSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int min = MViewTablePanel.this.verticalSlider.getMinValue();
            int max = MViewTablePanel.this.verticalSlider.getMaxValue();
            int rh = this.getRowHeight(max - min);
            if (rh != MViewTablePanel.this.rowHeight) {
                MViewTablePanel.this.rowHeight = rh;
                MViewTablePanel.this.mviewTable.setRowHeight(MViewTablePanel.this.rowHeight);
            } else {
                int v = MViewTablePanel.this.verticalSlider.getMaximum() - max;
                MViewTablePanel.this.scrollPane.getVerticalScrollBar().setValue(this.getScrollValue(v));
            }
        }

        private int getScrollValue(int v) {
            return (int)((float)v / (float)MViewTablePanel.this.rowHeightUnit * (float)MViewTablePanel.this.mviewTable.getRowHeight());
        }

        private int getRowHeight(float diff) {
            if (diff == 0.0f) {
                diff = 1.0f;
            }
            float rh = MViewTablePanel.this.scrollPane.getHeight();
            return (int)(rh /= (diff /= (float)MViewTablePanel.this.rowHeightUnit));
        }

        public void update() {
            int min = MViewTablePanel.this.verticalSlider.getMinValue();
            int max = MViewTablePanel.this.verticalSlider.getMaxValue();
            int rh = this.getRowHeight(max - min);
            if (rh != MViewTablePanel.this.rowHeight) {
                MViewTablePanel.this.rowHeight = rh;
                MViewTablePanel.this.mviewTable.setRowHeight(MViewTablePanel.this.rowHeight);
            }
        }

        public void setValues() {
            int max = MViewTablePanel.this.rowCount * MViewTablePanel.this.rowHeightUnit;
            int min = max - this.getVMaxValue();
            MViewTablePanel.this.verticalSlider.set(0, min, max, max);
        }

        private int getVMaxValue() {
            if (MViewTablePanel.this.visibleRowPolicy == 2) {
                MViewTablePanel.this.visibleRowCount = MViewTablePanel.this.rowCount;
                return MViewTablePanel.this.visibleRowCount * MViewTablePanel.this.rowHeightUnit;
            }
            if (MViewTablePanel.this.visibleRowPolicy == 3) {
                return MViewTablePanel.this.visibleRowCount * MViewTablePanel.this.rowHeightUnit;
            }
            float rh = MViewTablePanel.this.scrollPane.getHeight();
            rh /= (float)MViewTablePanel.this.rowHeight;
            return (int)(rh *= (float)MViewTablePanel.this.rowHeightUnit);
        }

        public boolean isScrollable(int adj) {
            return MViewTablePanel.this.verticalSlider.getMinValue() - adj >= MViewTablePanel.this.verticalSlider.getMinimum() && MViewTablePanel.this.verticalSlider.getMaxValue() - adj <= MViewTablePanel.this.verticalSlider.getMaximum();
        }
    }

    class MoleculeWithTextPanel
    extends JPanel {
        protected MViewPane viewPane = new MViewPane();
        protected JTextArea textArea = new JTextArea();

        MoleculeWithTextPanel() {
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.viewPane, "Center");
            this.add((Component)this.textArea, "South");
        }

        public void setTextConstraints(Object c) {
            this.add((Component)this.textArea, c);
        }

        public void setMolecule(Molecule m) {
            this.viewPane.setM(0, m);
        }

        public Molecule getMolecule() {
            return this.viewPane.getM(0);
        }

        public void setText(String s) {
            this.textArea.setText(s);
        }

        public MViewPane getMoleculeVisualizer() {
            return this.viewPane;
        }

        public JTextArea getTextVisualizer() {
            return this.textArea;
        }
    }

    class MViewTableModel
    extends AbstractTableModel {
        Object[] data = new Object[0];
        int rc = 0;
        int cc = 0;

        MViewTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.cc;
        }

        @Override
        public int getRowCount() {
            return this.rc;
        }

        @Override
        public String getColumnName(int col) {
            return "" + (col + 1);
        }

        public void clear() {
            this.data = null;
            this.fireTableStructureChanged();
        }

        public void set(int rc, int cc) {
            this.rc = rc;
            this.cc = cc;
            if (this.data == null) {
                this.data = new Object[rc * cc];
            }
            this.fireTableStructureChanged();
            MViewTablePanel.this.hSliderListener.setValues();
            MViewTablePanel.this.vSliderListener.setValues();
            MViewTablePanel.this.hSliderListener.update();
            MViewTablePanel.this.vSliderListener.update();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex * this.cc + columnIndex < 0) {
                return null;
            }
            if (rowIndex * this.cc + columnIndex >= this.data.length) {
                return null;
            }
            return this.data[rowIndex * this.cc + columnIndex];
        }

        public Class getColumnClass(int c) {
            return Molecule.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row * this.cc + col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void setValueAt(Object value, int idx) {
            this.setValueAt(value, idx / this.cc, idx % this.cc);
        }

        public int getIdx(int row, int col) {
            return row * this.cc + col;
        }
    }

    class MolEditor
    extends DefaultCellEditor {
        protected Molecule currentMol;

        public MolEditor(MoleculeWithTextPanel mvp) {
            super(new JCheckBox());
            this.currentMol = null;
            this.editorComponent = mvp;
        }

        @Override
        public Object getCellEditorValue() {
            this.currentMol = ((MoleculeWithTextPanel)this.editorComponent).getMolecule();
            return this.currentMol;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentMol = (Molecule)value;
            ((MoleculeWithTextPanel)this.editorComponent).setMolecule(this.currentMol);
            JTextArea textArea = ((MoleculeWithTextPanel)this.editorComponent).textArea;
            try {
                int f = (Integer)MViewTablePanel.this.molFlag.get(row * MViewTablePanel.this.columnCount + column);
                if (f == 0) {
                    textArea.setBackground(topLevelColor);
                } else if (f == 1) {
                    textArea.setBackground(innerLevelColor);
                } else {
                    textArea.setBackground(Color.white);
                }
            }
            catch (IndexOutOfBoundsException ie) {
                textArea.setBackground(Color.white);
            }
            try {
                textArea.setText((String)MViewTablePanel.this.texts.get(row * MViewTablePanel.this.columnCount + column));
            }
            catch (IndexOutOfBoundsException ibe) {
                textArea.setText(" ");
            }
            return this.editorComponent;
        }
    }

    class MolRenderer
    extends MoleculeWithTextPanel
    implements TableCellRenderer {
        MolRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object mol, boolean isSelected, boolean hasFocus, int row, int column) {
            this.viewPane.setM(0, (Molecule)mol);
            try {
                int f = (Integer)MViewTablePanel.this.molFlag.get(row * MViewTablePanel.this.columnCount + column);
                if (f == 0) {
                    this.textArea.setBackground(topLevelColor);
                } else if (f == 1) {
                    this.textArea.setBackground(innerLevelColor);
                } else {
                    this.textArea.setBackground(Color.white);
                }
            }
            catch (IndexOutOfBoundsException ie) {
                this.textArea.setBackground(Color.white);
            }
            try {
                this.textArea.setText((String)MViewTablePanel.this.texts.get(row * MViewTablePanel.this.columnCount + column));
            }
            catch (IndexOutOfBoundsException ibe) {
                this.textArea.setText(" ");
            }
            return this;
        }
    }
}

