/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProgressMonitorPanel
extends JPanel {
    private JProgressBar progressBar;
    private JLabel messageLabel;
    private JLabel noteLabel;
    private String message;
    private String note;
    private int min;
    private int max;
    private boolean canceled = false;
    private JLabel[] infoLabels = null;
    private JPanel infoPanel;

    public ProgressMonitorPanel(String message, String note, int min, int max) {
        this.min = min;
        this.max = max;
        this.message = message;
        this.note = note;
        this.initLayout();
    }

    public void reset(int min, int max) {
        this.setNote(" ");
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(min);
        this.canceled = false;
    }

    public void setProgressValue(final int v) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorPanel.this.progressBar.setValue(v);
            }
        });
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        this.max = m;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
        if (this.messageLabel != null) {
            this.messageLabel.setText(this.message);
        }
    }

    public String getNote() {
        return this.note;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(12, 12, 11, 11)));
        this.setLayout(new BoxLayout(this, 1));
        this.infoPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(250, 25));
        JButton cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressMonitorPanel.this.canceled = true;
            }
        });
        this.messageLabel = new JLabel(this.message);
        this.noteLabel = new JLabel(this.note);
        JPanel xPanel1 = new JPanel();
        BoxLayout xl1 = new BoxLayout(xPanel1, 0);
        xPanel1.setLayout(xl1);
        xPanel1.add(this.messageLabel);
        xPanel1.add(Box.createHorizontalGlue());
        JPanel xPanel2 = new JPanel();
        BoxLayout xl2 = new BoxLayout(xPanel2, 0);
        xPanel2.setLayout(xl2);
        xPanel2.add(this.noteLabel);
        xPanel2.add(Box.createHorizontalGlue());
        JPanel xPanel3 = new JPanel();
        BoxLayout xl3 = new BoxLayout(xPanel3, 0);
        xPanel3.setLayout(xl3);
        xPanel3.add(Box.createHorizontalGlue());
        xPanel3.add(cancelButton);
        xPanel3.add(Box.createHorizontalGlue());
        JPanel xPanel4 = new JPanel();
        xPanel4.setLayout(new GridLayout(1, 3));
        xPanel4.add(this.infoPanel);
        xPanel4.add(new JLabel(" "));
        xPanel4.add(new JLabel(" "));
        this.add(xPanel4);
        this.add(Box.createVerticalGlue());
        this.add(xPanel1);
        this.add(Box.createVerticalStrut(11));
        this.add(xPanel2);
        this.add(Box.createVerticalStrut(11));
        this.add(this.progressBar);
        this.add(Box.createVerticalStrut(17));
        this.add(xPanel3);
    }

    public void addInformationPanel(String[] info) {
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoLabels = new JLabel[info.length];
        for (int i = 0; i < info.length; ++i) {
            JPanel xPanel = new JPanel();
            xPanel.setLayout(new BoxLayout(xPanel, 0));
            JLabel label = new JLabel(info[i]);
            label.setHorizontalAlignment(2);
            this.infoLabels[i] = new JLabel("" + i);
            this.infoLabels[i].setHorizontalAlignment(4);
            xPanel.add(label);
            xPanel.add(Box.createHorizontalGlue());
            xPanel.add(this.infoLabels[i]);
            xPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
            this.infoPanel.add(xPanel);
            this.infoPanel.add(Box.createVerticalStrut(5));
        }
        this.validate();
    }

    public void setInformationString(int i, String s) {
        this.infoLabels[i].setText(s);
        this.validate();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new ProgressMonitorPanel("Progress Message", "Progress Note", 0, 100), "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

