/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;
    protected int editedRow;
    protected JTable table;
    static int leftIndent = UIManager.getInt("Tree.leftChildIndent");
    static int indent = leftIndent + UIManager.getInt("Tree.rightChildIndent");
    static Color treeColor = UIManager.getColor("Tree.hash");

    public TreeRenderer(TreeModel model, JTable table) {
        super(model);
        this.table = table;
        this.setRootVisible(true);
        if (model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
        this.setCellRenderer(new TreeCellRenderer());
        this.setToggleClickCount(1);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, table.getGridColor()));
        this.setLargeModel(true);
        UIManager.put("Tree.lineTypeDashed", Boolean.FALSE);
    }

    public void onRemove() {
        this.setModel(null);
        this.setCellRenderer(null);
        this.table = null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, 0, width, this.table.getHeight() + this.getRowHeight());
    }

    @Override
    public void paint(Graphics g) {
        g.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(g);
        g.setColor(treeColor);
        Enumeration<TreePath> e = this.getExpandedDescendants(this.getPathForRow(0));
        if (e != null) {
            while (e.hasMoreElements()) {
                TreePath desc = e.nextElement();
                Rectangle rect = this.getPathBounds(desc);
                int x = leftIndent + indent * (desc.getPathCount() - 1);
                int y1 = rect.y + rect.height / 2 + 10;
                int y2 = rect.y + rect.height;
                g.drawLine(x, y1, x, y2);
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.getCellRenderer() != null) {
            ((DefaultTreeCellRenderer)this.getCellRenderer()).setBackgroundNonSelectionColor(bg);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setRowHeight(table.getRowHeight(row));
        this.visibleRow = row + 1;
        return this;
    }

    public void setEditedRow(int row) {
        this.editedRow = row;
    }

    private int yCoordTranslate() {
        int translate = 0;
        this.setRowHeight(this.table.getRowHeight(this.editedRow));
        for (int i = 0; i < this.editedRow; ++i) {
            translate -= this.table.getRowHeight(i);
        }
        translate += this.table.getRowHeight(this.editedRow) * this.editedRow;
        return translate += this.getRowHeight();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        e.translatePoint(0, this.yCoordTranslate());
        super.processMouseEvent(e);
    }

    class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        public TreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        }
    }
}

